@extends('layouts.app')

@section('title', __('Website Visit Task Details') . ' - ' . ($settings['site_name'] ?? 'Site'))

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{ __('Task Details') }}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('user.website-visits.index') }}">{{ __('My Website Visits') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Task Details') }}</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <a href="{{ route('user.website-visits.index') }}" class="btn btn-secondary">
                    <i class='bx bx-arrow-back'></i> {{ __('Back to List') }}
                </a>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Task Information Card -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">{{ __('Task Information') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-borderless">
                                    <tr>
                                        <td><strong>{{ __('Task Title') }}:</strong></td>
                                        <td>{{ $websiteVisit->title }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Website URL') }}:</strong></td>
                                        <td><a href="{{ $websiteVisit->website_url }}" target="_blank">{{ $websiteVisit->website_url }}</a></td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Reward Amount') }}:</strong></td>
                                        <td>{{ number_format($websiteVisit->reward_amount, 2, ',', '.') }}{{ $settings['currency'] ?? 'TL' }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Visit Duration') }}:</strong></td>
                                        <td>{{ $websiteVisit->visit_duration }} {{ __('seconds') }}</td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-borderless">
                                    <tr>
                                        <td><strong>{{ __('Status') }}:</strong></td>
                                        <td>
                                            @if($websiteVisit->status == 1)
                                                <span class="badge bg-success">{{ __('Active') }}</span>
                                            @else
                                                <span class="badge bg-warning">{{ __('Inactive') }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Daily Limit') }}:</strong></td>
                                        <td>{{ $websiteVisit->user_daily_limit ?? __('Unlimited') }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Created At') }}:</strong></td>
                                        <td>{{ $websiteVisit->created_at->format('d.m.Y H:i') }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Updated At') }}:</strong></td>
                                        <td>{{ $websiteVisit->updated_at->format('d.m.Y H:i') }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        @if($websiteVisit->description)
                        <div class="row mt-3">
                            <div class="col-12">
                                <strong>{{ __('Description') }}:</strong>
                                <p class="mt-2">{{ $websiteVisit->description }}</p>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex gap-2">
                            <a href="{{ route('user.website-visits.edit', $websiteVisit) }}" class="btn btn-warning">
                                <i class='bx bx-edit'></i> {{ __('Edit Task') }}
                            </a>
                            
                            <button type="button" class="btn btn-danger" onclick="deleteTask({{ $websiteVisit->id }})">
                                <i class='bx bx-trash'></i> {{ __('Delete Task') }}
                            </button>
                            
                            @if($websiteVisit->status == 1)
                                <a href="{{ route('website-visits.index') }}" class="btn btn-success">
                                    <i class='bx bx-play'></i> {{ __('Start Visit') }}
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function deleteTask(taskId) {
    Swal.fire({
        title: '{{ __("Are you sure?") }}',
        text: '{{ __("This action cannot be undone! All related data will be permanently deleted.") }}',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: '{{ __("Yes, delete it!") }}',
        cancelButtonText: '{{ __("Cancel") }}',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            // Show loading
            Swal.fire({
                title: '{{ __("Deleting...") }}',
                text: '{{ __("Please wait while we delete the task.") }}',
                icon: 'info',
                allowOutsideClick: false,
                showConfirmButton: false,
                willOpen: () => {
                    Swal.showLoading();
                }
            });

            // Create form and submit
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `{{ url('/my/website-visits') }}/${taskId}`;
            
            const methodInput = document.createElement('input');
            methodInput.type = 'hidden';
            methodInput.name = '_method';
            methodInput.value = 'DELETE';
            
            const tokenInput = document.createElement('input');
            tokenInput.type = 'hidden';
            tokenInput.name = '_token';
            tokenInput.value = '{{ csrf_token() }}';
            
            form.appendChild(methodInput);
            form.appendChild(tokenInput);
            document.body.appendChild(form);
            form.submit();
        }
    });
}

// Include SweetAlert2 if not already included
if (typeof Swal === 'undefined') {
    const script = document.createElement('script');
    script.src = 'https://cdn.jsdelivr.net/npm/sweetalert2@11';
    document.head.appendChild(script);
}
</script>
@endsection