            @extends('layouts.app')

            @section('style')
                <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
                <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
                <style>
                    .ip-group-card {
                        border-left: 4px solid #007bff;
                        margin-bottom: 20px;
                        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
                    }
                    .ip-header {
                        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                        color: white;
                        padding: 15px;
                        border-radius: 8px 8px 0 0;
                    }
                    .user-card {
                        border: 1px solid #e9ecef;
                        border-radius: 8px;
                        margin-bottom: 10px;
                        transition: all 0.3s ease;
                    }
                    .user-card:hover {
                        box-shadow: 0 4px 8px rgba(0,0,0,0.15);
                        transform: translateY(-2px);
                    }
                    .status-badge {
                        font-size: 0.75rem;
                        padding: 4px 8px;
                    }
                    .action-buttons {
                        display: flex;
                        gap: 5px;
                        flex-wrap: wrap;
                    }
                    .action-buttons .btn {
                        padding: 4px 8px;
                        font-size: 0.75rem;
                    }
                    @media (max-width: 768px) {
                        .user-info {
                            font-size: 0.85rem;
                        }
                        .action-buttons {
                            justify-content: center;
                            margin-top: 10px;
                        }
                        .ip-header h5 {
                            font-size: 1rem;
                        }
                    }
                    .loading-spinner {
                        display: none;
                        text-align: center;
                        padding: 20px;
                    }
                    .search-container {
                        background: white;
                        padding: 20px;
                        border-radius: 8px;
                        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
                        margin-bottom: 20px;
                    }
                </style>
            @endsection

            @section('wrapper')
            <div class="page-wrapper">
                <div class="page-content">
                    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                        <div class="breadcrumb-title pe-3">{{ __('Users with Same IP Address') }}</div>
                        <div class="ps-3">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-0 p-0">
                                    <li class="breadcrumb-item"><a href="{{ url('/home') }}"><i class="bx bx-home-alt"></i></a></li>
                                    <li class="breadcrumb-item active" aria-current="page">{{ __('Same IP Users') }}</li>
                                </ol>
                            </nav>
                        </div>
                    </div>

                    <!-- Search Container -->
                    <div class="search-container">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="input-group">
                                    <input type="text" id="searchInput" class="form-control" placeholder="{{ __('Search by name, username, email, phone or IP...') }}" value="{{ request('search') }}">
                                    <button class="btn btn-primary" type="button" onclick="searchUsers()">
                                        <i class="bx bx-search"></i> {{ __('Search') }}
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <select id="perPageSelect" class="form-select" onchange="changePerPage()">
                                    <option value="12">12 {{ __('per page') }}</option>
                                    <option value="24">24 {{ __('per page') }}</option>
                                    <option value="48">48 {{ __('per page') }}</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Loading Spinner -->
                    <div class="loading-spinner" id="loadingSpinner">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">{{ __('Loading...') }}</span>
                        </div>
                        <p class="mt-2">{{ __('Loading users...') }}</p>
                    </div>

                    <!-- Users Container -->
                    <div id="usersContainer">
                        <!-- Users will be loaded here via AJAX -->
                    </div>

                    <!-- Pagination -->
                    <div id="paginationContainer" class="d-flex justify-content-center mt-4">
                        <!-- Pagination will be loaded here -->
                    </div>

                </div>
            </div>


        <!-- User Details Modal -->
        <div class="modal fade" id="userDetailsModal" tabindex="-1" aria-labelledby="userDetailsModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="userDetailsModalLabel">{{ __("User Details") }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="userDetailsContent">
                        <!-- User details will be loaded here -->
                    </div>
                </div>
            </div>
        </div>

        <!-- Delete Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel">{{ __("Delete Account") }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form id="deleteForm">
                            <div class="mb-3">
                                <label for="deleteReason" class="form-label">{{ __("Reason for deletion") }}</label>
                                <textarea class="form-control" id="deleteReason" rows="3" required></textarea>
                            </div>
                            <input type="hidden" id="deleteUserId">
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __("Close") }}</button>
                        <button type="button" class="btn btn-danger" onclick="confirmDelete()">{{ __("Delete") }}</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Ban Modal -->
        <div class="modal fade" id="banModal" tabindex="-1" aria-labelledby="banModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="banModalLabel">{{ __("Ban Account") }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form id="banForm">
                            <div class="mb-3">
                                <label for="banReason" class="form-label">{{ __("Reason for banning") }}</label>
                                <textarea class="form-control" id="banReason" rows="3" required></textarea>
                            </div>
                            <input type="hidden" id="banUserId">
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __("Close") }}</button>
                        <button type="button" class="btn btn-danger" onclick="confirmBan()">{{ __("Ban") }}</button>
                    </div>
                </div>
            </div>
        </div>


@section('script')
<script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
<script src="{{ asset('assets/plugins/notifications/js/notifications.min.js') }}"></script>
<script>
    let currentPage = 1;
    let currentSearch = '';
    let currentPerPage = 12;

    // Page load
    $(document).ready(function() {
        loadUsers();
        
        // Enter key search
        $('#searchInput').on('keypress', function(e) {
            if (e.which == 13) {
                searchUsers();
            }
        });
    });

    function loadUsers(page = 1) {
        $('#loadingSpinner').show();
        $('#usersContainer').hide();
        
        $.ajax({
            url: '{{ route("same.ip.ajax") }}',
            type: 'GET',
            data: {
                page: page,
                search: currentSearch,
                per_page: currentPerPage
            },
            success: function(response) {
                if (response.success) {
                    displayUsers(response.ip_groups);
                    displayPagination(response.pagination);
                    currentPage = page;
                }
                $('#loadingSpinner').hide();
                $('#usersContainer').show();
            },
            error: function() {
                $('#loadingSpinner').hide();
                showNotification('error', '{{ __("An error occurred while loading users.") }}');
            }
        });
    }

    function displayUsers(ipGroups) {
        let html = '';
        
        if (Object.keys(ipGroups).length === 0) {
            html = `
                <div class="text-center py-5">
                    <i class="bx bx-search-alt-2 display-1 text-muted"></i>
                    <h4 class="mt-3">{{ __('No users found') }}</h4>
                    <p class="text-muted">{{ __('No users with same IP address found.') }}</p>
                </div>
            `;
        } else {
            Object.keys(ipGroups).forEach(function(ip) {
                const users = ipGroups[ip];
                const userCount = users.length;
                
                html += `
                    <div class="card ip-group-card">
                        <div class="ip-header">
                            <div class="row align-items-center">
                                <div class="col">
                                    <h5 class="mb-0 text-white">
                                        <i class="bx bx-globe me-2"></i>
                                        IP: ${ip}
                                    </h5>
                                </div>
                                <div class="col-auto">
                                    <span class="badge bg-light text-dark">
                                        ${userCount} {{ __('users') }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                `;
                
                users.forEach(function(user) {
                    html += generateUserCard(user);
                });
                
                html += `
                            </div>
                        </div>
                    </div>
                `;
            });
        }
        
        $('#usersContainer').html(html);
    }

    function generateUserCard(user) {
        const statusBadge = getStatusBadge(user);
        const genderBadge = user.gender === 'male' ? 
            '<span class="badge bg-primary">{{ __("Male") }}</span>' : 
            '<span class="badge bg-pink">{{ __("Female") }}</span>';
        const verifiedBadge = user.phone_verified == 1 ? 
            '<span class="badge bg-success">{{ __("Verified") }}</span>' : 
            '<span class="badge bg-danger">{{ __("Not Verified") }}</span>';

        return `
            <div class="col-lg-6 col-xl-4 mb-3">
                <div class="user-card p-3">
                    <div class="d-flex align-items-center mb-2">
                        <div class="avatar-wrapper me-3">
                            <div class="avatar bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                ${user.account_holder ? user.account_holder.charAt(0).toUpperCase() : 'U'}
                            </div>
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="mb-0">${user.account_holder || 'N/A'}</h6>
                            <small class="text-muted">#${user.username}</small>
                        </div>
                        <div class="text-end">
                            ${statusBadge}
                        </div>
                    </div>
                    
                    <div class="user-info">
                        <div class="row g-2 mb-2">
                            <div class="col-12">
                                <small class="text-muted d-block">
                                    <i class="bx bx-envelope me-1"></i>
                                    ${user.email || 'N/A'}
                                </small>
                            </div>
                            <div class="col-6">
                                <small class="text-muted d-block">
                                    <i class="bx bx-map me-1"></i>
                                    ${user.CountryName || 'N/A'}/${user.CityName || 'N/A'}
                                </small>
                            </div>
                            <div class="col-6">
                                <small class="text-muted d-block">
                                    <i class="bx bx-phone me-1"></i>
                                    ${user.phone || 'N/A'}
                                </small>
                            </div>
                        </div>
                        
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <div>
                                ${genderBadge}
                                ${verifiedBadge}
                            </div>
                        </div>
                    </div>
                    
                    <div class="action-buttons">
                        <button class="btn btn-info btn-sm" onclick="showUserDetails(${user.id})">
                            <i class="bx bx-info-circle"></i> {{ __('Details') }}
                        </button>
                        ${!user.banned ? `
                            <button class="btn btn-warning btn-sm" onclick="bannedAccount(${user.id})">
                                <i class="bx bx-block"></i> {{ __('Ban') }}
                            </button>
                        ` : `
                            <button class="btn btn-success btn-sm" onclick="unbanAccount(${user.id})">
                                <i class="bx bx-check"></i> {{ __('Unban') }}
                            </button>
                        `}
                        ${!user.deleted ? `
                            <button class="btn btn-danger btn-sm" onclick="deleteAccount(${user.id})">
                                <i class="bx bx-trash"></i> {{ __('Delete') }}
                            </button>
                        ` : ''}
                    </div>
                </div>
            </div>
        `;
    }

    function getStatusBadge(user) {
        if (user.deleted) {
            return `<span class="badge bg-danger status-badge" onclick="showReason('${user.deletion_reason || ''}')">{{ __('Deleted') }}</span>`;
        } else if (user.banned) {
            return `<span class="badge bg-warning status-badge" onclick="showReason('${user.ban_reason || ''}')">{{ __('Banned') }}</span>`;
        } else {
            return `<span class="badge bg-success status-badge">{{ __('Active') }}</span>`;
        }
    }

    function displayPagination(pagination) {
        if (pagination.last_page <= 1) {
            $('#paginationContainer').html('');
            return;
        }

        let html = '<nav><ul class="pagination">';
        
        // Previous button
        if (pagination.current_page > 1) {
            html += `<li class="page-item"><a class="page-link" href="#" onclick="loadUsers(${pagination.current_page - 1})">{{ __('Previous') }}</a></li>`;
        }
        
        // Page numbers
        for (let i = Math.max(1, pagination.current_page - 2); i <= Math.min(pagination.last_page, pagination.current_page + 2); i++) {
            html += `<li class="page-item ${i === pagination.current_page ? 'active' : ''}">
                        <a class="page-link" href="#" onclick="loadUsers(${i})">${i}</a>
                     </li>`;
        }
        
        // Next button
        if (pagination.current_page < pagination.last_page) {
            html += `<li class="page-item"><a class="page-link" href="#" onclick="loadUsers(${pagination.current_page + 1})">{{ __('Next') }}</a></li>`;
        }
        
        html += '</ul></nav>';
        
        // Add info
        html += `<div class="text-center mt-2">
                    <small class="text-muted">
                        {{ __('Showing') }} ${pagination.from} {{ __('to') }} ${pagination.to} {{ __('of') }} ${pagination.total} {{ __('results') }}
                    </small>
                 </div>`;
        
        $('#paginationContainer').html(html);
    }

    function searchUsers() {
        currentSearch = $('#searchInput').val();
        currentPage = 1;
        loadUsers(1);
    }

    function changePerPage() {
        currentPerPage = $('#perPageSelect').val();
        currentPage = 1;
        loadUsers(1);
    }

    function showUserDetails(userId) {
        $.ajax({
            url: '{{ route("same.ip.details", ":id") }}'.replace(':id', userId),
            type: 'GET',
            success: function(response) {
                if (response.success) {
                    let html = generateUserDetailsHTML(response.user, response.same_ip_users);
                    $('#userDetailsContent').html(html);
                    $('#userDetailsModal').modal('show');
                }
            },
            error: function() {
                showNotification('error', '{{ __("An error occurred while loading user details.") }}');
            }
        });
    }

    function generateUserDetailsHTML(user, sameIpUsers) {
        return `
            <div class="row">
                <div class="col-md-6">
                    <h6>{{ __('User Information') }}</h6>
                    <table class="table table-sm">
                        <tr><td><strong>{{ __('Name') }}:</strong></td><td>${user.account_holder || 'N/A'}</td></tr>
                        <tr><td><strong>{{ __('Username') }}:</strong></td><td>#${user.username}</td></tr>
                        <tr><td><strong>{{ __('Email') }}:</strong></td><td>${user.email}</td></tr>
                        <tr><td><strong>{{ __('Phone') }}:</strong></td><td>${user.phone || 'N/A'}</td></tr>
                        <tr><td><strong>{{ __('IP Address') }}:</strong></td><td><span class="badge bg-primary">${user.ip}</span></td></tr>
                        <tr><td><strong>{{ __('Location') }}:</strong></td><td>${user.CountryName || 'N/A'} / ${user.CityName || 'N/A'}</td></tr>
                        <tr><td><strong>{{ __('Gender') }}:</strong></td><td>${user.gender === 'male' ? '{{ __("Male") }}' : '{{ __("Female") }}'}</td></tr>
                        <tr><td><strong>{{ __('Registration') }}:</strong></td><td>${new Date(user.created_at).toLocaleDateString()}</td></tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <h6>{{ __('Other Users with Same IP') }} (${sameIpUsers.length})</h6>
                    <div class="list-group">
                        ${sameIpUsers.map(u => `
                            <div class="list-group-item">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <strong>${u.account_holder || 'N/A'}</strong><br>
                                        <small class="text-muted">#${u.username} - ${u.email}</small>
                                    </div>
                                    <small class="text-muted">${new Date(u.created_at).toLocaleDateString()}</small>
                                </div>
                            </div>
                        `).join('')}
                    </div>
                </div>
            </div>
        `;
    }

    // Modal functions
    function deleteAccount(userId) {
        $('#deleteUserId').val(userId);
        $('#deleteModal').modal('show');
    }

    function confirmDelete() {
        const userId = $('#deleteUserId').val();
        const reason = $('#deleteReason').val();

        if (!reason.trim()) {
            showNotification('error', '{{ __("Please enter a reason for deletion.") }}');
            return;
        }

        $.ajax({
            url: '{{ route("same.ip.delete", ":id") }}'.replace(':id', userId),
            type: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                reason: reason
            },
            success: function(response) {
                $('#deleteModal').modal('hide');
                if (response.success) {
                    showNotification('success', '{{ __("User has been deleted.") }}');
                    loadUsers(currentPage);
                } else {
                    showNotification('error', '{{ __("An error occurred, please try again.") }}');
                }
            },
            error: function() {
                $('#deleteModal').modal('hide');
                showNotification('error', '{{ __("An error occurred, please try again.") }}');
            }
        });
    }

    function bannedAccount(userId) {
        $('#banUserId').val(userId);
        $('#banModal').modal('show');
    }

    function confirmBan() {
        const userId = $('#banUserId').val();
        const reason = $('#banReason').val();

        if (!reason.trim()) {
            showNotification('error', '{{ __("Please enter a reason for banning.") }}');
            return;
        }

        $.ajax({
            url: '{{ route("same.ip.ban", ":id") }}'.replace(':id', userId),
            type: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                reason: reason
            },
            success: function(response) {
                $('#banModal').modal('hide');
                if (response.success) {
                    showNotification('success', '{{ __("User has been banned.") }}');
                    loadUsers(currentPage);
                } else {
                    showNotification('error', '{{ __("An error occurred, please try again.") }}');
                }
            },
            error: function() {
                $('#banModal').modal('hide');
                showNotification('error', '{{ __("An error occurred, please try again.") }}');
            }
        });
    }

    function unbanAccount(userId) {
        Swal.fire({
            title: '{{ __("Are you sure?") }}',
            text: '{{ __("Do you want to unban this user?") }}',
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: '{{ __("Yes, unban") }}',
            cancelButtonText: '{{ __("Cancel") }}'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '{{ route("same.ip.unban", ":id") }}'.replace(':id', userId),
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.success) {
                            showNotification('success', '{{ __("User has been unbanned.") }}');
                            loadUsers(currentPage);
                        } else {
                            showNotification('error', '{{ __("An error occurred, please try again.") }}');
                        }
                    },
                    error: function() {
                        showNotification('error', '{{ __("An error occurred, please try again.") }}');
                    }
                });
            }
        });
    }

    function showReason(reason) {
        if (reason) {
            Swal.fire({
                title: '{{ __("Reason") }}',
                text: reason,
                icon: 'info',
                confirmButtonText: '{{ __("OK") }}'
            });
        }
    }

    function showNotification(type, message) {
        Lobibox.notify(type, {
            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            msg: message
        });
    }
</script>
@endsection
            @endsection
