@extends("layouts.app")
@section("style")
	<link href="{{ ('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet" />
    <style>
  
        h1 {
            font-size: 24px;
            margin-bottom: 20px;
        }
        iframe {
            width: 560px;
            height: 315px;
            border: none;
        }
        .timer {
            font-size: 20px;
            color: red;
            margin-top: 10px;
        }
        .alert {
            padding: 15px;
            background-color: #f44336;
            color: white;
            margin-bottom: 20px;
        }
    </style>
	@endsection
@section("wrapper")
<div class="page-wrapper">
<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3">{{__('Tasks')}}</div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="/"><i class="bx bx-home-alt"></i></a>
								</li>
                                <li class="breadcrumb-item active" aria-current="page">	<a class="breadcrumb-item" href="{{ route('tasks.watch') }}">{{__('Watch Earn')}}</a></li>
						
								</li>
							</ol>
						</nav>
					</div>
			
				</div>
               
				<!--end breadcrumb-->
                <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-4">
              
                  @if($taskWatched)
                    <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-white"><i class="bx bxs-message-square-x"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-white">{{ __('Warning') }}</h6>
                                <div class="text-white"> {{ __('You\'ve done this job before.') }}</div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    
                    @else
                    <header>
                       
<h4>{{ $task->name }}</h4>
<div class="timer badge bg-primary text-size-18" id="timer">{{ $task->watch_time }}</div>
                    </header>
                   
                    <div id="player"></div>
                    
                    @endif
                </div>
				
				
				</div>
				<!--end row-->
			</div>
</div>

  @endsection

@section("script")
	<!--notification js -->
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js')  }}"></script>
	<script src="{{ asset('assets/plugins/notifications/js/notifications.min.js')  }}"></script>
	<script src="{{ asset('assets/plugins/notifications/js/notification-custom-script.js')  }}"></script>
    @if (session('success'))
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        Lobibox.notify('success', {
            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-check-circle',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            msg: '{{ session('success') }}'
        });
    });
    </script>
    @endif
    
    @if ($errors->any())
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        @foreach ($errors->all() as $error)
        Lobibox.notify('error', {
            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-error',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            msg: '{{ $error }}'
        });
        @endforeach
    });
    </script>
    @endif
    @if(!$taskWatched)
    <script>
        var tag = document.createElement('script');
        tag.src = "https://www.youtube.com/iframe_api";
        var firstScriptTag = document.getElementsByTagName('script')[0];
        firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

        var player;
        var countdown;
        var watchedTime = 0;
        var minWatchTime = {{ $task->watch_time }};
        var timerElement = document.getElementById('timer');
        var token = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        function onYouTubeIframeAPIReady() {
            player = new YT.Player('player', {
                height: '315',
                width: '560',
                videoId: '{{ $embedUrl }}'.split('embed/')[1],
                events: {
                    'onStateChange': onPlayerStateChange
                }
            });
        }

        function onPlayerStateChange(event) {
            if (event.data == YT.PlayerState.PLAYING) {
                startCountdown();
            } else if (event.data == YT.PlayerState.PAUSED || event.data == YT.PlayerState.ENDED) {
                pauseCountdown();
            }

            if (event.data == YT.PlayerState.ENDED) {
                completeTask();
            }
        }

        function startCountdown() {
            countdown = setInterval(function() {
                if (watchedTime < minWatchTime) {
                    watchedTime++;
                    timerElement.textContent = minWatchTime - watchedTime;
                } else {
                    clearInterval(countdown);
                    completeTask();
                }
            }, 1000);
        }

        function pauseCountdown() {
            clearInterval(countdown);
        }

        function completeTask() {
            fetch('/tasks/{{ $task->id }}/complete', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': token
                },
                body: JSON.stringify({ watchedTime: watchedTime })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Görev Tamamlandı! Ödülünüz Hesabınıza Eklendi.');
                }
            });
        }
    </script>
    @endif
@endsection
