@extends('layouts.app')

@section('title', __('Create Website Visit Task'))

@section('style')
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{ __('Create Website Visit Task') }}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('website-visits.index') }}">{{ __('Website Visits') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Create Task') }}</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <a href="{{ route('website-visits.index') }}" class="btn btn-secondary">
                    <i class='bx bx-arrow-back me-1'></i>{{ __('Back') }}
                </a>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="row">
            <div class="col-xl-8 mx-auto">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class='bx bx-plus me-2'></i>{{ __('New Website Visit Task') }}
                        </h5>
                    </div>
                    <div class="card-body">
                        <form id="createTaskForm" action="{{ route('website-visits.store') }}" method="POST">
                            @csrf
                            
                            <!-- Basic Information -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <h6 class="text-primary">{{ __('Basic Information') }}</h6>
                                    <hr>
                                </div>
                                
                                <div class="col-md-12 mb-3">
                                    <label for="title" class="form-label">{{ __('Task Title') }} <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="title" name="title" required>
                                    <div class="invalid-feedback"></div>
                                </div>
                                
                                <div class="col-md-12 mb-3">
                                    <label for="description" class="form-label">{{ __('Task Description') }} <span class="text-danger">*</span></label>
                                    <textarea class="form-control" id="description" name="description" rows="3" required></textarea>
                                    <div class="invalid-feedback"></div>
                                    <small class="text-muted">{{ __('Explain what users need to do on the website') }}</small>
                                </div>
                            </div>

                            <!-- Website Information -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <h6 class="text-primary">{{ __('Website Information') }}</h6>
                                    <hr>
                                </div>
                                
                                <div class="col-md-12 mb-3">
                                    <label for="website_url" class="form-label">{{ __('Website URL') }} <span class="text-danger">*</span></label>
                                    <input type="url" class="form-control" id="website_url" name="website_url" required>
                                    <div class="invalid-feedback"></div>
                                    <small class="text-muted">{{ __('Full URL including http:// or https://') }}</small>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="visit_method" class="form-label">{{ __('Visit Method') }} <span class="text-danger">*</span></label>
                                    <select class="form-select" id="visit_method" name="visit_method" required>
                                        <option value="">{{ __('Select Method') }}</option>
                                        <option value="direct">{{ __('Direct Visit') }}</option>
                                        <option value="google_search">{{ __('Google Search') }}</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                                
                                <div class="col-md-6 mb-3" id="search_keywords_group" style="display: none;">
                                    <label for="search_keywords" class="form-label">{{ __('Search Keywords') }}</label>
                                    <input type="text" class="form-control" id="search_keywords" name="search_keywords">
                                    <div class="invalid-feedback"></div>
                                    <small class="text-muted">{{ __('Keywords users will search on Google') }}</small>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="required_time" class="form-label">{{ __('Required Time (seconds)') }} <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="required_time" name="required_time" min="10" max="3600" value="30" required>
                                    <div class="invalid-feedback"></div>
                                    <small class="text-muted">{{ __('Minimum time users must spend on website') }}</small>
                                </div>
                            </div>

                            <!-- Reward & Limits -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <h6 class="text-primary">{{ __('Reward & Limits') }}</h6>
                                    <hr>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="reward_amount" class="form-label">{{ __('Reward Amount') }} <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" id="reward_amount" name="reward_amount" step="0.01" min="0.01" required>
                                        <span class="input-group-text">₺</span>
                                    </div>
                                    <div class="invalid-feedback"></div>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="max_completions" class="form-label">{{ __('Maximum Completions') }} <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="max_completions" name="max_completions" min="1" value="100" required>
                                    <div class="invalid-feedback"></div>
                                    <small class="text-muted">{{ __('Total number of times this task can be completed') }}</small>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="user_daily_limit" class="form-label">{{ __('User Daily Limit') }} <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="user_daily_limit" name="user_daily_limit" min="1" max="10" value="1" required>
                                    <div class="invalid-feedback"></div>
                                    <small class="text-muted">{{ __('How many times per day each user can complete this task') }}</small>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="user_total_limit" class="form-label">{{ __('User Total Limit') }} <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" id="user_total_limit" name="user_total_limit" min="1" value="1" required>
                                    <div class="invalid-feedback"></div>
                                    <small class="text-muted">{{ __('How many times total each user can complete this task') }}</small>
                                </div>
                            </div>

                            <!-- Targeting -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <h6 class="text-primary">{{ __('Targeting Options') }}</h6>
                                    <hr>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="target_country_id" class="form-label">{{ __('Target Country') }}</label>
                                    <select class="form-select" id="target_country_id" name="target_country_id" data-placeholder="{{ __('All Countries') }}">
                                        <option value="0">{{ __('All Countries') }}</option>
                                        @foreach($countries as $country)
                                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="target_city_id" class="form-label">{{ __('Target City') }}</label>
                                    <select class="form-select" id="target_city_id" name="target_city_id" data-placeholder="{{ __('All Cities') }}">
                                        <option value="0">{{ __('All Cities') }}</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="target_gender" class="form-label">{{ __('Target Gender') }}</label>
                                    <select class="form-select" id="target_gender" name="target_gender" required>
                                        <option value="0">{{ __('All Genders') }}</option>
                                        <option value="1">{{ __('Male') }}</option>
                                        <option value="2">{{ __('Female') }}</option>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="expires_at" class="form-label">{{ __('Expiration Date') }}</label>
                                    <input type="datetime-local" class="form-control" id="expires_at" name="expires_at">
                                    <div class="invalid-feedback"></div>
                                    <small class="text-muted">{{ __('Leave empty for no expiration') }}</small>
                                </div>
                            </div>

                            <!-- Submit Buttons -->
                            <div class="row">
                                <div class="col-12">
                                    <hr>
                                    <div class="d-flex gap-3">
                                        <button type="submit" class="btn btn-primary" id="submitBtn">
                                            <span class="btn-text">
                                                <i class='bx bx-check me-1'></i>{{ __('Create Task') }}
                                            </span>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <a href="{{ route('website-visits.index') }}" class="btn btn-secondary">
                                            <i class='bx bx-x me-1'></i>{{ __('Cancel') }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    <!--notification js -->
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/notifications/js/notifications.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/notifications/js/notification-custom-script.js') }}"></script>
    
    <!--select2 js -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
    $(document).ready(function() {
        // Initialize Select2
        $('#target_country_id').select2({
            theme: 'bootstrap-5',
            placeholder: '{{ __("All Countries") }}',
            allowClear: true
        });
        
        $('#target_city_id').select2({
            theme: 'bootstrap-5',
            placeholder: '{{ __("All Cities") }}',
            allowClear: true
        });

        // Visit method change handler
        $('#visit_method').on('change', function() {
            const method = $(this).val();
            const keywordsGroup = $('#search_keywords_group');
            const keywordsInput = $('#search_keywords');
            
            if (method === 'google_search') {
                keywordsGroup.show();
                keywordsInput.attr('required', true);
            } else {
                keywordsGroup.hide();
                keywordsInput.attr('required', false);
            }
        });

        // Country change handler
        $('#target_country_id').on('change', function() {
            const countryId = $(this).val();
            const citySelect = $('#target_city_id');
            
            // Clear city select
            citySelect.empty().append('<option value="0">{{ __("All Cities") }}</option>');
            citySelect.select2('destroy').select2({
                theme: 'bootstrap-5',
                placeholder: '{{ __("All Cities") }}',
                allowClear: true
            });
            
            if (countryId && countryId !== '0' && countryId !== '') {
                $.get(`{{ url('/cities') }}/${countryId}`, function(cities) {
                    $.each(cities, function(index, city) {
                        citySelect.append(`<option value="${city.id}">${city.name}</option>`);
                    });
                    citySelect.trigger('change');
                });
            }
        });

        // Form submission
        $('#createTaskForm').on('submit', function(e) {
            e.preventDefault();
            
            const form = $(this);
            const submitBtn = $('#submitBtn');
            const btnText = submitBtn.find('.btn-text');
            const spinner = submitBtn.find('.spinner-border');
            
            // Clear previous errors
            $('.is-invalid').removeClass('is-invalid');
            $('.invalid-feedback').text('');
            
            // Show loading state
            submitBtn.prop('disabled', true);
            btnText.html('<i class="bx bx-loader bx-spin me-1"></i>{{ __("Creating...") }}');
            spinner.removeClass('d-none');
            
            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: form.serialize(),
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'X-Requested-With': 'XMLHttpRequest'
                },
                success: function(response) {
                    if (response.success) {
                        // Show success notification
                        Lobibox.notify('success', {
                            pauseDelayOnHover: true,
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            icon: 'bx bx-check-circle',
                            title: '{{ __("Success") }}',
                            msg: response.message
                        });
                        
                        // Redirect to tasks list
                        setTimeout(() => {
                            window.location.href = '{{ route("website-visits.index") }}';
                        }, 1500);
                    } else {
                        // Show error notification
                        Lobibox.notify('error', {
                            pauseDelayOnHover: true,
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            icon: 'bx bx-x-circle',
                            title: '{{ __("Error") }}',
                            msg: response.message || '{{ __("An error occurred") }}'
                        });
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        // Validation errors
                        const errors = xhr.responseJSON.errors;
                        
                        $.each(errors, function(field, messages) {
                            const input = $('[name="' + field + '"]');
                            input.addClass('is-invalid');
                            input.siblings('.invalid-feedback').text(messages[0]);
                        });
                        
                        // Show validation error notification
                        Lobibox.notify('error', {
                            pauseDelayOnHover: true,
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            icon: 'bx bx-error-circle',
                            title: '{{ __("Error") }}',
                            msg: xhr.responseJSON.message || '{{ __("Please check the form for errors") }}'
                        });
                    } else {
                        // General error
                        const errorMessage = xhr.responseJSON && xhr.responseJSON.message 
                            ? xhr.responseJSON.message 
                            : '{{ __("An error occurred while creating task") }}';
                            
                        Lobibox.notify('error', {
                            pauseDelayOnHover: true,
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            icon: 'bx bx-x-circle',
                            title: '{{ __("Error") }}',
                            msg: errorMessage
                        });
                    }
                },
                complete: function() {
                    // Reset button state
                    submitBtn.prop('disabled', false);
                    btnText.html('<i class="bx bx-check me-1"></i>{{ __("Create Task") }}');
                    spinner.addClass('d-none');
                }
            });
        });
    });
    </script>
@endsection