@extends('layouts.app')

@section('title', __('Website Visit Proofs'))

@section('style')
    <link href="{{ asset('assets/plugins/notifications/css/lobibox.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet">
@endsection

@section('wrapper')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">{{ __('Website Visit Proofs') }}</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('website-visits.index') }}">{{ __('Website Visits') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Proofs') }}</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="proofsTable" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>{{ __('User') }}</th>
                                <th>{{ __('Task') }}</th>
                                <th>{{ __('Description') }}</th>
                                <th>{{ __('Files') }}</th>
                                <th>{{ __('Status') }}</th>
                                <th>{{ __('Submitted') }}</th>
                                <th>{{ __('Actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($proofs as $proof)
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="ms-2">
                                            <h6 class="mb-0">{{ $proof->user->name }}</h6>
                                            <p class="text-muted mb-0">{{ $proof->user->email }}</p>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div>
                                        <h6 class="mb-0">{{ $proof->visit->task->title }}</h6>
                                        <small class="text-muted">{{ $proof->visit->task->website_url }}</small>
                                    </div>
                                </td>
                                <td>
                                    <div style="max-width: 200px;">
                                        {{ Str::limit($proof->description, 100) }}
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex flex-wrap gap-1">
                                        @foreach($proof->files as $file)
                                            <a href="{{ $file->getUrl() }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                                <i class='bx bx-image me-1'></i>{{ __('View') }}
                                            </a>
                                        @endforeach
                                    </div>
                                </td>
                                <td>
                                    @if($proof->status == 0)
                                        <span class="badge bg-warning">{{ __('Pending') }}</span>
                                    @elseif($proof->status == 1)
                                        <span class="badge bg-success">{{ __('Approved') }}</span>
                                    @else
                                        <span class="badge bg-danger">{{ __('Denied') }}</span>
                                    @endif
                                </td>
                                <td>{{ $proof->created_at->format('d/m/Y H:i') }}</td>
                                <td>
                                    @if($proof->status == 0)
                                        <button class="btn btn-success btn-sm" onclick="approveProof({{ $proof->id }})">
                                            <i class='bx bx-check me-1'></i>{{ __('Approve') }}
                                        </button>
                                        <button class="btn btn-danger btn-sm" onclick="denyProof({{ $proof->id }})">
                                            <i class='bx bx-x me-1'></i>{{ __('Deny') }}
                                        </button>
                                    @else
                                        <span class="text-muted">{{ __('Reviewed') }}</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <div class="d-flex justify-content-center mt-3">
                    {{ $proofs->links() }}
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Deny Reason Modal -->
<div class="modal fade" id="denyReasonModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Deny Proof') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="denyForm">
                    <input type="hidden" id="denyProofId" name="proof_id">
                    <div class="mb-3">
                        <label class="form-label">{{ __('Reason for denial') }}</label>
                        <textarea name="reason" class="form-control" rows="3" required 
                            placeholder="{{ __('Please provide a reason for denying this proof...') }}"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                <button type="button" class="btn btn-danger" onclick="submitDeny()">{{ __('Deny Proof') }}</button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    <script src="{{ asset('assets/plugins/notifications/js/lobibox.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/notifications/js/notifications.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js') }}"></script>

    <script>
        $(document).ready(function() {
            $('#proofsTable').DataTable({
                order: [[5, 'desc']], // Sort by submitted date
                pageLength: 25
            });
        });

        function approveProof(proofId) {
            if (confirm('{{ __("Are you sure you want to approve this proof?") }}')) {
                $.ajax({
                    url: `{{ url('/admin/website-visit-proofs') }}/${proofId}/approve`,
                    type: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    success: function(response) {
                        if (response.success) {
                            showNotification('success', '{{ __("Success") }}', response.message);
                            location.reload();
                        } else {
                            showNotification('error', '{{ __("Error") }}', response.message);
                        }
                    },
                    error: function(xhr) {
                        const message = xhr.responseJSON?.message || '{{ __("An error occurred") }}';
                        showNotification('error', '{{ __("Error") }}', message);
                    }
                });
            }
        }

        function denyProof(proofId) {
            $('#denyProofId').val(proofId);
            $('#denyReasonModal').modal('show');
        }

        function submitDeny() {
            const proofId = $('#denyProofId').val();
            const reason = $('#denyForm textarea[name="reason"]').val();

            if (!reason.trim()) {
                alert('{{ __("Please provide a reason for denial") }}');
                return;
            }

            $.ajax({
                url: `{{ url('/admin/website-visit-proofs') }}/${proofId}/deny`,
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'X-Requested-With': 'XMLHttpRequest'
                },
                data: {
                    reason: reason
                },
                success: function(response) {
                    if (response.success) {
                        showNotification('success', '{{ __("Success") }}', response.message);
                        $('#denyReasonModal').modal('hide');
                        location.reload();
                    } else {
                        showNotification('error', '{{ __("Error") }}', response.message);
                    }
                },
                error: function(xhr) {
                    const message = xhr.responseJSON?.message || '{{ __("An error occurred") }}';
                    showNotification('error', '{{ __("Error") }}', message);
                }
            });
        }

        function showNotification(type, title, message) {
            Lobibox.notify(type, {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                icon: type === 'success' ? 'bx bx-check-circle' : 'bx bx-x-circle',
                title: title,
                msg: message
            });
        }
    </script>
@endsection