<?php



use Illuminate\Support\Facades\Route;

use App\Http\Controllers\GorevSitesi\LandingController;

use App\Http\Controllers\GorevSitesi\ProductController;

use App\Http\Controllers\GorevSitesi\AuthController;

use App\Http\Controllers\GorevSitesi\OrderController;

use App\Http\Controllers\GorevSitesi\CartController;

use App\Http\Controllers\GorevSitesi\AccountController;

use App\Http\Controllers\GorevSitesi\BalanceController;



/*

|--------------------------------------------------------------------------

| Marketplace Routes (SC)

|--------------------------------------------------------------------------

| Bu dosya, SC domain grubunun (routes/web.php) İÇİNDE require edilir.

| Burada Route::domain(...) / Route::name('site2.') AÇMA.

*/



Route::get('/', [LandingController::class, 'index'])->name('landing');



Route::get('/urunler', [ProductController::class, 'index'])->name('products.index');

Route::get('/urunler/{id}', [ProductController::class, 'show'])->name('products.show');



Route::get('/login',    [AuthController::class, 'showLoginForm'])->name('login');

Route::post('/login',   [AuthController::class, 'login'])->name('login.submit');

Route::get('/register', [AuthController::class, 'showRegistrationForm'])->name('register');

Route::post('/register',[AuthController::class, 'register'])->name('register.submit');

Route::post('/logout',  [AuthController::class, 'logout'])->name('logout');



Route::get('/sepet',         [CartController::class, 'index'])->name('cart.index');

Route::post('/sepet/ekle',   [CartController::class, 'add'])->name('cart.add');

Route::post('/sepet/guncelle',[CartController::class, 'update'])->name('cart.update');

Route::post('/sepet/kaldir', [CartController::class, 'remove'])->name('cart.remove');

Route::get('/sepet/odeme',   [CartController::class, 'checkout'])->name('cart.checkout');



Route::post('/urunler/siparis-ver', [OrderController::class, 'store'])->name('products.order');



Route::middleware(['auth', 'is_customer'])->prefix('hesabim')->name('account.')->group(function () {

    Route::get('/', [AccountController::class, 'index'])->name('dashboard');

    // Profile routes
    Route::get('/profil', [AccountController::class, 'profile'])->name('profile');
    Route::post('/profil/guncelle', [AccountController::class, 'updateProfile'])->name('profile.update');
    Route::post('/sifre/guncelle', [AccountController::class, 'updatePassword'])->name('password.update');

    Route::get('/siparislerim',        [OrderController::class, 'index'])->name('orders');

    Route::get('/siparislerim/{id}',   [OrderController::class, 'show'])->name('orders.show');

    Route::post('/siparislerim/{id}/cancel', [OrderController::class, 'cancel'])->name('orders.cancel');



    Route::get('/bakiye-yukle',  [BalanceController::class, 'create'])->name('balance.create');

    Route::post('/bakiye-yukle', [BalanceController::class, 'store'])->name('balance.store');

});

