<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

// MODELLER
use App\Models\City;
use App\Models\Country;
use App\Models\SocialPlatform;

// PRIMARY SITE CONTROLLERS
use App\Http\Controllers\HomeController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CityController;
use App\Http\Controllers\TaskController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\TaskProofController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\MemberController;
use App\Http\Controllers\ProductController as MainProductController;
use App\Http\Controllers\ProductCategoryController;
use App\Http\Controllers\ProfitController;
use App\Http\Controllers\UserProfileController;
use App\Http\Controllers\WebsiteVisitController;
use App\Http\Controllers\Admin\WebsiteVisitTaskController as AdminWebsiteVisitTaskController;
use App\Http\Controllers\User\WebsiteVisitTaskController as UserWebsiteVisitTaskController;
use App\Http\Controllers\Api\WatchTaskController;
use App\Http\Controllers\AnnouncementController;
use App\Http\Controllers\SocialPlatformController;
use App\Http\Controllers\SocialMediaAccountController;
use App\Http\Controllers\Admin\BalanceRequestController;

// SECONDARY SITE CONTROLLERS (SC)
use App\Http\Controllers\GorevSitesi\SecondaryLanguageController;
use App\Http\Controllers\GorevSitesi\LandingController as SCLandingController;
use App\Http\Controllers\GorevSitesi\ProductController as SCProductController;
use App\Http\Controllers\GorevSitesi\CartController as SCCartController;
use App\Http\Controllers\GorevSitesi\AuthController as SCAuthController;
use App\Http\Controllers\GorevSitesi\AccountController as SCAccountController;
use App\Http\Controllers\GorevSitesi\OrderController as SCOrderController;
use App\Http\Controllers\GorevSitesi\BalanceController as SCBalanceController;

// ====== DOMAINLERİ DOĞRU FORMATTA ÇÖZ ======
$primaryHost   = parse_url(config('app.url'), PHP_URL_HOST) ?: config('app.url');
$secondaryHost = parse_url(config('app.secondary_url'), PHP_URL_HOST) ?: config('app.secondary_url');

// =====================================================================
// 1) ANA SİTE (gorevsaati.com.tr)
// =====================================================================
Route::domain($primaryHost)->group(function () {

    // Dil değişimi (Ana site)
    Route::get('lang/{lang}', [LanguageController::class, 'switch'])->name('lang.switch');

    // Şehir/ülke ajax
    Route::get('/cities/{country}', [TaskController::class, 'getCitiesByCountry'])->name('cities.byCountry');

    // Auth
    Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('login', [LoginController::class, 'login'])->name('login.submit');
    Route::post('logout', [LoginController::class, 'logout'])->name('logout');

    Route::get('register', function () {
        $countries = Country::all();
        $cities = City::all();
        return view('auth.register', compact('countries','cities'));
    })->name('register');

    Route::post('register', [AuthController::class, 'register']);

    // Admin ayarları
    Route::middleware(['auth', 'isAdmin'])->group(function () {
        Route::get('/all-members', [MemberController::class, 'index'])->name('all_members');
        Route::get('/members/ajax', [MemberController::class, 'getMembersAjax'])->name('members.ajax');
        Route::get('/members/{id}/details', [MemberController::class, 'getMemberDetails'])->name('members.details');
        Route::post('/members/{id}/unban', [MemberController::class, 'unbanMember'])->name('members.unban');

        Route::get('/settings', [App\Http\Controllers\SettingsController::class, 'index'])->name('settings.index');
        Route::post('/settings', [App\Http\Controllers\SettingsController::class, 'update'])->name('settings.update');
    });

    // Public landing
    Route::get('/', [HomeController::class, 'landing'])->name('landing');

    // ==== AUTH GEREKTİREN ANA GRUP ====
    Route::middleware(['auth'])->group(function () {

        // Task işlemleri
        Route::post('/task/activate/{id}', [TaskController::class, 'activateTask'])->name('tasks.activate');
        Route::post('/task/disable/{id}', [TaskController::class, 'disableTask'])->name('tasks.disable');
        Route::post('/task/confirm/{id}', [TaskController::class, 'confirmTask'])->name('tasks.confirm');
        Route::post('/task/delete/{id}', [TaskController::class, 'deleteTask'])->name('tasks.delete');
        Route::post('/task/visible/{id}', [TaskController::class, 'visibleTask'])->name('tasks.visible');
        Route::post('/task/unvisible/{id}', [TaskController::class, 'unvisibleTask'])->name('tasks.unvisible');

        // YouTube Video İzleme
        Route::get('/tasks/watch', [App\Http\Controllers\WatchController::class, 'index'])->name('tasks.watch');
        Route::get('/my/watch-tasks', [App\Http\Controllers\WatchController::class, 'myTasks'])->name('user.watch.tasks');
        Route::get('/watch/{taskId}', [App\Http\Controllers\WatchController::class, 'watch'])->name('watch.video');
        Route::post('/watch/update-progress', [App\Http\Controllers\WatchController::class, 'updateProgress'])->name('watch.progress');
        Route::post('/watch/claim-reward', [App\Http\Controllers\WatchController::class, 'claimReward'])->name('watch.claim');
        Route::post('/watch-tasks/create', [App\Http\Controllers\WatchController::class, 'store'])->name('watch.store');
        Route::get('/my/watch-tasks/{task}/edit', [App\Http\Controllers\WatchController::class, 'editTask'])->name('user.watch.edit');
        Route::post('/my/watch-tasks/{task}/update', [App\Http\Controllers\WatchController::class, 'updateTask'])->name('user.watch.update');

        Route::resource('tasks', TaskController::class);
        Route::get('/tasks-deleted', [TaskController::class, 'unvisibleTasks'])->name('tasks.deleted');
        Route::match(['GET', 'POST'], '/task-info', [TaskController::class, 'show'])->name('task.info');

        // Dashboard / API
        Route::get('/tasks-list', [TaskController::class, 'taskList'])->name('tasks.list');
        Route::get('/home', [HomeController::class, 'index'])->name('task.index');
        Route::get('/dashboard', [HomeController::class, 'index'])->name('index');
        Route::get('/dashboard', [HomeController::class, 'index'])->name('dashboard');

        // (blade’de kullanılan) İSİMLİ API uçları
        Route::get('/api/users-datatable', [HomeController::class, 'getUsersDataTable'])->name('api.users.datatable');
        Route::get('/api/recent-tasks', [HomeController::class, 'getRecentTasksApi'])->name('api.recent.tasks');

        // Proofs
        Route::post('/task/submit-proof', [TaskProofController::class, 'store'])->name('task.proofSubmit');
        Route::get('/task-proofs', [TaskProofController::class, 'index'])->name('task.proofs.index');
        Route::get('/api/task-proofs-datatable', [TaskProofController::class, 'getProofsDataTable'])->name('api.task.proofs.datatable');
        Route::post('/task-proofs/{id}/approve', [TaskProofController::class, 'approveProof'])->name('task.proofs.approve');
        Route::post('/task-proofs/{id}/deny', [TaskProofController::class, 'denyProof'])->name('task.proofs.deny');
        // Notification routes
        Route::get('/notifications', [NotificationController::class, 'index'])->name('notifications.index');
        Route::post('/mark-notification-read/{id}', [NotificationController::class, 'markAsRead'])->name('notifications.mark-read');
        Route::post('/mark-all-notifications-read', [NotificationController::class, 'markAllAsRead'])->name('notifications.mark-all-read');
        Route::delete('/notifications/{id}', [NotificationController::class, 'destroy'])->name('notifications.destroy');
        Route::get('/proofs/{proof}', [TaskProofController::class, 'show'])->name('proofs.show');
        Route::post('/proofs/{proof}/status', [TaskProofController::class, 'updateStatus'])->name('proofs.updateStatus');
        Route::get('/proofs/table', [TaskProofController::class, 'getTable'])->name('proofs.table');
        Route::get('/tasks/checkPendingProof/{taskId}', [TaskController::class, 'checkPendingProof'])->name('tasks.checkPendingProof');
        Route::post('/approve-proof/{id}', [TaskController::class, 'approveProof'])->name('proofs.approve');
        Route::post('/deny-proof/{id}', [TaskController::class, 'denyProof'])->name('proofs.deny');
        Route::get('/proofs-denied', [TaskController::class, 'showDeniedProofs'])->name('task.proofs.denied');
        Route::get('/api/denied-proofs-datatable', [TaskController::class, 'getDeniedProofsDataTable'])->name('api.denied.proofs.datatable');
        Route::post('/denied-proofs/{id}/reactivate', [TaskController::class, 'reactivateProof'])->name('denied.proofs.reactivate');

        // Para Çekim İşlemleri + AJAX helpers
        Route::get('/withdrawals', [App\Http\Controllers\WithdrawalController::class, 'index'])->name('withdrawals.index');
        Route::post('/withdrawals', [App\Http\Controllers\WithdrawalController::class, 'store'])->name('withdrawals.store');
        Route::post('/withdrawals/{id}/cancel', [App\Http\Controllers\WithdrawalController::class, 'cancel'])->name('withdrawals.cancel');

        Route::get('/api/cities/{countryCode}', [CityController::class, 'getCitiesByCountry'])->name('api.cities');
        Route::post('/profile/update', [UserProfileController::class, 'update'])->name('user.profile.update');

        // Watch Analytics (user + admin)
        Route::get('/my/watch-analytics', [App\Http\Controllers\WatchController::class, 'userAnalytics'])->name('user.watch.analytics');
        Route::get('/api/user/watch-tasks-datatable', [App\Http\Controllers\WatchController::class, 'userDataTable'])->name('api.user.watch.datatable');



        // ✅ EKSİK OLAN: Admin watch analytics sayfası + admin datatable API
        Route::get('/admin/watch-analytics', [App\Http\Controllers\WatchController::class, 'adminAnalytics'])->name('admin.watch.analytics')->middleware('isAdmin');
        Route::get('/api/admin/watch-tasks-datatable', [App\Http\Controllers\WatchController::class, 'adminDataTable'])->name('api.admin.watch.datatable')->middleware('isAdmin');

        // Admin: Withdrawal Mgmt
        Route::get('/admin/withdrawals', [App\Http\Controllers\WithdrawalController::class, 'adminIndex'])->name('admin.withdrawals.index')->middleware('isAdmin');
        Route::get('/api/admin/withdrawals-datatable', [App\Http\Controllers\WithdrawalController::class, 'adminDataTable'])->name('api.admin.withdrawals.datatable')->middleware('isAdmin');
        Route::get('/admin/withdrawals/{id}/details', [App\Http\Controllers\WithdrawalController::class, 'details'])->name('admin.withdrawals.details')->middleware('isAdmin');
        Route::post('/admin/withdrawals/{id}/approve', [App\Http\Controllers\WithdrawalController::class, 'approve'])->name('admin.withdrawals.approve')->middleware('isAdmin');
        Route::post('/admin/withdrawals/{id}/reject', [App\Http\Controllers\WithdrawalController::class, 'reject'])->name('admin.withdrawals.reject')->middleware('isAdmin');
        Route::post('/admin/withdrawals/{id}/complete', [App\Http\Controllers\WithdrawalController::class, 'complete'])->name('admin.withdrawals.complete')->middleware('isAdmin');

        // Ticket System (user + admin)
        Route::get('/tickets', [App\Http\Controllers\TicketController::class, 'index'])->name('tickets.index');
        Route::get('/tickets/create', [App\Http\Controllers\TicketController::class, 'create'])->name('tickets.create');
        Route::post('/tickets', [App\Http\Controllers\TicketController::class, 'store'])->name('tickets.store');
        Route::get('/tickets/{id}', [App\Http\Controllers\TicketController::class, 'show'])->name('tickets.show');
        Route::post('/tickets/{id}/message', [App\Http\Controllers\TicketController::class, 'sendMessage'])->name('tickets.message');

        Route::get('/admin/tickets', [App\Http\Controllers\TicketController::class, 'adminIndex'])->name('admin.tickets.index')->middleware('isAdmin');
        Route::post('/admin/tickets', [App\Http\Controllers\TicketController::class, 'adminStore'])->name('admin.tickets.store')->middleware('isAdmin');
        Route::get('/api/admin/tickets-datatable', [App\Http\Controllers\TicketController::class, 'adminDataTable'])->name('api.admin.tickets.datatable')->middleware('isAdmin');
        Route::post('/admin/tickets/{id}/status', [App\Http\Controllers\TicketController::class, 'updateStatus'])->name('admin.tickets.status')->middleware('isAdmin');
        Route::post('/admin/tickets/{id}/assign', [App\Http\Controllers\TicketController::class, 'assign'])->name('admin.tickets.assign')->middleware('isAdmin');

        // User search API (admin)
        Route::get('/api/users/search', [UserController::class, 'search'])->name('api.users.search')->middleware('isAdmin');

        // Mobile API
        Route::get('/api/tickets/mobile', [App\Http\Controllers\TicketController::class, 'mobileData'])->name('api.tickets.mobile');

        // Duyurular
        Route::get('/announcements', [AnnouncementController::class, 'index'])->name('announcements.index');
        Route::get('/announcements/{id}', [AnnouncementController::class, 'show'])->name('announcements.show');
        Route::post('/announcements/{id}/read', [AnnouncementController::class, 'markAsRead'])->name('announcements.read');
        Route::get('/api/announcements/popup', [AnnouncementController::class, 'getPopupAnnouncements'])->name('api.announcements.popup');

        // Admin duyuru
        Route::get('/admin/announcements', [AnnouncementController::class, 'adminIndex'])->name('admin.announcements.index')->middleware('isAdmin');
        Route::get('/admin/announcements/create', [AnnouncementController::class, 'create'])->name('admin.announcements.create')->middleware('isAdmin');
        Route::post('/admin/announcements', [AnnouncementController::class, 'store'])->name('admin.announcements.store')->middleware('isAdmin');
        Route::get('/admin/announcements/{id}/edit', [AnnouncementController::class, 'getEditData'])->name('admin.announcements.edit')->middleware('isAdmin');
        Route::post('/admin/announcements/{id}', [AnnouncementController::class, 'update'])->name('admin.announcements.update')->middleware('isAdmin');
        Route::delete('/admin/announcements/{id}', [AnnouncementController::class, 'destroy'])->name('admin.announcements.destroy')->middleware('isAdmin');
        Route::get('/api/admin/announcements-datatable', [AnnouncementController::class, 'adminDataTable'])->name('api.admin.announcements.datatable')->middleware('isAdmin');


/*
|--------------------------------------------------------------------------
| YouTube Watch “API” Rotları
|--------------------------------------------------------------------------
| Artık bunlar web.php içinde, "web" + "auth" middleware ile korunuyor.
*/

Route::middleware(['web','auth'])->prefix('api')->group(function () {
         
    // Başkalarının görevlerini listele
Route::get('/watch-tasks', [WatchTaskController::class, 'index']) ->name('api.watch.tasks');
    // Yeni görev oluştur
Route::post('/watch-tasks', [WatchTaskController::class, 'store'])->name('api.watch.store');
    // Görev aktif/pasif toggle
Route::post('/watch-tasks/{task}/toggle', [WatchTaskController::class, 'toggleStatus'])->name('api.watch.toggle');
    // Görevi sil (spoofing ile POST)
Route::delete('/watch-tasks/{task}', [WatchTaskController::class, 'destroy'])->name('api.watch.destroy');
    // Sosyal medya hesabı sil
Route::delete('/social-accounts/{id}', [SocialMediaAccountController::class, 'destroy'])->name('api.social_accounts.destroy');
    // Kişinin kendi görevlerini yönetme
Route::get('/user/watch-tasks', [WatchTaskController::class, 'userTasks'])->name('api.user.watch.tasks');
Route::get('/user/watch-tasks/{task}', [WatchTaskController::class, 'show'])->name('api.user.watch.show');
Route::post('/user/watch-tasks/{task}', [WatchTaskController::class, 'update'])->name('api.user.watch.update');
});

        // Dashboard AJAX
        Route::get('/ajax/recent-tasks', [HomeController::class, 'getRecentTasksAjax'])->name('ajax.recent-tasks');
        Route::get('/ajax/recent-members', [HomeController::class, 'getRecentMembersAjax'])->name('ajax.recent-members')->middleware('isAdmin');

// Bu route'u auth middleware grubuna taşıdık
Route::get('/proofs-approved', [TaskController::class, 'showAprrovedProofs'])->name('task.proofs.aproved');
Route::get('/proof-images/{proofId}', [TaskController::class, 'getProofImages'])->name('proof.images');
Route::post('/task/watch', [TaskController::class, 'watch'])->name('task.watch.old');
Route::get('/task/watch', [App\Http\Controllers\WatchController::class, 'index'])->name('task.watch');
Route::post('/tasks/{id}/complete', [TaskController::class, 'complete'])->name('tasks.complete');
Route::resource('social-platforms', SocialPlatformController::class);
Route::get('social-platforms-search', [SocialPlatformController::class, 'search'])->name('social-platforms.search');

        // User Social Accounts
        Route::get('/my-social-accounts', [SocialMediaAccountController::class, 'userIndex'])->name('user.social_accounts.index');
        Route::post('/my-social-accounts', [SocialMediaAccountController::class, 'store'])->name('user.social_accounts.store');
        Route::delete('/my-social-accounts/{id}', [SocialMediaAccountController::class, 'destroy'])->name('user.social_accounts.destroy');
        Route::post('/my-social-accounts/{id}/delete', [SocialMediaAccountController::class, 'destroy'])->name('user.social_accounts.delete');
        Route::get('/my-social-accounts/search', [SocialMediaAccountController::class, 'userSearch'])->name('user.social_accounts.search');
        Route::get('/social-platforms-list', [SocialMediaAccountController::class, 'getPlatforms'])->name('social_platforms.list');

        // Eski sistem uyumluluğu
        Route::post('/social-media-accounts/{id}/delete', [SocialMediaAccountController::class, 'destroy'])->name('social_media_accounts.delete');

        // Admin Social Accounts + Backups
        Route::middleware(['auth', 'is_not_customer', 'isAdmin'])->group(function () {
            Route::get('/admin/social-accounts', [SocialMediaAccountController::class, 'adminIndex'])->name('admin.social_accounts.index');
            Route::get('/admin/social-accounts/search', [SocialMediaAccountController::class, 'adminSearch'])->name('admin.social_accounts.search');
            Route::post('/admin/social-accounts/{id}/approve', [SocialMediaAccountController::class, 'approve'])->name('admin.social_accounts.approve');
            Route::post('/admin/social-accounts/{id}/reject', [SocialMediaAccountController::class, 'reject'])->name('admin.social_accounts.reject');
            Route::delete('/admin/social-accounts/{id}', [SocialMediaAccountController::class, 'adminDestroy'])->name('admin.social_accounts.destroy');

            Route::prefix('admin/backups')->name('admin.backups.')->middleware('backup')->group(function () {
                Route::get('/', [App\Http\Controllers\Admin\BackupController::class, 'index'])->name('index');
                Route::post('/create', [App\Http\Controllers\Admin\BackupController::class, 'create'])->name('create');
                Route::get('/{backup}/download', [App\Http\Controllers\Admin\BackupController::class, 'download'])->name('download');
                Route::post('/{backup}/restore', [App\Http\Controllers\Admin\BackupController::class, 'restore'])->name('restore');
                Route::delete('/{backup}', [App\Http\Controllers\Admin\BackupController::class, 'destroy'])->name('destroy');
                Route::get('/{backup}/progress', [App\Http\Controllers\Admin\BackupController::class, 'progress'])->name('progress');
                Route::post('/cleanup', [App\Http\Controllers\Admin\BackupController::class, 'cleanup'])->name('cleanup');
            });
        });

        // Kullanıcı işlemleri
        Route::post('/delete-member', [MemberController::class, 'deleteMember'])->name('delete_member');
        Route::post('/banned-member', [MemberController::class, 'banMember'])->name('banned_member');

        // Aynı IP
        Route::middleware(['auth', 'isAdmin'])->group(function () {
            Route::get('/users/same-ip', [UserController::class, 'listUsersWithSameIp'])->name('same.ip');
            Route::get('/users/same-ip/ajax', [UserController::class, 'getSameIpUsersAjax'])->name('same.ip.ajax');
            Route::get('/users/same-ip/{id}/details', [UserController::class, 'getSameIpUserDetails'])->name('same.ip.details');
            Route::post('/users/same-ip/{id}/ban', [UserController::class, 'banMember'])->name('same.ip.ban');
            Route::post('/users/same-ip/{id}/unban', [UserController::class, 'unbanMember'])->name('same.ip.unban');
            Route::post('/users/same-ip/{id}/delete', [UserController::class, 'deleteMember'])->name('same.ip.delete');
        });

        // User Profile
        Route::get('/profile', [UserProfileController::class, 'index'])->name('user.profile');
        Route::get('/profile/edit', [UserProfileController::class, 'edit'])->name('user.profile.edit');
        Route::post('/profile', [UserProfileController::class, 'update'])->name('user.profile.update.old');
        Route::post('/profile/password', [UserProfileController::class, 'updatePassword'])->name('user.password.update');

        // Website Visit Tasks
        Route::get('/website-visits', [WebsiteVisitController::class, 'index'])->name('website-visits.index');
        Route::post('/website-visits/{task}/start', [WebsiteVisitController::class, 'startVisit'])->name('website-visits.start');
        Route::post('/website-visits/track/{visit}', [WebsiteVisitController::class, 'trackVisit'])->name('website-visits.track');
        Route::post('/website-visits/complete/{visit}', [WebsiteVisitController::class, 'completeVisit'])->name('website-visits.complete');
        Route::post('/website-visits/submit-proof', [WebsiteVisitController::class, 'submitProof'])->name('website-visits.submit-proof');
        Route::post('/website-visits/window-close', [WebsiteVisitController::class, 'handleWindowClose'])->name('website-visits.window-close');
        Route::post('/website-visits/cancel/{visit}', [WebsiteVisitController::class, 'cancelVisit'])->name('website-visits.cancel');
        Route::get('/website-visits/{task}', [WebsiteVisitController::class, 'show'])->name('website-visits.show');

        // Admin Website Visit Tasks
        Route::middleware(['auth', 'is_not_customer', 'isAdmin'])->prefix('admin')->name('admin.')->group(function () {
            Route::get('/website-visits', [AdminWebsiteVisitTaskController::class, 'index'])->name('website-visits.index');
            Route::get('/dashboard', [HomeController::class, 'index'])->name('index');
            Route::get('/website-visits/{task}', [AdminWebsiteVisitTaskController::class, 'show'])->name('website-visits.show');
            Route::get('/website-visits/{task}/export', [AdminWebsiteVisitTaskController::class, 'exportVisits'])->name('website-visits.export');
            Route::get('/website-visits/{task}/recent-visits', [AdminWebsiteVisitTaskController::class, 'getRecentVisits'])->name('website-visits.recent-visits');
            Route::delete('/website-visits/{task}', [AdminWebsiteVisitTaskController::class, 'destroy'])->name('website-visits.destroy');
            Route::post('/website-visits/{task}/delete', [AdminWebsiteVisitTaskController::class, 'destroy'])->name('website-visits.delete');
            Route::get('/website-visit-proofs', [AdminWebsiteVisitTaskController::class, 'proofs'])->name('website-visits.proofs.index');
            Route::post('/website-visit-proofs/{proof}/approve', [AdminWebsiteVisitTaskController::class, 'approveProof'])->name('website-visits.proofs.approve');
            Route::post('/website-visit-proofs/{proof}/deny', [AdminWebsiteVisitTaskController::class, 'denyProof'])->name('website-visits.proofs.deny');
        });

        // Kullanıcı Website Visit Tasks yönetimi
        Route::prefix('my')->name('user.')->group(function () {
            Route::get('/website-visits', [UserWebsiteVisitTaskController::class, 'index'])->name('website-visits.index');
            Route::get('/website-visits/create', [UserWebsiteVisitTaskController::class, 'create'])->name('website-visits.create');
            Route::post('/website-visits', [UserWebsiteVisitTaskController::class, 'store'])->name('website-visits.store');
            Route::get('/website-visits/{task}', [UserWebsiteVisitTaskController::class, 'show'])->name('website-visits.show');
            Route::get('/website-visits/{task}/edit', [UserWebsiteVisitTaskController::class, 'edit'])->name('website-visits.edit');
            Route::post('/website-visits/{task}', [UserWebsiteVisitTaskController::class, 'update'])->name('website-visits.update');
            Route::delete('/website-visits/{task}', [UserWebsiteVisitTaskController::class, 'destroy'])->name('website-visits.destroy');
        });
    });

    // Digital Products (ANA site)
    Route::get('/products', [MainProductController::class, 'index'])->name('products.index');
    Route::get('/api/products', [MainProductController::class, 'getProductsAjax'])->name('api.products');
    Route::get('/api/product-categories', [MainProductController::class, 'getCategories'])->name('api.product-categories');
    Route::get('/api/orders/{id}', [App\Http\Controllers\OrderController::class, 'getOrderDetails'])->name('api.orders.show');

    // Admin Order Management
    Route::middleware(['auth', 'isAdmin'])->prefix('admin')->group(function () {
        Route::post('/orders/{id}/status', [App\Http\Controllers\OrderController::class, 'updateStatus'])->name('admin.orders.update-status');
    });

    // Orders System
    Route::middleware(['auth', 'is_not_customer'])->group(function () {
        Route::get('/orders', [App\Http\Controllers\OrderController::class, 'index'])->name('orders.index');
        Route::post('/orders', [App\Http\Controllers\OrderController::class, 'store'])->name('orders.store');
        Route::get('/orders/{id}', [App\Http\Controllers\OrderController::class, 'show'])->name('orders.show');
        Route::post('/orders/{id}/cancel', [App\Http\Controllers\OrderController::class, 'cancel'])->name('orders.cancel');
        Route::get('/api/orders', [App\Http\Controllers\OrderController::class, 'getUserOrdersAjax'])->name('api.orders');

        Route::get('/product/{id}', [MainProductController::class, 'show'])->name('products.show.user');
    });

    // Admin Product & Order
    Route::middleware(['auth', 'is_not_customer', 'isAdmin'])->group(function () {
        Route::get('/admin/products', [MainProductController::class, 'adminIndex'])->name('admin.products.index');
        Route::get('/api/admin/products-datatable', [MainProductController::class, 'adminDataTable'])->name('api.admin.products.datatable');

        Route::get('/admin/orders', [App\Http\Controllers\OrderController::class, 'adminIndex'])->name('admin.orders.index');
        Route::post('/admin/orders/{id}/status', [App\Http\Controllers\OrderController::class, 'updateStatus'])->name('admin.orders.status');
        Route::get('/api/admin/orders-datatable', [App\Http\Controllers\OrderController::class, 'adminDataTable'])->name('api.admin.orders.datatable');
        
        // Balance Requests Admin Routes
  Route::middleware(['auth', 'is_not_customer', 'isAdmin'])
    ->prefix('admin')->name('admin.')
    ->group(function () {

        // Admin ana sayfa istersen kalsın
        Route::get('/', [BalanceRequestController::class, 'index'])->name('index');

        // Balance Requests alt grubu
        Route::prefix('balance-requests')->name('balance-requests.')->group(function () {
            Route::get('/', [BalanceRequestController::class, 'index'])->name('index');
            Route::get('/{id}', [BalanceRequestController::class, 'show'])->name('show');
            Route::patch('/{id}/approve', [BalanceRequestController::class, 'approve'])->name('approve');
            Route::patch('/{id}/reject', [BalanceRequestController::class, 'reject'])->name('reject');
            Route::get('/{id}/download-receipt', [BalanceRequestController::class, 'downloadReceipt'])->name('download-receipt');
        });

        // Language Management alt grubu (JSON based)
        Route::prefix('languages')->name('languages.')->group(function () {
            Route::get('/', [\App\Http\Controllers\Admin\LanguageController::class, 'index'])->name('index');
            Route::get('/data', [\App\Http\Controllers\Admin\LanguageController::class, 'getData'])->name('data');
            Route::post('/', [\App\Http\Controllers\Admin\LanguageController::class, 'store'])->name('store');
            Route::put('/{code}', [\App\Http\Controllers\Admin\LanguageController::class, 'update'])->name('update');
            Route::delete('/{code}', [\App\Http\Controllers\Admin\LanguageController::class, 'destroy'])->name('destroy');
            
            // Translation Management
            Route::get('/{code}/translations', [\App\Http\Controllers\Admin\LanguageController::class, 'translations'])->name('translations');
            Route::get('/{code}/translations/data', [\App\Http\Controllers\Admin\LanguageController::class, 'getTranslations'])->name('translations.data');
            Route::post('/{code}/translations/update', [\App\Http\Controllers\Admin\LanguageController::class, 'updateTranslation'])->name('translations.update');
            Route::post('/{code}/translations/add', [\App\Http\Controllers\Admin\LanguageController::class, 'addTranslation'])->name('translations.add');
            
            // Export
            Route::get('/{code}/export', [\App\Http\Controllers\Admin\LanguageController::class, 'export'])->name('export');
        });
    });

        // Admin Product CRUD
        Route::get('/products/create', [MainProductController::class, 'create'])->name('products.create');
        Route::post('/products', [MainProductController::class, 'store'])->name('products.store');
        Route::post('/products/{id}/delete', [MainProductController::class, 'destroy'])->name('products.destroy');
        Route::get('/products/{id}/edit', [MainProductController::class, 'edit'])->name('products.edit');
        Route::post('/products/{id}', [MainProductController::class, 'update'])->name('products.update');
        Route::get('/products/{id}', [MainProductController::class, 'show'])->name('products.show');
    });

    // Profit/Earnings
    Route::middleware(['auth', 'is_not_customer'])->group(function () {
        Route::get('/profits/user', [ProfitController::class, 'userIndex'])->name('profit.user');
        Route::get('/api/profits/user-data', [ProfitController::class, 'getUserData'])->name('profit.user.data');
    });

    Route::middleware(['auth', 'is_not_customer', 'isAdmin'])->group(function () {
        Route::get('/profits/admin', [ProfitController::class, 'adminIndex'])->name('profit.admin');
        Route::get('/api/profits/admin-data', [ProfitController::class, 'getAdminData'])->name('profit.admin.data');
    });
});

// =====================================================================
// 2) İKİNCİL SİTE (gorevsitesi.com.tr)
// =====================================================================
Route::domain($secondaryHost)->name('site2.')->group(function () {
    // SC – Dil değişimi
    Route::get('/lang/{lang}', [SecondaryLanguageController::class, 'switch'])->name('lang.switch');

    // SC – Register AJAX: Ülkeye göre şehir listesi
    Route::get('/api/cities/{countryCode}', [SCAuthController::class, 'getCitiesByCountryCode'])->name('api.cities');

    // Marketplace rotalarını bu grubun İÇİNDE dahil et
    $marketplacePath = __DIR__ . '/marketplace.php';
    if (file_exists($marketplacePath)) {
        require $marketplacePath;
    }
});
