<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\TaskController;
use App\Http\Controllers\WatchController;
use App\Http\Controllers\Api\WatchTaskController;
use App\Http\Controllers\TaskProofController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\SocialPlatformController;
use App\Http\Controllers\SocialMediaAccountController;
use App\Http\Controllers\CityController;
use App\Http\Controllers\UserProfileController;
use App\Http\Controllers\WebsiteVisitController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\AnnouncementController;
use App\Http\Controllers\TicketController;

/*
|--------------------------------------------------------------------------
| Public Routes
|--------------------------------------------------------------------------
*/
Route::get('/', [HomeController::class, 'landing'])->name('landing');

/*
|--------------------------------------------------------------------------
| Authentication Routes
|--------------------------------------------------------------------------
*/
Auth::routes();

/*
|--------------------------------------------------------------------------
| Authenticated User Routes
|--------------------------------------------------------------------------
*/
Route::middleware('auth')->group(function () {
    // Home / Dashboard
    Route::get('/home', [HomeController::class, 'index'])->name('task.index');
    Route::get('/dashboard', [HomeController::class, 'index'])->name('dashboard');

    // Task Management
    Route::post('/task/activate/{id}', [TaskController::class, 'activateTask'])->name('tasks.activate');
    Route::post('/task/disable/{id}', [TaskController::class, 'disableTask'])->name('tasks.disable');
    Route::post('/task/confirm/{id}', [TaskController::class, 'confirmTask'])->name('tasks.confirm');
    Route::post('/task/delete/{id}', [TaskController::class, 'deleteTask'])->name('tasks.delete');
    Route::post('/task/visible/{id}', [TaskController::class, 'visibleTask'])->name('tasks.visible');
    Route::post('/task/unvisible/{id}', [TaskController::class, 'unvisibleTask'])->name('tasks.unvisible');
    Route::resource('tasks', TaskController::class);
    Route::get('/tasks-deleted', [TaskController::class, 'unvisibleTasks'])->name('tasks.deleted');
    Route::match(['GET', 'POST'], '/task-info', [TaskController::class, 'show'])->name('task.info');
    Route::get('/tasks-list', [TaskController::class, 'taskList'])->name('tasks.list');

    // YouTube Watch Module
    Route::get('/tasks/watch', [WatchController::class, 'index'])->name('tasks.watch');
    Route::get('/my/watch-tasks', [WatchController::class, 'myTasks'])->name('user.watch.tasks');
    Route::get('/watch/{taskId}', [WatchController::class, 'watch'])->name('watch.video');
    Route::post('/watch/update-progress', [WatchController::class, 'updateProgress'])->name('watch.progress');
    Route::post('/watch/claim-reward', [WatchController::class, 'claimReward'])->name('watch.claim');
    Route::post('/watch-tasks/create', [WatchController::class, 'store'])->name('watch.store');
    Route::get('/my/watch-tasks/{task}/edit', [WatchController::class, 'editTask'])->name('user.watch.edit');
    Route::post('/my/watch-tasks/{task}/update', [WatchController::class, 'updateTask'])->name('user.watch.update');

    // Task Proofs
    Route::post('/task/submit-proof', [TaskProofController::class, 'store'])->name('task.proofSubmit');
    Route::get('/task-proofs', [TaskProofController::class, 'index'])->name('task.proofs.index');
    Route::post('/task-proofs/{id}/approve', [TaskProofController::class, 'approveProof'])->name('task.proofs.approve');
    Route::post('/task-proofs/{id}/deny', [TaskProofController::class, 'denyProof'])->name('task.proofs.deny');

    // Notifications
    Route::post('/mark-notification-read/{id}', [NotificationController::class, 'markAsRead']);

    // Social Platforms & Accounts
    Route::resource('social-platforms', SocialPlatformController::class);
    Route::get('social-platforms-search', [SocialPlatformController::class, 'search'])->name('social-platforms.search');
    Route::get('/my-social-accounts', [SocialMediaAccountController::class, 'userIndex'])->name('user.social_accounts.index');
    Route::post('/my-social-accounts', [SocialMediaAccountController::class, 'store'])->name('user.social_accounts.store');
    Route::delete('/my-social-accounts/{id}', [SocialMediaAccountController::class, 'destroy'])->name('user.social_accounts.destroy');
    Route::get('/my-social-accounts/search', [SocialMediaAccountController::class, 'userSearch'])->name('user.social_accounts.search');

    // Products (User)
    Route::get('/products', [ProductController::class, 'index'])->name('products.index');
    Route::get('/products/{id}', [ProductController::class, 'show'])->name('products.show');

    // Orders (User)
    Route::get('/orders', [OrderController::class, 'index'])->name('orders.index');
    Route::post('/orders', [OrderController::class, 'store'])->name('orders.store');
    Route::get('/orders/{id}', [OrderController::class, 'show'])->name('orders.show');
    Route::post('/orders/{id}/cancel', [OrderController::class, 'cancel'])->name('orders.cancel');

    // User Profile
    Route::get('/profile', [UserProfileController::class, 'index'])->name('user.profile');
    Route::get('/profile/edit', [UserProfileController::class, 'edit'])->name('user.profile.edit');
    Route::put('/profile', [UserProfileController::class, 'update'])->name('user.profile.update');
    Route::post('/profile/password', [UserProfileController::class, 'updatePassword'])->name('user.password.update');

    // Website Visits
    Route::get('/website-visits', [WebsiteVisitController::class, 'index'])->name('website-visits.index');
    Route::post('/website-visits/{task}/start', [WebsiteVisitController::class, 'startVisit'])->name('website-visits.start');
    Route::post('/website-visits/submit-proof', [WebsiteVisitController::class, 'submitProof'])->name('website-visits.submit-proof');
    Route::get('/website-visits/{task}', [WebsiteVisitController::class, 'show'])->name('website-visits.show');

    // Announcements (User)
    Route::get('/announcements', [AnnouncementController::class, 'index'])->name('announcements.index');
    Route::get('/announcements/{id}', [AnnouncementController::class, 'show'])->name('announcements.show');
    Route::post('/announcements/{id}/read', [AnnouncementController::class, 'markAsRead'])->name('announcements.read');

    // Tickets (User)
    Route::get('/tickets', [TicketController::class, 'index'])->name('tickets.index');
    Route::get('/tickets/create', [TicketController::class, 'create'])->name('tickets.create');
    Route::post('/tickets', [TicketController::class, 'store'])->name('tickets.store');
    Route::get('/tickets/{id}', [TicketController::class, 'show'])->name('tickets.show');
    Route::post('/tickets/{id}/message', [TicketController::class, 'sendMessage'])->name('tickets.message');
});

/*
|--------------------------------------------------------------------------
| API Routes (Web + Auth)
|--------------------------------------------------------------------------
*/
Route::middleware(['web','auth'])->prefix('api')->group(function () {
    // Watch Tasks API
    Route::get('/watch-tasks', [WatchTaskController::class, 'index'])->name('api.watch.tasks');
    Route::post('/watch-tasks', [WatchTaskController::class, 'store'])->name('api.watch.store');
    Route::post('/watch-tasks/{task}/toggle', [WatchTaskController::class, 'toggleStatus'])->name('api.watch.toggle');
    Route::delete('/watch-tasks/{task}', [WatchTaskController::class, 'destroy'])->name('api.watch.destroy');
    Route::get('/user/watch-tasks', [WatchTaskController::class, 'userTasks'])->name('api.user.watch.tasks');
    Route::get('/user/watch-tasks/{task}', [WatchTaskController::class, 'show'])->name('api.user.watch.show');
    Route::put('/user/watch-tasks/{task}', [WatchTaskController::class, 'update'])->name('api.user.watch.update');

    // Products & Categories API
    Route::get('/products', [ProductController::class, 'getProductsAjax'])->name('api.products');
    Route::get('/product-categories', [ProductController::class, 'getCategories'])->name('api.product-categories');

    // Orders Details API
    Route::get('/orders/{id}', [OrderController::class, 'getOrderDetails'])->name('api.orders.show');
});

/*
|--------------------------------------------------------------------------
| Admin Routes (Auth + isAdmin)
|--------------------------------------------------------------------------
*/
Route::prefix('admin')->middleware(['auth','isAdmin'])->group(function () {
    // Social Media Accounts Management (Admin)
    Route::get('/social-accounts', [SocialMediaAccountController::class, 'adminIndex'])->name('admin.social_accounts.index');
    Route::get('/social-accounts/search', [SocialMediaAccountController::class, 'adminSearch'])->name('admin.social_accounts.search');
    Route::post('/social-accounts/{id}/approve', [SocialMediaAccountController::class, 'approve'])->name('admin.social_accounts.approve');
    Route::post('/social-accounts/{id}/reject', [SocialMediaAccountController::class, 'reject'])->name('admin.social_accounts.reject');

    // Products Management (Admin)
    Route::get('/products', [ProductController::class, 'adminIndex'])->name('admin.products.index');
    Route::get('/products/create', [ProductController::class, 'create'])->name('admin.products.create');
    Route::post('/products', [ProductController::class, 'store'])->name('admin.products.store');
    Route::get('/products/{id}/edit', [ProductController::class, 'edit'])->name('admin.products.edit');
    Route::put('/products/{id}', [ProductController::class, 'update'])->name('admin.products.update');
    Route::delete('/products/{id}', [ProductController::class, 'destroy'])->name('admin.products.destroy');

    // Orders Management (Admin)
    Route::get('/orders', [OrderController::class, 'adminIndex'])->name('admin.orders.index');
    Route::post('/orders/{id}/status', [OrderController::class, 'updateStatus'])->name('admin.orders.status');

    // Announcements Management (Admin)
    Route::get('/announcements', [AnnouncementController::class, 'adminIndex'])->name('admin.announcements.index');
    Route::get('/announcements/create', [AnnouncementController::class, 'create'])->name('admin.announcements.create');
    Route::post('/announcements', [AnnouncementController::class, 'store'])->name('admin.announcements.store');
    Route::get('/announcements/{id}/edit', [AnnouncementController::class, 'edit'])->name('admin.announcements.edit');
    Route::put('/announcements/{id}', [AnnouncementController::class, 'update'])->name('admin.announcements.update');
    Route::delete('/announcements/{id}', [AnnouncementController::class, 'destroy'])->name('admin.announcements.destroy');

    // Tickets Management (Admin)
    Route::get('/tickets', [TicketController::class, 'adminIndex'])->name('admin.tickets.index');
    Route::post('/tickets', [TicketController::class, 'adminStore'])->name('admin.tickets.store');
    Route::get('/tickets/{id}', [TicketController::class, 'adminShow'])->name('admin.tickets.show');
    Route::post('/tickets/{id}/status', [TicketController::class, 'updateStatus'])->name('admin.tickets.status');
    Route::post('/tickets/{id}/assign', [TicketController::class, 'assign'])->name('admin.tickets.assign');
});
