<?php $__env->startSection('style'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Announcements')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/home')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('announcements.index')); ?>"><?php echo e(__('Announcements')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($announcement->title); ?></li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8">
                <!-- Announcement Content -->
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <h4 class="mb-1"><?php echo e($announcement->title); ?></h4>
                                <div class="text-muted">
                                    <i class="bx bx-time me-1"></i><?php echo e($announcement->created_at->format('d.m.Y H:i')); ?>

                                    <span class="ms-3">
                                        <i class="bx bx-user me-1"></i><?php echo e($announcement->creator->account_holder ?? $announcement->creator->name); ?>

                                    </span>
                                </div>
                            </div>
                            <span class="badge bg-<?php echo e($announcement->priority_badge); ?>"><?php echo e($announcement->priority_text); ?></span>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="announcement-content">
                            <?php echo $announcement->formatted_content; ?>

                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <!-- Announcement Info -->
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0"><?php echo e(__('Announcement Details')); ?></h6>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-12">
                                <small class="text-muted"><?php echo e(__('Type')); ?></small><br>
                                <span class="badge bg-secondary"><?php echo e($announcement->type_text); ?></span>
                            </div>
                            
                            <div class="col-12">
                                <small class="text-muted"><?php echo e(__('Priority')); ?></small><br>
                                <span class="badge bg-<?php echo e($announcement->priority_badge); ?>"><?php echo e($announcement->priority_text); ?></span>
                            </div>
                            
                            <div class="col-12">
                                <small class="text-muted"><?php echo e(__('Status')); ?></small><br>
                                <?php if($announcement->is_active && !$announcement->isExpired()): ?>
                                <span class="badge bg-success"><?php echo e(__('Active')); ?></span>
                                <?php elseif($announcement->isExpired()): ?>
                                <span class="badge bg-warning"><?php echo e(__('Expired')); ?></span>
                                <?php else: ?>
                                <span class="badge bg-secondary"><?php echo e(__('Inactive')); ?></span>
                                <?php endif; ?>
                            </div>
                            
                            <?php if($announcement->expires_at): ?>
                            <div class="col-12">
                                <small class="text-muted"><?php echo e(__('Expires At')); ?></small><br>
                                <span><?php echo e($announcement->expires_at->format('d.m.Y H:i')); ?></span>
                            </div>
                            <?php endif; ?>
                            
                            <div class="col-12">
                                <small class="text-muted"><?php echo e(__('Created At')); ?></small><br>
                                <span><?php echo e($announcement->created_at->format('d.m.Y H:i')); ?></span>
                            </div>
                            
                            <?php if($announcement->type === 'user_specific' && auth()->user()->user_type == 1): ?>
                            <div class="col-12">
                                <small class="text-muted"><?php echo e(__('Target Users')); ?></small><br>
                                <div class="mt-2">
                                    <?php $__currentLoopData = $announcement->targetUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge bg-info me-1 mb-1"><?php echo e($user->account_holder ?? $user->name); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if(auth()->user()->user_type == 1): ?>
                            <div class="col-12">
                                <small class="text-muted"><?php echo e(__('Read Statistics')); ?></small><br>
                                <div class="mt-2">
                                    <span class="badge bg-success me-1">
                                        <i class="bx bx-check me-1"></i><?php echo e($announcement->readByUsers()->count()); ?> <?php echo e(__('Read')); ?>

                                    </span>
                                    <?php if($announcement->type === 'user_specific'): ?>
                                    <span class="badge bg-warning">
                                        <i class="bx bx-user me-1"></i><?php echo e($announcement->targetUsers()->count()); ?> <?php echo e(__('Total Target Users')); ?>

                                    </span>
                                    <?php else: ?>
                                    <span class="badge bg-info">
                                        <i class="bx bx-globe me-1"></i><?php echo e(__('General Announcement')); ?>

                                    </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <?php if(auth()->user()->user_type == 1): ?>
                        <div class="d-grid gap-2 mt-3">
                            <button class="btn btn-warning" onclick="editAnnouncement(<?php echo e($announcement->id); ?>)">
                                <i class="bx bx-edit me-2"></i><?php echo e(__('Edit')); ?>

                            </button>
                            <button class="btn btn-danger" onclick="deleteAnnouncement(<?php echo e($announcement->id); ?>)">
                                <i class="bx bx-trash me-2"></i><?php echo e(__('Delete')); ?>

                            </button>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if(auth()->user()->user_type == 1): ?>
<!-- Edit Announcement Offcanvas -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="editAnnouncementOffcanvas" aria-labelledby="editAnnouncementOffcanvasLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="editAnnouncementOffcanvasLabel"><?php echo e(__('Edit Announcement')); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <form id="editAnnouncementForm">
            <?php echo csrf_field(); ?>
            <?php echo method_field('POST'); ?>
            <input type="hidden" id="editAnnouncementId" name="announcement_id">
            
            <!-- Title -->
            <div class="mb-3">
                <label for="editTitle" class="form-label"><?php echo e(__('Title')); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="editTitle" name="title" required maxlength="255">
            </div>

            <!-- Content -->
            <div class="mb-3">
                <label for="editContent" class="form-label"><?php echo e(__('Content')); ?> <span class="text-danger">*</span></label>
                <textarea class="form-control" id="editContent" name="content" rows="4" required maxlength="5000"></textarea>
                <div class="form-text"><?php echo e(__('Remaining characters')); ?>: <span id="editContentCharCount">5000</span></div>
            </div>

            <!-- Type -->
            <div class="mb-3">
                <label for="editType" class="form-label"><?php echo e(__('Type')); ?> <span class="text-danger">*</span></label>
                <select class="form-select" id="editType" name="type" required>
                    <option value="general"><?php echo e(__('General')); ?></option>
                    <option value="user_specific"><?php echo e(__('User Specific')); ?></option>
                </select>
            </div>

            <!-- Target Users -->
            <div class="mb-3" id="editTargetUsersDiv" style="display: none;">
                <label for="editTargetUsers" class="form-label"><?php echo e(__('Target Users')); ?> <span class="text-danger">*</span></label>
                <select class="form-select" id="editTargetUsers" name="target_users[]" multiple>
                </select>
            </div>

            <!-- Priority -->
            <div class="mb-3">
                <label for="editPriority" class="form-label"><?php echo e(__('Priority')); ?> <span class="text-danger">*</span></label>
                <select class="form-select" id="editPriority" name="priority" required>
                    <option value="low"><?php echo e(__('Low')); ?></option>
                    <option value="medium"><?php echo e(__('Medium')); ?></option>
                    <option value="high"><?php echo e(__('High')); ?></option>
                    <option value="urgent"><?php echo e(__('Urgent')); ?></option>
                </select>
            </div>

            <!-- Status -->
            <div class="mb-3">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="editIsActive" name="is_active" value="1">
                    <label class="form-check-label" for="editIsActive">
                        <?php echo e(__('Active')); ?>

                    </label>
                </div>
            </div>

            <!-- Options -->
            <div class="mb-3">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="editShowAsPopup" name="show_as_popup" value="1">
                    <label class="form-check-label" for="editShowAsPopup">
                        <?php echo e(__('Show as popup')); ?>

                    </label>
                </div>
            </div>

            <!-- Expires At -->
            <div class="mb-3">
                <label for="editExpiresAt" class="form-label"><?php echo e(__('Expires At')); ?> <span class="text-muted">(<?php echo e(__('Optional')); ?>)</span></label>
                <input type="datetime-local" class="form-control" id="editExpiresAt" name="expires_at">
            </div>

            <!-- Submit Button -->
            <div class="d-grid">
                <button type="submit" class="btn btn-warning" id="editBtn">
                    <i class="bx bx-edit me-2"></i><?php echo e(__('Update Announcement')); ?>

                    <span class="spinner-border spinner-border-sm ms-2 d-none" id="editSpinner"></span>
                </button>
            </div>
        </form>
    </div>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
function editAnnouncement(id) {
    // Load announcement data
    $.ajax({
        url: `/admin/announcements/${id}/edit`,
        method: 'GET',
        success: function(response) {
            if (response.success) {
                const announcement = response.announcement;
                
                // Fill form fields
                $('#editAnnouncementId').val(announcement.id);
                $('#editTitle').val(announcement.title);
                $('#editContent').val(announcement.content);
                $('#editType').val(announcement.type);
                $('#editPriority').val(announcement.priority);
                $('#editIsActive').prop('checked', announcement.is_active);
                $('#editShowAsPopup').prop('checked', announcement.show_as_popup);
                
                if (announcement.expires_at) {
                    $('#editExpiresAt').val(announcement.expires_at);
                }
                
                // Handle target users
                if (announcement.type === 'user_specific') {
                    $('#editTargetUsersDiv').show();
                    $('#editTargetUsers').prop('required', true);
                    
                    // Clear previous options
                    $('#editTargetUsers').empty();
                    
                    // Set selected users
                    if (announcement.target_users && announcement.target_users.length > 0) {
                        announcement.target_users.forEach(function(user) {
                            const option = new Option(user.account_holder + ' (' + user.email + ')', user.id, true, true);
                            $('#editTargetUsers').append(option);
                        });
                    }
                    
                    initializeUserSelect('#editTargetUsers');
                } else {
                    $('#editTargetUsersDiv').hide();
                    $('#editTargetUsers').prop('required', false);
                }
                
                // Update character count
                const remaining = 5000 - announcement.content.length;
                $('#editContentCharCount').text(remaining);
                
                // Show offcanvas
                $('#editAnnouncementOffcanvas').offcanvas('show');
            }
        },
        error: function() {
            Lobibox.notify('error', {
                title: '<?php echo e(__('Error')); ?>',
                msg: '<?php echo e(__('Error loading announcement data')); ?>',
                sound: false
            });
        }
    });
}

function initializeUserSelect(selector) {
    if (!$(selector).hasClass('select2-hidden-accessible')) {
        $(selector).select2({
            theme: 'bootstrap-5',
            ajax: {
                url: '/api/users/search',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        q: params.term,
                        page: params.page
                    };
                },
                processResults: function (data, params) {
                    params.page = params.page || 1;
                    return {
                        results: data.data.map(function(user) {
                            return {
                                id: user.id,
                                text: user.account_holder + ' (' + user.email + ')'
                            };
                        }),
                        pagination: {
                            more: data.has_more
                        }
                    };
                },
                cache: true
            },
            placeholder: '<?php echo e(__('Search users...')); ?>',
            minimumInputLength: 2,
            dropdownParent: $('#editAnnouncementOffcanvas')
        });
    }
}

// Initialize offcanvas events
$('#editAnnouncementOffcanvas').on('shown.bs.offcanvas', function() {
    // Character counter
    $('#editContent').on('input', function() {
        const remaining = 5000 - $(this).val().length;
        $('#editContentCharCount').text(remaining);
        
        if (remaining < 100) {
            $('#editContentCharCount').addClass('text-danger');
        } else {
            $('#editContentCharCount').removeClass('text-danger');
        }
    });

    // Type change handler
    $('#editType').on('change', function() {
        if ($(this).val() === 'user_specific') {
            $('#editTargetUsersDiv').show();
            $('#editTargetUsers').prop('required', true);
            initializeUserSelect('#editTargetUsers');
        } else {
            $('#editTargetUsersDiv').hide();
            $('#editTargetUsers').prop('required', false);
        }
    });

    // Form submission
    $('#editAnnouncementForm').off('submit').on('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const announcementId = $('#editAnnouncementId').val();
        
        $('#editBtn').prop('disabled', true);
        $('#editSpinner').removeClass('d-none');
        
        $.ajax({
            url: `/admin/announcements/${announcementId}`,
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    Lobibox.notify('success', {
                        title: '<?php echo e(__('Success')); ?>',
                        msg: response.message,
                        sound: false
                    });
                    
                    $('#editAnnouncementOffcanvas').offcanvas('hide');
                    
                    // Reload page to show updated data
                    setTimeout(() => location.reload(), 1000);
                } else {
                    Lobibox.notify('error', {
                        title: '<?php echo e(__('Error')); ?>',
                        msg: response.message,
                        sound: false
                    });
                }
            },
            error: function(xhr) {
                if (xhr.status === 422) {
                    const errors = xhr.responseJSON?.errors;
                    let errorMsg = '<?php echo e(__('Please check your input and try again.')); ?>';
                    if (errors) {
                        const firstError = Object.values(errors)[0];
                        if (firstError && firstError[0]) {
                            errorMsg = firstError[0];
                        }
                    }
                    Lobibox.notify('error', {
                        title: '<?php echo e(__('Validation Error')); ?>',
                        msg: errorMsg,
                        sound: false
                    });
                } else {
                    Lobibox.notify('error', {
                        title: '<?php echo e(__('Error')); ?>',
                        msg: '<?php echo e(__('Error updating announcement')); ?>',
                        sound: false
                    });
                }
            },
            complete: function() {
                $('#editBtn').prop('disabled', false);
                $('#editSpinner').addClass('d-none');
            }
        });
    });
});

function deleteAnnouncement(id) {
    Swal.fire({
        title: '<?php echo e(__('Are you sure?')); ?>',
        text: '<?php echo e(__('This announcement will be deleted permanently!')); ?>',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: '<?php echo e(__('Yes, delete it!')); ?>',
        cancelButtonText: '<?php echo e(__('Cancel')); ?>',
        confirmButtonColor: '#dc3545'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/admin/announcements/${id}`,
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Lobibox.notify('success', {
                            title: '<?php echo e(__('Success')); ?>',
                            msg: response.message,
                            sound: false
                        });
                        setTimeout(() => window.location.href = '<?php echo e(route('announcements.index')); ?>', 1000);
                    }
                },
                error: function() {
                    Lobibox.notify('error', {
                        title: '<?php echo e(__('Error')); ?>',
                        msg: '<?php echo e(__('Error deleting announcement')); ?>',
                        sound: false
                    });
                }
            });
        }
    });
}
</script>
<?php $__env->stopSection(); ?>

<style>
.announcement-content {
    line-height: 1.8;
    font-size: 1.1rem;
}

.announcement-content p {
    margin-bottom: 1rem;
}
</style>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/announcements/show.blade.php ENDPATH**/ ?>