<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo $__env->yieldContent('description', 'GorevSitesi - Kaliteli ürünler, hızlı teslimat'); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('keywords', 'e-ticaret, online alışveriş, ürün satışı'); ?>">
    <meta name="author" content="GorevSitesi">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="<?php echo $__env->yieldContent('title', 'GorevSitesi'); ?>">
    <meta property="og:description" content="<?php echo $__env->yieldContent('description', 'GorevSitesi - Kaliteli ürünler, hızlı teslimat'); ?>">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    
    <title><?php echo $__env->yieldContent('title', 'GorevSitesi'); ?></title>
    
    <!-- Preconnect for performance -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary-color: #2563eb;
            --secondary-color: #64748b;
            --success-color: #059669;
            --warning-color: #d97706;
            --danger-color: #dc2626;
            --dark-color: #1e293b;
            --light-color: #f8fafc;
            --border-color: #e2e8f0;
            --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
            --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
            --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
        }
        
        * {
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            line-height: 1.6;
            color: var(--dark-color);
            background-color: #ffffff;
        }
        
        .navbar {
            background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
            border-bottom: 1px solid var(--border-color);
            box-shadow: var(--shadow-sm);
            padding: 1rem 0;
        }
        
        .navbar-brand {
            font-weight: 700;
            font-size: 1.5rem;
            color: var(--primary-color) !important;
            text-decoration: none;
        }
        
        .navbar-brand:hover {
            color: var(--primary-color) !important;
            transform: translateY(-1px);
            transition: all 0.2s ease;
        }
        
        .nav-link {
            font-weight: 500;
            color: var(--dark-color) !important;
            padding: 0.5rem 1rem !important;
            border-radius: 0.5rem;
            transition: all 0.2s ease;
        }
        
        .nav-link:hover {
            background-color: var(--light-color);
            color: var(--primary-color) !important;
        }
        
        .btn {
            font-weight: 500;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            transition: all 0.2s ease;
            border: none;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color) 0%, #3b82f6 100%);
            box-shadow: var(--shadow-sm);
        }
        
        .btn-primary:hover {
            background: linear-gradient(135deg, #1d4ed8 0%, var(--primary-color) 100%);
            transform: translateY(-1px);
            box-shadow: var(--shadow-md);
        }
        
        .btn-outline-primary {
            border: 2px solid var(--primary-color);
            color: var(--primary-color);
        }
        
        .btn-outline-primary:hover {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            transform: translateY(-1px);
        }
        
        .card {
            border: 1px solid var(--border-color);
            border-radius: 1rem;
            box-shadow: var(--shadow-sm);
            transition: all 0.2s ease;
        }
        
        .card:hover {
            box-shadow: var(--shadow-md);
            transform: translateY(-2px);
        }
        
        .form-control, .form-select {
            border: 2px solid var(--border-color);
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
            transition: all 0.2s ease;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(37, 99, 235, 0.25);
        }
        
        .alert {
            border-radius: 0.75rem;
            border: none;
            padding: 1rem 1.5rem;
        }
        
        .footer {
            background: linear-gradient(135deg, var(--dark-color) 0%, #334155 100%);
            color: white;
            margin-top: auto;
        }
        
        .main-content {
            min-height: calc(100vh - 200px);
        }
        
        /* Mobile optimizations */
        @media (max-width: 768px) {
            .navbar-brand {
                font-size: 1.25rem;
            }
            
            .btn {
                padding: 0.625rem 1.25rem;
                font-size: 0.9rem;
            }
            
            .container {
                padding-left: 1rem;
                padding-right: 1rem;
            }
        }
        
        /* Loading animation */
        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255,255,255,.3);
            border-radius: 50%;
            border-top-color: #fff;
            animation: spin 1s ease-in-out infinite;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        /* Cart badge */
        .cart-badge {
            position: absolute;
            top: -8px;
            right: -8px;
            background: var(--danger-color);
            color: white;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            font-size: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        /* Product card enhancements */
        .product-card {
            transition: all 0.3s ease;
            border: 1px solid var(--border-color);
        }
        
        .product-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow-lg);
        }
        
        .product-image {
            height: 200px;
            object-fit: cover;
            border-radius: 0.5rem;
        }
        
        /* Responsive utilities */
        .text-truncate-2 {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
        
        .text-truncate-3 {
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
    </style>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="d-flex flex-column min-vh-100">
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg sticky-top">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(route('site2.landing')); ?>">
                <i class="bi bi-shop"></i> GorevSitesi
            </a>
            
            <button class="navbar-toggler border-0" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('site2.landing') ? 'active' : ''); ?>" href="<?php echo e(route('site2.landing')); ?>">
                            <i class="bi bi-house"></i> <?php echo e(s__('Home')); ?>

                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('site2.products.*') ? 'active' : ''); ?>" href="<?php echo e(route('site2.products.index')); ?>">
                            <i class="bi bi-grid"></i> <?php echo e(s__('Products')); ?>

                        </a>
                    </li>
                </ul>
                
                <ul class="navbar-nav ms-auto align-items-center">
                    <!-- Cart Icon -->
                    <li class="nav-item me-3">
                        <a class="nav-link position-relative" href="<?php echo e(route('site2.cart.index')); ?>" id="cartToggle">
                            <i class="bi bi-bag fs-5"></i>
                            <span class="cart-badge d-none" id="cartCount">0</span>
                        </a>
                    </li>
                    
                    <?php if(auth()->guard()->guest()): ?>
                        <li class="nav-item me-2">
                            <a class="btn btn-outline-primary btn-sm" href="<?php echo e(route('site2.login')); ?>">
                                <i class="bi bi-box-arrow-in-right"></i> <?php echo e(s__('Login')); ?>

                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="btn btn-primary btn-sm" href="<?php echo e(route('site2.register')); ?>">
                                <i class="bi bi-person-plus"></i> <?php echo e(s__('Register')); ?>

                            </a>
                        </li>
                    <?php else: ?>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px;">
                                    <i class="bi bi-person text-white"></i>
                                </div>
                                <span class="d-none d-md-inline"><?php echo e(Auth::user()->username ?? Auth::user()->name); ?></span>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end shadow border-0" aria-labelledby="navbarDropdown">
                                <li>
                                    <h6 class="dropdown-header">
                                        <i class="bi bi-wallet2"></i> Bakiye: <?php echo e(number_format(Auth::user()->balance ?? 0, 2)); ?> ₺
                                    </h6>
                                </li>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <a class="dropdown-item" href="<?php echo e(route('site2.account.dashboard')); ?>">
                                        <i class="bi bi-speedometer2"></i> Hesabım
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="<?php echo e(route('site2.account.orders')); ?>">
                                        <i class="bi bi-bag-check"></i> Siparişlerim
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="<?php echo e(route('site2.account.balance.create')); ?>">
                                        <i class="bi bi-credit-card"></i> Bakiye Yükle
                                    </a>
                                </li>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <a class="dropdown-item text-danger" href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                        <i class="bi bi-box-arrow-right"></i> Çıkış Yap
                                    </a>
                                    <form id="logout-form" action="<?php echo e(route('site2.logout')); ?>" method="POST" class="d-none">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </li>
                            </ul>
                        </li>
                    <?php endif; ?>
                    
                    <!-- Secondary Domain Language Dropdown -->
                    <li class="nav-item dropdown ms-2">
                        <a class="nav-link dropdown-toggle" href="#" id="languageDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-translate"></i> <?php echo e(strtoupper(secondary_locale())); ?>

                        </a>
                        <ul class="dropdown-menu dropdown-menu-end shadow border-0" aria-labelledby="languageDropdown">
                            <?php $__currentLoopData = secondary_languages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                   <a class="dropdown-item" href="<?php echo e(route('site2.lang.switch', $lang['code'])); ?>">
                                        <?php if($lang['code'] == 'tr'): ?> 🇹🇷
                                        <?php elseif($lang['code'] == 'en'): ?> 🇺🇸
                                        <?php elseif($lang['code'] == 'ru'): ?> 🇷🇺
                                        <?php elseif($lang['code'] == 'ar'): ?> 🇸🇦
                                        <?php endif; ?>
                                        <?php echo e($lang['name']); ?>

                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Alert Messages -->
    <?php if(session('success') || session('error') || session('warning') || session('info')): ?>
        <div class="container mt-3">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-circle"></i> <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <?php if(session('warning')): ?>
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle"></i> <?php echo e(session('warning')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <?php if(session('info')): ?>
                <div class="alert alert-info alert-dismissible fade show" role="alert">
                    <i class="bi bi-info-circle"></i> <?php echo e(session('info')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <!-- Main Content -->
    <main class="main-content flex-grow-1">
        <div class="container py-4">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer mt-auto py-4">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-4 mb-lg-0">
                    <h5 class="text-white mb-3">
                        <i class="bi bi-shop"></i> GorevSitesi
                    </h5>
                    <p class="text-light opacity-75">
                        Kaliteli ürünler, hızlı teslimat ve güvenilir alışveriş deneyimi için doğru adres.
                    </p>
                </div>
                <div class="col-lg-2 col-md-6 mb-4 mb-lg-0">
                    <h6 class="text-white mb-3">Hızlı Linkler</h6>
                    <ul class="list-unstyled">
                        <li><a href="<?php echo e(route('site2.landing')); ?>" class="text-light opacity-75 text-decoration-none">Ana Sayfa</a></li>
                        <li><a href="<?php echo e(route('site2.products.index')); ?>" class="text-light opacity-75 text-decoration-none">Ürünler</a></li>
                        <?php if(auth()->guard()->check()): ?>
                            <li><a href="<?php echo e(route('site2.account.dashboard')); ?>" class="text-light opacity-75 text-decoration-none">Hesabım</a></li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="col-lg-2 col-md-6 mb-4 mb-lg-0">
                    <h6 class="text-white mb-3">Destek</h6>
                    <ul class="list-unstyled">
                        <li><a href="#" class="text-light opacity-75 text-decoration-none">İletişim</a></li>
                        <li><a href="#" class="text-light opacity-75 text-decoration-none">SSS</a></li>
                        <li><a href="#" class="text-light opacity-75 text-decoration-none">Yardım</a></li>
                    </ul>
                </div>
                <div class="col-lg-4">
                    <h6 class="text-white mb-3">İletişim</h6>
                    <p class="text-light opacity-75 mb-2">
                        <i class="bi bi-envelope"></i> info@gorevsitesi.com.tr
                    </p>
                    <p class="text-light opacity-75 mb-3">
                        <i class="bi bi-telephone"></i> +90 (XXX) XXX XX XX
                    </p>
                    <div class="d-flex gap-2">
                        <a href="#" class="text-light opacity-75"><i class="bi bi-facebook fs-5"></i></a>
                        <a href="#" class="text-light opacity-75"><i class="bi bi-twitter fs-5"></i></a>
                        <a href="#" class="text-light opacity-75"><i class="bi bi-instagram fs-5"></i></a>
                        <a href="#" class="text-light opacity-75"><i class="bi bi-linkedin fs-5"></i></a>
                    </div>
                </div>
            </div>
            <hr class="my-4 opacity-25">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <p class="text-light opacity-75 mb-0">
                        &copy; <?php echo e(date('Y')); ?> GorevSitesi. Tüm hakları saklıdır.
                    </p>
                </div>
                <div class="col-md-6 text-md-end">
                    <a href="#" class="text-light opacity-75 text-decoration-none me-3">Gizlilik Politikası</a>
                    <a href="#" class="text-light opacity-75 text-decoration-none">Kullanım Şartları</a>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    
    <!-- Custom JavaScript -->
    <script>
        // CSRF Token setup for AJAX
        window.Laravel = {
            csrfToken: '<?php echo e(csrf_token()); ?>'
        };
        
        // Set CSRF token for all AJAX requests
        if (window.jQuery) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
        }
        
        // Auto-hide alerts after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                setTimeout(function() {
                    const bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                }, 5000);
            });
        });
        
        // Loading state helper
        function showLoading(element) {
            const originalText = element.innerHTML;
            element.innerHTML = '<span class="loading"></span> Yükleniyor...';
            element.disabled = true;
            return originalText;
        }
        
        function hideLoading(element, originalText) {
            element.innerHTML = originalText;
            element.disabled = false;
        }
        
        // Cart functionality (will be enhanced later)
        function updateCartCount(count) {
            const cartBadge = document.getElementById('cartCount');
            if (count > 0) {
                cartBadge.textContent = count;
                cartBadge.classList.remove('d-none');
            } else {
                cartBadge.classList.add('d-none');
            }
        }
        
        // Initialize cart count from localStorage
        document.addEventListener('DOMContentLoaded', function() {
            const cartItems = JSON.parse(localStorage.getItem('cart') || '[]');
            updateCartCount(cartItems.length);
        });
    </script>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH /home/saat/public_html/resources/views/gorevsitesi/layouts/app.blade.php ENDPATH**/ ?>