<?php $__env->startSection('title', 'Ödeme - GorevSitesi'); ?>
<?php $__env->startSection('description', 'Siparişinizi güvenle tamamlayın.'); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<div class="row mb-4">
    <div class="col-12">
        <h1 class="fw-bold mb-2">
            <i class="bi bi-credit-card me-2"></i>Ödeme
        </h1>
        <p class="text-muted mb-0">Siparişinizi güvenle tamamlayın</p>
    </div>
</div>

<!-- Checkout Steps -->
<div class="row mb-4">
    <div class="col-12">
        <div class="checkout-steps">
            <div class="d-flex justify-content-between align-items-center">
                <div class="step completed">
                    <div class="step-circle">
                        <i class="bi bi-check"></i>
                    </div>
                    <span class="step-label">Sepet</span>
                </div>
                <div class="step-line completed"></div>
                <div class="step active">
                    <div class="step-circle">2</div>
                    <span class="step-label">Ödeme</span>
                </div>
                <div class="step-line"></div>
                <div class="step">
                    <div class="step-circle">3</div>
                    <span class="step-label">Tamamlandı</span>
                </div>
            </div>
        </div>
    </div>
</div>

<form id="checkoutForm">
    <?php echo csrf_field(); ?>
    <div class="row">
        <div class="col-lg-8">
            <!-- Payment Method -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-0">
                    <h5 class="mb-0 fw-bold">
                        <i class="bi bi-wallet2 me-2"></i>Ödeme Yöntemi
                    </h5>
                </div>
                <div class="card-body">
                    <?php if(auth()->guard()->check()): ?>
                        <!-- Balance Payment -->
                        <div class="payment-method mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="payment_method" id="balance" value="balance" checked>
                                <label class="form-check-label w-100" for="balance">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <i class="bi bi-wallet2 text-primary me-2"></i>
                                            <strong>Bakiye ile Öde</strong>
                                            <div class="small text-muted">Mevcut bakiyenizi kullanarak ödeyin</div>
                                        </div>
                                        <div class="text-end">
                                            <div class="fw-bold text-success"><?php echo e(number_format(Auth::user()->balance ?? 0, 2)); ?> ₺</div>
                                            <div class="small text-muted">Mevcut Bakiye</div>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                        
                        <!-- Insufficient Balance Warning -->
                        <div id="insufficientBalance" class="alert alert-warning d-none">
                            <i class="bi bi-exclamation-triangle me-2"></i>
                            Bakiyeniz yetersiz. <a href="<?php echo e(route('site2.account.balance.create')); ?>" class="alert-link">Bakiye yüklemek için tıklayın.</a>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            Ödeme yapabilmek için <a href="<?php echo e(route('site2.login')); ?>" class="alert-link">giriş yapmanız</a> gerekiyor.
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Order Notes -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-0">
                    <h5 class="mb-0 fw-bold">
                        <i class="bi bi-chat-text me-2"></i>Sipariş Notları (Opsiyonel)
                    </h5>
                </div>
                <div class="card-body">
                    <textarea class="form-control" name="notes" rows="3" placeholder="Siparişiniz hakkında özel notlarınız varsa buraya yazabilirsiniz..."></textarea>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <!-- Order Summary -->
            <div class="card border-0 shadow-sm sticky-top" style="top: 100px;">
                <div class="card-header bg-white border-0">
                    <h5 class="mb-0 fw-bold">Sipariş Özeti</h5>
                </div>
                <div class="card-body">
                    <!-- Order Items -->
                    <div id="orderItems" class="mb-3">
                        <!-- Items will be loaded here -->
                    </div>
                    
                    <hr>
                    
                    <!-- Price Breakdown -->
                    <div class="price-breakdown">
                        <div class="d-flex justify-content-between mb-2">
                            <span>Ara Toplam:</span>
                            <span id="subtotal">0,00 ₺</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Kargo:</span>
                            <span class="text-success">Ücretsiz</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>KDV:</span>
                            <span id="tax">Dahil</span>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between mb-3">
                            <span class="fw-bold fs-5">Toplam:</span>
                            <span class="fw-bold text-primary fs-5" id="total">0,00 ₺</span>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="d-grid gap-2">
                        <?php if(auth()->guard()->check()): ?>
                            <button type="submit" class="btn btn-success btn-lg" id="completeOrderBtn">
                                <i class="bi bi-check-circle me-2"></i>Siparişi Tamamla
                            </button>
                        <?php else: ?>
                            <a href="<?php echo e(route('site2.login')); ?>" class="btn btn-success btn-lg">
                                <i class="bi bi-box-arrow-in-right me-2"></i>Giriş Yap ve Devam Et
                            </a>
                        <?php endif; ?>
                        <a href="<?php echo e(route('site2.cart.index')); ?>" class="btn btn-outline-secondary">
                            <i class="bi bi-arrow-left me-2"></i>Sepete Dön
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Security Info -->
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-body text-center">
                    <i class="bi bi-shield-check text-success fs-1 mb-3"></i>
                    <h6 class="fw-bold mb-2">%100 Güvenli Ödeme</h6>
                    <p class="small text-muted mb-0">
                        Tüm ödemeleriniz SSL sertifikası ile korunmaktadır. 
                        Kişisel bilgileriniz güvende.
                    </p>
                </div>
            </div>
        </div>
    </div>
</form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .checkout-steps {
        padding: 2rem 0;
    }
    
    .step {
        text-align: center;
        position: relative;
    }
    
    .step-circle {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: #e9ecef;
        color: #6c757d;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        margin: 0 auto 0.5rem;
        transition: all 0.3s ease;
    }
    
    .step.active .step-circle {
        background: var(--primary-color);
        color: white;
    }
    
    .step.completed .step-circle {
        background: var(--success-color);
        color: white;
    }
    
    .step-line {
        flex: 1;
        height: 2px;
        background: #e9ecef;
        margin: 0 1rem;
        align-self: center;
        margin-top: -20px;
    }
    
    .step-line.completed {
        background: var(--success-color);
    }
    
    .step-label {
        font-size: 0.9rem;
        color: #6c757d;
        font-weight: 500;
    }
    
    .step.active .step-label,
    .step.completed .step-label {
        color: var(--dark-color);
        font-weight: 600;
    }
    
    .payment-method {
        border: 2px solid #e9ecef;
        border-radius: 0.5rem;
        padding: 1rem;
        transition: all 0.2s ease;
    }
    
    .payment-method:hover {
        border-color: var(--primary-color);
        background-color: var(--light-color);
    }
    
    .payment-method input:checked + label {
        color: var(--primary-color);
    }
    
    .order-item {
        padding: 0.75rem 0;
        border-bottom: 1px solid #e9ecef;
    }
    
    .order-item:last-child {
        border-bottom: none;
    }
    
    @media (max-width: 768px) {
        .checkout-steps .d-flex {
            flex-direction: column;
            gap: 1rem;
        }
        
        .step-line {
            display: none;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        loadOrderSummary();
        
        const checkoutForm = document.getElementById('checkoutForm');
        if (checkoutForm) {
            checkoutForm.addEventListener('submit', handleCheckout);
        }
    });

    function loadOrderSummary() {
        const cart = JSON.parse(localStorage.getItem('cart') || '[]');
        const orderItemsContainer = document.getElementById('orderItems');
        
        if (cart.length === 0) {
            window.location.href = '<?php echo e(route("site2.cart.index")); ?>';
            return;
        }
        
        let orderHTML = '';
        let total = 0;
        
        cart.forEach(item => {
            const itemTotal = item.price * item.quantity;
            total += itemTotal;
            
            orderHTML += `
                <div class="order-item">
                    <div class="d-flex align-items-center">
                        <img src="${item.image}" class="rounded me-3" style="width: 50px; height: 50px; object-fit: cover;" alt="${item.name}">
                        <div class="flex-grow-1">
                            <div class="fw-medium">${item.name}</div>
                            <div class="small text-muted">${item.quantity} x ${item.price.toFixed(2)} ₺</div>
                        </div>
                        <div class="fw-bold">${itemTotal.toFixed(2)} ₺</div>
                    </div>
                </div>
            `;
        });
        
        orderItemsContainer.innerHTML = orderHTML;
        updatePriceSummary(total);
        
        // Check balance sufficiency
        <?php if(auth()->guard()->check()): ?>
            const userBalance = <?php echo e(Auth::user()->balance ?? 0); ?>;
            const insufficientBalanceAlert = document.getElementById('insufficientBalance');
            const completeOrderBtn = document.getElementById('completeOrderBtn');
            
            if (userBalance < total) {
                insufficientBalanceAlert.classList.remove('d-none');
                completeOrderBtn.disabled = true;
                completeOrderBtn.innerHTML = '<i class="bi bi-exclamation-triangle me-2"></i>Yetersiz Bakiye';
            } else {
                insufficientBalanceAlert.classList.add('d-none');
                completeOrderBtn.disabled = false;
                completeOrderBtn.innerHTML = '<i class="bi bi-check-circle me-2"></i>Siparişi Tamamla';
            }
        <?php endif; ?>
    }

    function updatePriceSummary(total) {
        document.getElementById('subtotal').textContent = total.toFixed(2) + ' ₺';
        document.getElementById('total').textContent = total.toFixed(2) + ' ₺';
    }

    async function handleCheckout(e) {
        e.preventDefault();
        
        const cart = JSON.parse(localStorage.getItem('cart') || '[]');
        if (cart.length === 0) {
            alert('Sepetiniz boş!');
            return;
        }
        
        const completeOrderBtn = document.getElementById('completeOrderBtn');
        const originalText = completeOrderBtn.innerHTML;
        
        // Show loading state
        completeOrderBtn.innerHTML = '<span class="loading"></span> İşleniyor...';
        completeOrderBtn.disabled = true;
        
        try {
            // Process each item in cart as separate orders
            const orderPromises = cart.map(item => {
                return fetch('<?php echo e(route("site2.products.order")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({
                        product_id: item.id,
                        quantity: item.quantity,
                        notes: document.querySelector('textarea[name="notes"]').value
                    })
                });
            });
            
            const responses = await Promise.all(orderPromises);
            
            // Check if all orders were successful
            let allSuccessful = true;
            for (const response of responses) {
                if (!response.ok) {
                    allSuccessful = false;
                    break;
                }
            }
            
            if (allSuccessful) {
                // Clear cart
                localStorage.removeItem('cart');
                updateCartCount(0);
                
                // Redirect to success page
                window.location.href = '<?php echo e(route("site2.account.orders")); ?>?success=1';
            } else {
                throw new Error('Sipariş işlemi başarısız');
            }
            
        } catch (error) {
            console.error('Checkout error:', error);
            alert('Sipariş işlemi sırasında bir hata oluştu. Lütfen tekrar deneyin.');
            
            // Restore button
            completeOrderBtn.innerHTML = originalText;
            completeOrderBtn.disabled = false;
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('gorevsitesi.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/gorevsitesi/cart/checkout.blade.php ENDPATH**/ ?>