<?php $__env->startSection("style"); ?>
	<link href="<?php echo e(('assets/plugins/notifications/css/lobibox.min.css')); ?>" rel="stylesheet">
	<link href="assets/plugins/Drag-And-Drop/dist/imageuploadify.min.css" rel="stylesheet">
	<?php $__env->stopSection(); ?>
<?php $__env->startSection("wrapper"); ?>
<div class="page-wrapper">
    <div class="page-content">

        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Tasks')); ?></div>


            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('task.index')); ?>"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('tasks.list')); ?>"><i class="bx bx-home-alt"></i><?php echo e(__('Task List')); ?></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Task Details')); ?></li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
            <button type="button" class="btn btn-danger px-5" onclick="history.back()"><i class="fadeIn animated bx bx-arrow-back"></i><?php echo e(__('Back')); ?></button>
            </div>
        </div>
        <!--end breadcrumb-->

        <?php if($response['IsoCode'] != $task->city && $task->city != 0): ?>
        <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
            <div class="d-flex align-items-center">
                <div class="font-35 text-white"><i class="bx bxs-message-square-x"></i>
                </div>
                <div class="ms-3">
                    <h6 class="mb-0 text-white"><?php echo e(__('Warning')); ?></h6>
                    <div class="text-white"><?php echo e(__('You are not in the city of the mission, you cannot do this mission.')); ?></div>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php else: ?>
         <div class="card">
            <div class="row g-0">
              <div class="col-md-3 border-end">
                <img src="<?php echo e(asset('assets/images/tasks/' . $task->image)); ?>" class="rounded-circle p-1 border" width="350" alt="<?php echo e($task->name); ?>">

              </div>
              <div class="col-md-9">
                <div class="card-body">
                  <h4 class="card-title"><?php echo e($task->name); ?></h4>
                  <div class="d-flex gap-3 py-3">

                      <div class="text-success"><i class="bx bxs-cart-alt align-middle"></i><?php echo e(__('Inventory')); ?>: <?php echo e($ProofCount); ?>/<?php echo e($task->limit); ?></div>
                  </div>
                  <div class="mb-3">
                    <span class="price h4"><?php echo e(__('Profit')); ?>: <?php echo e(number_format($task->reward, 2, ',', '.')); ?><?php echo e($settings['currency']); ?></span>

                </div>
                <hr>
                <div class="chip">
                    <img src="<?php echo e(asset('assets/images/app/' . $task->PlatformIcon)); ?>" alt="<?php echo e($task->PlatformDescription); ?>"><?php echo e(__('Platform')); ?>: <?php echo e($task->PlatformName); ?>

                </div>
                <hr>
                <span class="price h5"><?php echo e(__('Task Description')); ?>:</span>
                  <p class="card-text fs-6"><?php echo e($task->description); ?></p>

                  <hr>
                  <div class="chip">
                    <img src="<?php echo e(asset('assets/images/avatars/' . $task->UserAvatar)); ?>" alt="<?php echo e(__('Added by')); ?>"><?php echo e(__('Added by')); ?>: <?php echo e($task->UserName); ?>

                </div>
                <div class="chip chip-lg bg-primary text-white"><?php echo e(__('Limits')); ?>: <?php echo e(__('Daily')); ?> <?php echo e($task->daily_limit); ?>  <?php echo e(__('Total')); ?> <?php echo e($task->limit); ?>

                </div>
                <div class="chip chip-lg bg-secondary text-white"><?php echo e(__('Location')); ?>: <?php if($task->CountryName == 0 || $task->CityName == 0): ?>
                    <?php echo e(__('All')); ?>

                <?php else: ?>
                    <?php echo e($task->CountryName); ?>/<?php echo e($task->CityName); ?>

                <?php endif; ?>

                </div>
                <hr>
                <div class="card-title">
                    <h5 class="mb-0"><?php echo e(__('Completed')); ?></h5>
                </div>
<?php
$completedCount = $task->proofs->isNotEmpty() ? $task->proofs->first()->total : 0;
$completionPercentage = $task->limit > 0 ? ($completedCount / $task->limit * 100) : 0;
?>

<div class="progress">
<div class="progress-bar" role="progressbar" style="width: <?php echo e($completionPercentage); ?>%;" aria-valuenow="<?php echo e($completionPercentage); ?>" aria-valuemin="0" aria-valuemax="100">
<?php echo e(number_format($completionPercentage, 2)); ?>%
</div>
</div>
<hr>
                  <div class="row row-cols-auto row-cols-1 row-cols-md-1 align-items-center">
                    <form id="proofSubmitForm" enctype="multipart/form-data"<?php echo e(isset($task->is_pending) && $task->is_pending ? ' disabled' : ''); ?>>
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e($task->id); ?>">
                        <div class="col">
                            <label class="form-label"><?php echo e(__('Have you completed the task? Submit your proof, let our team evaluate it and earn your reward! Supported image formats > png, jpg, jpeg')); ?></label>
                            <div class="row">
                                <div class="col-xl-9 mx-auto">
                                    <h6 class="mb-0 text-uppercase"><?php echo e(__('upload_task_proofs', ['number' => $task->proof_number])); ?></h6>
                                    <hr/>
                                    <div class="card">
                                        <div class="card-body">
                                            <?php for($i = 1; $i <= $task->proof_number; $i++): ?>
                                                <div class="form-group">
                                                    <label for="proof<?php echo e($i); ?>"><?php echo e(__('Proof')); ?> <?php echo e($i); ?></label>
                                                    <input class="form-control" type="file" id="proof<?php echo e($i); ?>" name="proofs[]"<?php echo e($pendingProof ? ' disabled' : ''); ?>>
                                                </div>
                                            <?php endfor; ?>
                                            <div class="form-group">
                                                <label for="proof_comment"><?php echo e(__('Comment')); ?></label>
                                                <textarea class="form-control" id="proof_comment" name="Description"<?php echo e($pendingProof ? ' disabled' : ''); ?>></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex gap-3 mt-3">
                            <a href="<?php echo e($task->link); ?>" target="_blank" title="<?php echo e($task->name); ?>" class="btn btn-primary"><?php echo e(__('Go To Task')); ?></a>
                            <button type="submit" id="submitProofBtn" class="btn btn-outline-success"<?php echo e($pendingProof ? ' disabled' : ''); ?>>
                                <span class="btn-text"><?php echo e(__('Complete Task')); ?></span>
                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                            </button>
                        </div>
                    </form>

                </div>

                </div>
              </div>
            </div>
            <hr>


          </div>

    </div>
</div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
	<!--notification js -->
    <script src="<?php echo e(asset('assets/plugins/notifications/js/lobibox.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/plugins/notifications/js/notifications.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/plugins/notifications/js/notification-custom-script.js')); ?>"></script>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
 
    <?php if($pendingProof): ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: 'warning',
                title: "<?php echo e(__('Unconfirmed Proof')); ?>",
                text: "<?php echo e(__('You have a proof for this task that has not yet been approved. Please wait until the evidence is approved.')); ?>",
                confirmButtonText: "<?php echo e(__('OK')); ?>"
            });
        });
    </script>
    <?php endif; ?>

    <script>
        $(document).ready(function() {
            $('#proofSubmitForm').on('submit', function(e) {
                e.preventDefault();
                
                const form = this;
                const formData = new FormData(form);
                const submitBtn = $('#submitProofBtn');
                const btnText = submitBtn.find('.btn-text');
                const spinner = submitBtn.find('.spinner-border');
                
                // Dosya kontrolü
                const proofFiles = $('input[name="proofs[]"]');
                let hasFiles = false;
                proofFiles.each(function() {
                    if (this.files.length > 0) {
                        hasFiles = true;
                        return false;
                    }
                });
                
                if (!hasFiles) {
                    Lobibox.notify('error', {
                        pauseDelayOnHover: true,
                        continueDelayOnInactiveTab: false,
                        position: 'top right',
                        icon: 'bx bx-x-circle',
                        msg: "<?php echo e(__('Please upload at least one proof file.')); ?>"
                    });
                    return;
                }
                
                // Button durumunu değiştir
                submitBtn.prop('disabled', true);
                btnText.text("<?php echo e(__('Submitting...')); ?>");
                spinner.removeClass('d-none');
                
                $.ajax({
                    url: "<?php echo e(route('task.proofSubmit')); ?>",
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success) {
                            Lobibox.notify('success', {
                                pauseDelayOnHover: true,
                                continueDelayOnInactiveTab: false,
                                position: 'top right',
                                icon: 'bx bx-check-circle',
                                msg: response.message
                            });
                            
                            // Formu temizle
                            form.reset();
                            
                            // Sayfayı 2 saniye sonra yenile
                            setTimeout(function() {
                                location.reload();
                            }, 2000);
                        } else {
                            Lobibox.notify('error', {
                                pauseDelayOnHover: true,
                                continueDelayOnInactiveTab: false,
                                position: 'top right',
                                icon: 'bx bx-x-circle',
                                msg: response.message
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        let errorMessage = "<?php echo e(__('An error occurred while submitting your proof. Please try again.')); ?>";
                        
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        }
                        
                        Lobibox.notify('error', {
                            pauseDelayOnHover: true,
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            icon: 'bx bx-x-circle',
                            msg: errorMessage
                        });
                    },
                    complete: function() {
                        // Button durumunu eski haline getir
                        submitBtn.prop('disabled', false);
                        btnText.text("<?php echo e(__('Complete Task')); ?>");
                        spinner.addClass('d-none');
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.app", array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/tasks/show.blade.php ENDPATH**/ ?>