<?php $__env->startSection("style"); ?>
	<link href="<?php echo e(('assets/plugins/notifications/css/lobibox.min.css')); ?>" rel="stylesheet" />
	<?php $__env->stopSection(); ?>
<?php $__env->startSection("wrapper"); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Tasks')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="/"><i class="bx bx-home-alt"></i></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <button type="button" class="btn btn-success position-relative me-lg-5"> <i class="fadeIn animated bx bx-task align-middle"></i> <?php echo e(__('Task List')); ?> <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-dark"><?php echo e($tasks->count()); ?> <span class="visually-hidden">unread messages</span></span>
                            </button> 
                         </li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
            <button type="button" class="btn btn-danger px-5" onclick="history.back()"><i class="fadeIn animated bx bx-arrow-back"></i><?php echo e(__('Back')); ?></button>
            </div>
        </div>
       
        <!--end breadcrumb-->
        <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-4">
<?php if($tasks->isNotEmpty()): ?>
<?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="col">
    <div class="card radius-15">
        <div class="card-body text-center">
            <div class="p-4 border radius-15">
                <img src="<?php echo e(asset('assets/images/tasks/' . $task->image)); ?>" width="110" height="110" class="rounded-circle shadow" alt="<?php echo e($task->name); ?>">
                <h5 class="mb-0 mt-5"><?php echo e($task->name); ?></h5>
               
                <div class="app-name">
                        <div class="chip">
                        <img src="<?php echo e(asset('assets/images/app/' . $task->PlatformIcon)); ?>" alt="<?php echo e($task->PlatformDescription); ?>"><?php echo e(__('Platform')); ?>: <?php echo e($task->PlatformName); ?>

                    </div>
                    
             
                    <div class="chip chip-lg bg-danger text-white"><?php echo e(__('Your Earnings')); ?>: (<?php echo e(number_format($task->reward, 2, ',', '.')); ?><?php echo e($settings['currency']); ?>)
                    </div>
                    <div class="chip">
                        <img src="<?php echo e(asset('assets/images/avatars/' . $task->UserAvatar)); ?>" alt="<?php echo e(__('Added by')); ?>"><?php echo e(__('Added by')); ?>: <?php echo e($task->UserName); ?>

                    </div>
                    <div class="chip chip-lg bg-primary text-white"><?php echo e(__('Limits')); ?>: <?php echo e($task->daily_limit); ?>/<?php echo e($task->limit); ?>

                    </div>
                    <div class="chip chip-lg bg-secondary text-white"><?php echo e(__('Location')); ?>: <?php if($task->CountryName == 0 || $task->CityName == 0): ?>
                        <?php echo e(__('All')); ?>

                    <?php else: ?>
                        <?php echo e($task->CountryName); ?>/<?php echo e($task->CityName); ?>

                    <?php endif; ?>
                    
                    </div>
                  
                </div>
                <div class="card-title">
                            <h5 class="mb-0"><?php echo e(__('Completed')); ?></h5>
                        </div>
<?php
$completedCount = $task->proofs->isNotEmpty() ? $task->proofs->first()->total : 0;
$completionPercentage = $task->limit > 0 ? ($completedCount / $task->limit * 100) : 0;
?>

<div class="progress">
<div class="progress-bar" role="progressbar" style="width: <?php echo e($completionPercentage); ?>%;" aria-valuenow="<?php echo e($completionPercentage); ?>" aria-valuemin="0" aria-valuemax="100">
<?php echo e(number_format($completionPercentage, 2)); ?>%
</div>
</div>
           

                
<hr>
             <div class="row">
                <div class="col-md-6">
                    <form action="<?php echo e(route('task.info')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e($task->id); ?>">
                        <button type="submit"  class="btn btn-outline-info"><?php echo e(__('Task Transactions')); ?></button>
                    </form>
                   
                </div>
                <div class="col-md-6">
                    <button type="button" data-id="<?php echo e($task->id); ?>" target="_blank" rel="noopener" title="<?php echo e($task->name); ?>"  class="btn btn-outline-primary go-to-task" onclick="window.location.href = '<?php echo e($task->link); ?>'"><?php echo e(__('Go To Task')); ?></button>
                   
                </div>
              
             </div>
            </div>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
<div class="col">
<p><?php echo e(__('No data found.')); ?></p>
</div>
<?php endif; ?>

        
        
        </div>
        <!--end row-->
    </div>
</div>
<?php $__env->startSection("script"); ?>
	<!--notification js -->
    <script src="<?php echo e(asset('assets/plugins/notifications/js/lobibox.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/plugins/notifications/js/notifications.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/plugins/notifications/js/notification-custom-script.js')); ?>"></script>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.go-to-task').forEach(button => {
                button.addEventListener('click', function() {
                    const taskId = this.getAttribute('data-id');
                    const url = '<?php echo e(route("tasks.checkPendingProof", ":id")); ?>'.replace(':id', taskId);

                    fetch(url, {
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.pending) {
                            Swal.fire({
                                icon: 'warning',
                                title: 'Onaylanmamış Kanıt',
                                text: 'Bu göreve ait henüz onaylanmamış bir kanıtınız var. Lütfen kanıt onaylanana kadar bekleyin.',
                                confirmButtonText: 'Tamam'
                            });
                        } else {
                            window.location.href = data.url;
                        }
                    });
                });
            });
        });
    </script>
    <?php if(session('success')): ?>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        Lobibox.notify('success', {
            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-check-circle',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            msg: '<?php echo e(session('success')); ?>'
        });
    });
    </script>
    <?php endif; ?>
    <?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.app", array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/tasks/list.blade.php ENDPATH**/ ?>