<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Announcements')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/home')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Announcements')); ?></li>
                    </ol>
                </nav>
            </div>
        </div>

        <?php if(auth()->user()->user_type == 1): ?>
        <!-- Admin View -->
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><?php echo e(__('Announcements Management')); ?></h5>
                    <a href="<?php echo e(route('admin.announcements.create')); ?>" class="btn btn-primary">
                        <i class="bx bx-plus me-2"></i><?php echo e(__('Create Announcement')); ?>

                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo e(__('Title')); ?></th>
                                <th><?php echo e(__('Type')); ?></th>
                                <th><?php echo e(__('Priority')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th><?php echo e(__('Created')); ?></th>
                                <th><?php echo e(__('Actions')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $announcements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $announcement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <div>
                                        <strong><?php echo e($announcement->title); ?></strong>
                                        <?php if($announcement->show_as_popup): ?>
                                        <span class="badge bg-info ms-2"><?php echo e(__('Popup')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-secondary"><?php echo e($announcement->type_text); ?></span>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($announcement->priority_badge); ?>"><?php echo e($announcement->priority_text); ?></span>
                                </td>
                                <td>
                                    <?php if($announcement->is_active && !$announcement->isExpired()): ?>
                                    <span class="badge bg-success"><?php echo e(__('Active')); ?></span>
                                    <?php elseif($announcement->isExpired()): ?>
                                    <span class="badge bg-warning"><?php echo e(__('Expired')); ?></span>
                                    <?php else: ?>
                                    <span class="badge bg-secondary"><?php echo e(__('Inactive')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($announcement->created_at->format('d.m.Y H:i')); ?></td>
                                <td>
                                    <div class="d-flex gap-1">
                                        <a href="<?php echo e(route('announcements.show', $announcement->id)); ?>" class="btn btn-sm btn-outline-primary">
                                            <i class="bx bx-show"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.announcements.edit', $announcement->id)); ?>" class="btn btn-sm btn-outline-warning">
                                            <i class="bx bx-edit"></i>
                                        </a>
                                        <button class="btn btn-sm btn-outline-danger" onclick="deleteAnnouncement(<?php echo e($announcement->id); ?>)">
                                            <i class="bx bx-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                
                <?php echo e($announcements->links()); ?>

            </div>
        </div>
        <?php else: ?>
        <!-- User View -->
        <div class="row">
            <?php $__empty_1 = true; $__currentLoopData = $announcements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $announcement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-lg-6 col-xl-4">
                <div class="card announcement-card h-100">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-start">
                            <h6 class="mb-0"><?php echo e($announcement->title); ?></h6>
                            <span class="badge bg-<?php echo e($announcement->priority_badge); ?>"><?php echo e($announcement->priority_text); ?></span>
                        </div>
                    </div>
                    <div class="card-body">
                        <p class="card-text"><?php echo e(Str::limit(strip_tags($announcement->content), 150)); ?></p>
                        <div class="d-flex justify-content-between align-items-center">
                            <small class="text-muted">
                                <i class="bx bx-time me-1"></i><?php echo e($announcement->created_at->diffForHumans()); ?>

                            </small>
                            <a href="<?php echo e(route('announcements.show', $announcement->id)); ?>" class="btn btn-sm btn-primary">
                                <?php echo e(__('Read More')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12">
                <div class="text-center py-5">
                    <i class="bx bx-bullhorn display-1 text-muted"></i>
                    <h5 class="mt-3"><?php echo e(__('No announcements found')); ?></h5>
                    <p class="text-muted"><?php echo e(__('There are no announcements available at the moment.')); ?></p>
                </div>
            </div>
            <?php endif; ?>
        </div>
        
        <?php if($announcements->hasPages()): ?>
        <div class="d-flex justify-content-center mt-4">
            <?php echo e($announcements->links()); ?>

        </div>
        <?php endif; ?>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
function deleteAnnouncement(id) {
    Swal.fire({
        title: '<?php echo e(__('Are you sure?')); ?>',
        text: '<?php echo e(__('This announcement will be deleted permanently!')); ?>',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: '<?php echo e(__('Yes, delete it!')); ?>',
        cancelButtonText: '<?php echo e(__('Cancel')); ?>',
        confirmButtonColor: '#dc3545'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/admin/announcements/${id}`,
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Lobibox.notify('success', {
                            title: '<?php echo e(__('Success')); ?>',
                            msg: response.message,
                            sound: false
                        });
                        setTimeout(() => location.reload(), 1000);
                    }
                },
                error: function() {
                    Lobibox.notify('error', {
                        title: '<?php echo e(__('Error')); ?>',
                        msg: '<?php echo e(__('Error deleting announcement')); ?>',
                        sound: false
                    });
                }
            });
        }
    });
}
</script>
<?php $__env->stopSection(); ?>

<style>
.announcement-card {
    transition: transform 0.2s ease;
}

.announcement-card:hover {
    transform: translateY(-2px);
}
</style>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/announcements/index.blade.php ENDPATH**/ ?>