<?php $__env->startSection('title', s__('My Account') . ' - GorevSitesi'); ?>
<?php $__env->startSection('description', s__('Account Information')); ?>

<?php $__env->startSection('content'); ?>
<!-- Welcome Section -->
<div class="row mb-4">
    <div class="col-12">
        <div class="welcome-section bg-primary bg-opacity-10 rounded-3 p-4">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h1 class="fw-bold text-white mb-2">
                        <?php echo e(s__('Welcome')); ?>, <?php echo e(Auth::user()->username ?? Auth::user()->name); ?>!
                    </h1>
                    <p class="text-muted text-white mb-0"><?php echo e(s__('Account Information')); ?></p>
                </div>
                <div class="col-md-4 text-md-end">
                    <div class="balance-info">
                        <div class="small text-muted"><?php echo e(s__('Current Balance')); ?></div>
                        <div class="h4 fw-bold text-primary mb-0"><?php echo e(number_format(Auth::user()->balance ?? 0, 2)); ?> ₺</div>
                        <a href="<?php echo e(route('site2.account.balance.create')); ?>" class="btn btn-sm btn-outline-primary mt-2">
                            <i class="bi bi-plus-circle me-1"></i><?php echo e(s__('Load Balance')); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Stats -->
<div class="row mb-4">
    <div class="col-md-3 mb-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body text-center">
                <i class="bi bi-bag-check text-success fs-1 mb-3"></i>
                <h5 class="fw-bold mb-2"><?php echo e(Auth::user()->orders()->count()); ?></h5>
                <p class="text-muted mb-0"><?php echo e(s__('Total Orders')); ?></p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body text-center">
                <i class="bi bi-clock-history text-warning fs-1 mb-3"></i>
                <h5 class="fw-bold mb-2"><?php echo e(Auth::user()->orders()->where('status', 'pending')->count()); ?></h5>
                <p class="text-muted mb-0"><?php echo e(s__('Pending Orders')); ?></p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body text-center">
                <i class="bi bi-check-circle text-primary fs-1 mb-3"></i>
                <h5 class="fw-bold mb-2"><?php echo e(Auth::user()->orders()->where('status', 'completed')->count()); ?></h5>
                <p class="text-muted mb-0"><?php echo e(s__('Completed Orders')); ?></p>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-body text-center">
                <i class="bi bi-wallet2 text-info fs-1 mb-3"></i>
                <h5 class="fw-bold mb-2"><?php echo e(number_format(Auth::user()->orders()->where('status', 'completed')->sum('total_amount'), 2)); ?> ₺</h5>
                <p class="text-muted mb-0"><?php echo e(s__('Total Spending')); ?></p>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white border-0">
                <h5 class="mb-0 fw-bold">
                    <i class="bi bi-lightning me-2"></i><?php echo e(s__('Quick Actions')); ?>

                </h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-3">
                        <a href="<?php echo e(route('site2.products.index')); ?>" class="btn btn-outline-primary w-100 h-100 d-flex flex-column align-items-center justify-content-center p-3">
                            <i class="bi bi-grid fs-3 mb-2"></i>
                            <span><?php echo e(s__('Browse Products')); ?></span>
                        </a>
                    </div>
                    <div class="col-md-3">
                        <a href="<?php echo e(route('site2.account.orders')); ?>" class="btn btn-outline-success w-100 h-100 d-flex flex-column align-items-center justify-content-center p-3">
                            <i class="bi bi-bag-check fs-3 mb-2"></i>
                            <span><?php echo e(s__('My Orders')); ?></span>
                        </a>
                    </div>
                    <div class="col-md-3">
                        <a href="<?php echo e(route('site2.account.balance.create')); ?>" class="btn btn-outline-warning w-100 h-100 d-flex flex-column align-items-center justify-content-center p-3">
                            <i class="bi bi-credit-card fs-3 mb-2"></i>
                            <span><?php echo e(s__('Add Balance')); ?></span>
                        </a>
                    </div>
                    <div class="col-md-3">
                        <a href="<?php echo e(route('site2.account.profile')); ?>" class="btn btn-outline-info w-100 h-100 d-flex flex-column align-items-center justify-content-center p-3">
                            <i class="bi bi-person-gear fs-3 mb-2"></i>
                            <span><?php echo e(s__('Profile Settings')); ?></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Orders -->
<div class="row">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold">
                    <i class="bi bi-clock-history me-2"></i><?php echo e(s__('Recent Orders')); ?>

                </h5>
                <a href="<?php echo e(route('site2.account.orders')); ?>" class="btn btn-sm btn-outline-primary">
                    <?php echo e(s__('View All')); ?> <i class="bi bi-arrow-right ms-1"></i>
                </a>
            </div>
            <div class="card-body">
                <?php
                    $recentOrders = Auth::user()->orders()->latest()->limit(5)->get();
                ?>
                
                <?php if($recentOrders->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th><?php echo e(s__('Order Number')); ?></th>
                                    <th><?php echo e(s__('Product')); ?></th>
                                    <th><?php echo e(s__('Amount')); ?></th>
                                    <th><?php echo e(s__('Status')); ?></th>
                                    <th><?php echo e(s__('Date')); ?></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $recentOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <span class="fw-medium">#<?php echo e($order->order_number); ?></span>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div>
                                                    <div class="fw-medium"><?php echo e($order->product_name); ?></div>
                                                    <div class="small text-muted"><?php echo e($order->quantity); ?> <?php echo e(s__('pieces')); ?></div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="fw-bold"><?php echo e($order->formatted_total); ?></span>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?php echo e($order->status_badge); ?>">
                                                <?php echo e($order->status_text); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <div class="small">
                                                <?php echo e($order->created_at->format('d.m.Y')); ?>

                                                <div class="text-muted"><?php echo e($order->created_at->format('H:i')); ?></div>
                                            </div>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('site2.account.orders.show', $order->id)); ?>" 
                                               class="btn btn-sm btn-outline-primary">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="text-center py-4">
                        <i class="bi bi-bag-x text-muted" style="font-size: 3rem;"></i>
                        <h5 class="mt-3 mb-3"><?php echo e(s__('No orders yet')); ?></h5>
                        <p class="text-muted mb-3"><?php echo e(s__('Start shopping to see your orders here')); ?></p>
                        <a href="<?php echo e(route('site2.products.index')); ?>" class="btn btn-primary">
                            <i class="bi bi-grid me-2"></i><?php echo e(s__('Browse Products')); ?>

                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Balance Requests -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold">
                    <i class="bi bi-credit-card me-2"></i><?php echo e(s__('Balance Loading Requests')); ?>

                </h5>
                <a href="<?php echo e(route('site2.account.balance.create')); ?>" class="btn btn-sm btn-outline-success">
                    <i class="bi bi-plus-circle me-1"></i><?php echo e(s__('Load Balance')); ?>

                </a>
            </div>
            <div class="card-body">
                <?php
                    $balanceRequests = \App\Models\BalanceLog::where('user_id', Auth::id())
                        ->where('type', 'deposit')
                        ->whereNotNull('payment_method')
                        ->latest()
                        ->limit(5)
                        ->get();
                ?>
                
                <?php if($balanceRequests->count() > 0): ?>
                    <div class="row g-3">
                        <?php $__currentLoopData = $balanceRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-12">
                                <div class="card border-start border-4 border-<?php echo e($request->status == 'completed' ? 'success' : ($request->status == 'pending' ? 'warning' : 'danger')); ?> bg-light">
                                    <div class="card-body p-3">
                                        <div class="row align-items-center">
                                            <div class="col-md-2 col-6">
                                                <div class="d-flex align-items-center">
                                                    <div class="bg-<?php echo e($request->status == 'completed' ? 'success' : ($request->status == 'pending' ? 'warning' : 'danger')); ?> bg-opacity-10 rounded-circle p-2 me-2">
                                                        <i class="bi bi-<?php echo e($request->payment_method == 'credit_card' ? 'credit-card' : 'bank'); ?> text-<?php echo e($request->status == 'completed' ? 'success' : ($request->status == 'pending' ? 'warning' : 'danger')); ?>"></i>
                                                    </div>
                                                    <div>
                                                        <div class="fw-bold"><?php echo e(number_format($request->amount, 2)); ?> ₺</div>
                                                        <div class="small text-muted">
                                                            <?php echo e($request->payment_method == 'credit_card' ? s__('Credit Card') : s__('Bank Transfer')); ?>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-6">
                                                <div class="text-center text-md-start">
                                                    <?php if($request->status == 'completed'): ?>
                                                        <span class="badge bg-success px-3 py-2">
                                                            <i class="bi bi-check-circle me-1"></i><?php echo e(s__('Completed')); ?>

                                                        </span>
                                                    <?php elseif($request->status == 'pending'): ?>
                                                        <span class="badge bg-warning px-3 py-2">
                                                            <i class="bi bi-clock me-1"></i><?php echo e(s__('Pending Approval')); ?>

                                                        </span>
                                                    <?php else: ?>
                                                        <span class="badge bg-danger px-3 py-2">
                                                            <i class="bi bi-x-circle me-1"></i><?php echo e(s__('Rejected')); ?>

                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-6 mt-2 mt-md-0">
                                                <div class="small text-muted">
                                                    <i class="bi bi-calendar me-1"></i><?php echo e($request->created_at->format('d.m.Y H:i')); ?>

                                                </div>
                                                <?php if($request->status == 'completed' && $request->approved_at): ?>
                                                    <div class="small text-success">
                                                        <i class="bi bi-check me-1"></i><?php echo e(s__('Approved')); ?>: <?php echo e($request->approved_at->format('d.m.Y H:i')); ?>

                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="col-md-4 col-6 mt-2 mt-md-0">
                                                <div class="d-flex justify-content-end gap-2">
                                                    <?php if($request->payment_method == 'bank_transfer' && $request->receipt_path): ?>
                                                        <button class="btn btn-sm btn-outline-info" onclick="viewReceipt('<?php echo e(asset('storage/' . $request->receipt_path)); ?>')">
                                                            <i class="bi bi-file-earmark-image"></i>
                                                            <span class="d-none d-sm-inline ms-1"><?php echo e(s__('Receipt')); ?></span>
                                                        </button>
                                                    <?php endif; ?>
                                                    <?php if($request->status == 'pending' && $request->payment_method == 'bank_transfer'): ?>
                                                        <span class="badge bg-info px-2 py-1">
                                                            <i class="bi bi-hourglass-split me-1"></i><?php echo e(s__('Under Review')); ?>

                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <?php if($request->status == 'rejected' && $request->rejection_reason): ?>
                                            <div class="mt-2 pt-2 border-top">
                                                <div class="alert alert-danger mb-0 py-2">
                                                    <small>
                                                        <strong><?php echo e(s__('Rejection Reason')); ?>:</strong> <?php echo e($request->rejection_reason); ?>

                                                    </small>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-4">
                        <i class="bi bi-wallet2 text-muted" style="font-size: 3rem;"></i>
                        <h5 class="mt-3 mb-3"><?php echo e(s__('No balance requests yet')); ?></h5>
                        <p class="text-muted mb-3"><?php echo e(s__('Load balance to your account to start shopping')); ?></p>
                        <a href="<?php echo e(route('site2.account.balance.create')); ?>" class="btn btn-success">
                            <i class="bi bi-plus-circle me-2"></i><?php echo e(s__('Load Balance Now')); ?>

                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Dashboard specific scripts
function viewReceipt(receiptUrl) {
    // Create modal for receipt viewing
    const modal = document.createElement('div');
    modal.className = 'modal fade';
    modal.id = 'receiptModal';
    modal.setAttribute('tabindex', '-1');
    modal.innerHTML = `
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="bi bi-file-earmark-image me-2"></i><?php echo e(s__('Receipt')); ?>

                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <div class="spinner-border text-primary mb-3" role="status">
                        <span class="visually-hidden"><?php echo e(s__('Loading...')); ?></span>
                    </div>
                    <div id="receiptContent"></div>
                </div>
                <div class="modal-footer">
                    <a href="${receiptUrl}" target="_blank" class="btn btn-primary">
                        <i class="bi bi-download me-2"></i><?php echo e(s__('Download')); ?>

                    </a>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <?php echo e(s__('Close')); ?>

                    </button>
                </div>
            </div>
        </div>
    `;
    
    document.body.appendChild(modal);
    
    const bootstrapModal = new bootstrap.Modal(modal);
    bootstrapModal.show();
    
    // Load receipt content
    const receiptContent = document.getElementById('receiptContent');
    const spinner = modal.querySelector('.spinner-border');
    
    // Check if it's an image or PDF
    const fileExtension = receiptUrl.split('.').pop().toLowerCase();
    
    if (['jpg', 'jpeg', 'png', 'gif'].includes(fileExtension)) {
        // Display image
        const img = document.createElement('img');
        img.src = receiptUrl;
        img.className = 'img-fluid rounded shadow';
        img.style.maxHeight = '500px';
        img.onload = function() {
            spinner.style.display = 'none';
            receiptContent.appendChild(img);
        };
        img.onerror = function() {
            spinner.style.display = 'none';
            receiptContent.innerHTML = `
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <?php echo e(s__('Could not load receipt. Please try downloading.')); ?>

                </div>
            `;
        };
    } else if (fileExtension === 'pdf') {
        // Display PDF
        spinner.style.display = 'none';
        receiptContent.innerHTML = `
            <div class="alert alert-info mb-3">
                <i class="bi bi-file-earmark-pdf me-2"></i>
                <?php echo e(s__('PDF Receipt')); ?>

            </div>
            <iframe src="${receiptUrl}" width="100%" height="500px" class="border rounded"></iframe>
        `;
    } else {
        // Unknown file type
        spinner.style.display = 'none';
        receiptContent.innerHTML = `
            <div class="alert alert-info">
                <i class="bi bi-file-earmark me-2"></i>
                <?php echo e(s__('Receipt file ready for download')); ?>

            </div>
        `;
    }
    
    // Clean up modal when closed
    modal.addEventListener('hidden.bs.modal', function() {
        document.body.removeChild(modal);
    });
}
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .welcome-section {
        background: linear-gradient(135deg, var(--primary-color) 0%, #3b82f6 100%);
        background-opacity: 0.1 !important;
    }
    
    .balance-info {
        background: rgba(255, 255, 255, 0.8);
        padding: 1rem;
        border-radius: 0.5rem;
        backdrop-filter: blur(10px);
    }
    
    .quick-action-card {
        transition: all 0.2s ease;
        border: 2px solid transparent;
    }
    
    .quick-action-card:hover {
        border-color: var(--primary-color);
        transform: translateY(-2px);
        box-shadow: var(--shadow-md);
    }
    
    @media (max-width: 768px) {
        .welcome-section .row {
            text-align: center;
        }
        
        .balance-info {
            margin-top: 1rem;
        }
    }
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('gorevsitesi.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/gorevsitesi/account/dashboard.blade.php ENDPATH**/ ?>