<?php if(isset($request)): ?>
<div class="row g-3">
    <!-- User Information -->
    <div class="col-12">
        <div class="card border-0 bg-light">
            <div class="card-body">
                <h6 class="card-title mb-3">
                    <i class="bx bx-user me-2 text-primary"></i><?php echo e(__('User Information')); ?>

                </h6>
                <div class="row">
                    <div class="col-md-6">
                        <small class="text-muted"><?php echo e(__('Username')); ?></small>
                        <div class="fw-bold"><?php echo e($request->user->username ?? 'N/A'); ?></div>
                    </div>
                    <div class="col-md-6">
                        <small class="text-muted"><?php echo e(__('Email')); ?></small>
                        <div class="fw-bold"><?php echo e($request->user->email ?? 'N/A'); ?></div>
                    </div>
                </div>
                <?php if($request->user->phone ?? false): ?>
                <div class="row mt-2">
                    <div class="col-md-6">
                        <small class="text-muted"><?php echo e(__('Phone')); ?></small>
                        <div class="fw-bold"><?php echo e($request->user->phone); ?></div>
                    </div>
                    <div class="col-md-6">
                        <small class="text-muted"><?php echo e(__('Current Balance')); ?></small>
                        <div class="fw-bold text-success"><?php echo e(number_format($request->user->balance ?? 0, 2)); ?> ₺</div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Request Details -->
    <div class="col-12">
        <div class="card border-0">
            <div class="card-body">
                <h6 class="card-title mb-3">
                    <i class="bx bx-wallet me-2 text-info"></i><?php echo e(__('Request Details')); ?>

                </h6>
                <div class="row g-3">
                    <div class="col-md-4">
                        <small class="text-muted"><?php echo e(__('Request ID')); ?></small>
                        <div class="fw-bold">#<?php echo e($request->id); ?></div>
                    </div>
                    <div class="col-md-4">
                        <small class="text-muted"><?php echo e(__('Amount')); ?></small>
                        <div class="fw-bold text-success fs-5"><?php echo e(number_format($request->amount, 2)); ?> ₺</div>
                    </div>
                    <div class="col-md-4">
                        <small class="text-muted"><?php echo e(__('Status')); ?></small>
                        <div>
                            <?php if($request->status == 'pending'): ?>
                                <span class="badge bg-warning fs-6"><?php echo e(__('Pending')); ?></span>
                            <?php elseif($request->status == 'completed'): ?>
                                <span class="badge bg-success fs-6"><?php echo e(__('Approved')); ?></span>
                            <?php elseif($request->status == 'rejected'): ?>
                                <span class="badge bg-danger fs-6"><?php echo e(__('Rejected')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <small class="text-muted"><?php echo e(__('Request Date')); ?></small>
                        <div class="fw-bold"><?php echo e($request->created_at->format('d.m.Y H:i:s')); ?></div>
                    </div>
                    <?php if($request->updated_at != $request->created_at): ?>
                    <div class="col-md-6">
                        <small class="text-muted"><?php echo e(__('Last Updated')); ?></small>
                        <div class="fw-bold"><?php echo e($request->updated_at->format('d.m.Y H:i:s')); ?></div>
                    </div>
                    <?php endif; ?>
                </div>

                <?php if($request->description): ?>
                <div class="mt-3">
                    <small class="text-muted"><?php echo e(__('Description')); ?></small>
                    <div class="mt-1 p-2 bg-light rounded"><?php echo e($request->description); ?></div>
                </div>
                <?php endif; ?>

                <?php if($request->rejection_reason): ?>
                <div class="mt-3">
                    <small class="text-muted text-danger"><?php echo e(__('Rejection Reason')); ?></small>
                    <div class="mt-1 p-2 bg-danger bg-opacity-10 text-white border border-danger rounded">
                        <i class="bx bx-info-circle me-1"></i><?php echo e($request->rejection_reason); ?>

                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Receipt Information -->
    <?php if($request->receipt_path): ?>
    <div class="col-12">
        <div class="card border-0">
            <div class="card-body">
                <h6 class="card-title mb-3">
                    <i class="bx bx-file me-2 text-success"></i><?php echo e(__('Receipt')); ?>

                </h6>
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <div class="fw-bold"><?php echo e(__('Receipt Available')); ?></div>
                        <small class="text-muted"><?php echo e(__('Click to download the receipt file')); ?></small>
                    </div>
                    <a href="<?php echo e(route('admin.balance-requests.download-receipt', ['id' => $request->id])); ?>" 
                       class="btn btn-success" target="_blank">
                        <i class="bx bx-download me-2"></i><?php echo e(__('Download Receipt')); ?>

                    </a>
                </div>
            </div>
        </div>
    </div>
    <?php else: ?>
    <div class="col-12">
        <div class="alert alert-info">
            <i class="bx bx-info-circle me-2"></i><?php echo e(__('No receipt file uploaded for this request')); ?>

        </div>
    </div>
    <?php endif; ?>

    <!-- Bank Information (if available) -->
    <?php if($request->user->bank_name || $request->user->iban): ?>
    <div class="col-12">
        <div class="card border-0">
            <div class="card-body">
                <h6 class="card-title mb-3">
                    <i class="bx bx-credit-card me-2 text-warning"></i><?php echo e(__('Bank Information')); ?>

                </h6>
                <div class="row">
                    <?php if($request->user->bank_name): ?>
                    <div class="col-md-6">
                        <small class="text-muted"><?php echo e(__('Bank Name')); ?></small>
                        <div class="fw-bold"><?php echo e($request->user->bank_name); ?></div>
                    </div>
                    <?php endif; ?>
                    <?php if($request->user->iban): ?>
                    <div class="col-md-6">
                        <small class="text-muted"><?php echo e(__('IBAN')); ?></small>
                        <div class="fw-bold font-monospace"><?php echo e($request->user->iban); ?></div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Action Buttons -->
    <?php if($request->status == 'pending'): ?>
    <div class="col-12">
        <div class="card border-0 bg-light">
            <div class="card-body">
                <h6 class="card-title mb-3">
                    <i class="bx bx-cog me-2 text-secondary"></i><?php echo e(__('Actions')); ?>

                </h6>
                <div class="d-flex gap-2 flex-wrap">
                    <button class="btn btn-success" onclick="approveRequest(<?php echo e($request->id); ?>)">
                        <i class="bx bx-check me-2"></i><?php echo e(__('Approve Request')); ?>

                    </button>
                    <button class="btn btn-danger" onclick="rejectRequest(<?php echo e($request->id); ?>)">
                        <i class="bx bx-x me-2"></i><?php echo e(__('Reject Request')); ?>

                    </button>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php else: ?>
<div class="alert alert-danger">
    <i class="bx bx-error-circle me-2"></i><?php echo e(__('Request not found or access denied')); ?>

</div>
<?php endif; ?><?php /**PATH /home/saat/public_html/resources/views/admin/balance-requests/show.blade.php ENDPATH**/ ?>