<!doctype html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() == 'ar' ? 'rtl' : 'ltr'); ?>">
<head>
	 <base href="<?php echo e(url('/')); ?>/">
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="<?php echo e(asset('assets/images/' . ($settings['favicon'] ?? 'favicon-32x32.png'))); ?>" type="image/png">
	<!--plugins-->
	<?php echo $__env->yieldContent("style"); ?>
	<link href="<?php echo e(asset('assets/plugins/simplebar/css/simplebar.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('assets/plugins/metismenu/css/metisMenu.min.css')); ?>" rel="stylesheet">
	<!-- loader-->
	<link href="<?php echo e(asset('assets/css/pace.min.css')); ?>" rel="stylesheet">
	<script src="<?php echo e(asset('assets/js/pace.min.js')); ?>"></script>
	<!-- Bootstrap CSS -->
	<link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/bootstrap-extended.css')); ?>" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
	<link href="<?php echo e(asset('assets/css/app.css')); ?>" rel="stylesheet">
	<link href="<?php echo e(asset('assets/css/icons.css')); ?>" rel="stylesheet">

    <!-- Theme Style CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/dark-theme.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/semi-dark.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/header-colors.css')); ?>">

    <meta name="description" content="<?php echo e($settings['description'] ?? ''); ?>">
    <meta name="keywords" content="<?php echo e($settings['keywords'] ?? ''); ?>">
    <meta name="author" content="<?php echo e($settings['site_name'] ?? 'TaskHub'); ?>">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
	
    <title><?php echo $__env->yieldContent('title', $settings['site_name'] ?? 'Dashboard'); ?></title>
	<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link href="<?php echo e(asset('assets/plugins/notifications/css/lobibox.min.css')); ?>" rel="stylesheet">

<style>
	.announcement-popup-modal {
		max-width: 600px !important;
	}
	
	.announcement-popup-content {
		text-align: left !important;
	}
	
	.announcement-content {
		max-height: 300px;
		overflow-y: auto;
		line-height: 1.6;
	}
	</style>
</head>

<body>
	<!--wrapper-->
	<div class="wrapper">
		<!--start header -->
		<?php echo $__env->make("layouts.header", array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
		<!--end header -->
		<!--navigation-->
		<?php echo $__env->make("layouts.nav", array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
		<!--end navigation-->
		<!--start page wrapper -->
		<?php echo $__env->yieldContent("wrapper"); ?>
		<!--end page wrapper -->
    
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		<footer class="page-footer">
			<p class="mb-0"><?php echo e(__('copyright', ['year' => date("Y")])); ?></p>
		</footer>
	</div>
	<!--end wrapper-->
 
	<!-- Bootstrap JS -->
	<script src="<?php echo e(asset('assets/js/bootstrap.bundle.min.js')); ?>"></script>
	<!--plugins-->
	<script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
	<script>
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
      'Accept':       'application/json',
      'X-Requested-With': 'XMLHttpRequest'
    }
  });
</script>
	<script src="<?php echo e(asset('assets/plugins/notifications/js/lobibox.min.js')); ?>"></script>
	<script>
  // Lobibox'un varsayılan soundPath'ini mutlak bir asset yoluyla değiştiriyoruz
  Lobibox.notify.DEFAULTS = $.extend(true, {}, Lobibox.notify.DEFAULTS, {
    soundPath: <?php echo json_encode(asset('assets/plugins/notifications/sounds/'), 15, 512) ?>,
    soundExt: '.ogg'   // eğer .ogg dışında bir uzantı kullanıyorsan burayı da güncelle
  });
</script>
	<script src="<?php echo e(asset('assets/plugins/notifications/js/notifications.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/plugins/metismenu/js/metisMenu.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>

	<!--app JS-->
	<script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>

	<!-- Announcement Popup System -->
	<script>
	$(document).ready(function() {
		// Check for popup announcements after page load
		setTimeout(function() {
			checkPopupAnnouncements();
		}, 2000);
	});

	function checkPopupAnnouncements() {
		$.ajax({
			url: '<?php echo e(route('api.announcements.popup')); ?>',
			method: 'GET',
			success: function(response) {
				if (response.success && response.announcements.length > 0) {
					showAnnouncementPopups(response.announcements);
				}
			},
			error: function() {
				console.log('Error loading popup announcements');
			}
		});
	}

	function showAnnouncementPopups(announcements) {
		let currentIndex = 0;
		
		function showNextAnnouncement() {
			if (currentIndex >= announcements.length) {
				return;
			}
			
			const announcement = announcements[currentIndex];
			const priorityIcon = getPriorityIcon(announcement.priority);
			
			Swal.fire({
				title: announcement.title,
				html: `
					<div class="announcement-popup">
						<div class="d-flex align-items-center mb-3">
							<span class="badge bg-${announcement.priority_badge} me-2">${announcement.priority.toUpperCase()}</span>
							<small class="text-muted">${announcement.created_at}</small>
						</div>
						<div class="announcement-content text-start">
							${announcement.content}
						</div>
					</div>
				`,
				icon: priorityIcon,
				showCancelButton: true,
				confirmButtonText: '<?php echo e(__('Mark as Read')); ?>',
				cancelButtonText: '<?php echo e(__('Close')); ?>',
				allowOutsideClick: false,
				customClass: {
					popup: 'announcement-popup-modal',
					content: 'announcement-popup-content'
				}
			}).then((result) => {
				if (result.isConfirmed) {
					markAnnouncementAsRead(announcement.id);
				}
				
				currentIndex++;
				if (currentIndex < announcements.length) {
					setTimeout(showNextAnnouncement, 500);
				}
			});
		}
		
		showNextAnnouncement();
	}

	function getPriorityIcon(priority) {
		switch(priority) {
			case 'urgent': return 'error';
			case 'high': return 'warning';
			case 'medium': return 'info';
			case 'low': return 'success';
			default: return 'info';
		}
	}

	function markAnnouncementAsRead(announcementId) {
		$.ajax({
			url: `/announcements/${announcementId}/read`,
			method: 'POST',
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			success: function(response) {
				if (response.success) {
					console.log('Announcement marked as read');
				}
			}
		});
	}
	</script>

	
		
	<?php echo $__env->yieldContent("script"); ?>
</body>

</html>
<?php /**PATH /home/saat/public_html/resources/views/layouts/app.blade.php ENDPATH**/ ?>