<?php $__env->startSection('title', __('Register') . ' - GorevSitesi'); ?>
<?php $__env->startSection('description', __('Join GorevSitesi for free and enjoy shopping.')); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
  <div class="col-lg-10">
    <div class="card border-0 shadow-lg">
      <div class="card-body p-5">
        <div class="text-center mb-4">
          <div class="bg-success bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width:80px;height:80px;">
            <i class="bi bi-person-plus text-success fs-1"></i>
          </div>
          <h2 class="fw-bold mb-2"><?php echo e(__('Create Account')); ?></h2>
          <p class="text-muted"><?php echo e(__('Create a free account and start shopping')); ?></p>
        </div>

        <form method="POST" action="<?php echo e(route('site2.register.submit')); ?>" id="registerForm">
          <?php echo csrf_field(); ?>

          <div class="row g-3">
            <!-- Name / Username -->
            <div class="col-md-6">
              <label for="account_holder" class="form-label fw-medium">
                <i class="bi bi-person me-2"></i><?php echo e(__('Name Surname')); ?></label>
              <input id="account_holder" type="text"
                     class="form-control form-control-lg <?php $__errorArgs = ['account_holder'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                     name="account_holder" value="<?php echo e(old('account_holder')); ?>" required
                     autocomplete="name" autofocus
                     placeholder="<?php echo e(__('Please Enter Name Surname')); ?>">
              <?php $__errorArgs = ['account_holder'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="col-md-6">
              <label for="username" class="form-label fw-medium">
                <i class="bi bi-at me-2"></i><?php echo e(__('Username')); ?></label>
              <input id="username" type="text"
                     class="form-control form-control-lg <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                     name="username" value="<?php echo e(old('username')); ?>" required autocomplete="username"
                     placeholder="<?php echo e(__('Please Enter Username')); ?>">
              <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Email / Phone -->
            <div class="col-md-6">
              <label for="email" class="form-label fw-medium">
                <i class="bi bi-envelope me-2"></i><?php echo e(__('Email Address')); ?></label>
              <input id="email" type="email"
                     class="form-control form-control-lg <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                     name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email"
                     placeholder="<?php echo e(__('jhon@example.com')); ?>">
              <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="col-md-6">
              <label for="phone" class="form-label fw-medium">
                <i class="bi bi-telephone me-2"></i><?php echo e(__('Phone Number')); ?></label>
              <input id="phone" type="tel"
                     class="form-control form-control-lg <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                     name="phone" value="<?php echo e(old('phone')); ?>" required autocomplete="tel"
                     placeholder="<?php echo e(__('5320000000')); ?>">
              <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Country / City -->
            <div class="col-md-6">
              <label for="country_code" class="form-label fw-medium">
                <i class="bi bi-globe me-2"></i><?php echo e(__('Country')); ?></label>
              <select class="form-select form-select-lg <?php $__errorArgs = ['country_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                      name="country_code" id="country_code"
                      data-cities-url-template="<?php echo e(url('/api/cities/XX')); ?>" required>
                <option value=""><?php echo e(__('Please Select')); ?></option>
                <?php $__currentLoopData = ($countries ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($country->code); ?>" <?php echo e(old('country_code') === $country->code ? 'selected' : ''); ?>>
                    <?php echo e($country->name); ?>

                  </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <option value="9999" <?php echo e(old('country_code') == "9999" ? 'selected' : ''); ?>><?php echo e(__('Other')); ?></option>
              </select>
              <?php $__errorArgs = ['country_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="col-md-6">
              <label for="city_id" class="form-label fw-medium">
                <i class="bi bi-building me-2"></i><?php echo e(__('City')); ?></label>
              <select class="form-select form-select-lg <?php $__errorArgs = ['city_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                      name="city_id" id="city_id" <?php echo e(old('country_code') ? '' : 'disabled'); ?>>
                <option value=""><?php echo e(__('Please Select')); ?></option>
                <option value="9999" <?php echo e(old('city_id') == "9999" ? 'selected' : ''); ?>><?php echo e(__('Other')); ?></option>
              </select>
              <?php $__errorArgs = ['city_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Gender / Password -->
            <div class="col-md-6">
              <label for="gender" class="form-label fw-medium">
                <i class="bi bi-person-badge me-2"></i><?php echo e(__('Sex')); ?></label>
              <select class="form-select form-select-lg <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                      name="gender" id="gender" required>
                <option value=""><?php echo e(__('Please Select')); ?></option>
                <option value="male"   <?php echo e(old('gender') === 'male'   ? 'selected' : ''); ?>><?php echo e(__('Male')); ?></option>
                <option value="female" <?php echo e(old('gender') === 'female' ? 'selected' : ''); ?>><?php echo e(__('Female')); ?></option>
                <option value="other"  <?php echo e(old('gender') === 'other'  ? 'selected' : ''); ?>><?php echo e(__('Other')); ?></option>
              </select>
              <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="col-md-6">
              <label for="password" class="form-label fw-medium"><i class="bi bi-lock me-2"></i><?php echo e(__('Password')); ?></label>
              <div class="position-relative">
                <input id="password" type="password"
                       class="form-control form-control-lg <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                       name="password" required autocomplete="new-password" placeholder="********" minlength="8">
                <button type="button" class="btn btn-link position-absolute end-0 top-50 translate-middle-y text-muted"
                        onclick="togglePassword('password')" style="border:none;background:none;z-index:10;">
                  <i class="bi bi-eye" id="password-eye"></i>
                </button>
              </div>
              <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              <div class="form-text"><small class="text-muted"><i class="bi bi-info-circle me-1"></i><?php echo e(__('Password must be at least 8 characters long')); ?></small></div>
            </div>

            <!-- Password confirm / Terms -->
            <div class="col-md-6">
              <label for="password_confirmation" class="form-label fw-medium"><i class="bi bi-lock-fill me-2"></i><?php echo e(__('Password Confirmation')); ?></label>
              <div class="position-relative">
                <input id="password_confirmation" type="password" class="form-control form-control-lg"
                       name="password_confirmation" required autocomplete="new-password" placeholder="********" minlength="8">
                <button type="button" class="btn btn-link position-absolute end-0 top-50 translate-middle-y text-muted"
                        onclick="togglePassword('password_confirmation')" style="border:none;background:none;z-index:10;">
                  <i class="bi bi-eye" id="password_confirmation-eye"></i>
                </button>
              </div>
              <div id="password-match-message" class="form-text"></div>
            </div>

            <div class="col-md-6 d-flex align-items-end">
              <div class="form-check">
                <input class="form-check-input" type="checkbox" id="terms" name="terms" required>
                <label class="form-check-label" for="terms"><?php echo e(__('I read and agree to Terms & Conditions')); ?></label>
              </div>
            </div>

            <!-- Submit full width -->
            <div class="col-12">
              <div class="d-grid">
                <button type="submit" class="btn btn-success btn-lg" id="registerBtn">
                  <i class="bi bi-person-plus me-2"></i><?php echo e(__('Create Account')); ?>

                </button>
              </div>
            </div>
          </div>
        </form>

        <div class="text-center my-4">
          <hr class="my-3"><span class="bg-white px-3 text-muted"><?php echo e(__('or')); ?></span>
        </div>

        <div class="text-center">
          <p class="mb-2"><?php echo e(__('Already have an account?')); ?></p>
          <a href="<?php echo e(route('site2.login')); ?>" class="btn btn-outline-primary">
            <i class="bi bi-box-arrow-in-right me-2"></i><?php echo e(__('Login')); ?>

          </a>
        </div>
      </div>
    </div>

    <div class="text-center mt-4">
      <h6 class="fw-bold mb-3"><?php echo e(__('Benefits')); ?></h6>
      <div class="row g-3">
        <div class="col-4"><div class="text-center"><i class="bi bi-gift fs-4"></i><p class="small text-muted mb-0"><?php echo e(__('Special Discounts')); ?></p></div></div>
        <div class="col-4"><div class="text-center"><i class="bi bi-truck fs-4"></i><p class="small text-muted mb-0"><?php echo e(__('Free Shipping')); ?></p></div></div>
        <div class="col-4"><div class="text-center"><i class="bi bi-star fs-4"></i><p class="small text-muted mb-0"><?php echo e(__('Quality Products')); ?></p></div></div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function togglePassword(id){
  const i=document.getElementById(id), e=document.getElementById(id+'-eye');
  if(i.type==='password'){ i.type='text'; e.classList.replace('bi-eye','bi-eye-slash'); }
  else{ i.type='password'; e.classList.replace('bi-eye-slash','bi-eye'); }
}

function checkPasswordMatch(){
  const p1=document.getElementById('password').value;
  const p2=document.getElementById('password_confirmation').value;
  const el=document.getElementById('password-match-message');
  if(p2.length>0){
    if(p1===p2){ el.innerHTML='<small class="text-success"><i class="bi bi-check-circle me-1"></i><?php echo e(__("Passwords match")); ?></small>'; return true; }
    el.innerHTML='<small class="text-danger"><i class="bi bi-x-circle me-1"></i><?php echo e(__("Passwords do not match")); ?></small>'; return false;
  }
  el.innerHTML=''; return false;
}

(function(){
  const countrySel=document.getElementById('country_code');
  const citySel=document.getElementById('city_id');
  const urlTpl=countrySel?.getAttribute('data-cities-url-template')||'';
  const OLD={country:<?php echo json_encode(old('country_code'), 15, 512) ?>, city:<?php echo json_encode(old('city_id'), 15, 512) ?>};
  const cache={};

  function url(code){ return urlTpl.replace('XX', encodeURIComponent(code)); }

  function resetCities(){
    citySel.innerHTML='';
    const def=document.createElement('option'); def.value=''; def.textContent='<?php echo e(__("Please Select")); ?>'; citySel.appendChild(def);
    const other=document.createElement('option'); other.value='9999'; other.textContent='<?php echo e(__("Other")); ?>'; citySel.appendChild(other);
  }

  function fill(cities, selected){
    resetCities();
    (cities||[]).forEach(c=>{
      const o=document.createElement('option'); o.value=c.id; o.textContent=c.name;
      if(String(selected||'')===String(c.id)) o.selected=true;
      citySel.insertBefore(o, citySel.querySelector('option[value="9999"]'));
    });
    citySel.disabled=false;
  }

  async function loadCities(code, selected){
    if(!code || code==='9999'){ resetCities(); citySel.disabled=(code!=='9999'); return; }
    if(cache[code]){ fill(cache[code], selected); return; }
    citySel.disabled=true; citySel.innerHTML='<option value=""><?php echo e(__("Loading...")); ?></option>';
    try{
      const res=await fetch(url(code), {headers:{'Accept':'application/json'}});
      if(!res.ok) throw new Error('HTTP '+res.status);
      const data=await res.json();
      cache[code]=data.cities||[];
      fill(cache[code], selected);
    }catch(err){
      console.error(err); resetCities(); citySel.disabled=true;
    }
  }

  countrySel?.addEventListener('change', function(){ loadCities(this.value, null); });

  document.addEventListener('DOMContentLoaded', function(){
    document.getElementById('account_holder').focus();
    document.getElementById('password_confirmation').addEventListener('input', checkPasswordMatch);
    document.getElementById('password').addEventListener('input', function(){
      if(document.getElementById('password_confirmation').value.length>0) checkPasswordMatch();
    });
    if(OLD.country){ loadCities(OLD.country, OLD.city); }
  });
})();

document.getElementById('registerForm').addEventListener('submit', function(e){
  if(!checkPasswordMatch()){ e.preventDefault(); return; }
  const btn=document.getElementById('registerBtn'), t=btn.innerHTML;
  btn.innerHTML='<span class="spinner-border spinner-border-sm me-2"></span><?php echo e(__("Creating account...")); ?>';
  btn.disabled=true; setTimeout(()=>{btn.innerHTML=t; btn.disabled=false;}, 5000);
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('gorevsitesi.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/gorevsitesi/auth/register.blade.php ENDPATH**/ ?>