<?php $__env->startSection('style'); ?>
<link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('assets/plugins/datatable/css/responsive.bootstrap5.min.css')); ?>" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Admin')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/home')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Announcements Management')); ?></li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card stats-card">
                    <div class="card-body text-center">
                        <div class="stats-icon bg-primary">
              <i class='bx bx-megaphone'></i> 
                        </div>
                        <div class="stats-number"><?php echo e($stats['total']); ?></div>
                        <div class="stats-title"><?php echo e(__('Total Announcements')); ?></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card stats-card">
                    <div class="card-body text-center">
                        <div class="stats-icon bg-success">
                            <i class="bx bx-check-circle"></i>
                        </div>
                        <div class="stats-number"><?php echo e($stats['active']); ?></div>
                        <div class="stats-title"><?php echo e(__('Active')); ?></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card stats-card">
                    <div class="card-body text-center">
                        <div class="stats-icon bg-info">
                            <i class="bx bx-globe"></i>
                        </div>
                        <div class="stats-number"><?php echo e($stats['general']); ?></div>
                        <div class="stats-title"><?php echo e(__('General')); ?></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card stats-card">
                    <div class="card-body text-center">
                        <div class="stats-icon bg-warning">
                            <i class="bx bx-user"></i>
                        </div>
                        <div class="stats-number"><?php echo e($stats['user_specific']); ?></div>
                        <div class="stats-title"><?php echo e(__('User Specific')); ?></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card stats-card">
                    <div class="card-body text-center">
                        <div class="stats-icon bg-danger">
                            <i class="bx bx-error"></i>
                        </div>
                        <div class="stats-number"><?php echo e($stats['urgent']); ?></div>
                        <div class="stats-title"><?php echo e(__('Urgent')); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Card -->
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><?php echo e(__('Announcements Management')); ?></h5>
                    <div class="d-flex gap-2">
                        <button class="btn btn-success btn-sm" data-bs-toggle="offcanvas" data-bs-target="#createAnnouncementOffcanvas">
                            <i class="bx bx-plus me-2"></i><?php echo e(__('Create Announcement')); ?>

                        </button>
                        <button class="btn btn-primary btn-sm" onclick="refreshData()">
                            <i class="bx bx-refresh me-2"></i><?php echo e(__('Refresh')); ?>

                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <!-- Filters -->
                <div class="row mb-3">
                    <div class="col-md-3">
                        <select class="form-select form-select-sm" id="typeFilter">
                            <option value=""><?php echo e(__('All Types')); ?></option>
                            <option value="general"><?php echo e(__('General')); ?></option>
                            <option value="user_specific"><?php echo e(__('User Specific')); ?></option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select class="form-select form-select-sm" id="priorityFilter">
                            <option value=""><?php echo e(__('All Priorities')); ?></option>
                            <option value="urgent"><?php echo e(__('Urgent')); ?></option>
                            <option value="high"><?php echo e(__('High')); ?></option>
                            <option value="medium"><?php echo e(__('Medium')); ?></option>
                            <option value="low"><?php echo e(__('Low')); ?></option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select class="form-select form-select-sm" id="statusFilter">
                            <option value=""><?php echo e(__('All Status')); ?></option>
                            <option value="active"><?php echo e(__('Active')); ?></option>
                            <option value="inactive"><?php echo e(__('Inactive')); ?></option>
                            <option value="expired"><?php echo e(__('Expired')); ?></option>
                        </select>
                    </div>
                </div>

                <!-- Desktop Table -->
                <div class="d-none d-lg-block">
                    <div class="table-responsive">
                        <table id="announcementsTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Title')); ?></th>
                                    <th><?php echo e(__('Type')); ?></th>
                                    <th><?php echo e(__('Priority')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Read Stats')); ?></th>
                                    <th><?php echo e(__('Created')); ?></th>
                                    <th><?php echo e(__('Actions')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- DataTable will populate this -->
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Mobile Cards -->
                <div class="d-lg-none">
                    <div class="mobile-header mb-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <h6 class="mb-0"><?php echo e(__('Announcements')); ?></h6>
                            <button class="btn btn-primary btn-sm" onclick="refreshMobileData()">
                                <i class="bx bx-refresh"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Mobile Filters -->
                    <div class="row mb-3">
                        <div class="col-4">
                            <select class="form-select form-select-sm" id="typeFilterMobile">
                                <option value=""><?php echo e(__('All Types')); ?></option>
                                <option value="general"><?php echo e(__('General')); ?></option>
                                <option value="user_specific"><?php echo e(__('User Specific')); ?></option>
                            </select>
                        </div>
                        <div class="col-4">
                            <select class="form-select form-select-sm" id="priorityFilterMobile">
                                <option value=""><?php echo e(__('All Priorities')); ?></option>
                                <option value="urgent"><?php echo e(__('Urgent')); ?></option>
                                <option value="high"><?php echo e(__('High')); ?></option>
                                <option value="medium"><?php echo e(__('Medium')); ?></option>
                                <option value="low"><?php echo e(__('Low')); ?></option>
                            </select>
                        </div>
                        <div class="col-4">
                            <select class="form-select form-select-sm" id="statusFilterMobile">
                                <option value=""><?php echo e(__('All Status')); ?></option>
                                <option value="active"><?php echo e(__('Active')); ?></option>
                                <option value="inactive"><?php echo e(__('Inactive')); ?></option>
                                <option value="expired"><?php echo e(__('Expired')); ?></option>
                            </select>
                        </div>
                    </div>

                    <!-- Mobile Container -->
                    <div id="mobileAnnouncementsContainer">
                        <!-- Mobile cards will be loaded here -->
                    </div>

                    <div class="text-center mt-3">
                        <button class="btn btn-outline-primary" id="loadMoreBtn" onclick="loadMoreMobileData()">
                            <i class="bx bx-loader-alt bx-spin d-none" id="loadMoreSpinner"></i>
                            <?php echo e(__('Load More')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Create Announcement Offcanvas -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="createAnnouncementOffcanvas" aria-labelledby="createAnnouncementOffcanvasLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="createAnnouncementOffcanvasLabel"><?php echo e(__('Create New Announcement')); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <form id="createAnnouncementForm">
            <?php echo csrf_field(); ?>
            
            <!-- Title -->
            <div class="mb-3">
                <label for="createTitle" class="form-label"><?php echo e(__('Title')); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="createTitle" name="title" required maxlength="255">
            </div>

            <!-- Content -->
            <div class="mb-3">
                <label for="createContent" class="form-label"><?php echo e(__('Content')); ?> <span class="text-danger">*</span></label>
                <textarea class="form-control" id="createContent" name="content" rows="4" required maxlength="5000"></textarea>
                <div class="form-text"><?php echo e(__('Remaining characters')); ?>: <span id="createContentCharCount">5000</span></div>
            </div>

            <!-- Type -->
            <div class="mb-3">
                <label for="createType" class="form-label"><?php echo e(__('Type')); ?> <span class="text-danger">*</span></label>
                <select class="form-select" id="createType" name="type" required>
                    <option value=""><?php echo e(__('Select Type')); ?></option>
                    <option value="general"><?php echo e(__('General')); ?></option>
                    <option value="user_specific"><?php echo e(__('User Specific')); ?></option>
                </select>
            </div>

            <!-- Target Users -->
            <div class="mb-3" id="createTargetUsersDiv" style="display: none;">
                <label for="createTargetUsers" class="form-label"><?php echo e(__('Target Users')); ?> <span class="text-danger">*</span></label>
                <select class="form-select" id="createTargetUsers" name="target_users[]" multiple>
                </select>
            </div>

            <!-- Priority -->
            <div class="mb-3">
                <label for="createPriority" class="form-label"><?php echo e(__('Priority')); ?> <span class="text-danger">*</span></label>
                <select class="form-select" id="createPriority" name="priority" required>
                    <option value=""><?php echo e(__('Select Priority')); ?></option>
                    <option value="low"><?php echo e(__('Low')); ?></option>
                    <option value="medium" selected><?php echo e(__('Medium')); ?></option>
                    <option value="high"><?php echo e(__('High')); ?></option>
                    <option value="urgent"><?php echo e(__('Urgent')); ?></option>
                </select>
            </div>

            <!-- Options -->
            <div class="mb-3">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="createShowAsPopup" name="show_as_popup" value="1" checked>
                    <label class="form-check-label" for="createShowAsPopup">
                        <?php echo e(__('Show as popup')); ?>

                    </label>
                </div>
            </div>

            <!-- Expires At -->
            <div class="mb-3">
                <label for="createExpiresAt" class="form-label"><?php echo e(__('Expires At')); ?> <span class="text-muted">(<?php echo e(__('Optional')); ?>)</span></label>
                <input type="datetime-local" class="form-control" id="createExpiresAt" name="expires_at">
            </div>

            <!-- Submit Button -->
            <div class="d-grid">
                <button type="submit" class="btn btn-primary" id="createBtn">
                    <i class="bx bx-plus me-2"></i><?php echo e(__('Create Announcement')); ?>

                    <span class="spinner-border spinner-border-sm ms-2 d-none" id="createSpinner"></span>
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Edit Announcement Offcanvas -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="editAnnouncementOffcanvas" aria-labelledby="editAnnouncementOffcanvasLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="editAnnouncementOffcanvasLabel"><?php echo e(__('Edit Announcement')); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <form id="editAnnouncementForm">
            <?php echo csrf_field(); ?>
            <?php echo method_field('POST'); ?>
            <input type="hidden" id="editAnnouncementId" name="announcement_id">
            
            <!-- Title -->
            <div class="mb-3">
                <label for="editTitle" class="form-label"><?php echo e(__('Title')); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="editTitle" name="title" required maxlength="255">
            </div>

            <!-- Content -->
            <div class="mb-3">
                <label for="editContent" class="form-label"><?php echo e(__('Content')); ?> <span class="text-danger">*</span></label>
                <textarea class="form-control" id="editContent" name="content" rows="4" required maxlength="5000"></textarea>
                <div class="form-text"><?php echo e(__('Remaining characters')); ?>: <span id="editContentCharCount">5000</span></div>
            </div>

            <!-- Type -->
            <div class="mb-3">
                <label for="editType" class="form-label"><?php echo e(__('Type')); ?> <span class="text-danger">*</span></label>
                <select class="form-select" id="editType" name="type" required>
                    <option value="general"><?php echo e(__('General')); ?></option>
                    <option value="user_specific"><?php echo e(__('User Specific')); ?></option>
                </select>
            </div>

            <!-- Target Users -->
            <div class="mb-3" id="editTargetUsersDiv" style="display: none;">
                <label for="editTargetUsers" class="form-label"><?php echo e(__('Target Users')); ?> <span class="text-danger">*</span></label>
                <select class="form-select" id="editTargetUsers" name="target_users[]" multiple>
                </select>
            </div>

            <!-- Priority -->
            <div class="mb-3">
                <label for="editPriority" class="form-label"><?php echo e(__('Priority')); ?> <span class="text-danger">*</span></label>
                <select class="form-select" id="editPriority" name="priority" required>
                    <option value="low"><?php echo e(__('Low')); ?></option>
                    <option value="medium"><?php echo e(__('Medium')); ?></option>
                    <option value="high"><?php echo e(__('High')); ?></option>
                    <option value="urgent"><?php echo e(__('Urgent')); ?></option>
                </select>
            </div>

            <!-- Status -->
            <div class="mb-3">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="editIsActive" name="is_active" value="1">
                    <label class="form-check-label" for="editIsActive">
                        <?php echo e(__('Active')); ?>

                    </label>
                </div>
            </div>

            <!-- Options -->
            <div class="mb-3">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="editShowAsPopup" name="show_as_popup" value="1">
                    <label class="form-check-label" for="editShowAsPopup">
                        <?php echo e(__('Show as popup')); ?>

                    </label>
                </div>
            </div>

            <!-- Expires At -->
            <div class="mb-3">
                <label for="editExpiresAt" class="form-label"><?php echo e(__('Expires At')); ?> <span class="text-muted">(<?php echo e(__('Optional')); ?>)</span></label>
                <input type="datetime-local" class="form-control" id="editExpiresAt" name="expires_at">
            </div>

            <!-- Submit Button -->
            <div class="d-grid">
                <button type="submit" class="btn btn-warning" id="editBtn">
                    <i class="bx bx-edit me-2"></i><?php echo e(__('Update Announcement')); ?>

                    <span class="spinner-border spinner-border-sm ms-2 d-none" id="editSpinner"></span>
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/responsive.bootstrap5.min.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
let announcementsTable;
let mobileCurrentPage = 0;
let mobileHasMore = true;

$(document).ready(function() {
    // Initialize DataTable
    announcementsTable = $('#announcementsTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '/api/admin/announcements-datatable',
            type: 'GET',
            data: function(d) {
                d.type = $('#typeFilter').val();
                d.priority = $('#priorityFilter').val();
                d.status = $('#statusFilter').val();
            },
            error: function(xhr, error, thrown) {
                Lobibox.notify('error', {
                    title: '<?php echo e(__('Error')); ?>',
                    msg: '<?php echo e(__('Error loading data')); ?>: ' + xhr.status,
                    sound: false
                });
            }
        },
        columns: [
            { 
                data: 'title', 
                name: 'title',
                render: function(data, type, row) {
                    return `
                        <div>
                            <strong>${data}</strong>
                            <br>
                            <small class="text-muted">${row.content_preview}</small>
                        </div>
                    `;
                }
            },
            { 
                data: 'type_text', 
                name: 'type',
                render: function(data) {
                    return `<span class="badge bg-secondary">${data}</span>`;
                }
            },
            { 
                data: 'priority_text', 
                name: 'priority',
                render: function(data, type, row) {
                    return `<span class="badge bg-${row.priority_badge}">${data}</span>`;
                }
            },
            { 
                data: 'status_text', 
                name: 'status',
                render: function(data, type, row) {
                    return `<span class="badge bg-${row.status_badge}">${data}</span>`;
                }
            },
            { 
                data: 'read_count', 
                name: 'read_stats',
                orderable: false,
                render: function(data, type, row) {
                    if (row.type === 'user_specific') {
                        const percentage = row.target_users_count > 0 ? Math.round((data / row.target_users_count) * 100) : 0;
                        return `
                            <div class="text-center">
                                <span class="badge bg-success">${data} <?php echo e(__('Read')); ?></span>
                                <br>
                                <small class="text-muted">${data}/${row.target_users_count} (${percentage}%)</small>
                            </div>
                        `;
                    } else {
                        return `
                            <div class="text-center">
                                <span class="badge bg-info">${data} <?php echo e(__('Read')); ?></span>
                                <br>
                                <small class="text-muted"><?php echo e(__('General')); ?></small>
                            </div>
                        `;
                    }
                }
            },
            { 
                data: 'created_at', 
                name: 'created_at'
            },
            { 
                data: 'id', 
                name: 'actions',
                orderable: false,
                searchable: false,
                width: '200px',
                render: function(data, type, row) {
                    const priorityColor = row.priority === 'urgent' ? 'danger' : 
                                        row.priority === 'high' ? 'warning' : 'primary';
                    
                    return `
                        <div class="d-flex gap-1 flex-wrap">
                            <a href="/announcements/${data}" class="btn btn-sm btn-${priorityColor}" title="<?php echo e(__('View Details')); ?>">
                                <i class="bx bx-show me-1"></i><?php echo e(__('View')); ?>

                            </a>
                            <button class="btn btn-sm btn-warning" onclick="editAnnouncement(${data})" title="<?php echo e(__('Edit Announcement')); ?>">
                                <i class="bx bx-edit me-1"></i><?php echo e(__('Edit')); ?>

                            </button>
                            <button class="btn btn-sm btn-danger" onclick="deleteAnnouncement(${data})" title="<?php echo e(__('Delete Announcement')); ?>">
                                <i class="bx bx-trash me-1"></i><?php echo e(__('Delete')); ?>

                            </button>
                        </div>
                    `;
                }
            }
        ],
        order: [[5, 'desc']], // Order by created_at column
        pageLength: 25,
        responsive: true,
        columnDefs: [
            {
                targets: -1, // Actions column
                className: 'text-center'
            }
        ],
        language: {
            processing: "<?php echo e(__('Processing...')); ?>",
            search: "<?php echo e(__('Search:')); ?>",
            lengthMenu: "<?php echo e(__('Show _MENU_ entries')); ?>",
            info: "<?php echo e(__('Showing _START_ to _END_ of _TOTAL_ entries')); ?>",
            infoEmpty: "<?php echo e(__('Showing 0 to 0 of 0 entries')); ?>",
            infoFiltered: "<?php echo e(__('(filtered from _MAX_ total entries)')); ?>",
            paginate: {
                first: "<?php echo e(__('First')); ?>",
                last: "<?php echo e(__('Last')); ?>",
                next: "<?php echo e(__('Next')); ?>",
                previous: "<?php echo e(__('Previous')); ?>"
            }
        }
    });

    // Filter change handlers
    $('#typeFilter, #priorityFilter, #statusFilter').on('change', function() {
        announcementsTable.ajax.reload();
    });

    // Mobile initialization
    if (window.innerWidth < 992) {
        loadMobileData();
    }

    // Mobile filters
    $('#typeFilterMobile, #priorityFilterMobile, #statusFilterMobile').on('change', function() {
        mobileCurrentPage = 0;
        mobileHasMore = true;
        loadMobileData(true);
    });

    // Initialize offcanvas events
    initializeOffcanvasEvents();
});

function loadMobileData(reset = false) {
    if (reset) {
        $('#mobileAnnouncementsContainer').empty();
        mobileCurrentPage = 0;
    }

    $('#loadMoreSpinner').removeClass('d-none');
    $('#loadMoreBtn').prop('disabled', true);

    const type = $('#typeFilterMobile').val();
    const priority = $('#priorityFilterMobile').val();
    const status = $('#statusFilterMobile').val();

    $.ajax({
        url: '/api/admin/announcements-datatable',
        method: 'GET',
        data: {
            start: mobileCurrentPage * 10,
            length: 10,
            type: type,
            priority: priority,
            status: status
        },
        success: function(response) {
            if (response.data && response.data.length > 0) {
                response.data.forEach(function(announcement) {
                    const card = createMobileAnnouncementCard(announcement);
                    $('#mobileAnnouncementsContainer').append(card);
                });
                mobileCurrentPage++;
                mobileHasMore = response.data.length === 10;
            } else {
                mobileHasMore = false;
                if (mobileCurrentPage === 0) {
                    $('#mobileAnnouncementsContainer').html(`
                        <div class="text-center py-5">
                            <i class="bx bx-bullhorn display-1 text-muted"></i>
                            <h6 class="mt-3"><?php echo e(__('No announcements found')); ?></h6>
                        </div>
                    `);
                }
            }
            
            $('#loadMoreBtn').toggle(mobileHasMore);
        },
        error: function() {
            Lobibox.notify('error', {
                title: '<?php echo e(__('Error')); ?>',
                msg: '<?php echo e(__('Error loading mobile data')); ?>',
                sound: false
            });
        },
        complete: function() {
            $('#loadMoreSpinner').addClass('d-none');
            $('#loadMoreBtn').prop('disabled', false);
        }
    });
}

function createMobileAnnouncementCard(announcement) {
    const priorityColor = announcement.priority === 'urgent' ? 'danger' : 
                         announcement.priority === 'high' ? 'warning' : 'primary';
    
    return `
        <div class="card mb-3 announcement-mobile-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start mb-2">
                    <h6 class="card-title mb-0">${announcement.title}</h6>
                    <span class="badge bg-${announcement.priority_badge}">${announcement.priority_text}</span>
                </div>
                
                <p class="card-text text-muted small">${announcement.content_preview}</p>
                
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <span class="badge bg-secondary me-1">${announcement.type_text}</span>
                        <span class="badge bg-${announcement.status_badge}">${announcement.status_text}</span>
                    </div>
                    <small class="text-muted">${announcement.created_at}</small>
                </div>
                
                <div class="d-grid gap-2">
                    <div class="d-flex gap-2">
                        <a href="/announcements/${announcement.id}" class="btn btn-${priorityColor} flex-fill">
                            <i class="bx bx-show me-1"></i><?php echo e(__('View Details')); ?>

                        </a>
                        <button class="btn btn-warning flex-fill" onclick="editAnnouncement(${announcement.id})">
                            <i class="bx bx-edit me-1"></i><?php echo e(__('Edit')); ?>

                        </button>
                    </div>
                    <button class="btn btn-danger btn-sm" onclick="deleteAnnouncement(${announcement.id})">
                        <i class="bx bx-trash me-1"></i><?php echo e(__('Delete Announcement')); ?>

                    </button>
                </div>
            </div>
        </div>
    `;
}

function loadMoreMobileData() {
    if (mobileHasMore) {
        loadMobileData();
    }
}

function refreshData() {
    if (window.innerWidth >= 992) {
        announcementsTable.ajax.reload();
    } else {
        refreshMobileData();
    }
    
    Lobibox.notify('info', {
        title: '<?php echo e(__('Info')); ?>',
        msg: '<?php echo e(__('Data refreshed successfully')); ?>',
        sound: false
    });
}

function refreshMobileData() {
    mobileCurrentPage = 0;
    mobileHasMore = true;
    loadMobileData(true);
}

function initializeOffcanvasEvents() {
    // Create offcanvas events
    $('#createAnnouncementOffcanvas').on('shown.bs.offcanvas', function() {
        initializeCreateForm();
    });

    // Edit offcanvas events  
    $('#editAnnouncementOffcanvas').on('shown.bs.offcanvas', function() {
        initializeEditForm();
    });
}

function initializeCreateForm() {
    // Character counter
    $('#createContent').on('input', function() {
        const remaining = 5000 - $(this).val().length;
        $('#createContentCharCount').text(remaining);
        
        if (remaining < 100) {
            $('#createContentCharCount').addClass('text-danger');
        } else {
            $('#createContentCharCount').removeClass('text-danger');
        }
    });

    // Type change handler
    $('#createType').on('change', function() {
        if ($(this).val() === 'user_specific') {
            $('#createTargetUsersDiv').show();
            $('#createTargetUsers').prop('required', true);
            initializeUserSelect('#createTargetUsers');
        } else {
            $('#createTargetUsersDiv').hide();
            $('#createTargetUsers').prop('required', false);
        }
    });

    // Form submission
    $('#createAnnouncementForm').off('submit').on('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        
        $('#createBtn').prop('disabled', true);
        $('#createSpinner').removeClass('d-none');
        
        $.ajax({
            url: '/admin/announcements',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    Lobibox.notify('success', {
                        title: '<?php echo e(__('Success')); ?>',
                        msg: response.message,
                        sound: false
                    });
                    
                    $('#createAnnouncementOffcanvas').offcanvas('hide');
                    $('#createAnnouncementForm')[0].reset();
                    $('#createTargetUsersDiv').hide();
                    $('#createContentCharCount').text('5000').removeClass('text-danger');
                    
                    refreshData();
                } else {
                    Lobibox.notify('error', {
                        title: '<?php echo e(__('Error')); ?>',
                        msg: response.message,
                        sound: false
                    });
                }
            },
            error: function(xhr) {
                handleFormError(xhr);
            },
            complete: function() {
                $('#createBtn').prop('disabled', false);
                $('#createSpinner').addClass('d-none');
            }
        });
    });
}

function initializeEditForm() {
    // Character counter
    $('#editContent').on('input', function() {
        const remaining = 5000 - $(this).val().length;
        $('#editContentCharCount').text(remaining);
        
        if (remaining < 100) {
            $('#editContentCharCount').addClass('text-danger');
        } else {
            $('#editContentCharCount').removeClass('text-danger');
        }
    });

    // Type change handler
    $('#editType').on('change', function() {
        if ($(this).val() === 'user_specific') {
            $('#editTargetUsersDiv').show();
            $('#editTargetUsers').prop('required', true);
            initializeUserSelect('#editTargetUsers');
        } else {
            $('#editTargetUsersDiv').hide();
            $('#editTargetUsers').prop('required', false);
        }
    });

    // Form submission
    $('#editAnnouncementForm').off('submit').on('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const announcementId = $('#editAnnouncementId').val();
        
        $('#editBtn').prop('disabled', true);
        $('#editSpinner').removeClass('d-none');
        
        $.ajax({
            url: `/admin/announcements/${announcementId}`,
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    Lobibox.notify('success', {
                        title: '<?php echo e(__('Success')); ?>',
                        msg: response.message,
                        sound: false
                    });
                    
                    $('#editAnnouncementOffcanvas').offcanvas('hide');
                    refreshData();
                } else {
                    Lobibox.notify('error', {
                        title: '<?php echo e(__('Error')); ?>',
                        msg: response.message,
                        sound: false
                    });
                }
            },
            error: function(xhr) {
                handleFormError(xhr);
            },
            complete: function() {
                $('#editBtn').prop('disabled', false);
                $('#editSpinner').addClass('d-none');
            }
        });
    });
}

function initializeUserSelect(selector) {
    if (!$(selector).hasClass('select2-hidden-accessible')) {
        $(selector).select2({
            theme: 'bootstrap-5',
            ajax: {
                url: '/api/users/search',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        q: params.term,
                        page: params.page
                    };
                },
                processResults: function (data, params) {
                    params.page = params.page || 1;
                    return {
                        results: data.data.map(function(user) {
                            return {
                                id: user.id,
                                text: user.account_holder + ' (' + user.email + ')'
                            };
                        }),
                        pagination: {
                            more: data.has_more
                        }
                    };
                },
                cache: true
            },
            placeholder: '<?php echo e(__('Search users...')); ?>',
            minimumInputLength: 2,
            dropdownParent: $(selector).closest('.offcanvas')
        });
    }
}

function editAnnouncement(id) {
    // Load announcement data
    $.ajax({
        url: `/admin/announcements/${id}/edit`,
        method: 'GET',
        success: function(response) {
            if (response.success) {
                const announcement = response.announcement;
                
                // Fill form fields
                $('#editAnnouncementId').val(announcement.id);
                $('#editTitle').val(announcement.title);
                $('#editContent').val(announcement.content);
                $('#editType').val(announcement.type);
                $('#editPriority').val(announcement.priority);
                $('#editIsActive').prop('checked', announcement.is_active);
                $('#editShowAsPopup').prop('checked', announcement.show_as_popup);
                
                if (announcement.expires_at) {
                    $('#editExpiresAt').val(announcement.expires_at);
                }
                
                // Handle target users
                if (announcement.type === 'user_specific') {
                    $('#editTargetUsersDiv').show();
                    $('#editTargetUsers').prop('required', true);
                    
                    // Set selected users
                    if (announcement.target_users && announcement.target_users.length > 0) {
                        announcement.target_users.forEach(function(user) {
                            const option = new Option(user.account_holder + ' (' + user.email + ')', user.id, true, true);
                            $('#editTargetUsers').append(option);
                        });
                    }
                } else {
                    $('#editTargetUsersDiv').hide();
                    $('#editTargetUsers').prop('required', false);
                }
                
                // Update character count
                const remaining = 5000 - announcement.content.length;
                $('#editContentCharCount').text(remaining);
                
                // Show offcanvas
                $('#editAnnouncementOffcanvas').offcanvas('show');
            }
        },
        error: function() {
            Lobibox.notify('error', {
                title: '<?php echo e(__('Error')); ?>',
                msg: '<?php echo e(__('Error loading announcement data')); ?>',
                sound: false
            });
        }
    });
}
function deleteAnnouncement(id) {
    Swal.fire({
        title: '<?php echo e(__('Are you sure?')); ?>',
        text: '<?php echo e(__('This announcement will be deleted permanently!')); ?>',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: '<?php echo e(__('Yes, delete it!')); ?>',
        cancelButtonText: '<?php echo e(__('Cancel')); ?>',
        confirmButtonColor: '#dc3545'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/admin/announcements/${id}`,
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Lobibox.notify('success', {
                            title: '<?php echo e(__('Success')); ?>',
                            msg: response.message,
                            sound: false
                        });
                        refreshData();
                    }
                },
                error: function() {
                    Lobibox.notify('error', {
                        title: '<?php echo e(__('Error')); ?>',
                        msg: '<?php echo e(__('Error deleting announcement')); ?>',
                        sound: false
                    });
                }
            });
        }
    });
}

function handleFormError(xhr) {
    if (xhr.status === 422) {
        const errors = xhr.responseJSON?.errors;
        let errorMsg = '<?php echo e(__('Please check your input and try again.')); ?>';
        if (errors) {
            const firstError = Object.values(errors)[0];
            if (firstError && firstError[0]) {
                errorMsg = firstError[0];
            }
        }
        Lobibox.notify('error', {
            title: '<?php echo e(__('Validation Error')); ?>',
            msg: errorMsg,
            sound: false
        });
    } else {
        Lobibox.notify('error', {
            title: '<?php echo e(__('Error')); ?>',
            msg: '<?php echo e(__('Error processing request')); ?>',
            sound: false
        });
    }
}
</script>
<?php $__env->stopSection(); ?>

<style>
.stats-card {
    transition: transform 0.2s ease;
}

.stats-card:hover {
    transform: translateY(-2px);
}

.stats-icon {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 10px;
    color: white;
    font-size: 1.5rem;
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 5px;
}

.stats-title {
    font-size: 0.9rem;
    color: #6c757d;
    font-weight: 500;
}

@media (max-width: 768px) {
    .stats-card {
        margin-bottom: 1rem;
    }
}
</style>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/announcements/admin/index.blade.php ENDPATH**/ ?>