<?php $__env->startSection('style'); ?>
<style>
.messages-container {
    max-height: 600px;
    overflow-y: auto;
    padding: 1rem;
}

.message-item {
    margin-bottom: 1.5rem;
    padding: 1rem;
    border-radius: 12px;
    border: 1px solid #e9ecef;
}

.message-item.own-message {
    background-color: #e3f2fd;
    border-color: #2196f3;
    margin-left: 2rem;
}

.message-item.other-message {
    background-color: #f8f9fa;
    margin-right: 2rem;
}

.message-item.internal-message {
    background-color: #fff3cd;
    border-color: #ffc107;
}

.message-header {
    margin-bottom: 0.75rem;
}

.message-author {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.author-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    font-size: 1.1rem;
}

.author-name {
    font-weight: 600;
    color: #2c3e50;
}

.message-time {
    font-size: 0.85rem;
    color: #6c757d;
}

.message-content {
    line-height: 1.6;
    color: #2c3e50;
}

.message-attachments {
    background-color: rgba(0,0,0,0.05);
    padding: 0.75rem;
    border-radius: 8px;
}

.attachment-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin-bottom: 0.5rem;
}

.attachment-item:last-child {
    margin-bottom: 0;
}

.attachment-link {
    color: #007bff;
    text-decoration: none;
}

.attachment-link:hover {
    text-decoration: underline;
}

.attachment-size {
    font-size: 0.85rem;
    color: #6c757d;
}

.info-item {
    margin-bottom: 1rem;
    padding-bottom: 0.75rem;
    border-bottom: 1px solid #f1f3f4;
}

.info-item:last-child {
    margin-bottom: 0;
    border-bottom: none;
}

.file-preview-item {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 8px 12px;
    background-color: #f8f9fa;
    border-radius: 6px;
    margin-bottom: 8px;
}

@media (max-width: 768px) {
    .message-item.own-message {
        margin-left: 0.5rem;
    }
    
    .message-item.other-message {
        margin-right: 0.5rem;
    }
    
    .messages-container {
        max-height: 400px;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Support')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/home')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('tickets.index')); ?>"><?php echo e(__('Support Tickets')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($ticket->ticket_number); ?></li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="row">
            <!-- Ticket Details -->
            <div class="col-lg-8">
                <!-- Ticket Header -->
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start mb-3">
                            <div>
                                <h5 class="mb-1"><?php echo e($ticket->subject); ?></h5>
                                <div class="text-muted">
                                    <strong><?php echo e($ticket->ticket_number); ?></strong> • 
                                    <?php echo e(__('Created')); ?> <?php echo e($ticket->created_at->format('d.m.Y H:i')); ?>

                                </div>
                            </div>
                            <div class="text-end">
                                <span class="badge bg-<?php echo e($ticket->status_badge); ?> mb-1"><?php echo e($ticket->status_text); ?></span><br>
                                <span class="badge bg-<?php echo e($ticket->priority_badge); ?>"><?php echo e($ticket->priority_text); ?></span>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <small class="text-muted"><?php echo e(__('Category')); ?></small><br>
                                <span class="badge bg-secondary"><?php echo e($ticket->category_text); ?></span>
                            </div>
                            <div class="col-md-6">
                                <small class="text-muted"><?php echo e(__('Last Activity')); ?></small><br>
                                <span><?php echo e($ticket->last_activity_at->diffForHumans()); ?></span>
                            </div>
                        </div>

                        <?php if($ticket->assignedTo): ?>
                        <div class="mt-3">
                            <small class="text-muted"><?php echo e(__('Assigned To')); ?></small><br>
                            <span><?php echo e($ticket->assignedTo->account_holder ?? $ticket->assignedTo->name); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Messages -->
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0"><?php echo e(__('Messages')); ?> (<?php echo e($ticket->messages->count()); ?>)</h6>
                    </div>
                    <div class="card-body p-0">
                        <div id="messagesContainer" class="messages-container">
                            <?php $__currentLoopData = $ticket->messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!$message->is_internal || auth()->user()->user_type == 1): ?>
                                <div class="message-item <?php echo e($message->user_id == auth()->id() ? 'own-message' : 'other-message'); ?> <?php echo e($message->is_internal ? 'internal-message' : ''); ?>">
                                    <div class="message-header">
                                        <div class="message-author">
                                            <div class="author-avatar">
                                                <?php echo e(substr($message->user->account_holder ?? $message->user->name, 0, 1)); ?>

                                            </div>
                                            <div class="author-info">
                                                <div class="author-name">
                                                    <?php echo e($message->user->account_holder ?? $message->user->name); ?>

                                                    <?php if($message->user->user_type == 1): ?>
                                                        <span class="badge bg-primary ms-2"><?php echo e(__('Admin')); ?></span>
                                                    <?php endif; ?>
                                                    <?php if($message->is_internal): ?>
                                                        <span class="badge bg-warning ms-2"><?php echo e(__('Internal Note')); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="message-time"><?php echo e($message->created_at->format('d.m.Y H:i')); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="message-content">
                                        <?php echo $message->formatted_message; ?>

                                        
                                        <?php if($message->hasAttachments()): ?>
                                        <div class="message-attachments mt-3">
                                            <h6 class="mb-2"><?php echo e(__('Attachments')); ?> (<?php echo e($message->getAttachmentCount()); ?>)</h6>
                                            <?php $__currentLoopData = $message->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="attachment-item">
                                                <i class="bx bx-file me-2"></i>
                                                <a href="<?php echo e(Storage::url($attachment['path'])); ?>" target="_blank" class="attachment-link">
                                                    <?php echo e($attachment['name']); ?>

                                                </a>
                                                <span class="attachment-size">(<?php echo e($attachment['size'] < 1024 ? $attachment['size'] . ' B' : 
                                                    ($attachment['size'] < 1048576 ? number_format($attachment['size'] / 1024, 2) . ' KB' : 
                                                    number_format($attachment['size'] / 1048576, 2) . ' MB')); ?>)</span>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

                <!-- Reply Form -->
                <?php if(in_array($ticket->status, ['open', 'in_progress', 'waiting_user', 'waiting_admin'])): ?>
                <div class="card mt-3">
                    <div class="card-header">
                        <h6 class="mb-0"><?php echo e(__('Send Reply')); ?></h6>
                    </div>
                    <div class="card-body">
                        <form id="replyForm" enctype="multipart/form-data" action="javascript:void(0)">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <textarea class="form-control" id="replyMessage" name="message" rows="4" placeholder="<?php echo e(__('Type your message here...')); ?>" required maxlength="5000"></textarea>
                                <div class="form-text"><?php echo e(__('Remaining characters')); ?>: <span id="replyCharCount">5000</span></div>
                                <div class="invalid-feedback"></div>
                            </div>

                            <div class="mb-3">
                                <label for="replyAttachments" class="form-label"><?php echo e(__('Attachments')); ?> <span class="text-muted">(<?php echo e(__('Optional')); ?>)</span></label>
                                <input type="file" class="form-control" id="replyAttachments" name="attachments[]" multiple accept=".jpg,.jpeg,.png,.pdf,.doc,.docx,.txt">
                                <div class="form-text"><?php echo e(__('Max file size: 10MB')); ?> | <?php echo e(__('Allowed formats: JPG, PNG, PDF, DOC, TXT')); ?></div>
                                <div id="replyFilePreview" class="mt-2"></div>
                            </div>

                            <?php if(auth()->user()->user_type == 1): ?>
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="isInternal" name="is_internal" value="1">
                                    <label class="form-check-label" for="isInternal">
                                        <?php echo e(__('Internal Note')); ?> <small class="text-muted">(<?php echo e(__('Only visible to admins')); ?>)</small>
                                    </label>
                                </div>
                            </div>
                            <?php endif; ?>

                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary" id="replyBtn">
                                    <i class="bx bx-send me-2"></i><?php echo e(__('Send Reply')); ?>

                                    <span class="spinner-border spinner-border-sm ms-2 d-none" id="replySpinner"></span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
                <?php else: ?>
                <div class="card mt-3">
                    <div class="card-body text-center">
                        <i class="bx bx-lock display-4 text-muted"></i>
                        <h6 class="mt-2"><?php echo e(__('Ticket is Closed')); ?></h6>
                        <p class="text-muted"><?php echo e(__('This ticket has been closed and no longer accepts replies.')); ?></p>
                        <?php if($ticket->status == 'resolved' && auth()->user()->user_type != 1): ?>
                        <button class="btn btn-outline-primary" onclick="reopenTicket()">
                            <i class="bx bx-refresh me-2"></i><?php echo e(__('Reopen Ticket')); ?>

                        </button>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <?php if(auth()->user()->user_type == 1): ?>
                <!-- Admin Actions -->
                <div class="card mb-3">
                    <div class="card-header">
                        <h6 class="mb-0"><?php echo e(__('Admin Actions')); ?></h6>
                    </div>
                    <div class="card-body">
                        <!-- Status Update -->
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Update Status')); ?></label>
                            <select class="form-select" id="statusUpdate">
                                <option value="open" <?php echo e($ticket->status == 'open' ? 'selected' : ''); ?>><?php echo e(__('Open')); ?></option>
                                <option value="in_progress" <?php echo e($ticket->status == 'in_progress' ? 'selected' : ''); ?>><?php echo e(__('In Progress')); ?></option>
                                <option value="waiting_user" <?php echo e($ticket->status == 'waiting_user' ? 'selected' : ''); ?>><?php echo e(__('Waiting for User')); ?></option>
                                <option value="waiting_admin" <?php echo e($ticket->status == 'waiting_admin' ? 'selected' : ''); ?>><?php echo e(__('Waiting for Admin')); ?></option>
                                <option value="resolved" <?php echo e($ticket->status == 'resolved' ? 'selected' : ''); ?>><?php echo e(__('Resolved')); ?></option>
                                <option value="closed" <?php echo e($ticket->status == 'closed' ? 'selected' : ''); ?>><?php echo e(__('Closed')); ?></option>
                            </select>
                        </div>

                        <!-- Assignment -->
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Assign To')); ?></label>
                            <select class="form-select" id="assignTicket">
                                <option value=""><?php echo e(__('Unassigned')); ?></option>
                                <option value="<?php echo e(auth()->id()); ?>" <?php echo e($ticket->assigned_to == auth()->id() ? 'selected' : ''); ?>><?php echo e(__('Assign to Me')); ?></option>
                                <!-- Add other admin users here -->
                            </select>
                        </div>

                        <div class="d-grid gap-2">
                            <button class="btn btn-success" onclick="updateTicketStatus()">
                                <i class="bx bx-check me-2"></i><?php echo e(__('Update Status')); ?>

                            </button>
                            <button class="btn btn-info" onclick="assignTicket()">
                                <i class="bx bx-user me-2"></i><?php echo e(__('Update Assignment')); ?>

                            </button>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Ticket Info -->
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0"><?php echo e(__('Ticket Information')); ?></h6>
                    </div>
                    <div class="card-body">
                        <div class="info-item">
                            <small class="text-muted"><?php echo e(__('Ticket Number')); ?></small>
                            <div><?php echo e($ticket->ticket_number); ?></div>
                        </div>
                        <div class="info-item">
                            <small class="text-muted"><?php echo e(__('Created By')); ?></small>
                            <div><?php echo e($ticket->user->account_holder ?? $ticket->user->name); ?></div>
                        </div>
                        <div class="info-item">
                            <small class="text-muted"><?php echo e(__('Created Date')); ?></small>
                            <div><?php echo e($ticket->created_at->format('d.m.Y H:i')); ?></div>
                        </div>
                        <div class="info-item">
                            <small class="text-muted"><?php echo e(__('Last Activity')); ?></small>
                            <div><?php echo e($ticket->last_activity_at->format('d.m.Y H:i')); ?></div>
                        </div>
                        <?php if($ticket->resolved_at): ?>
                        <div class="info-item">
                            <small class="text-muted"><?php echo e(__('Resolved Date')); ?></small>
                            <div><?php echo e($ticket->resolved_at->format('d.m.Y H:i')); ?></div>
                        </div>
                        <?php endif; ?>
                        <?php if($ticket->closed_at): ?>
                        <div class="info-item">
                            <small class="text-muted"><?php echo e(__('Closed Date')); ?></small>
                            <div><?php echo e($ticket->closed_at->format('d.m.Y H:i')); ?></div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('script'); ?>
<script>
$(document).ready(function() {
    // Character counter for reply
    $('#replyMessage').on('input', function() {
        const remaining = 5000 - $(this).val().length;
        $('#replyCharCount').text(remaining);
        
        if (remaining < 100) {
            $('#replyCharCount').addClass('text-danger');
        } else {
            $('#replyCharCount').removeClass('text-danger');
        }
    });

    // File upload handling for reply
    $('#replyAttachments').on('change', function() {
        const files = this.files;
        const preview = $('#replyFilePreview');
        preview.empty();

        Array.from(files).forEach((file, index) => {
            if (file.size > 10 * 1024 * 1024) {
                Lobibox.notify('error', {
                    title: '<?php echo e(__('Error')); ?>',
                    msg: `File "${file.name}" is too large. Maximum size is 10MB.`,
                    sound: false
                });
                return;
            }

            const fileItem = createFilePreview(file, index);
            preview.append(fileItem);
        });
    });

    // Reply button click handler
    $('#replyBtn').on('click', function(e) {
        e.preventDefault();
        submitReplyForm();
        return false;
    });
    
    function submitReplyForm() {
        const form = $('#replyForm')[0];
        const formData = new FormData(form);
        
        $('#replyBtn').prop('disabled', true);
        $('#replySpinner').removeClass('d-none');

        $.ajax({
            url: '<?php echo e(route('tickets.message', $ticket->id)); ?>',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'X-Requested-With': 'XMLHttpRequest'
            },
            success: function(response) {
                if (response.success) {
                    Lobibox.notify('success', {
                        title: '<?php echo e(__('Success')); ?>',
                        msg: response.message,
                        sound: false
                    });
                    
                    // Add new message to container
                    const messageHtml = createMessageHtml(response.message_data);
                    $('#messagesContainer').append(messageHtml);
                    
                    // Update message count in header
                    const currentCount = parseInt($('.card-header h6').text().match(/\((\d+)\)/)[1]);
                    $('.card-header h6').text('<?php echo e(__('Messages')); ?> (' + (currentCount + 1) + ')');
                    
                    // Clear form
                    $('#replyForm')[0].reset();
                    $('#replyFilePreview').empty();
                    $('#replyCharCount').text('5000').removeClass('text-danger');
                    
                    // Scroll to bottom
                    $('.messages-container').scrollTop($('.messages-container')[0].scrollHeight);
                } else {
                    Lobibox.notify('error', {
                        title: '<?php echo e(__('Error')); ?>',
                        msg: response.message
                    });
                }
            },
            error: function(xhr, status, error) {
                console.log('Ajax error:', xhr, status, error);
                console.log('Response text:', xhr.responseText);
                
                if (xhr.status === 422) {
                    const errors = xhr.responseJSON?.errors;
                    let errorMsg = '<?php echo e(__('Please check your input and try again.')); ?>';
                    if (errors && errors.message) {
                        errorMsg = errors.message[0];
                    }
                    Lobibox.notify('error', {
                        title: '<?php echo e(__('Validation Error')); ?>',
                        msg: errorMsg,
                        sound: false
                    });
                } else {
                    Lobibox.notify('error', {
                        title: '<?php echo e(__('Error')); ?>',
                        msg: '<?php echo e(__('Error sending message')); ?> (Status: ' + xhr.status + ')',
                        sound: false
                    });
                }
            },
            complete: function() {
                $('#replyBtn').prop('disabled', false);
                $('#replySpinner').addClass('d-none');
            }
        });
    }

    // Auto-scroll to bottom of messages
    $('.messages-container').scrollTop($('.messages-container')[0].scrollHeight);
});

function createMessageHtml(messageData) {
    const currentUserType = <?php echo e(auth()->user()->user_type); ?>;
    const isOwnMessage = messageData.user_type == currentUserType || (currentUserType != 1 && messageData.user_type != 1);
    const messageClass = isOwnMessage ? 'own-message' : 'other-message';
    const internalClass = messageData.is_internal ? 'internal-message' : '';
    
    let adminBadge = '';
    if (messageData.user_type == 1) {
        adminBadge = '<span class="badge bg-primary ms-2"><?php echo e(__('Admin')); ?></span>';
    }
    
    let internalBadge = '';
    if (messageData.is_internal) {
        internalBadge = '<span class="badge bg-warning ms-2"><?php echo e(__('Internal Note')); ?></span>';
    }
    
    return `
        <div class="message-item ${messageClass} ${internalClass}">
            <div class="message-header">
                <div class="message-author">
                    <div class="author-avatar">
                        ${messageData.user_name.charAt(0).toUpperCase()}
                    </div>
                    <div class="author-info">
                        <div class="author-name">
                            ${messageData.user_name}
                            ${adminBadge}
                            ${internalBadge}
                        </div>
                        <div class="message-time">${messageData.created_at}</div>
                    </div>
                </div>
            </div>
            <div class="message-content">
                ${messageData.message}
            </div>
        </div>
    `;
}

function updateTicketStatus() {
    const status = $('#statusUpdate').val();
    
    Swal.fire({
        title: '<?php echo e(__('Update Status')); ?>',
        input: 'textarea',
        inputLabel: '<?php echo e(__('Add a note (optional):')); ?>',
        inputPlaceholder: '<?php echo e(__('Enter your note here...')); ?>',
        showCancelButton: true,
        confirmButtonText: '<?php echo e(__('Update Status')); ?>',
        cancelButtonText: '<?php echo e(__('Cancel')); ?>',
        confirmButtonColor: '#007bff'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: '<?php echo e(route('admin.tickets.status', $ticket->id)); ?>',
                method: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    status: status,
                    note: result.value
                },
                success: function(response) {
                    if (response.success) {
                        Lobibox.notify('success', {
                            title: '<?php echo e(__('Success')); ?>',
                            msg: response.message
                        });
                        setTimeout(() => location.reload(), 1000);
                    } else {
                        Lobibox.notify('error', {
                            title: '<?php echo e(__('Error')); ?>',
                            msg: response.message
                        });
                    }
                },
                error: function() {
                    Lobibox.notify('error', {
                        title: '<?php echo e(__('Error')); ?>',
                        msg: '<?php echo e(__('Error updating status')); ?>'
                    });
                }
            });
        }
    });
}

function createFilePreview(file, index) {
    const fileSize = formatFileSizeJS(file.size);
    const fileType = getFileType(file.name);
    const fileIcon = getFileIcon(fileType);
    
    return `
        <div class="file-preview-item" data-index="${index}">
            <div class="file-preview-info">
                <div class="file-preview-icon ${fileType}">${fileIcon}</div>
                <div class="file-preview-details">
                    <div class="file-preview-name">${file.name}</div>
                    <div class="file-preview-size">${fileSize}</div>
                </div>
            </div>
            <button type="button" class="file-remove-btn" onclick="removeReplyFile(${index})">
                <i class="bx bx-x"></i>
            </button>
        </div>
    `;
}

function getFileType(filename) {
    const ext = filename.split('.').pop().toLowerCase();
    if (['jpg', 'jpeg', 'png', 'gif', 'webp'].includes(ext)) return 'image';
    if (['pdf'].includes(ext)) return 'pdf';
    if (['doc', 'docx'].includes(ext)) return 'document';
    if (['txt'].includes(ext)) return 'text';
    return 'file';
}

function getFileIcon(type) {
    switch(type) {
        case 'image': return '<i class="bx bx-image"></i>';
        case 'pdf': return '<i class="bx bx-file-pdf"></i>';
        case 'document': return '<i class="bx bx-file-doc"></i>';
        case 'text': return '<i class="bx bx-file-txt"></i>';
        default: return '<i class="bx bx-file"></i>';
    }
}

function formatFileSizeJS(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB', 'GB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
}

function removeReplyFile(index) {
    const fileInput = document.getElementById('replyAttachments');
    const dt = new DataTransfer();
    
    for (let i = 0; i < fileInput.files.length; i++) {
        if (i !== index) {
            dt.items.add(fileInput.files[i]);
        }
    }
    
    fileInput.files = dt.files;
    
    // Remove preview item
    $(`.file-preview-item[data-index="${index}"]`).remove();
    
    // Update indices
    $('.file-preview-item').each(function(newIndex) {
        $(this).attr('data-index', newIndex);
        $(this).find('.file-remove-btn').attr('onclick', `removeReplyFile(${newIndex})`);
    });
}

function reopenTicket() {
    Swal.fire({
        title: '<?php echo e(__('Reopen Ticket')); ?>',
        text: '<?php echo e(__('Are you sure you want to reopen this ticket?')); ?>',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: '<?php echo e(__('Yes, Reopen')); ?>',
        cancelButtonText: '<?php echo e(__('Cancel')); ?>',
        confirmButtonColor: '#28a745'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: '<?php echo e(route('admin.tickets.status', $ticket->id)); ?>',
                method: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    status: 'open'
                },
                success: function(response) {
                    if (response.success) {
                        Lobibox.notify('success', {
                            title: '<?php echo e(__('Success')); ?>',
                            msg: response.message
                        });
                        setTimeout(() => location.reload(), 1000);
                    } else {
                        Lobibox.notify('error', {
                            title: '<?php echo e(__('Error')); ?>',
                            msg: response.message
                        });
                    }
                },
                error: function() {
                    Lobibox.notify('error', {
                        title: '<?php echo e(__('Error')); ?>',
                        msg: '<?php echo e(__('Error reopening ticket')); ?>'
                    });
                }
            });
        }
    });
}


</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/tickets/show.blade.php ENDPATH**/ ?>