<?php $__env->startSection('title', __('Translations') . ' - ' . $language['native_name']); ?>
<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Language Management')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/home')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.languages.index')); ?>"><?php echo e(__('Languages')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($language['native_name']); ?></li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Language Info Header -->
        <div class="card mb-4">
            <div class="card-body">
                <div class="d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center">
                        <div class="language-icon me-3">
                            <span class="fs-2"><?php echo e($language['icon'] ?? '🌐'); ?></span>
                        </div>
                        <div>
                            <h4 class="mb-1"><?php echo e($language['native_name']); ?></h4>
                            <p class="mb-0 text-muted">
                                <?php echo e(__('Code')); ?>: <?php echo e(strtoupper($language['code'])); ?> • 
                                <?php echo e(__('Direction')); ?>: <?php echo e(strtoupper($language['direction'])); ?>

                            </p>
                        </div>
                    </div>
                    <div class="d-flex gap-2">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addTranslationModal">
                            <i class="bx bx-plus"></i> <?php echo e(__('Add Translation')); ?>

                        </button>
                        <a href="<?php echo e(route('admin.languages.export', $language['code'])); ?>" class="btn btn-outline-success btn-sm">
                            <i class="bx bx-download"></i> <?php echo e(__('Export')); ?>

                        </a>
                        <a href="<?php echo e(route('admin.languages.index')); ?>" class="btn btn-outline-secondary btn-sm">
                            <i class="bx bx-arrow-back"></i> <?php echo e(__('Back')); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="card mb-4">
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-4">
                        <label for="searchInput" class="form-label"><?php echo e(__('Search')); ?></label>
                        <input type="text" class="form-control" id="searchInput" placeholder="<?php echo e(__('Search keys or translations...')); ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="statusFilter" class="form-label"><?php echo e(__('Status')); ?></label>
                        <select class="form-select" id="statusFilter">
                            <option value=""><?php echo e(__('All')); ?></option>
                            <option value="empty"><?php echo e(__('Empty')); ?></option>
                            <option value="filled"><?php echo e(__('Filled')); ?></option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="lengthSelect" class="form-label"><?php echo e(__('Show')); ?></label>
                        <select class="form-select" id="lengthSelect">
                            <option value="25">25</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                        </select>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button type="button" class="btn btn-outline-secondary w-100" onclick="resetFilters()">
                            <i class="bx bx-refresh"></i> <?php echo e(__('Reset')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Translations Cards -->
        <div class="card">
            <div class="card-header">
                <div class="d-flex align-items-center justify-content-between">
                    <h5 class="mb-0"><?php echo e(__('Translations')); ?></h5>
                    <div id="tableInfo" class="text-muted small"></div>
                </div>
            </div>
            <div class="card-body">
                <!-- Loading -->
                <div id="tableLoading" class="text-center py-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden"><?php echo e(__('Loading...')); ?></span>
                    </div>
                </div>
                
                <!-- Translations Container -->
                <div id="translationsContainer" style="display: none;">
                    <!-- Translation cards will be loaded here -->
                </div>
                
                <!-- Pagination -->
                <div id="pagination" class="d-flex justify-content-between align-items-center mt-3" style="display: none;">
                    <div id="paginationInfo" class="text-muted small"></div>
                    <nav>
                        <ul id="paginationLinks" class="pagination pagination-sm mb-0">
                            <!-- Pagination links will be generated here -->
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Translation Modal -->
<div class="modal fade" id="addTranslationModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Add New Translation')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="addTranslationForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="new_key" class="form-label"><?php echo e(__('Translation Key')); ?> *</label>
                        <input type="text" class="form-control" id="new_key" name="key" required>
                        <div class="form-text"><?php echo e(__('Unique identifier for this translation')); ?></div>
                    </div>
                    <div class="mb-3">
                        <label for="new_value" class="form-label"><?php echo e(__('Translation Value')); ?> *</label>
                        <textarea class="form-control" id="new_value" name="value" rows="4" required></textarea>
                        <div class="form-text"><?php echo e(__('The translated text in')); ?> <?php echo e($language['native_name']); ?></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                    <button type="submit" class="btn btn-primary">
                        <span class="spinner-border spinner-border-sm me-2" style="display: none;"></span>
                        <?php echo e(__('Add Translation')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Translation Modal -->
<div class="modal fade" id="editTranslationModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Edit Translation')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="editTranslationForm">
                <input type="hidden" id="edit_key" name="key">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Translation Key')); ?></label>
                        <input type="text" class="form-control" id="edit_key_display" readonly>
                    </div>
                    <div class="mb-3">
                        <label for="edit_value" class="form-label"><?php echo e(__('Translation Value')); ?> *</label>
                        <textarea class="form-control" id="edit_value" name="value" rows="4" required></textarea>
                        <div class="form-text">
                            <span id="charCount">0</span> <?php echo e(__('characters')); ?> • 
                            <span id="wordCount">0</span> <?php echo e(__('words')); ?>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                    <button type="submit" class="btn btn-primary">
                        <span class="spinner-border spinner-border-sm me-2" style="display: none;"></span>
                        <?php echo e(__('Update Translation')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
$(document).ready(function() {
    const languageCode = '<?php echo e($language["code"]); ?>';
    let currentPage = 1;
    let currentLength = 25;
    let currentSearch = '';
    let currentStatus = '';

    // CSRF Token
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // Load translations on page load
    loadTranslations();

    // Search input with debounce
    let searchTimeout;
    $('#searchInput').on('input', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(function() {
            currentSearch = $('#searchInput').val();
            currentPage = 1;
            loadTranslations();
        }, 500);
    });

    // Status filter change
    $('#statusFilter').on('change', function() {
        currentStatus = $(this).val();
        currentPage = 1;
        loadTranslations();
    });

    // Length select change
    $('#lengthSelect').on('change', function() {
        currentLength = parseInt($(this).val());
        currentPage = 1;
        loadTranslations();
    });

    // Add Translation Form Submit
    $('#addTranslationForm').on('submit', function(e) {
        e.preventDefault();
        
        const form = $(this);
        const submitBtn = form.find('button[type="submit"]');
        const spinner = submitBtn.find('.spinner-border');
        
        submitBtn.prop('disabled', true);
        spinner.show();
        
        $.ajax({
            url: '<?php echo e(route("admin.languages.translations.add", $language["code"])); ?>',
            method: 'POST',
            data: form.serialize(),
            success: function(response) {
                if (response.success) {
                    $('#addTranslationModal').modal('hide');
                    form[0].reset();
                    loadTranslations();
                    showToast('success', response.message);
                }
            },
            error: function(xhr) {
                const errors = xhr.responseJSON?.errors || {};
                showValidationErrors(form, errors);
                if (xhr.responseJSON?.message) {
                    showToast('error', xhr.responseJSON.message);
                }
            },
            complete: function() {
                submitBtn.prop('disabled', false);
                spinner.hide();
            }
        });
    });

    // Edit Translation Form Submit
    $('#editTranslationForm').on('submit', function(e) {
        e.preventDefault();
        
        const form = $(this);
        const submitBtn = form.find('button[type="submit"]');
        const spinner = submitBtn.find('.spinner-border');
        
        submitBtn.prop('disabled', true);
        spinner.show();
        
        $.ajax({
            url: '<?php echo e(route("admin.languages.translations.update", $language["code"])); ?>',
            method: 'POST',
            data: form.serialize(),
            success: function(response) {
                if (response.success) {
                    $('#editTranslationModal').modal('hide');
                    loadTranslations();
                    showToast('success', response.message);
                }
            },
            error: function(xhr) {
                const errors = xhr.responseJSON?.errors || {};
                showValidationErrors(form, errors);
                if (xhr.responseJSON?.message) {
                    showToast('error', xhr.responseJSON.message);
                }
            },
            complete: function() {
                submitBtn.prop('disabled', false);
                spinner.hide();
            }
        });
    });

    // Character and word count for edit form
    $('#edit_value').on('input', function() {
        const text = $(this).val();
        const charCount = text.length;
        const wordCount = text.trim() ? text.trim().split(/\s+/).length : 0;
        
        $('#charCount').text(charCount);
        $('#wordCount').text(wordCount);
    });

    // Load Translations Function
    function loadTranslations() {
        $('#tableLoading').show();
        $('#translationsContainer').hide();
        $('#pagination').hide();
        
        const params = {
            start: (currentPage - 1) * currentLength,
            length: currentLength,
            search: { value: currentSearch },
            status: currentStatus,
            draw: Math.random()
        };
        
        $.ajax({
            url: '<?php echo e(route("admin.languages.translations.data", $language["code"])); ?>',
            method: 'GET',
            data: params,
            success: function(response) {
                console.log('AJAX Response:', response);
                if (response.success === false) {
                    showToast('error', response.message || 'Unknown error');
                    return;
                }
                
                if (response.data) {
                    renderTranslations(response.data);
                    updatePagination(response);
                    updateTableInfo(response);
                } else {
                    console.error('No data in response:', response);
                    showToast('error', 'No translation data received');
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', xhr.responseText);
                showToast('error', '<?php echo e(__("An error occurred while loading translations")); ?>');
            },
            complete: function() {
                $('#tableLoading').hide();
                $('#translationsContainer').show();
                $('#pagination').show();
            }
        });
    }

    // Render Translations Function
    function renderTranslations(translations) {
        let html = '';
        
        if (translations.length === 0) {
            html = `
                <div class="text-center py-5 text-muted">
                    <i class="bx bx-search fs-1 d-block mb-2"></i>
                    <h5><?php echo e(__('No translations found')); ?></h5>
                    <p><?php echo e(__('Try adjusting your search or filter criteria')); ?></p>
                </div>
            `;
        } else {
            translations.forEach(function(item, index) {
                const statusBadge = item.is_empty 
                    ? '<span class="badge bg-warning"><?php echo e(__("Empty")); ?></span>'
                    : '<span class="badge bg-success"><?php echo e(__("Filled")); ?></span>';
                
                html += `
                    <div class="card mb-3 translation-card" data-key="${escapeHtml(item.key)}">
                        <div class="card-body">
                            <div class="row align-items-start">
                                <div class="col-12 col-md-4 mb-2 mb-md-0">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <code class="text-primary small">${escapeHtml(item.key)}</code>
                                        ${statusBadge}
                                    </div>
                                </div>
                                <div class="col-12 col-md-8">
                                    <div class="translation-content">
                                        <div class="translation-display" onclick="startInlineEdit('${escapeHtml(item.key)}', this)">
                                            ${item.is_empty 
                                                ? '<em class="text-muted"><?php echo e(__("Click to add translation...")); ?></em>'
                                                : `<span class="translation-text">${escapeHtml(item.value)}</span>`
                                            }
                                        </div>
                                        <div class="translation-edit" style="display: none;">
                                            <div class="input-group">
                                                <textarea class="form-control translation-input" rows="2" placeholder="<?php echo e(__('Enter translation...')); ?>" 
                                                    onblur="autoSaveTranslation('${escapeHtml(item.key)}', this)"
                                                    onkeydown="handleKeyPress(event, '${escapeHtml(item.key)}', this)">${escapeHtml(item.value)}</textarea>
                                                <button class="btn btn-success btn-sm" type="button" onclick="saveInlineEdit('${escapeHtml(item.key)}', this)">
                                                    <i class="bx bx-check"></i>
                                                </button>
                                                <button class="btn btn-outline-secondary btn-sm" type="button" onclick="cancelInlineEdit('${escapeHtml(item.key)}', this)">
                                                    <i class="bx bx-x"></i>
                                                </button>
                                            </div>
                                        </div>
                                        ${item.character_count > 0 ? `
                                            <small class="text-muted d-block mt-1">
                                                ${item.character_count} <?php echo e(__("chars")); ?> • ${item.word_count} <?php echo e(__("words")); ?>

                                            </small>
                                        ` : ''}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
            });
        }
        
        $('#translationsContainer').html(html);
    }

    // Update Pagination
    function updatePagination(response) {
        const totalPages = Math.ceil(response.recordsTotal / currentLength);
        let paginationHtml = '';
        
        // Previous button
        if (currentPage > 1) {
            paginationHtml += `
                <li class="page-item">
                    <a class="page-link" href="javascript:void(0)" onclick="changePage(${currentPage - 1}); return false;">
                        <i class="bx bx-chevron-left"></i>
                    </a>
                </li>
            `;
        }
        
        // Page numbers
        const startPage = Math.max(1, currentPage - 2);
        const endPage = Math.min(totalPages, currentPage + 2);
        
        for (let i = startPage; i <= endPage; i++) {
            paginationHtml += `
                <li class="page-item ${i === currentPage ? 'active' : ''}">
                    <a class="page-link" href="javascript:void(0)" onclick="changePage(${i}); return false;">${i}</a>
                </li>
            `;
        }
        
        // Next button
        if (currentPage < totalPages) {
            paginationHtml += `
                <li class="page-item">
                    <a class="page-link" href="javascript:void(0)" onclick="changePage(${currentPage + 1}); return false;">
                        <i class="bx bx-chevron-right"></i>
                    </a>
                </li>
            `;
        }
        
        $('#paginationLinks').html(paginationHtml);
        
        // Pagination info
        const start = ((currentPage - 1) * currentLength) + 1;
        const end = Math.min(currentPage * currentLength, response.recordsTotal);
        $('#paginationInfo').text(`<?php echo e(__("Showing")); ?> ${start} <?php echo e(__("to")); ?> ${end} <?php echo e(__("of")); ?> ${response.recordsTotal} <?php echo e(__("entries")); ?>`);
    }

    // Update Table Info
    function updateTableInfo(response) {
        $('#tableInfo').text(`${response.recordsTotal} <?php echo e(__("translations")); ?>`);
    }

    // Change Page Function
    window.changePage = function(page) {
        currentPage = page;
        loadTranslations();
    };

    // Reset Filters Function
    window.resetFilters = function() {
        $('#searchInput').val('');
        $('#statusFilter').val('');
        $('#lengthSelect').val('25');
        
        currentPage = 1;
        currentLength = 25;
        currentSearch = '';
        currentStatus = '';
        
        loadTranslations();
    };

    // Inline Edit Functions
    window.startInlineEdit = function(key, element) {
        // First, close any other open edit modes
        $('.translation-edit:visible').each(function() {
            const otherCard = $(this).closest('.translation-card');
            const otherInput = $(this).find('.translation-input');
            const otherKey = otherCard.data('key');
            
            if (otherKey && otherKey !== key) {
                // Auto-save if there are changes
                const originalValue = otherCard.data('original-value') || '';
                const currentValue = otherInput.val().trim();
                
                if (currentValue !== originalValue && currentValue !== '') {
                    // Save silently without notification
                    $.ajax({
                        url: '<?php echo e(route("admin.languages.translations.update", $language["code"])); ?>',
                        method: 'POST',
                        data: {
                            key: otherKey,
                            value: currentValue,
                            _token: $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function(response) {
                            if (response.success) {
                                // Update display silently
                                const otherDisplayDiv = otherCard.find('.translation-display');
                                otherDisplayDiv.find('.translation-text').text(currentValue);
                                if (otherDisplayDiv.find('em').length > 0) {
                                    otherDisplayDiv.html(`<span class="translation-text">${escapeHtml(currentValue)}</span>`);
                                }
                                otherCard.find('.badge').removeClass('bg-warning').addClass('bg-success').text('<?php echo e(__("Filled")); ?>');
                            }
                        }
                    });
                }
                
                // Close the edit mode
                otherCard.find('.translation-display').show();
                $(this).hide();
            }
        });
        
        const card = $(element).closest('.translation-card');
        const displayDiv = card.find('.translation-display');
        const editDiv = card.find('.translation-edit');
        const input = editDiv.find('.translation-input');
        
        // Store original value and key for comparison
        card.data('original-value', input.val());
        card.data('key', key);
        
        displayDiv.hide();
        editDiv.show();
        input.focus();
        
        // Select all text for easy editing
        input[0].select();
    };

    window.saveInlineEdit = function(key, element) {
        const card = $(element).closest('.translation-card');
        const input = card.find('.translation-input');
        const value = input.val().trim();
        
        if (!value) {
            showToast('error', '<?php echo e(__("Translation cannot be empty")); ?>');
            return;
        }
        
        // Show loading
        $(element).prop('disabled', true).html('<i class="bx bx-loader-alt bx-spin"></i>');
        
        $.ajax({
            url: '<?php echo e(route("admin.languages.translations.update", $language["code"])); ?>',
            method: 'POST',
            data: {
                key: key,
                value: value,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    // Update display
                    const displayDiv = card.find('.translation-display');
                    const editDiv = card.find('.translation-edit');
                    
                    displayDiv.find('.translation-text').text(value);
                    if (displayDiv.find('em').length > 0) {
                        displayDiv.html(`<span class="translation-text">${escapeHtml(value)}</span>`);
                    }
                    
                    // Update status badge
                    card.find('.badge').removeClass('bg-warning').addClass('bg-success').text('<?php echo e(__("Filled")); ?>');
                    
                    displayDiv.show();
                    editDiv.hide();
                    
                    showToast('success', response.message);
                }
            },
            error: function(xhr) {
                showToast('error', xhr.responseJSON?.message || '<?php echo e(__("An error occurred")); ?>');
            },
            complete: function() {
                $(element).prop('disabled', false).html('<i class="bx bx-check"></i>');
            }
        });
    };

    window.cancelInlineEdit = function(key, element) {
        const card = $(element).closest('.translation-card');
        const displayDiv = card.find('.translation-display');
        const editDiv = card.find('.translation-edit');
        
        displayDiv.show();
        editDiv.hide();
    };

    // Auto-save when input loses focus
    window.autoSaveTranslation = function(key, element) {
        const card = $(element).closest('.translation-card');
        const originalValue = card.data('original-value') || '';
        const newValue = $(element).val().trim();
        
        // Always close edit mode first
        const displayDiv = card.find('.translation-display');
        const editDiv = card.find('.translation-edit');
        
        // Only save if value changed and not empty
        if (newValue !== originalValue && newValue !== '') {
            // Add visual indicator
            $(element).addClass('border-warning');
            
            $.ajax({
                url: '<?php echo e(route("admin.languages.translations.update", $language["code"])); ?>',
                method: 'POST',
                data: {
                    key: key,
                    value: newValue,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        // Update display
                        displayDiv.find('.translation-text').text(newValue);
                        if (displayDiv.find('em').length > 0) {
                            displayDiv.html(`<span class="translation-text">${escapeHtml(newValue)}</span>`);
                        }
                        
                        // Update status badge
                        card.find('.badge').removeClass('bg-warning').addClass('bg-success').text('<?php echo e(__("Filled")); ?>');
                        
                        // Store new value as original
                        card.data('original-value', newValue);
                        
                        // Remove visual indicator
                        $(element).removeClass('border-warning').addClass('border-success');
                        setTimeout(() => {
                            $(element).removeClass('border-success');
                        }, 1000);
                        
                        // Show subtle success notification
                        showToast('success', '<?php echo e(__("Auto-saved")); ?>');
                    }
                },
                error: function(xhr) {
                    $(element).removeClass('border-warning').addClass('border-danger');
                    setTimeout(() => {
                        $(element).removeClass('border-danger');
                    }, 2000);
                    showToast('error', xhr.responseJSON?.message || '<?php echo e(__("Auto-save failed")); ?>');
                }
            });
        }
        
        // Always hide edit mode after processing
        displayDiv.show();
        editDiv.hide();
    };

    // Handle keyboard shortcuts
    window.handleKeyPress = function(event, key, element) {
        // Enter key: Save and close
        if (event.key === 'Enter' && !event.shiftKey) {
            event.preventDefault();
            autoSaveTranslation(key, element);
        }
        // Escape key: Cancel without saving
        else if (event.key === 'Escape') {
            event.preventDefault();
            const card = $(element).closest('.translation-card');
            const displayDiv = card.find('.translation-display');
            const editDiv = card.find('.translation-edit');
            
            // Restore original value
            const originalValue = card.data('original-value') || '';
            $(element).val(originalValue);
            
            displayDiv.show();
            editDiv.hide();
        }
    };

    // Edit Translation Function (for modal - keep for compatibility)
    window.editTranslation = function(key, value) {
        $('#edit_key').val(key);
        $('#edit_key_display').val(key);
        $('#edit_value').val(value);
        
        // Update character and word count
        const charCount = value.length;
        const wordCount = value.trim() ? value.trim().split(/\s+/).length : 0;
        $('#charCount').text(charCount);
        $('#wordCount').text(wordCount);
        
        $('#editTranslationModal').modal('show');
    };

    // Utility Functions
    function escapeHtml(text) {
        const div = document.createElement('div');
        div.textContent = text;
        return div.innerHTML;
    }

    function showToast(type, message) {
        if (typeof Lobibox !== 'undefined') {
            if (type === 'success') {
                Lobibox.notify('success', {
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    icon: 'bx bx-check-circle',
                    msg: message
                });
            } else if (type === 'error') {
                Lobibox.notify('error', {
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    icon: 'bx bx-x-circle',
                    msg: message
                });
            }
        } else {
            // Fallback to alert if Lobibox is not available
            if (type === 'success') {
                alert('✅ ' + message);
            } else {
                alert('❌ ' + message);
            }
        }
    }

    function showValidationErrors(form, errors) {
        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback').remove();
        
        Object.keys(errors).forEach(function(field) {
            const input = form.find(`[name="${field}"]`);
            input.addClass('is-invalid');
            input.after(`<div class="invalid-feedback">${errors[field][0]}</div>`);
        });
    }

    // Clear validation errors when modal is hidden
    $('.modal').on('hidden.bs.modal', function() {
        $(this).find('.is-invalid').removeClass('is-invalid');
        $(this).find('.invalid-feedback').remove();
        $(this).find('form')[0].reset();
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/admin/languages/translations.blade.php ENDPATH**/ ?>