<?php $__env->startSection('style'); ?>
    <link href="<?php echo e(asset('assets/plugins/notifications/css/lobibox.min.css')); ?>" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        .account-card {
            border: 1px solid #e9ecef;
            border-radius: 12px;
            transition: all 0.3s ease;
            background: white;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        .account-card:hover {
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
            transform: translateY(-2px);
        }
        .platform-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            object-fit: cover;
            border: 2px solid #f8f9fa;
        }
        .status-badge {
            font-size: 0.75rem;
            padding: 6px 12px;
            border-radius: 20px;
            font-weight: 600;
        }
        .action-buttons {
            display: flex;
            gap: 8px;
            flex-wrap: wrap;
        }
        .action-buttons .btn {
            padding: 6px 12px;
            font-size: 0.8rem;
            border-radius: 8px;
        }
        .search-container {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 25px;
            color: white;
        }
        .search-container .form-control {
            border: none;
            border-radius: 8px;
            padding: 12px 15px;
            background: rgba(255,255,255,0.9);
        }
        .search-container .btn {
            border-radius: 8px;
            padding: 12px 20px;
            font-weight: 600;
        }
        .add-account-btn {
            background: linear-gradient(45deg, #28a745, #20c997);
            border: none;
            border-radius: 8px;
            padding: 12px 20px;
            color: white;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .add-account-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(40, 167, 69, 0.4);
        }
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #6c757d;
        }
        .empty-state i {
            font-size: 4rem;
            margin-bottom: 20px;
            opacity: 0.5;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Social Media')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('My Social Accounts')); ?></li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Search and Filter Section -->
        <div class="search-container">
            <div class="row align-items-end">
                <div class="col-md-4 mb-3">
                    <label class="form-label text-white"><?php echo e(__('Search')); ?></label>
                    <input type="text" class="form-control" id="searchInput" placeholder="<?php echo e(__('Search by username or platform...')); ?>">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label text-white"><?php echo e(__('Status')); ?></label>
                    <select class="form-select" id="statusFilter">
                        <option value=""><?php echo e(__('All Status')); ?></option>
                        <option value="0"><?php echo e(__('Pending')); ?></option>
                        <option value="1"><?php echo e(__('Approved')); ?></option>
                        <option value="2"><?php echo e(__('Rejected')); ?></option>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <button type="button" class="btn btn-light w-100" onclick="searchAccounts()">
                        <i class="bx bx-search me-2"></i><?php echo e(__('Search')); ?>

                    </button>
                </div>
                <div class="col-md-2 mb-3">
                    <button type="button" class="btn add-account-btn w-100" data-bs-toggle="modal" data-bs-target="#addAccountModal">
                        <i class="bx bx-plus me-2"></i><?php echo e(__('Add Account')); ?>

                    </button>
                </div>
            </div>
        </div>

        <!-- Accounts Grid -->
        <div class="row" id="accountsContainer">
            <!-- Accounts will be loaded here -->
        </div>

        <!-- Pagination -->
        <div class="d-flex justify-content-center mt-4">
            <nav aria-label="Page navigation">
                <ul class="pagination" id="pagination">
                    <!-- Pagination will be loaded here -->
                </ul>
            </nav>
        </div>

        <!-- Loading Spinner -->
        <div class="text-center py-5" id="loadingSpinner" style="display: none;">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden"><?php echo e(__('Loading...')); ?></span>
            </div>
        </div>
    </div>
</div>

<!-- Add Account Modal -->
<div class="modal fade" id="addAccountModal" tabindex="-1" aria-labelledby="addAccountModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addAccountModalLabel"><?php echo e(__('Add Social Media Account')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="addAccountForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="platform_id" class="form-label"><?php echo e(__('Platform')); ?></label>
                        <select class="form-select" id="platform_id" name="platform_id" required>
                            <option value=""><?php echo e(__('Select Platform')); ?></option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="username" class="form-label"><?php echo e(__('Username')); ?></label>
                        <input type="text" class="form-control" id="username" name="username" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(__('Add Account')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('assets/plugins/notifications/js/lobibox.min.js')); ?>"></script>
    <script>
        let currentPage = 1;
        let isLoading = false;

        // Load accounts on page load
        document.addEventListener('DOMContentLoaded', function() {
            loadPlatforms();
            loadAccounts();
        });

        // Load platforms for dropdown
        function loadPlatforms() {
            fetch('<?php echo e(route('social_platforms.list')); ?>')
                .then(response => response.json())
                .then(data => {
                    const platformSelect = document.getElementById('platform_id');
                    platformSelect.innerHTML = '<option value=""><?php echo e(__('Select Platform')); ?></option>';
                    
                    if (data.success && data.platforms) {
                        data.platforms.forEach(platform => {
                            platformSelect.innerHTML += `<option value="${platform.id}">${platform.platform}</option>`;
                        });
                    }
                })
                .catch(error => {
                    console.error('Error loading platforms:', error);
                });
        }

        // Load accounts
        function loadAccounts(page = 1) {
            if (isLoading) return;
            
            isLoading = true;
            document.getElementById('loadingSpinner').style.display = 'block';
            
            const search = document.getElementById('searchInput').value;
            const status = document.getElementById('statusFilter').value;
            
            const params = new URLSearchParams({
                page: page,
                per_page: 12,
                search: search,
                status: status
            });

            fetch(`<?php echo e(route('user.social_accounts.search')); ?>?${params}`)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        displayAccounts(data.data);
                        displayPagination(data.pagination);
                        currentPage = page;
                    } else {
                        showNotification('error', data.message || '<?php echo e(__('Error loading accounts')); ?>');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    showNotification('error', '<?php echo e(__('Error loading accounts')); ?>');
                })
                .finally(() => {
                    isLoading = false;
                    document.getElementById('loadingSpinner').style.display = 'none';
                });
        }

        // Display accounts
        function displayAccounts(accounts) {
            const container = document.getElementById('accountsContainer');
            
            if (!accounts || accounts.length === 0) {
                container.innerHTML = `
                    <div class="col-12">
                        <div class="empty-state">
                            <i class="bx bx-user-x"></i>
                            <h4><?php echo e(__('No accounts found')); ?></h4>
                            <p><?php echo e(__('You haven\'t added any social media accounts yet.')); ?></p>
                        </div>
                    </div>
                `;
                return;
            }

            container.innerHTML = accounts.map(account => `
                <div class="col-xl-3 col-lg-4 col-md-6 mb-4">
                    <div class="account-card p-3 h-100">
                        <div class="d-flex align-items-center mb-3">
                            <img src="<?php echo e(asset('assets/images/app')); ?>/${account.platform?.icon || 'placeholder.png'}" 
                                 alt="${account.platform?.platform || 'Platform'}" 
                                 class="platform-icon me-3">
                            <div class="flex-grow-1">
                                <h6 class="mb-1">${account.platform?.platform || 'Unknown Platform'}</h6>
                                <p class="mb-0 text-muted">@${account.username}</p>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <span class="status-badge ${getStatusClass(account.status)}">
                                ${getStatusText(account.status)}
                            </span>
                        </div>
                        
                        <div class="action-buttons">
                            ${account.status != 1 || !account.has_completed_tasks ? `
                                <button class="btn btn-outline-danger btn-sm" onclick="deleteAccount(${account.id})">
                                    <i class="bx bx-trash me-1"></i><?php echo e(__('Delete')); ?>

                                </button>
                            ` : `
                                <small class="text-muted"><?php echo e(__('Cannot delete - has completed tasks')); ?></small>
                            `}
                        </div>
                    </div>
                </div>
            `).join('');
        }

        // Display pagination
        function displayPagination(pagination) {
            const container = document.getElementById('pagination');
            
            if (pagination.last_page <= 1) {
                container.innerHTML = '';
                return;
            }

            let paginationHTML = '';
            
            // Previous button
            if (pagination.current_page > 1) {
                paginationHTML += `
                    <li class="page-item">
                        <a class="page-link" href="#" onclick="loadAccounts(${pagination.current_page - 1})"><?php echo e(__('Previous')); ?></a>
                    </li>
                `;
            }

            // Page numbers
            for (let i = 1; i <= pagination.last_page; i++) {
                if (i === pagination.current_page) {
                    paginationHTML += `<li class="page-item active"><span class="page-link">${i}</span></li>`;
                } else {
                    paginationHTML += `<li class="page-item"><a class="page-link" href="#" onclick="loadAccounts(${i})">${i}</a></li>`;
                }
            }

            // Next button
            if (pagination.current_page < pagination.last_page) {
                paginationHTML += `
                    <li class="page-item">
                        <a class="page-link" href="#" onclick="loadAccounts(${pagination.current_page + 1})"><?php echo e(__('Next')); ?></a>
                    </li>
                `;
            }

            container.innerHTML = paginationHTML;
        }

        // Search accounts
        function searchAccounts() {
            loadAccounts(1);
        }

        // Add account form submission
        document.getElementById('addAccountForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            
            fetch('<?php echo e(route('user.social_accounts.store')); ?>', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Accept': 'application/json',
                },
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showNotification('success', data.message);
                    bootstrap.Modal.getInstance(document.getElementById('addAccountModal')).hide();
                    this.reset();
                    loadAccounts(currentPage);
                } else {
                    showNotification('error', data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showNotification('error', '<?php echo e(__('Error adding account')); ?>');
            });
        });

        // Delete account
        function deleteAccount(accountId) {
            Swal.fire({
                title: '<?php echo e(__('Are you sure?')); ?>',
                text: '<?php echo e(__('This action cannot be undone!')); ?>',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: '<?php echo e(__('Yes, delete it!')); ?>',
                cancelButtonText: '<?php echo e(__('No, cancel!')); ?>',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: `<?php echo e(url('my-social-accounts')); ?>/${accountId}/delete`,
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                            'Accept': 'application/json'
                        },
                        dataType: 'json'
                    }).done(function(response) {
                        if (response.success) {
                            showNotification('success', response.message);
                            loadAccounts(currentPage);
                        } else {
                            showNotification('error', response.message);
                        }
                    }).fail(function(xhr) {
                        console.error('Error:', xhr);
                        const errorMessage = xhr.responseJSON?.message || '<?php echo e(__('Error deleting account')); ?>';
                        showNotification('error', errorMessage);
                    });
                }
            });
        }

        // Helper functions
        function getStatusClass(status) {
            switch(status) {
                case 0: return 'bg-warning text-dark';
                case 1: return 'bg-success text-white';
                case 2: return 'bg-danger text-white';
                default: return 'bg-secondary text-white';
            }
        }

        function getStatusText(status) {
            switch(status) {
                case 0: return '<?php echo e(__('Pending')); ?>';
                case 1: return '<?php echo e(__('Approved')); ?>';
                case 2: return '<?php echo e(__('Rejected')); ?>';
                default: return '<?php echo e(__('Unknown')); ?>';
            }
        }

        function showNotification(type, message) {
            Lobibox.notify(type, {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                icon: type === 'success' ? 'bx bx-check-circle' : 'bx bx-x-circle',
                msg: message
            });
        }

        // Search on enter key
        document.getElementById('searchInput').addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                searchAccounts();
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/user/social_accounts/index.blade.php ENDPATH**/ ?>