<?php $__env->startSection('title', __('Order Details')); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <h1><?php echo app('translator')->get('Order Details'); ?> #<?php echo e($order->order_number); ?></h1>
        <hr>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="card mb-3">
            <div class="card-header"><?php echo app('translator')->get('Product Information'); ?></div>
            <div class="card-body">
                <h5 class="card-title"><?php echo e($order->product_name); ?></h5>
                <p class="card-text"><?php echo app('translator')->get('Unit Price'); ?>: <?php echo e($order->product_price); ?> ₺</p>
                <p class="card-text"><?php echo app('translator')->get('Quantity'); ?>: <?php echo e($order->quantity); ?></p>
                <p class="card-text"><?php echo app('translator')->get('Total Amount'); ?>: <?php echo e($order->formatted_total); ?></p>
                <?php if($order->product_id && $order->product): ?>
                    <a href="<?php echo e(route('site2.products.show', $order->product_id)); ?>" class="btn btn-sm btn-info"><?php echo app('translator')->get('View Product'); ?></a>
                <?php else: ?>
                    <span class="text-muted"><?php echo app('translator')->get('Product no longer available'); ?></span>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-3">
            <div class="card-header"><?php echo app('translator')->get('Order Information'); ?></div>
            <div class="card-body">
                <p class="card-text"><?php echo app('translator')->get('Order Number'); ?>: <?php echo e($order->order_number); ?></p>
                <p class="card-text"><?php echo app('translator')->get('Order Date'); ?>: <?php echo e($order->created_at); ?></p>
                <p class="card-text"><?php echo app('translator')->get('Status'); ?>: <span class="badge <?php echo e($order->status_badge); ?>"><?php echo e($order->status_text); ?></span></p>
                <p class="card-text"><?php echo app('translator')->get('Payment Status'); ?>: <span class="badge <?php echo e($order->payment_status_badge); ?>"><?php echo e($order->payment_status_text); ?></span></p>
                <?php if($order->delivered_at): ?>
                    <p class="card-text"><?php echo app('translator')->get('Delivered on'); ?>: <?php echo e($order->delivered_at); ?></p>
                <?php endif; ?>
                <?php if($order->notes): ?>
                    <p class="card-text"><?php echo app('translator')->get('Notes'); ?>: <?php echo e($order->notes); ?></p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card mb-3">
            <div class="card-header"><?php echo app('translator')->get('Delivery Information'); ?></div>
            <div class="card-body">
                <?php if($order->product_data && $order->product_data['digital_content']): ?>
                    <p><?php echo app('translator')->get('Digital Content'); ?>:</p>
                    <pre><?php echo e($order->product_data['digital_content']); ?></pre>
                    <?php if($order->product_data['instructions']): ?>
                        <p><?php echo app('translator')->get('Instructions'); ?>:</p>
                        <pre><?php echo e($order->product_data['instructions']); ?></pre>
                    <?php endif; ?>
                <?php else: ?>
                    <p><?php echo app('translator')->get('No delivery information available yet.'); ?></p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12 text-center">
        <?php if($order->can_be_cancelled): ?>
            <button type="button" class="btn btn-danger cancel-order-btn" data-order-id="<?php echo e($order->id); ?>"><?php echo app('translator')->get('Cancel Order'); ?></button>
        <?php endif; ?>
        <a href="<?php echo e(route('site2.account.orders')); ?>" class="btn btn-secondary"><?php echo app('translator')->get('Back to My Orders'); ?></a>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.cancel-order-btn').forEach(button => {
            button.addEventListener('click', function () {
                const orderId = this.dataset.orderId;
                if (confirm('<?php echo app('translator')->get('Are you sure you want to cancel this order?'); ?>')) {
                    fetch(`<?php echo e(url('hesabim/siparislerim')); ?>/${orderId}/cancel`, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                            'Content-Type': 'application/json',
                            'Accept': 'application/json'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            alert(data.message);
                            window.location.href = '<?php echo e(route('site2.account.orders')); ?>';
                        } else {
                            alert(data.message);
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert('<?php echo app('translator')->get('An error occurred'); ?>');
                    });
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('gorevsitesi.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/gorevsitesi/account/order_detail.blade.php ENDPATH**/ ?>