<?php $__env->startSection('style'); ?>
<link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('assets/plugins/datatable/css/buttons.bootstrap5.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('assets/plugins/datatable/css/responsive.bootstrap5.min.css')); ?>" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet">
<style>
.stats-card {
    transition: transform 0.2s ease;
}

.stats-card:hover {
    transform: translateY(-2px);
}

.stats-icon {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 10px;
    color: white;
    font-size: 1.5rem;
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 5px;
}

.stats-title {
    font-size: 0.9rem;
    color: #6c757d;
    font-weight: 500;
}

/* User Info Styles */
.user-info {
    display: flex;
    align-items: center;
    gap: 10px;
}

.user-avatar {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    font-size: 0.9rem;
}

.user-details {
    flex: 1;
}

.user-name {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 2px;
    font-size: 0.9rem;
}

.user-email {
    font-size: 0.8rem;
    color: #6c757d;
}

.ticket-info {
    max-width: 250px;
}

.ticket-number {
    font-weight: 600;
    color: #007bff;
    font-size: 0.85rem;
}

.ticket-subject {
    color: #2c3e50;
    font-size: 0.9rem;
    margin-top: 2px;
}

/* Mobile Styles */
.mobile-ticket-card {
    background: white;
    border-radius: 12px;
    padding: 16px;
    margin-bottom: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    border: 1px solid #e9ecef;
    transition: all 0.2s ease;
    cursor: pointer;
}

.mobile-ticket-card:hover {
    box-shadow: 0 4px 16px rgba(0,0,0,0.15);
    transform: translateY(-1px);
}

.mobile-ticket-card.urgent {
    border-left: 4px solid #dc3545;
}

.mobile-ticket-card.high {
    border-left: 4px solid #fd7e14;
}

.mobile-ticket-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 12px;
}

.mobile-ticket-number {
    font-weight: 600;
    color: #007bff;
    font-size: 0.9rem;
}

.mobile-ticket-subject {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 8px;
    font-size: 1rem;
}

.mobile-ticket-user {
    font-size: 0.85rem;
    color: #6c757d;
    margin-bottom: 8px;
}

.mobile-ticket-meta {
    display: flex;
    gap: 6px;
    margin-bottom: 12px;
    flex-wrap: wrap;
}

.mobile-ticket-meta .badge {
    font-size: 0.7rem;
    padding: 4px 8px;
}

.mobile-ticket-footer {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding-top: 12px;
    border-top: 1px solid #f1f3f4;
}

.mobile-ticket-time {
    font-size: 0.8rem;
    color: #6c757d;
}

.mobile-unread-badge {
    background-color: #dc3545;
    color: white;
    border-radius: 50%;
    width: 18px;
    height: 18px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.7rem;
    font-weight: 600;
}

@media (max-width: 768px) {
    .stats-card {
        margin-bottom: 1rem;
    }
    
    .row.mb-4 {
        margin-bottom: 1.5rem !important;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Admin')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/home')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Support Tickets')); ?></li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card stats-card">
                    <div class="card-body text-center">
                        <div class="stats-icon bg-primary">
                            <i class="bx bx-ticket"></i>
                        </div>
                        <div class="stats-number"><?php echo e($stats['total']); ?></div>
                        <div class="stats-title"><?php echo e(__('Total Tickets')); ?></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card stats-card">
                    <div class="card-body text-center">
                        <div class="stats-icon bg-success">
                            <i class="bx bx-folder-open"></i>
                        </div>
                        <div class="stats-number"><?php echo e($stats['open']); ?></div>
                        <div class="stats-title"><?php echo e(__('Open Tickets')); ?></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card stats-card">
                    <div class="card-body text-center">
                        <div class="stats-icon bg-secondary">
                            <i class="bx bx-folder"></i>
                        </div>
                        <div class="stats-number"><?php echo e($stats['closed']); ?></div>
                        <div class="stats-title"><?php echo e(__('Closed Tickets')); ?></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card stats-card">
                    <div class="card-body text-center">
                        <div class="stats-icon bg-danger">
                            <i class="bx bx-error"></i>
                        </div>
                        <div class="stats-number"><?php echo e($stats['urgent']); ?></div>
                        <div class="stats-title"><?php echo e(__('Urgent Tickets')); ?></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card stats-card">
                    <div class="card-body text-center">
                        <div class="stats-icon bg-info">
                            <i class="bx bx-user"></i>
                        </div>
                        <div class="stats-number"><?php echo e($stats['assigned_to_me']); ?></div>
                        <div class="stats-title"><?php echo e(__('My Assigned')); ?></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card stats-card">
                    <div class="card-body text-center">
                        <div class="stats-icon bg-warning">
                            <i class="bx bx-user-x"></i>
                        </div>
                        <div class="stats-number"><?php echo e($stats['unassigned']); ?></div>
                        <div class="stats-title"><?php echo e(__('Unassigned')); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Desktop Table -->
        <div class="card d-none d-lg-block">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><?php echo e(__('Support Tickets Management')); ?></h5>
                    <div class="d-flex gap-2">
                        <button class="btn btn-success btn-sm" data-bs-toggle="offcanvas" data-bs-target="#createTicketOffcanvas">
                            <i class="bx bx-plus me-2"></i><?php echo e(__('Create Ticket')); ?>

                        </button>
                        <button class="btn btn-primary btn-sm" onclick="refreshData()">
                            <i class="bx bx-refresh me-2"></i><?php echo e(__('Refresh')); ?>

                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <!-- Filters -->
                <div class="row mb-3">
                    <div class="col-md-2">
                        <select class="form-select form-select-sm" id="statusFilter">
                            <option value=""><?php echo e(__('All Status')); ?></option>
                            <option value="open"><?php echo e(__('Open')); ?></option>
                            <option value="in_progress"><?php echo e(__('In Progress')); ?></option>
                            <option value="waiting_user"><?php echo e(__('Waiting User')); ?></option>
                            <option value="waiting_admin"><?php echo e(__('Waiting Admin')); ?></option>
                            <option value="resolved"><?php echo e(__('Resolved')); ?></option>
                            <option value="closed"><?php echo e(__('Closed')); ?></option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <select class="form-select form-select-sm" id="priorityFilter">
                            <option value=""><?php echo e(__('All Priorities')); ?></option>
                            <option value="urgent"><?php echo e(__('Urgent')); ?></option>
                            <option value="high"><?php echo e(__('High')); ?></option>
                            <option value="medium"><?php echo e(__('Medium')); ?></option>
                            <option value="low"><?php echo e(__('Low')); ?></option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <select class="form-select form-select-sm" id="categoryFilter">
                            <option value=""><?php echo e(__('All Categories')); ?></option>
                            <option value="general"><?php echo e(__('General')); ?></option>
                            <option value="technical"><?php echo e(__('Technical')); ?></option>
                            <option value="billing"><?php echo e(__('Billing')); ?></option>
                            <option value="account"><?php echo e(__('Account')); ?></option>
                            <option value="withdrawal"><?php echo e(__('Withdrawal')); ?></option>
                            <option value="task"><?php echo e(__('Task')); ?></option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <select class="form-select form-select-sm" id="assignedFilter">
                            <option value=""><?php echo e(__('All Assignments')); ?></option>
                            <option value="me"><?php echo e(__('Assigned to Me')); ?></option>
                            <option value="unassigned"><?php echo e(__('Unassigned')); ?></option>
                        </select>
                    </div>
                </div>

                <!-- DataTable -->
                <div class="table-responsive">
                    <table id="ticketsTable" class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo e(__('User')); ?></th>
                                <th><?php echo e(__('Ticket')); ?></th>
                                <th><?php echo e(__('Category')); ?></th>
                                <th><?php echo e(__('Priority')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th><?php echo e(__('Assigned To')); ?></th>
                                <th><?php echo e(__('Last Activity')); ?></th>
                                <th><?php echo e(__('Actions')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- DataTable will populate this -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Mobile Cards -->
        <div class="d-lg-none">
            <div class="mobile-header mb-3">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><?php echo e(__('Support Tickets')); ?></h5>
                    <button class="btn btn-primary btn-sm" onclick="refreshMobileData()">
                        <i class="bx bx-refresh"></i>
                    </button>
                </div>
            </div>

            <!-- Mobile Filters -->
            <div class="row mb-3">
                <div class="col-6">
                    <select class="form-select form-select-sm" id="statusFilterMobile">
                        <option value=""><?php echo e(__('All Status')); ?></option>
                        <option value="open"><?php echo e(__('Open')); ?></option>
                        <option value="closed"><?php echo e(__('Closed')); ?></option>
                        <option value="urgent"><?php echo e(__('Urgent')); ?></option>
                    </select>
                </div>
                <div class="col-6">
                    <select class="form-select form-select-sm" id="assignedFilterMobile">
                        <option value=""><?php echo e(__('All')); ?></option>
                        <option value="me"><?php echo e(__('Mine')); ?></option>
                        <option value="unassigned"><?php echo e(__('Unassigned')); ?></option>
                    </select>
                </div>
            </div>

            <!-- Mobile Container -->
            <div id="mobileTicketsContainer">
                <!-- Mobile cards will be loaded here -->
            </div>

            <div class="text-center mt-3">
                <button class="btn btn-outline-primary" id="loadMoreBtn" onclick="loadMoreMobileData()">
                    <i class="bx bx-loader-alt bx-spin d-none" id="loadMoreSpinner"></i>
                    <?php echo e(__('Load More')); ?>

                </button>
            </div>
        </div>
    </div>
</div>

<!-- Create Ticket Offcanvas -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="createTicketOffcanvas" aria-labelledby="createTicketOffcanvasLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="createTicketOffcanvasLabel"><?php echo e(__('Create New Ticket')); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <form id="createTicketForm">
            <?php echo csrf_field(); ?>
            
            <!-- User Selection -->
            <div class="mb-3">
                <label for="ticketUserId" class="form-label"><?php echo e(__('Select User')); ?> <span class="text-danger">*</span></label>
                <select class="form-select" id="ticketUserId" name="user_id" required>
                    <option value=""><?php echo e(__('Search and select user...')); ?></option>
                </select>
                <div class="form-text"><?php echo e(__('Type to search users by name or email')); ?></div>
            </div>

            <!-- Subject -->
            <div class="mb-3">
                <label for="ticketSubject" class="form-label"><?php echo e(__('Subject')); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="ticketSubject" name="subject" required maxlength="255">
                <div class="form-text"><?php echo e(__('Brief description of the issue')); ?></div>
            </div>

            <!-- Category -->
            <div class="mb-3">
                <label for="ticketCategory" class="form-label"><?php echo e(__('Category')); ?> <span class="text-danger">*</span></label>
                <select class="form-select" id="ticketCategory" name="category" required>
                    <option value=""><?php echo e(__('Select Category')); ?></option>
                    <option value="general"><?php echo e(__('General')); ?></option>
                    <option value="technical"><?php echo e(__('Technical')); ?></option>
                    <option value="billing"><?php echo e(__('Billing')); ?></option>
                    <option value="account"><?php echo e(__('Account')); ?></option>
                    <option value="withdrawal"><?php echo e(__('Withdrawal')); ?></option>
                    <option value="task"><?php echo e(__('Task')); ?></option>
                </select>
            </div>

            <!-- Priority -->
            <div class="mb-3">
                <label for="ticketPriority" class="form-label"><?php echo e(__('Priority')); ?> <span class="text-danger">*</span></label>
                <select class="form-select" id="ticketPriority" name="priority" required>
                    <option value=""><?php echo e(__('Select Priority')); ?></option>
                    <option value="low"><?php echo e(__('Low')); ?></option>
                    <option value="medium"><?php echo e(__('Medium')); ?></option>
                    <option value="high"><?php echo e(__('High')); ?></option>
                    <option value="urgent"><?php echo e(__('Urgent')); ?></option>
                </select>
            </div>

            <!-- Description -->
            <div class="mb-3">
                <label for="ticketDescription" class="form-label"><?php echo e(__('Description')); ?> <span class="text-danger">*</span></label>
                <textarea class="form-control" id="ticketDescription" name="description" rows="4" required maxlength="5000" placeholder="<?php echo e(__('Detailed description of the issue...')); ?>"></textarea>
                <div class="form-text"><?php echo e(__('Remaining characters')); ?>: <span id="descCharCount">5000</span></div>
            </div>

            <!-- Attachments -->
            <div class="mb-3">
                <label for="ticketAttachments" class="form-label"><?php echo e(__('Attachments')); ?> <span class="text-muted">(<?php echo e(__('Optional')); ?>)</span></label>
                <input type="file" class="form-control" id="ticketAttachments" name="attachments[]" multiple accept=".jpg,.jpeg,.png,.pdf,.doc,.docx,.txt">
                <div class="form-text"><?php echo e(__('Max file size: 10MB')); ?> | <?php echo e(__('Allowed formats: JPG, PNG, PDF, DOC, TXT')); ?></div>
                <div id="ticketFilePreview" class="mt-2"></div>
            </div>

            <!-- Assign to me -->
            <div class="mb-3">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="assignToMe" name="assign_to_me" value="1">
                    <label class="form-check-label" for="assignToMe">
                        <?php echo e(__('Assign this ticket to me')); ?>

                    </label>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="d-grid">
                <button type="submit" class="btn btn-primary" id="createTicketBtn">
                    <i class="bx bx-plus me-2"></i><?php echo e(__('Create Ticket')); ?>

                    <span class="spinner-border spinner-border-sm ms-2 d-none" id="createTicketSpinner"></span>
                </button>
            </div>
        </form>
    </div>
</div>

<?php $__env->startSection('script'); ?>

<script>
$(document).ready(function() {
    // Check if table exists
    if ($('#ticketsTable').length === 0) {
        console.error('Table #ticketsTable not found!');
        return;
    }
    
    // Initialize DataTable
    let ticketsTable = $('#ticketsTable').DataTable({
        processing: true,
        serverSide: true,
        destroy: true,
        ajax: {
            url: '<?php echo e(route('api.admin.tickets.datatable')); ?>',
            type: 'GET',
            data: function(d) {
                d.status = $('#statusFilter').val();
                d.priority = $('#priorityFilter').val();
                d.category = $('#categoryFilter').val();
                d.assigned = $('#assignedFilter').val();
            },
            error: function(xhr, error, thrown) {
                Lobibox.notify('error', {
                    title: '<?php echo e(__('Error')); ?>',
                    msg: '<?php echo e(__('Error loading data')); ?>: ' + xhr.status,
                    sound: false
                });
            },
            dataSrc: function(json) {
                if (!json.data) {
                    console.error('Invalid response format:', json);
                    return [];
                }
                return json.data;
            }
        },
        columns: [
            { 
                data: 'user_name', 
                name: 'user_name',
                render: function(data, type, row) {
                    return `
                        <div class="user-info">
                            <div class="user-avatar">
                                ${data.charAt(0).toUpperCase()}
                            </div>
                            <div class="user-details">
                                <div class="user-name">${data}</div>
                                <div class="user-email">${row.user_email}</div>
                            </div>
                        </div>
                    `;
                }
            },
            { 
                data: 'ticket_number', 
                name: 'ticket_number',
                render: function(data, type, row) {
                    const unreadBadge = row.unread_count > 0 ? 
                        `<span class="badge bg-danger ms-2">${row.unread_count}</span>` : '';
                    
                    return `
                        <div class="ticket-info">
                            <div class="ticket-number">
                                ${data} ${unreadBadge}
                            </div>
                            <div class="ticket-subject">
                                <a href="/tickets/${row.id}" class="text-decoration-none">
                                    ${row.subject.length > 40 ? row.subject.substring(0, 40) + '...' : row.subject}
                                </a>
                            </div>
                        </div>
                    `;
                }
            },
            { 
                data: 'category_text', 
                name: 'category',
                render: function(data) {
                    return `<span class="badge bg-secondary">${data}</span>`;
                }
            },
            { 
                data: 'priority_text', 
                name: 'priority',
                render: function(data, type, row) {
                    return `<span class="badge bg-${row.priority_badge}">${data}</span>`;
                }
            },
            { 
                data: 'status_text', 
                name: 'status',
                render: function(data, type, row) {
                    return `<span class="badge bg-${row.status_badge}">${data}</span>`;
                }
            },
            { 
                data: 'assigned_to', 
                name: 'assigned_to',
                render: function(data) {
                    return data || '<span class="text-muted"><?php echo e(__('Unassigned')); ?></span>';
                }
            },
            { 
                data: 'last_activity_at', 
                name: 'last_activity_at'
            },
            { 
                data: 'id', 
                name: 'actions',
                orderable: false,
                searchable: false,
                width: '120px',
                render: function(data, type, row) {
                    const priorityColor = row.priority === 'urgent' ? 'danger' : 
                                        row.priority === 'high' ? 'warning' : 'primary';
                    
                    return `
                        <div class="d-flex gap-1 justify-content-center">
                            <a href="/tickets/${data}" class="btn btn-sm btn-${priorityColor}" title="<?php echo e(__('View Details')); ?>" data-bs-toggle="tooltip">
                                <i class="bx bx-show me-1"></i><?php echo e(__('View')); ?>

                            </a>
                        </div>
                    `;
                }
            }
        ],
        order: [[6, 'desc']], // Order by last activity desc
        pageLength: 25,
        responsive: true,
        language: {
            processing: "<?php echo e(__('Processing...')); ?>",
            search: "<?php echo e(__('Search:')); ?>",
            lengthMenu: "<?php echo e(__('Show _MENU_ entries')); ?>",
            info: "<?php echo e(__('Showing _START_ to _END_ of _TOTAL_ entries')); ?>",
            infoEmpty: "<?php echo e(__('Showing 0 to 0 of 0 entries')); ?>",
            infoFiltered: "<?php echo e(__('(filtered from _MAX_ total entries)')); ?>",
            paginate: {
                first: "<?php echo e(__('First')); ?>",
                last: "<?php echo e(__('Last')); ?>",
                next: "<?php echo e(__('Next')); ?>",
                previous: "<?php echo e(__('Previous')); ?>"
            }
        }
    });

    // Filter change handlers
    $('#statusFilter, #priorityFilter, #categoryFilter, #assignedFilter').on('change', function() {
        ticketsTable.ajax.reload();
    });
    
    // Initialize tooltips after table draw
    ticketsTable.on('draw', function() {
        $('[data-bs-toggle="tooltip"]').tooltip();
    });

    // Mobile initialization
    if (window.innerWidth < 992) {
        loadMobileData();
    }

    // Mobile filters
    $('#statusFilterMobile, #assignedFilterMobile').on('change', function() {
        mobileCurrentPage = 0;
        mobileHasMore = true;
        loadMobileData(true);
    });
});

// Mobile variables
let mobileCurrentPage = 0;
let mobileHasMore = true;

function loadMobileData(reset = false) {
    if (reset) {
        $('#mobileTicketsContainer').empty();
        mobileCurrentPage = 0;
    }

    $('#loadMoreSpinner').removeClass('d-none');
    $('#loadMoreBtn').prop('disabled', true);

    const status = $('#statusFilterMobile').val();
    const assigned = $('#assignedFilterMobile').val();

    $.ajax({
        url: '<?php echo e(route('api.admin.tickets.datatable')); ?>',
        method: 'GET',
        data: {
            start: mobileCurrentPage * 10,
            length: 10,
            status: status,
            assigned: assigned
        },
        success: function(response) {
            if (response.data && response.data.length > 0) {
                response.data.forEach(function(ticket) {
                    const card = createMobileTicketCard(ticket);
                    $('#mobileTicketsContainer').append(card);
                });
                mobileCurrentPage++;
                mobileHasMore = response.data.length === 10;
            } else {
                mobileHasMore = false;
                if (mobileCurrentPage === 0) {
                    $('#mobileTicketsContainer').html(`
                        <div class="text-center py-5">
                            <i class="bx bx-inbox display-1 text-muted"></i>
                            <h6 class="mt-3"><?php echo e(__('No tickets found')); ?></h6>
                        </div>
                    `);
                }
            }
            
            $('#loadMoreBtn').toggle(mobileHasMore);
        },
        error: function() {
            Lobibox.notify('error', {
                title: '<?php echo e(__('Error')); ?>',
                msg: '<?php echo e(__('Error loading mobile data')); ?>',
                sound: false
            });
        },
        complete: function() {
            $('#loadMoreSpinner').addClass('d-none');
            $('#loadMoreBtn').prop('disabled', false);
        }
    });
}

function createMobileTicketCard(ticket) {
    const priorityClass = ticket.priority === 'urgent' ? 'urgent' : ticket.priority === 'high' ? 'high' : '';
    const unreadBadge = ticket.unread_count > 0 ? 
        `<div class="mobile-unread-badge">${ticket.unread_count}</div>` : '';

    return `
        <div class="mobile-ticket-card ${priorityClass}" onclick="window.location.href='/tickets/${ticket.id}'">
            <div class="mobile-ticket-header">
                <div class="mobile-ticket-number">${ticket.ticket_number}</div>
                ${unreadBadge}
            </div>
            
            <div class="mobile-ticket-subject">${ticket.subject}</div>
            <div class="mobile-ticket-user">👤 ${ticket.user_name}</div>
            
            <div class="mobile-ticket-meta">
                <span class="badge bg-secondary">${ticket.category_text}</span>
                <span class="badge bg-${ticket.priority_badge}">${ticket.priority_text}</span>
                <span class="badge bg-${ticket.status_badge}">${ticket.status_text}</span>
            </div>
            
            <div class="mobile-ticket-footer">
                <div class="mobile-ticket-time">${ticket.last_activity_at}</div>
                <div class="text-muted">
                    ${ticket.assigned_to ? '👤 ' + ticket.assigned_to : '<?php echo e(__('Unassigned')); ?>'}
                </div>
            </div>
        </div>
    `;
}

function loadMoreMobileData() {
    if (mobileHasMore) {
        loadMobileData();
    }
}

function refreshData() {
    $('#ticketsTable').DataTable().ajax.reload();
    Lobibox.notify('info', {
        title: '<?php echo e(__('Info')); ?>',
        msg: '<?php echo e(__('Data refreshed successfully')); ?>',
        sound: false
    });
}

function refreshMobileData() {
    mobileCurrentPage = 0;
    mobileHasMore = true;
    loadMobileData(true);
    Lobibox.notify('info', {
        title: '<?php echo e(__('Info')); ?>',
        msg: '<?php echo e(__('Data refreshed successfully')); ?>',
        sound: false
    });
}

// Initialize when offcanvas is shown
$('#createTicketOffcanvas').on('shown.bs.offcanvas', function() {
    // Character counter for description
    $('#ticketDescription').on('input', function() {
        const remaining = 5000 - $(this).val().length;
        $('#descCharCount').text(remaining);
        
        if (remaining < 100) {
            $('#descCharCount').addClass('text-danger');
        } else {
            $('#descCharCount').removeClass('text-danger');
        }
    });
    
    // Initialize Select2 when offcanvas is shown
    if (!$('#ticketUserId').hasClass('select2-hidden-accessible')) {
        $('#ticketUserId').select2({
            theme: 'bootstrap-5',
            ajax: {
                url: '/api/users/search',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        q: params.term,
                        page: params.page
                    };
                },
                processResults: function (data, params) {
                    params.page = params.page || 1;
                    return {
                        results: data.data.map(function(user) {
                            const displayText = user.account_holder + ' (' + user.email + ')' + 
                                              (user.phone ? ' - ' + user.phone : '');
                            return {
                                id: user.id,
                                text: displayText
                            };
                        }),
                        pagination: {
                            more: data.has_more
                        }
                    };
                },
                cache: true
            },
            placeholder: '<?php echo e(__('Search users...')); ?>',
            minimumInputLength: 2,
            dropdownParent: $('#createTicketOffcanvas')
        });
    }
});


// Create ticket form submission
$('#createTicketForm').on('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    $('#createTicketBtn').prop('disabled', true);
    $('#createTicketSpinner').removeClass('d-none');
    
    $.ajax({
        url: '<?php echo e(route('admin.tickets.store')); ?>',
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            if (response.success) {
                Lobibox.notify('success', {
                    title: '<?php echo e(__('Success')); ?>',
                    msg: response.message,
                    sound: false
                });
                
                // Close offcanvas
                $('#createTicketOffcanvas').offcanvas('hide');
                
                // Reset form
                $('#createTicketForm')[0].reset();
                $('#ticketUserId').val(null).trigger('change');
                $('#ticketFilePreview').empty();
                $('#descCharCount').text('5000').removeClass('text-danger');
                
                // Reload table
                $('#ticketsTable').DataTable().ajax.reload();
            } else {
                Lobibox.notify('error', {
                    title: '<?php echo e(__('Error')); ?>',
                    msg: response.message,
                    sound: false
                });
            }
        },
        error: function(xhr) {
            if (xhr.status === 422) {
                const errors = xhr.responseJSON?.errors;
                let errorMsg = '<?php echo e(__('Please check your input and try again.')); ?>';
                if (errors) {
                    const firstError = Object.values(errors)[0];
                    if (firstError && firstError[0]) {
                        errorMsg = firstError[0];
                    }
                }
                Lobibox.notify('error', {
                    title: '<?php echo e(__('Validation Error')); ?>',
                    msg: errorMsg,
                    sound: false
                });
            } else {
                Lobibox.notify('error', {
                    title: '<?php echo e(__('Error')); ?>',
                    msg: '<?php echo e(__('Error creating ticket')); ?>',
                    sound: false
                });
            }
        },
        complete: function() {
            $('#createTicketBtn').prop('disabled', false);
            $('#createTicketSpinner').addClass('d-none');
        }
    });
});
</script>

<script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/responsive.bootstrap5.min.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/tickets/admin/index.blade.php ENDPATH**/ ?>