<?php $__env->startSection('title', __('Website Visit Tasks')); ?>

<?php $__env->startSection('style'); ?>
    <link href="<?php echo e(asset('assets/plugins/notifications/css/lobibox.min.css')); ?>" rel="stylesheet">
    <style>
        .task-card {
            transition: transform 0.2s;
            border: 1px solid #e3e6f0;
        }
        .task-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .visit-method-badge {
            font-size: 0.75rem;
        }
        .progress-small {
            height: 6px;
        }
        .timer-display {
            font-family: 'Courier New', monospace;
            font-weight: bold;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Website Visit Tasks')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Visit & Earn')); ?></li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <?php if(auth()->user()->isAdmin()): ?>
                    <a href="<?php echo e(route('admin.website-visits.index')); ?>" class="btn btn-info me-2">
                        <i class='bx bx-cog me-1'></i><?php echo e(__('Admin Panel')); ?>

                    </a>
                <?php endif; ?>
                <a href="<?php echo e(route('user.website-visits.index')); ?>" class="btn btn-secondary me-2">
                    <i class='bx bx-list-ul me-1'></i><?php echo e(__('My Tasks')); ?>

                </a>
                <a href="<?php echo e(route('user.website-visits.create')); ?>" class="btn btn-primary">
                    <i class='bx bx-plus me-1'></i><?php echo e(__('Add New Task')); ?>

                </a>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class='bx bx-globe me-2'></i><?php echo e(__('Available Website Visit Tasks')); ?>

                            <span class="badge bg-primary ms-2"><?php echo e($tasks->count()); ?></span>
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php if($tasks->count() > 0): ?>
                            <div class="row">
                                <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-6 col-xl-4 mb-4">
                                    <div class="card task-card h-100">
                                        <div class="card-header pb-2">
                                            <div class="d-flex justify-content-between align-items-start">
                                                <h6 class="mb-1 text-white"><?php echo e(Str::limit($task->title, 30)); ?></h6>
                                                <span class="badge bg-<?php echo e($task->visit_method === 'direct' ? 'info' : 'warning'); ?> visit-method-badge">
                                                    <?php echo e($task->visit_method === 'direct' ? __('Direct Visit') : __('Google Search')); ?>

                                                </span>
                                            </div>
                                        </div>
                                        <div class="card-body pt-2">
                                            <p class="text-muted small mb-2"><?php echo e(Str::limit($task->description, 80)); ?></p>
                                            
                                            <!-- Task Info -->
                                            <div class="mb-3">
                                                <div class="d-flex justify-content-between align-items-center mb-1">
                                                    <small class="text-muted">
                                                        <i class='bx bx-time me-1'></i><?php echo e($task->required_time); ?><?php echo e(__('s')); ?>

                                                    </small>
                                                    <small class="text-success fw-bold">
                                                        <i class='bx bx-money me-1'></i><?php echo e($task->reward_amount); ?>₺
                                                    </small>
                                                </div>
                                                
                                                <!-- Progress -->
                                                <div class="progress progress-small mb-2">
                                                    <div class="progress-bar bg-success" 
                                                         style="width: <?php echo e($task->getCompletionPercentage()); ?>%">
                                                    </div>
                                                </div>
                                                <div class="d-flex justify-content-between">
                                                    <small class="text-muted">
                                                        <?php echo e($task->completedVisits()->count()); ?>/<?php echo e($task->max_completions); ?> <?php echo e(__('completed')); ?>

                                                    </small>
                                                    <small class="text-muted">
                                                        <?php echo e($task->getRemainingCompletions()); ?> <?php echo e(__('remaining')); ?>

                                                    </small>
                                                </div>
                                            </div>

                                            <!-- User Stats -->
                                            <div class="mb-3">
                                                <div class="row text-center">
                                                    <div class="col-6">
                                                        <div class="border-end">
                                                            <h6 class="mb-0 text-primary"><?php echo e($task->user_today_count); ?></h6>
                                                            <small class="text-muted"><?php echo e(__('Today')); ?></small>
                                                        </div>
                                                    </div>
                                                    <div class="col-6">
                                                        <h6 class="mb-0 text-info"><?php echo e($task->user_total_count); ?></h6>
                                                        <small class="text-muted"><?php echo e(__('Total')); ?></small>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Limits Info -->
                                            <div class="mb-3">
                                                <small class="text-muted d-block">
                                                    <i class='bx bx-calendar me-1'></i><?php echo e(__('Daily limit')); ?>: <?php echo e($task->user_daily_limit); ?>

                                                </small>
                                                <small class="text-muted d-block">
                                                    <i class='bx bx-repeat me-1'></i><?php echo e(__('Total limit')); ?>: <?php echo e($task->user_total_limit); ?>

                                                </small>
                                            </div>

                                            <!-- Website Info -->
                                            <div class="mb-3">
                                                <small class="text-muted d-block">
                                                    <i class='bx bx-link me-1'></i><?php echo e(parse_url($task->website_url, PHP_URL_HOST)); ?>

                                                </small>
                                                <?php if($task->visit_method === 'google_search'): ?>
                                                <small class="text-muted d-block">
                                                    <i class='bx bx-search me-1'></i><?php echo e($task->search_keywords); ?>

                                                </small>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="card-footer">
                                            <?php if($task->user_can_complete): ?>
                                                <div class="d-grid gap-2">
                                                    <button class="btn btn-success start-visit-btn" 
                                                            data-task-id="<?php echo e($task->id); ?>"
                                                            data-required-time="<?php echo e($task->required_time); ?>">
                                                        <i class='bx bx-play me-1'></i><?php echo e(__('Start Visit')); ?>

                                                    </button>
                                                    
                                                    <!-- Show progress button if visit is active -->
                                                    <button type="button" class="btn btn-info btn-sm d-none" id="showProgressBtn-<?php echo e($task->id); ?>" onclick="reopenProgressModal()">
                                                        <i class='bx bx-time me-1'></i><?php echo e(__('Show Progress')); ?>

                                                    </button>
                                                </div>
                                            <?php else: ?>
                                                <button class="btn btn-secondary w-100" disabled>
                                                    <i class='bx bx-lock me-1'></i><?php echo e(__('Limit Reached')); ?>

                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <i class='bx bx-globe display-4 text-muted'></i>
                                <h5 class="mt-3 text-muted"><?php echo e(__('No website visit tasks available')); ?></h5>
                                <p class="text-muted"><?php echo e(__('Check back later for new tasks')); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Visit Progress Modal -->
<div class="modal fade" id="visitProgressModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class='bx bx-time me-2'></i><?php echo e(__('Visit in Progress')); ?>

                </h5>
            </div>
            <div class="modal-body text-center">
                <div class="mb-4">
                    <div class="timer-display display-4 text-primary" id="timerDisplay">00:00</div>
                    <p class="text-muted"><?php echo e(__('Time spent on website')); ?></p>
                </div>
                
                <div class="progress mb-3" style="height: 10px;">
                    <div class="progress-bar bg-success" id="progressBar" style="width: 0%"></div>
                </div>
                
                <p class="text-muted mb-4">
                    <?php echo e(__('Required time')); ?>: <span id="requiredTime">0</span><?php echo e(__('s')); ?>

                </p>
                
                <div class="alert alert-info">
                    <i class='bx bx-info-circle me-2'></i>
                    <?php echo e(__('Keep the website tab open and stay on the page to complete the task.')); ?>

                </div>
                
                <!-- Proof Requirements -->
                <div class="alert alert-warning d-none" id="proofRequirement">
                    <i class='bx bx-camera me-2'></i>
                    <strong><?php echo e(__('Proof Required')); ?></strong><br>
                    <?php echo e(__('After completing the required time, you may need to provide a screenshot as proof of your visit.')); ?>

                </div>
                
                <!-- Visit Status Area -->
                <div id="visitStatus"></div>
                
                <!-- Window Status Alert -->
                <div class="alert alert-danger d-none" id="windowClosedAlert">
                    <i class='bx bx-error-circle me-2'></i>
                    <strong><?php echo e(__('Warning!')); ?></strong><br>
                    <?php echo e(__('The website tab was closed. You need to keep the website open to complete the task.')); ?><br><br>
                    <button class="btn btn-primary btn-sm" onclick="reopenWebsite()">
                        <i class='bx bx-refresh me-1'></i><?php echo e(__('Reopen Website')); ?>

                    </button>
                    <button class="btn btn-danger btn-sm ms-2" onclick="cancelVisit()">
                        <i class='bx bx-x me-1'></i><?php echo e(__('Cancel Task')); ?>

                    </button>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" id="cancelTaskBtn">
                    <i class='bx bx-x me-1'></i><?php echo e(__('Cancel Task')); ?>

                </button>
                <button type="button" class="btn btn-secondary" id="cancelVisitBtn">
                    <?php echo e(__('Close')); ?>

                </button>
                <button type="button" class="btn btn-success" id="completeVisitBtn" disabled>
                    <i class='bx bx-check me-1'></i><?php echo e(__('Complete Visit')); ?>

                </button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <!--notification js -->
    <script src="<?php echo e(asset('assets/plugins/notifications/js/lobibox.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/notifications/js/notifications.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/notifications/js/notification-custom-script.js')); ?>"></script>

    <script>
    let currentVisit = null;
    let visitTimer = null;
    let visitWindow = null;
    let startTime = null;
    let requiredTime = 0;
    let trackingInterval = null;
    let windowCheckInterval = null;

    $(document).ready(function() {
        // Sayfa yüklendiğinde aktif görevleri kontrol et
        checkActiveTasksOnLoad();
        
        // Start visit button click
        $('.start-visit-btn').on('click', function() {
            const taskId = $(this).data('task-id');
            requiredTime = $(this).data('required-time');
            startVisit(taskId);
        });

        // Complete visit button click
        $('#completeVisitBtn').on('click', function() {
            if (currentVisit) {
                completeVisit(currentVisit.id);
            }
        });

        // Cancel visit button click (sadece modal'ı kapat)
        $('#cancelVisitBtn').on('click', function() {
            $('#visitProgressModal').modal('hide');
        });

        // Cancel task button click (görevi tamamen iptal et)
        $('#cancelTaskBtn').on('click', function() {
            if (confirm('<?php echo e(__("Are you sure you want to cancel this task? This action cannot be undone.")); ?>')) {
                cancelTask();
            }
        });
    });

    function startVisit(taskId) {
        // localStorage'da aktif görev var mı kontrol et
        const activeTask = localStorage.getItem('activeWebsiteVisit');
        if (activeTask) {
            const taskData = JSON.parse(activeTask);
            if (taskData.taskId === taskId) {
                // Aynı görev devam ediyor
                resumeExistingTask(taskData);
                return;
            } else {
                // Farklı görev varsa eski görevi temizle
                localStorage.removeItem('activeWebsiteVisit');
            }
        }

        $.ajax({
            url: `<?php echo e(url('/website-visits')); ?>/${taskId}/start`,
            type: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'X-Requested-With': 'XMLHttpRequest'
            },
            success: function(response) {
                if (response.success) {
                    // localStorage'a kaydet
                    const taskData = {
                        visitId: response.visit_id,
                        taskId: taskId,
                        requiredTime: response.required_time,
                        startTime: Date.now(),
                        token: response.verification_token
                    };
                    localStorage.setItem('activeWebsiteVisit', JSON.stringify(taskData));
                    
                    currentVisit = {
                        id: response.visit_id,
                        token: response.verification_token,
                        taskId: taskId,
                        originalUrl: response.visit_url
                    };
                    
                    // Open website in new tab
                    visitWindow = window.open(response.visit_url, '_blank');
                    
                    // Show progress modal
                    $('#visitProgressModal').modal('show');
                    $('#requiredTime').text(response.required_time);
                    
                    // Start timer
                    startTimer(response.required_time);
                    
                    // Start tracking
                    startTracking();
                    
                    // Show progress button and hide start button
                    $(`.start-visit-btn[data-task-id="${taskId}"]`).addClass('d-none');
                    $(`#showProgressBtn-${taskId}`).removeClass('d-none');
                } else {
                    showNotification('error', '<?php echo e(__("Error")); ?>', response.message);
                }
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || '<?php echo e(__("An error occurred")); ?>';
                showNotification('error', '<?php echo e(__("Error")); ?>', message);
            }
        });
    }

    function resumeExistingTask(taskData) {
        // Mevcut görevi devam ettir
        currentVisit = {
            id: taskData.visitId,
            taskId: taskData.taskId,
            token: taskData.token
        };
        
        const elapsedSeconds = Math.floor((Date.now() - taskData.startTime) / 1000);
        startTime = taskData.startTime;
        requiredTime = taskData.requiredTime;
        
        // Show progress modal
        $('#visitProgressModal').modal('show');
        $('#requiredTime').text(taskData.requiredTime);
        
        // Resume timer from elapsed time
        resumeTimer(elapsedSeconds);
        startTracking();
        
        showNotification('info', '<?php echo e(__("Info")); ?>', '<?php echo e(__("Resuming existing task...")); ?>');
        
        // Butonları güncelle
        updateTaskButtons(taskData.taskId);
    }

    function checkActiveTasksOnLoad() {
        // localStorage'dan aktif görev kontrol et
        const activeTask = localStorage.getItem('activeWebsiteVisit');
        if (activeTask) {
            try {
                const taskData = JSON.parse(activeTask);
                updateTaskButtons(taskData.taskId);
            } catch (e) {
                // Bozuk veri varsa temizle
                localStorage.removeItem('activeWebsiteVisit');
            }
        }
    }

    function updateTaskButtons(activeTaskId) {
        // Tüm butonları normale döndür
        $('.start-visit-btn').each(function() {
            const $btn = $(this);
            const taskId = $btn.data('task-id');
            
            // Buton stilini ve içeriğini sıfırla
            $btn.removeClass('btn-info').addClass('btn-success');
            $btn.html('<i class="bx bx-play me-1"></i><?php echo e(__("Start Visit")); ?>');
            
            // Event'i sıfırla
            $btn.off('click').on('click', function() {
                const taskId = $(this).data('task-id');
                const requiredTime = $(this).data('required-time');
                startVisit(taskId);
            });
        });
        
        $('[id^="showProgressBtn-"]').addClass('d-none');
        
        // Aktif görevin butonunu güncelle
        if (activeTaskId) {
            const startBtn = $(`.start-visit-btn[data-task-id="${activeTaskId}"]`);
            
            // Start butonunu "İlerlemeyi Göster" olarak değiştir
            startBtn.removeClass('btn-success').addClass('btn-info');
            startBtn.html('<i class="bx bx-time me-1"></i><?php echo e(__("Show Progress")); ?>');
            
            // Onclick event'ini değiştir
            startBtn.off('click').on('click', function() {
                reopenProgressModal();
            });
        }
    }

    function startTimer(requiredSeconds) {
        startTime = Date.now();
        requiredTime = requiredSeconds;
        
        // Timer artık sadece görsel amaçlı, gerçek zaman server'dan gelecek
        visitTimer = setInterval(function() {
            const elapsed = Math.floor((Date.now() - startTime) / 1000);
            
            // Sadece server tracking'i arasında görsel güncelleme
            if (elapsed % 5 !== 0) { // Server her 5 saniyede güncellediği için
                const minutes = Math.floor(elapsed / 60);
                const seconds = elapsed % 60;
                
                $('#timerDisplay').text(
                    String(minutes).padStart(2, '0') + ':' + 
                    String(seconds).padStart(2, '0')
                );
                
                const progress = Math.min((elapsed / requiredTime) * 100, 100);
                $('#progressBar').css('width', progress + '%');
                
                if (elapsed >= requiredTime) {
                    $('#completeVisitBtn').prop('disabled', false);
                    $('#progressBar').removeClass('bg-primary').addClass('bg-success');
                }
            }
        }, 1000);
    }

    function startTracking() {
        if (!currentVisit) return;
        
        // Track visit progress every 5 seconds - ARKA PLANDA SÜREKLI ÇALIŞSIN
        trackingInterval = setInterval(function() {
            if (!currentVisit) {
                clearInterval(trackingInterval);
                return;
            }
            
            $.ajax({
                url: `/website-visits/track/${currentVisit.id}`,
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'X-Requested-With': 'XMLHttpRequest'
                },
                success: function(response) {
                    if (response.success) {
                        // Update timer with server time - SADECE MODAL AÇIKSA
                        if ($('#visitProgressModal').hasClass('show')) {
                            const serverElapsed = response.elapsed_time;
                            const minutes = Math.floor(serverElapsed / 60);
                            const seconds = serverElapsed % 60;
                            
                            $('#timerDisplay').text(
                                String(minutes).padStart(2, '0') + ':' + 
                                String(seconds).padStart(2, '0')
                            );
                            
                            const progress = Math.min((serverElapsed / response.required_time) * 100, 100);
                            $('#progressBar').css('width', progress + '%');
                            
                            if (serverElapsed >= response.required_time) {
                                $('#completeVisitBtn').prop('disabled', false);
                                $('#progressBar').removeClass('bg-primary').addClass('bg-success');
                                
                                // Show completion message
                                $('#visitStatus').html('<div class="alert alert-success"><i class="bx bx-check-circle me-2"></i><?php echo e(__("Required time completed! You can now complete the visit.")); ?></div>');
                            }
                        }
                    }
                },
                error: function(xhr, status, error) {
                    // Handle tracking error - maybe window was closed
                    checkWindowStatus();
                }
            });
        }, 3000); // Track every 3 seconds for better accuracy
        
        // Check if window is still open every 5 seconds
        windowCheckInterval = setInterval(function() {
            checkWindowStatus();
        }, 5000);
    }
    
    function checkWindowStatus() {
        if (visitWindow && visitWindow.closed) {
            // Window was closed - notify server and show warning
            notifyWindowClosed();
            showWindowClosedWarning();
        }
    }
    
    function notifyWindowClosed() {
        if (!currentVisit) return;
        
        $.ajax({
            url: '<?php echo e(route("website-visits.window-close")); ?>',
            type: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'X-Requested-With': 'XMLHttpRequest'
            },
            data: {
                visit_id: currentVisit.id
            },
            success: function(response) {
                // Window close recorded
            }
        });
    }
    
    function showWindowClosedWarning() {
        if (!currentVisit) return;
        
        // Pause the timer
        if (visitTimer) {
            clearInterval(visitTimer);
        }
        
        // Show warning alert
        $('#windowClosedAlert').removeClass('d-none');
        $('#completeVisitBtn').prop('disabled', true);
    }
    
    function reopenWebsite() {
        if (!currentVisit) return;
        
        // Hide warning alert
        $('#windowClosedAlert').addClass('d-none');
        
        // Get the original task URL and reopen
        const taskId = currentVisit.taskId || $('.start-visit-btn').first().data('task-id');
        
        // Simply reopen the website window
        if (currentVisit.originalUrl) {
            visitWindow = window.open(currentVisit.originalUrl, '_blank');
        } else {
            // Fallback: get URL from server
            $.ajax({
                url: `<?php echo e(url('/website-visits')); ?>/${taskId}/start`,
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'X-Requested-With': 'XMLHttpRequest'
                },
                success: function(response) {
                    if (response.success) {
                        visitWindow = window.open(response.visit_url, '_blank');
                        currentVisit.originalUrl = response.visit_url;
                    }
                }
            });
        }
        
        // Resume timer
        const elapsed = Math.floor((Date.now() - startTime) / 1000);
        resumeTimer(elapsed);
        
        // Restart tracking
        startTracking();
        
        // Re-enable complete button if time is sufficient
        if (elapsed >= requiredTime) {
            $('#completeVisitBtn').prop('disabled', false);
        }
    }
    
    function resumeTimer(elapsedSeconds) {
        const resumeStartTime = Date.now();
        
        visitTimer = setInterval(function() {
            const currentElapsed = elapsedSeconds + Math.floor((Date.now() - resumeStartTime) / 1000);
            const minutes = Math.floor(currentElapsed / 60);
            const seconds = currentElapsed % 60;
            
            $('#timerDisplay').text(
                String(minutes).padStart(2, '0') + ':' + 
                String(seconds).padStart(2, '0')
            );
            
            const progress = Math.min((currentElapsed / requiredTime) * 100, 100);
            $('#progressBar').css('width', progress + '%');
            
            if (currentElapsed >= requiredTime) {
                $('#completeVisitBtn').prop('disabled', false);
                $('#progressBar').removeClass('bg-primary').addClass('bg-success');
            }
        }, 1000);
    }

    function completeVisit(visitId) {
        // localStorage'dan görev bilgilerini al
        const activeTask = localStorage.getItem('activeWebsiteVisit');
        if (!activeTask) {
            showNotification('error', '<?php echo e(__("Error")); ?>', '<?php echo e(__("No active task found")); ?>');
            return;
        }

        const taskData = JSON.parse(activeTask);
        const elapsedTime = Math.floor((Date.now() - taskData.startTime) / 1000);
        

        // Zaman kontrolü
        if (elapsedTime < taskData.requiredTime) {
            showNotification('error', '<?php echo e(__("Error")); ?>', 
                `<?php echo e(__("You need to spend at least")); ?> ${taskData.requiredTime} <?php echo e(__("seconds on the website. Current:")); ?> ${elapsedTime} <?php echo e(__("seconds")); ?>`);
            return;
        }
        
        $.ajax({
            url: `<?php echo e(url('/website-visits/complete')); ?>/${visitId}`,
            type: 'POST',
            data: {
                elapsed_time: elapsedTime,
                verification_token: taskData.token
            },
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'X-Requested-With': 'XMLHttpRequest'
            },
            success: function(response) {
                if (response.success) {
                    // localStorage'ı temizle
                    localStorage.removeItem('activeWebsiteVisit');
                    
                    if (response.requires_proof) {
                        // Show proof submission modal
                        showProofModal(response.visit_id, response.message);
                    } else {
                        showNotification('success', '<?php echo e(__("Success")); ?>', response.message);
                        $('#visitProgressModal').modal('hide');
                        resetVisit();
                        
                        // Reload page to update user stats
                        setTimeout(() => {
                            location.reload();
                        }, 2000);
                    }
                } else {
                    showNotification('error', '<?php echo e(__("Error")); ?>', response.message);
                }
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || '<?php echo e(__("An error occurred")); ?>';
                showNotification('error', '<?php echo e(__("Error")); ?>', message);
            }
        });
    }

    function cancelTask() {
        // localStorage'dan aktif görevi al
        const activeTask = localStorage.getItem('activeWebsiteVisit');
        if (!activeTask) {
            showNotification('error', '<?php echo e(__("Error")); ?>', '<?php echo e(__("No active task found")); ?>');
            return;
        }

        const taskData = JSON.parse(activeTask);
        
        // Sunucuya görevi iptal ettiğimizi bildir
        $.ajax({
            url: `/website-visits/cancel/${taskData.visitId}`,
            type: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'X-Requested-With': 'XMLHttpRequest'
            },
            success: function(response) {
                console.log('Task cancelled on server:', response);
            },
            error: function(xhr) {
                console.log('Error cancelling task on server:', xhr.responseText);
            }
        });

        // localStorage'ı temizle
        localStorage.removeItem('activeWebsiteVisit');
        
        // Modal'ı kapat ve visit'i resetle
        $('#visitProgressModal').modal('hide');
        resetVisit();
        
        // Başarı mesajı göster
        showNotification('success', '<?php echo e(__("Success")); ?>', '<?php echo e(__("Task cancelled successfully")); ?>');
        
        // Sayfa yenile
        setTimeout(() => {
            location.reload();
        }, 1500);
    }

    function resetVisit() {
        // Clear all intervals
        if (visitTimer) {
            clearInterval(visitTimer);
            visitTimer = null;
        }
        
        if (trackingInterval) {
            clearInterval(trackingInterval);
            trackingInterval = null;
        }
        
        if (windowCheckInterval) {
            clearInterval(windowCheckInterval);
            windowCheckInterval = null;
        }
        
        // Close window if still open
        if (visitWindow && !visitWindow.closed) {
            visitWindow.close();
        }
        
        // Reset variables
        currentVisit = null;
        startTime = null;
        visitWindow = null;
        
        // Reset UI
        $('#timerDisplay').text('00:00');
        $('#progressBar').css('width', '0%').removeClass('bg-success').addClass('bg-primary');
        $('#completeVisitBtn').prop('disabled', true);
        
        // Hide any warning messages
        $('#windowClosedAlert').addClass('d-none');
        
        // Reset buttons
        $('.start-visit-btn').removeClass('d-none');
        $('[id^="showProgressBtn-"]').addClass('d-none');
    }

    function showNotification(type, title, message) {
        Lobibox.notify(type, {
            pauseDelayOnHover: true,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            icon: type === 'success' ? 'bx bx-check-circle' : 'bx bx-x-circle',
            title: title,
            msg: message
        });
    }

    function showProofModal(visitId, message) {
        const proofModalHtml = `
            <div class="modal fade" id="proofSubmissionModal" tabindex="-1">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">
                                <i class='bx bx-camera me-2'></i><?php echo e(__('Submit Proof')); ?>

                            </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" title="<?php echo e(__('You can close this modal and continue browsing. The timer will continue in background.')); ?>"></button>
                        </div>
                        <div class="modal-body">
                            <div class="alert alert-success">
                                <i class='bx bx-check-circle me-2'></i>
                                ${message}
                            </div>
                            
                            <form id="proofSubmissionForm" enctype="multipart/form-data">
                                <input type="hidden" name="visit_id" value="${visitId}">
                                
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('Description')); ?></label>
                                    <textarea name="description" class="form-control" rows="3" 
                                        placeholder="<?php echo e(__('Describe what you did on the website...')); ?>" required></textarea>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('Screenshots')); ?> <span class="text-danger">*</span></label>
                                    <input type="file" name="proofs[]" class="form-control" 
                                        accept="image/*" multiple required>
                                    <div class="form-text">
                                        <?php echo e(__('Upload screenshots showing your visit to the website. Multiple files allowed.')); ?>

                                    </div>
                                </div>
                                
                                <div class="d-grid gap-2">
                                    <button type="submit" class="btn btn-primary">
                                        <i class='bx bx-upload me-2'></i><?php echo e(__('Submit Proof')); ?>

                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        // Remove existing proof modal if any
        $('#proofSubmissionModal').remove();
        
        // Add new modal to body
        $('body').append(proofModalHtml);
        
        // Hide progress modal and show proof modal
        $('#visitProgressModal').modal('hide');
        $('#proofSubmissionModal').modal('show');
        
        // Handle proof form submission
        $('#proofSubmissionForm').on('submit', function(e) {
            e.preventDefault();
            submitProof(this);
        });
    }
    
    function submitProof(form) {
        const formData = new FormData(form);
        const submitBtn = $(form).find('button[type="submit"]');
        
        submitBtn.prop('disabled', true).html('<i class="bx bx-loader-alt bx-spin me-2"></i><?php echo e(__("Submitting...")); ?>');
        
        $.ajax({
            url: '<?php echo e(route("website-visits.submit-proof")); ?>',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'X-Requested-With': 'XMLHttpRequest'
            },
            success: function(response) {
                if (response.success) {
                    showNotification('success', '<?php echo e(__("Success")); ?>', response.message);
                    $('#proofSubmissionModal').modal('hide');
                    resetVisit();
                    
                    // Reload page to update user stats
                    setTimeout(() => {
                        location.reload();
                    }, 2000);
                } else {
                    showNotification('error', '<?php echo e(__("Error")); ?>', response.message);
                }
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || '<?php echo e(__("An error occurred")); ?>';
                showNotification('error', '<?php echo e(__("Error")); ?>', message);
            },
            complete: function() {
                submitBtn.prop('disabled', false).html('<i class="bx bx-upload me-2"></i><?php echo e(__("Submit Proof")); ?>');
            }
        });
    }

    // Handle modal close - DON'T reset visit, just hide modal
    $('#visitProgressModal').on('hidden.bs.modal', function() {
        // Modal kapandığında visit'i resetleme, sadece gizle
        // Kullanıcı website'de vakit geçirirken modal kapalı olabilir
        console.log('Modal closed, but visit continues in background');
        
        // Tracking interval'ı temizleme! Arka planda devam etsin
        // trackingInterval ve visitTimer çalışmaya devam etsin
    });
    
    // Add a button to reopen progress modal
    function reopenProgressModal() {
        if (currentVisit) {
            $('#visitProgressModal').modal('show');
            
            // Modal açıldığında güncel bilgileri al
            setTimeout(function() {
                updateModalDisplay();
            }, 500);
        }
    }
    
    // Yeni fonksiyon: Sadece modal'ı güncelle, visit'i resetleme
    function updateModalDisplay() {
        if (!currentVisit) return;
        
        // Server'dan güncel bilgi al
        $.ajax({
            url: `/website-visits/track/${currentVisit.id}`,
            type: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'X-Requested-With': 'XMLHttpRequest'
            },
            success: function(response) {
                if (response.success) {
                    // Update timer with server time
                    const serverElapsed = response.elapsed_time;
                    const minutes = Math.floor(serverElapsed / 60);
                    const seconds = serverElapsed % 60;
                    
                    $('#timerDisplay').text(
                        String(minutes).padStart(2, '0') + ':' + 
                        String(seconds).padStart(2, '0')
                    );
                    
                    const progress = Math.min((serverElapsed / response.required_time) * 100, 100);
                    $('#progressBar').css('width', progress + '%');
                    
                    if (serverElapsed >= response.required_time) {
                        $('#completeVisitBtn').prop('disabled', false);
                        $('#progressBar').removeClass('bg-primary').addClass('bg-success');
                        
                        // Show completion message
                        $('#visitStatus').html('<div class="alert alert-success"><i class="bx bx-check-circle me-2"></i><?php echo e(__("Required time completed! You can now complete the visit.")); ?></div>');
                    }
                    
                    console.log('Modal updated - Server elapsed time:', serverElapsed, 'Required:', response.required_time);
                }
            }
        });
    }
    
    // Handle proof modal close
    $(document).on('hidden.bs.modal', '#proofSubmissionModal', function() {
        resetVisit();
        $(this).remove();
    });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/website-visits/index.blade.php ENDPATH**/ ?>