<?php $__env->startSection('title', __('My Orders')); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <h1><?php echo app('translator')->get('My Orders'); ?></h1>
        <hr>
    </div>
</div>
<div class="row">
    <div class="col-12">
        <?php if($orders->isEmpty()): ?>
            <div class="alert alert-info" role="alert">
                <?php echo app('translator')->get('No orders found'); ?> <?php echo app('translator')->get('You haven\'t placed any orders yet.'); ?> <a href="<?php echo e(route('site2.products.index')); ?>"><?php echo app('translator')->get('Browse Products'); ?></a>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Order Number'); ?></th>
                            <th><?php echo app('translator')->get('Product'); ?></th>
                            <th><?php echo app('translator')->get('Quantity'); ?></th>
                            <th><?php echo app('translator')->get('Total Amount'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Order Date'); ?></th>
                            <th><?php echo app('translator')->get('Actions'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($order->order_number); ?></td>
                                <td><?php echo e($order->product_name); ?></td>
                                <td><?php echo e($order->quantity); ?></td>
                                <td><?php echo e($order->formatted_total); ?></td>
                                <td><span class="btn btn-info badge <?php echo e($order->status_badge); ?>"><?php echo e($order->status_text); ?></span></td>
                                <td><?php echo e($order->created_at); ?></td>
                                <td>
                                    <a href="<?php echo e(route('site2.account.orders.show', $order->id)); ?>" class="btn btn-sm btn-info"><?php echo app('translator')->get('View'); ?></a>
                                    <?php if($order->can_be_cancelled): ?>
                                        <button type="button" class="btn btn-sm btn-danger cancel-order-btn" data-order-id="<?php echo e($order->id); ?>"><?php echo app('translator')->get('Cancel Order'); ?></button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <div class="d-flex justify-content-center mt-4">
                <?php echo e($orders->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.cancel-order-btn').forEach(button => {
            button.addEventListener('click', function () {
                const orderId = this.dataset.orderId;
                if (confirm('<?php echo app('translator')->get('Are you sure you want to cancel this order?'); ?>')) {
                    fetch(`<?php echo e(url('hesabim/siparislerim')); ?>/${orderId}/cancel`, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                            'Content-Type': 'application/json',
                            'Accept': 'application/json'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            alert(data.message);
                            window.location.reload();
                        } else {
                            alert(data.message);
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert('<?php echo app('translator')->get('An error occurred'); ?>');
                    });
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('gorevsitesi.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/gorevsitesi/account/orders.blade.php ENDPATH**/ ?>