<?php $__env->startSection('title', __('Withdrawals')); ?>

<?php $__env->startSection('style'); ?>
<style>
    .withdrawal-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 20px;
        padding: 30px;
        color: white;
        margin-bottom: 30px;
    }
    
    .withdrawal-card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        margin-bottom: 20px;
        overflow: hidden;
        transition: transform 0.3s ease;
    }
    
    .withdrawal-card:hover {
        transform: translateY(-3px);
    }
    
    .balance-card {
        background: linear-gradient(45deg, #28a745, #20c997);
        color: white;
        border-radius: 15px;
        padding: 25px;
        text-align: center;
        margin-bottom: 30px;
    }
    
    .balance-amount {
        font-size: 2.5rem;
        font-weight: bold;
        margin-bottom: 10px;
    }
    
    .withdrawal-form {
        background: white;
        border-radius: 15px;
        padding: 30px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        margin-bottom: 30px;
    }
    
    .withdrawal-item {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 20px;
        margin-bottom: 15px;
        border-left: 4px solid #667eea;
        transition: all 0.3s ease;
    }
    
    .withdrawal-item:hover {
        background: #e9ecef;
        transform: translateX(5px);
    }
    
    .status-badge {
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: bold;
    }
    
    .status-pending {
        background: #fff3cd;
        color: #856404;
    }
    
    .status-approved {
        background: #d1ecf1;
        color: #0c5460;
    }
    
    .status-completed {
        background: #d4edda;
        color: #155724;
    }
    
    .status-rejected {
        background: #f8d7da;
        color: #721c24;
    }
    
    .iban-display {
        font-family: 'Courier New', monospace;
        background: #f8f9fa;
        padding: 8px 12px;
        border-radius: 5px;
        font-size: 0.9rem;
    }
    
    .withdrawal-stats {
        background: white;
        border-radius: 15px;
        padding: 25px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .stat-item {
        text-align: center;
        padding: 15px;
    }
    
    .stat-number {
        font-size: 1.8rem;
        font-weight: bold;
        color: #667eea;
        margin-bottom: 5px;
    }
    
    .stat-label {
        color: #6c757d;
        font-size: 0.9rem;
    }
    
    .requirements-list {
        background: #e7f3ff;
        border-radius: 10px;
        padding: 20px;
        margin-bottom: 20px;
    }
    
    .requirement-item {
        display: flex;
        align-items: center;
        margin-bottom: 10px;
    }
    
    .requirement-item i {
        color: #667eea;
        margin-right: 10px;
        font-size: 1.2rem;
    }
    
    @media (max-width: 768px) {
        .withdrawal-container {
            padding: 20px;
            margin: 10px;
            border-radius: 15px;
        }
        
        .balance-amount {
            font-size: 2rem;
        }
        
        .withdrawal-form {
            padding: 20px;
        }
        
        .withdrawal-item {
            padding: 15px;
        }
        
        .stat-number {
            font-size: 1.5rem;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Withdrawals')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Withdrawals')); ?></li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Header -->
        <div class="withdrawal-container">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h2 class="mb-3 text-white">
                        <i class="bx bx-money me-2"></i>
                        <?php echo e(__('Withdrawal Requests')); ?>

                    </h2>
                    <p class="mb-0 opacity-90">
                        <?php echo e(__('Request withdrawal of your earnings. Minimum amount is :amount :currency', ['amount' => number_format($minWithdrawal), 'currency' => $currency])); ?>

                    </p>
                </div>
                <div class="col-md-4 text-end">
                    <div class="balance-card">
                        <div class="balance-amount"><?php echo e(number_format($user->balance, 2)); ?><?php echo e($currency); ?></div>
                        <small class="opacity-75"><?php echo e(__('Available Balance')); ?></small>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Withdrawal Form -->
            <div class="col-lg-8">
                <!-- Requirements -->
                <div class="requirements-list">
                    <h6 class="mb-3">
                        <i class="bx bx-info-circle me-2"></i>
                        <?php echo e(__('Withdrawal Requirements')); ?>

                    </h6>
                    <div class="requirement-item">
                        <i class="bx bx-check-circle"></i>
                        <span><?php echo e(__('Minimum withdrawal amount: :amount :currency', ['amount' => number_format($minWithdrawal), 'currency' => $currency])); ?></span>
                    </div>
                    <div class="requirement-item">
                        <i class="bx bx-check-circle"></i>
                        <span><?php echo e(__('Maximum withdrawal amount: :amount :currency', ['amount' => number_format($maxWithdrawal), 'currency' => $currency])); ?></span>
                    </div>
                    <div class="requirement-item">
                        <i class="bx bx-check-circle"></i>
                        <span><?php echo e(__('Valid Turkish IBAN required')); ?></span>
                    </div>
                    <div class="requirement-item">
                        <i class="bx bx-check-circle"></i>
                        <span><?php echo e(__('Account holder name must match your profile')); ?></span>
                    </div>
                    <div class="requirement-item">
                        <i class="bx bx-check-circle"></i>
                        <span><?php echo e(__('Processing time: 1-3 business days')); ?></span>
                    </div>
                </div>

                <!-- Withdrawal Form -->
                <div class="withdrawal-form">
                    <h5 class="mb-4">
                        <i class="bx bx-plus-circle me-2"></i>
                        <?php echo e(__('New Withdrawal Request')); ?>

                    </h5>
                    
                    <form id="withdrawalForm">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('Withdrawal Amount')); ?> (<?php echo e($currency); ?>)</label>
                                    <input type="number" class="form-control" name="amount" 
                                           min="<?php echo e($minWithdrawal); ?>" max="<?php echo e($maxWithdrawal); ?>" step="0.01" required
                                           placeholder="<?php echo e(number_format($minWithdrawal, 2)); ?>"
                                           data-min="<?php echo e($minWithdrawal); ?>" data-max="<?php echo e($maxWithdrawal); ?>" data-currency="<?php echo e($currency); ?>">
                                    <div class="invalid-feedback"></div>
                                    <small class="text-muted"><?php echo e(__('Min: :min :currency - Max: :max :currency', ['min' => number_format($minWithdrawal), 'max' => number_format($maxWithdrawal), 'currency' => $currency])); ?></small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('Account Holder Name')); ?></label>
                                    <input type="text" class="form-control" name="account_holder_name" 
                                           value="<?php echo e($user->account_holder_name); ?>" required>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('IBAN')); ?></label>
                            <input type="text" class="form-control" name="iban" 
                                   value="<?php echo e($user->iban); ?>" required
                                   placeholder="TR00 0000 0000 0000 0000 0000 00"
                                   maxlength="26">
                            <div class="invalid-feedback"></div>
                            <small class="text-muted"><?php echo e(__('Turkish IBAN (26 characters starting with TR)')); ?></small>
                        </div>
                        
                        <div class="alert alert-info">
                            <h6><?php echo e(__('Important Notes')); ?></h6>
                            <ul class="mb-0">
                                <li><?php echo e(__('Withdrawal requests are processed within 1-3 business days')); ?></li>
                                <li><?php echo e(__('You can only have one pending withdrawal request at a time')); ?></li>
                                <li><?php echo e(__('Make sure your IBAN and account holder name are correct')); ?></li>
                                <li><?php echo e(__('You can cancel pending requests before they are approved')); ?></li>
                            </ul>
                        </div>
                        
                        <button type="submit" class="btn btn-primary btn-lg w-100" id="submitBtn">
                            <i class="bx bx-send me-2"></i><?php echo e(__('Submit Withdrawal Request')); ?>

                        </button>
                    </form>
                </div>

                <!-- Withdrawal History -->
                <div class="withdrawal-card">
                    <div class="card-header bg-transparent">
                        <h5 class="mb-0">
                            <i class="bx bx-history me-2"></i>
                            <?php echo e(__('Withdrawal History')); ?>

                        </h5>
                    </div>
                    <div class="card-body">
                        <?php if($withdrawals->count() > 0): ?>
                            <?php $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="withdrawal-item">
                                <div class="row align-items-center">
                                    <div class="col-md-3">
                                        <div class="fw-bold text-primary"><?php echo e(number_format($withdrawal->amount, 2)); ?><?php echo e($currency); ?></div>
                                        <small class="text-muted"><?php echo e($withdrawal->created_at->format('d.m.Y H:i')); ?></small>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="iban-display"><?php echo e($withdrawal->masked_iban); ?></div>
                                        <small class="text-muted"><?php echo e($withdrawal->account_holder_name); ?></small>
                                    </div>
                                    <div class="col-md-3">
                                        <span class="status-badge status-<?php echo e($withdrawal->status); ?>">
                                            <?php echo e($withdrawal->status_text); ?>

                                        </span>
                                        <?php if($withdrawal->admin_note): ?>
                                            <div class="mt-1">
                                                <small class="text-muted"><?php echo e($withdrawal->admin_note); ?></small>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-md-2 text-end">
                                        <?php if($withdrawal->status === 'pending'): ?>
                                            <button class="btn btn-sm btn-outline-danger" 
                                                    onclick="cancelWithdrawal(<?php echo e($withdrawal->id); ?>)">
                                                <i class="bx bx-x"></i> <?php echo e(__('Cancel')); ?>

                                            </button>
                                        <?php elseif($withdrawal->status === 'completed' && $withdrawal->transaction_reference): ?>
                                            <small class="text-success">
                                                <i class="bx bx-check-circle"></i>
                                                Ref: <?php echo e($withdrawal->transaction_reference); ?>

                                            </small>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="text-center py-4">
                                <i class="bx bx-money" style="font-size: 3rem; color: #dee2e6;"></i>
                                <p class="text-muted mt-2"><?php echo e(__('No withdrawal requests yet')); ?></p>
                                <p class="text-muted"><?php echo e(__('Submit your first withdrawal request above')); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Statistics -->
            <div class="col-lg-4">
                <div class="withdrawal-stats">
                    <h5 class="mb-4">
                        <i class="bx bx-bar-chart me-2"></i>
                        <?php echo e(__('Withdrawal Statistics')); ?>

                    </h5>
                    
                    <div class="row">
                        <div class="col-6">
                            <div class="stat-item">
                                <div class="stat-number"><?php echo e($withdrawals->count()); ?></div>
                                <div class="stat-label"><?php echo e(__('Total Requests')); ?></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="stat-item">
                                <div class="stat-number"><?php echo e($withdrawals->where('status', 'pending')->count()); ?></div>
                                <div class="stat-label"><?php echo e(__('Pending')); ?></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="stat-item">
                                <div class="stat-number"><?php echo e($withdrawals->where('status', 'completed')->count()); ?></div>
                                <div class="stat-label"><?php echo e(__('Completed')); ?></div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="stat-item">
                                <div class="stat-number"><?php echo e(number_format($withdrawals->where('status', 'completed')->sum('amount'), 0)); ?><?php echo e($currency); ?></div>
                                <div class="stat-label"><?php echo e(__('Total Withdrawn')); ?></div>
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <!-- Quick Actions -->
                    <h6 class="mb-3"><?php echo e(__('Quick Actions')); ?></h6>
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('user.profile')); ?>" class="btn btn-outline-primary btn-sm">
                            <i class="bx bx-edit me-2"></i><?php echo e(__('Update Payment Info')); ?>

                        </a>
                        <a href="<?php echo e(route('tasks.index')); ?>" class="btn btn-outline-success btn-sm">
                            <i class="bx bx-task me-2"></i><?php echo e(__('Earn More Money')); ?>

                        </a>
                        <a href="<?php echo e(route('tasks.watch')); ?>" class="btn btn-outline-info btn-sm">
                            <i class="bx bx-play-circle me-2"></i><?php echo e(__('Watch & Earn')); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
$(document).ready(function() {
    // IBAN formatting
    $('input[name="iban"]').on('input', function() {
        let value = this.value.replace(/\s/g, '').toUpperCase();
        if (value.length > 2) {
            value = value.substring(0, 2) + ' ' + value.substring(2).replace(/(.{4})/g, '$1 ').trim();
        }
        this.value = value;
    });
    
    // Amount validation with dynamic values
    $('input[name="amount"]').on('input', function() {
        const amount = parseFloat(this.value);
        const balance = <?php echo e($user->balance); ?>;
        const minAmount = parseFloat($(this).data('min'));
        const maxAmount = parseFloat($(this).data('max'));
        const currency = $(this).data('currency');
        
        if (amount > balance) {
            this.setCustomValidity('<?php echo e(__("Amount cannot exceed your balance")); ?>');
        } else if (amount < minAmount) {
            this.setCustomValidity('<?php echo e(__("Minimum amount is :amount :currency", ["amount" => "' + minAmount + '", "currency" => "' + currency + '"])); ?>');
        } else if (amount > maxAmount) {
            this.setCustomValidity('<?php echo e(__("Maximum amount is :amount :currency", ["amount" => "' + maxAmount + '", "currency" => "' + currency + '"])); ?>');
        } else {
            this.setCustomValidity('');
        }
    });
});

// Form submission
$('#withdrawalForm').on('submit', function(e) {
    e.preventDefault();
    
    const submitBtn = $('#submitBtn');
    const originalText = submitBtn.html();
    
    submitBtn.prop('disabled', true).html('<i class="bx bx-loader-alt bx-spin me-2"></i><?php echo e(__("Processing...")); ?>');
    
    // Clear previous errors
    $('.is-invalid').removeClass('is-invalid');
    $('.invalid-feedback').empty();
    
    $.ajax({
        url: '<?php echo e(route("withdrawals.store")); ?>',
        method: 'POST',
        data: $(this).serialize(),
        success: function(response) {
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: '<?php echo e(__("Success")); ?>',
                    text: response.message,
                    timer: 3000
                }).then(() => {
                    location.reload();
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: '<?php echo e(__("Error")); ?>',
                    text: response.message
                });
            }
        },
        error: function(xhr) {
            const errors = xhr.responseJSON?.errors || {};
            
            // Display validation errors
            Object.keys(errors).forEach(field => {
                const input = $(`[name="${field}"]`);
                input.addClass('is-invalid');
                input.siblings('.invalid-feedback').text(errors[field][0]);
            });
            
            // Show general error message
            if (xhr.responseJSON?.message) {
                Swal.fire({
                    icon: 'error',
                    title: '<?php echo e(__("Error")); ?>',
                    text: xhr.responseJSON.message
                });
            }
        },
        complete: function() {
            submitBtn.prop('disabled', false).html(originalText);
        }
    });
});

// Cancel withdrawal
function cancelWithdrawal(withdrawalId) {
    Swal.fire({
        title: '<?php echo e(__("Are you sure?")); ?>',
        text: '<?php echo e(__("Do you want to cancel this withdrawal request?")); ?>',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: '<?php echo e(__("Yes, cancel it!")); ?>',
        cancelButtonText: '<?php echo e(__("No, keep it")); ?>'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/withdrawals/${withdrawalId}/cancel`,
                method: 'POST',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: '<?php echo e(__("Cancelled!")); ?>',
                            text: response.message,
                            timer: 3000
                        }).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: '<?php echo e(__("Error")); ?>',
                            text: response.message
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: '<?php echo e(__("Error")); ?>',
                        text: '<?php echo e(__("An error occurred")); ?>'
                    });
                }
            });
        }
    });
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/withdrawals/index.blade.php ENDPATH**/ ?>