<?php $__env->startSection('title', s__('Load Balance') . ' - GorevSitesi'); ?>
<?php $__env->startSection('description', s__('Load balance to your account securely')); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<div class="row mb-4">
    <div class="col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('site2.account.dashboard')); ?>" class="text-decoration-none"><?php echo e(s__('My Account')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(s__('Load Balance')); ?></li>
            </ol>
        </nav>
        <h1 class="fw-bold mb-2">
            <i class="bi bi-credit-card me-2"></i><?php echo e(s__('Load Balance')); ?>

        </h1>
        <p class="text-muted mb-0"><?php echo e(s__('Load balance to your account securely and continue shopping')); ?></p>
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <!-- Balance Load Form -->
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white border-0">
                <h5 class="mb-0 fw-bold">
                    <i class="bi bi-wallet2 me-2"></i><?php echo e(s__('Balance Loading')); ?>

                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('site2.account.balance.store')); ?>" id="balanceForm">
                    <?php echo csrf_field(); ?>
                    
                    <!-- Current Balance -->
                    <div class="alert alert-info mb-4">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-info-circle me-3 fs-4"></i>
                            <div>
                                <strong><?php echo e(s__('Current Balance')); ?>:</strong> <?php echo e(number_format(Auth::user()->balance ?? 0, 2)); ?> ₺
                            </div>
                        </div>
                    </div>

                    <!-- Amount Selection -->
                    <div class="mb-4">
                        <label class="form-label fw-medium"><?php echo e(s__('Amount to Load')); ?></label>
                        
                        <!-- Quick Amount Buttons -->
                        <div class="row g-2 mb-3">
                            <div class="col-6 col-md-3">
                                <button type="button" class="btn btn-outline-primary w-100 amount-btn" data-amount="50">
                                    50 ₺
                                </button>
                            </div>
                            <div class="col-6 col-md-3">
                                <button type="button" class="btn btn-outline-primary w-100 amount-btn" data-amount="100">
                                    100 ₺
                                </button>
                            </div>
                            <div class="col-6 col-md-3">
                                <button type="button" class="btn btn-outline-primary w-100 amount-btn" data-amount="250">
                                    250 ₺
                                </button>
                            </div>
                            <div class="col-6 col-md-3">
                                <button type="button" class="btn btn-outline-primary w-100 amount-btn" data-amount="500">
                                    500 ₺
                                </button>
                            </div>
                        </div>
                        
                        <!-- Custom Amount Input -->
                        <div class="input-group input-group-lg">
                            <span class="input-group-text">₺</span>
                            <input type="number" 
                                   class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="amount" 
                                   id="amount" 
                                   placeholder="<?php echo e(s__('Enter custom amount')); ?>"
                                   min="10" 
                                   max="10000" 
                                   step="0.01"
                                   value="<?php echo e(old('amount')); ?>">
                        </div>
                        <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback">
                                <i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <div class="form-text">
                            <i class="bi bi-info-circle me-1"></i><?php echo e(s__('You can load minimum 10 ₺, maximum 10,000 ₺')); ?>

                        </div>
                    </div>

                    <!-- Payment Method -->
                    <div class="mb-4">
                        <label class="form-label fw-medium"><?php echo e(s__('Payment Method')); ?></label>
                        
                        <div class="payment-methods">
                            <!-- Credit Card -->
                            <div class="payment-method mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="payment_method" id="credit_card" value="credit_card" checked>
                                    <label class="form-check-label w-100" for="credit_card">
                                        <div class="d-flex align-items-center">
                                            <i class="bi bi-credit-card text-primary me-3 fs-4"></i>
                                            <div>
                                                <strong><?php echo e(s__('Credit/Debit Card')); ?></strong>
                                                <div class="small text-muted">Visa, Mastercard, American Express</div>
                                            </div>
                                            <div class="ms-auto">
                                                <i class="bi bi-shield-check text-success"></i>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            </div>

                            <!-- Bank Transfer -->
                            <div class="payment-method">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="payment_method" id="bank_transfer" value="bank_transfer">
                                    <label class="form-check-label w-100" for="bank_transfer">
                                        <div class="d-flex align-items-center">
                                            <i class="bi bi-bank text-success me-3 fs-4"></i>
                                            <div>
                                                <strong><?php echo e(s__('Bank Transfer/EFT')); ?></strong>
                                                <div class="small text-muted"><?php echo e(s__('Direct bank transfer')); ?></div>
                                            </div>
                                            <div class="ms-auto">
                                                <span class="badge bg-warning"><?php echo e(s__('Approval Required')); ?></span>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                            </div>
                        </div>
                        
                        <?php $__errorArgs = ['payment_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger small mt-2">
                                <i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Bank Transfer Form (Hidden by default) -->
                    <div id="bankTransferForm" class="d-none mb-4">
                        <div class="alert alert-warning mb-3">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong><?php echo e(s__('Step 1')); ?>:</strong> <?php echo e(s__('Click "Show Bank Info" button to see account details')); ?><br>
                            <strong><?php echo e(s__('Step 2')); ?>:</strong> <?php echo e(s__('Copy IBAN and description, make your transfer')); ?><br>
                            <strong><?php echo e(s__('Step 3')); ?>:</strong> <?php echo e(s__('Upload your receipt below')); ?>

                        </div>
                        
                        <div class="text-center mb-4">
                            <button type="button" class="btn btn-primary btn-lg" id="showBankInfoBtn">
                                <i class="bi bi-bank me-2"></i><?php echo e(s__('Show Bank Account Information')); ?>

                            </button>
                        </div>
                        
                        <div id="receiptUploadSection" style="display: none;">
                            <label class="form-label fw-medium"><?php echo e(s__('Upload Receipt')); ?> <span class="text-danger">*</span></label>
                            <input type="file" 
                                   class="form-control <?php $__errorArgs = ['receipt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="receipt" 
                                   accept=".jpg,.jpeg,.png,.pdf"
                                   disabled>
                            <?php $__errorArgs = ['receipt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <div class="form-text">
                                <i class="bi bi-info-circle me-1"></i><?php echo e(s__('Please upload your transfer receipt (JPG, PNG, PDF - Max 5MB)')); ?>

                            </div>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="d-grid">
                        <button type="submit" class="btn btn-success btn-lg" id="submitBtn">
                            <i class="bi bi-credit-card me-2"></i><span id="submitText"><?php echo e(s__('Proceed to Payment')); ?></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <!-- Summary Card -->
        <div class="card border-0 shadow-sm sticky-top" style="top: 100px;">
            <div class="card-header bg-white border-0">
                <h5 class="mb-0 fw-bold"><?php echo e(s__('Summary')); ?></h5>
            </div>
            <div class="card-body">
                <div class="summary-item d-flex justify-content-between mb-2">
                    <span><?php echo e(s__('Current Balance')); ?>:</span>
                    <span class="fw-medium"><?php echo e(number_format(Auth::user()->balance ?? 0, 2)); ?> ₺</span>
                </div>
                <div class="summary-item d-flex justify-content-between mb-2">
                    <span><?php echo e(s__('Amount to Load')); ?>:</span>
                    <span class="fw-medium" id="selectedAmount">0,00 ₺</span>
                </div>
                <hr>
                <div class="summary-item d-flex justify-content-between mb-3">
                    <span class="fw-bold"><?php echo e(s__('New Balance')); ?>:</span>
                    <span class="fw-bold text-success" id="newBalance"><?php echo e(number_format(Auth::user()->balance ?? 0, 2)); ?> ₺</span>
                </div>
                
                <div class="alert alert-light">
                    <small class="text-muted">
                        <i class="bi bi-info-circle me-1"></i>
                        Bakiye yükleme işlemi anında gerçekleşir ve hesabınıza yansır.
                    </small>
                </div>
            </div>
        </div>
        
        <!-- Security Info -->
        <div class="card border-0 shadow-sm mt-4">
            <div class="card-body text-center">
                <i class="bi bi-shield-check text-success fs-1 mb-3"></i>
                <h6 class="fw-bold mb-2"><?php echo e(s__('100% Secure Payment')); ?></h6>
                <p class="small text-muted mb-3">
                    <?php echo e(s__('All your payments are protected with 256-bit SSL certificate')); ?>

                </p>
                <div class="row g-2 text-center">
                    <div class="col-6">
                        <i class="bi bi-lock text-primary fs-5"></i>
                        <div class="small"><?php echo e(s__('SSL Security')); ?></div>
                    </div>
                    <div class="col-6">
                        <i class="bi bi-shield-check text-success fs-5"></i>
                        <div class="small">PCI DSS</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- IBAN Bilgileri Modal -->
<div class="modal fade" id="bankInfoModal" tabindex="-1" aria-labelledby="bankInfoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="bankInfoModalLabel">
                    <i class="bi bi-bank me-2"></i><?php echo e(s__('Bank Account Information')); ?>

                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info mb-4">
                    <i class="bi bi-info-circle me-2"></i>
                    <strong><?php echo e(s__('Important')); ?>:</strong> <?php echo e(s__('Please use the exact information below for your bank transfer')); ?>

                </div>
                
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="card border-primary">
                            <div class="card-body text-center">
                                <i class="bi bi-building text-primary fs-2 mb-2"></i>
                                <h6 class="card-title text-primary"><?php echo e(s__('Bank Name')); ?></h6>
                                <p class="card-text fw-bold">Ziraat Bankası</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card border-success">
                            <div class="card-body text-center">
                                <i class="bi bi-person-badge text-success fs-2 mb-2"></i>
                                <h6 class="card-title text-success"><?php echo e(s__('Account Holder')); ?></h6>
                                <p class="card-text fw-bold">GorevSitesi Ltd. Şti.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card border-warning">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="card-title text-warning mb-1">
                                            <i class="bi bi-credit-card me-2"></i>IBAN
                                        </h6>
                                        <p class="card-text fs-4 fw-bold font-monospace mb-0" id="modalIbanNumber">
                                            TR12 0001 0000 0000 0000 0000 01
                                        </p>
                                    </div>
                                    <button type="button" class="btn btn-warning" id="copyIbanBtn">
                                        <i class="bi bi-clipboard"></i> <?php echo e(s__('Copy IBAN')); ?>

                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card border-info">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="card-title text-info mb-1">
                                            <i class="bi bi-chat-text me-2"></i><?php echo e(s__('Transfer Description')); ?>

                                        </h6>
                                        <p class="card-text fw-bold mb-0" id="modalDescription">
                                            <?php echo e(Auth::user()->username); ?> - <?php echo e(s__('Balance Loading')); ?>

                                        </p>
                                    </div>
                                    <button type="button" class="btn btn-info" id="copyDescriptionBtn">
                                        <i class="bi bi-clipboard"></i> <?php echo e(s__('Copy Description')); ?>

                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="alert alert-success mt-4 mb-0" id="copyStatusAlert" style="display: none;">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-check-circle me-2"></i>
                        <div>
                            <strong><?php echo e(s__('Ready for Upload!')); ?></strong><br>
                            <span id="copyStatusText"><?php echo e(s__('Both IBAN and description copied. You can now make your transfer and upload the receipt.')); ?></span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x-circle me-2"></i><?php echo e(s__('Close')); ?>

                </button>
                <button type="button" class="btn btn-success" id="enableUploadBtn" disabled data-bs-dismiss="modal">
                    <i class="bi bi-upload me-2"></i><?php echo e(s__('Enable Receipt Upload')); ?>

                </button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .payment-method {
        border: 2px solid #e9ecef;
        border-radius: 0.5rem;
        padding: 1rem;
        transition: all 0.2s ease;
        cursor: pointer;
    }
    
    .payment-method:hover {
        border-color: var(--primary-color);
        background-color: var(--light-color);
    }
    
    .payment-method input:checked + label {
        color: var(--primary-color);
    }
    
    .payment-method input:checked {
        border-color: var(--primary-color);
        background-color: var(--primary-color);
    }
    
    .amount-btn {
        transition: all 0.2s ease;
    }
    
    .amount-btn:hover,
    .amount-btn.active {
        background-color: var(--primary-color);
        border-color: var(--primary-color);
        color: white;
    }
    
    .summary-item {
        padding: 0.25rem 0;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const amountInput = document.getElementById('amount');
        const amountButtons = document.querySelectorAll('.amount-btn');
        const selectedAmountSpan = document.getElementById('selectedAmount');
        const newBalanceSpan = document.getElementById('newBalance');
        const currentBalance = <?php echo e(Auth::user()->balance ?? 0); ?>;
        const paymentMethods = document.querySelectorAll('input[name="payment_method"]');
        const submitText = document.getElementById('submitText');
        
        // Modal ve upload section kontrolü
        let ibanCopied = false;
        let descriptionCopied = false;
        
        // Amount button clicks
        amountButtons.forEach(button => {
            button.addEventListener('click', function() {
                const amount = this.dataset.amount;
                amountInput.value = amount;
                updateSummary(parseFloat(amount));
                
                // Update button states
                amountButtons.forEach(btn => btn.classList.remove('active'));
                this.classList.add('active');
            });
        });
        
        // Amount input change
        amountInput.addEventListener('input', function() {
            const amount = parseFloat(this.value) || 0;
            updateSummary(amount);
            
            // Remove active state from buttons
            amountButtons.forEach(btn => btn.classList.remove('active'));
        });
        
        // Payment method change
        paymentMethods.forEach(method => {
            method.addEventListener('change', function() {
                if (this.value === 'credit_card') {
                    document.getElementById('bankTransferForm').classList.add('d-none');
                    submitText.textContent = '<?php echo e(s__("Proceed to Payment")); ?>';
                } else if (this.value === 'bank_transfer') {
                    document.getElementById('bankTransferForm').classList.remove('d-none');
                    submitText.textContent = '<?php echo e(s__("Submit Transfer Request")); ?>';
                    
                    // Reset upload section
                    resetUploadSection();
                }
            });
        });
        
        // Show Bank Info Button
        const showBankInfoBtn = document.getElementById('showBankInfoBtn');
        if (showBankInfoBtn) {
            showBankInfoBtn.addEventListener('click', function() {
                const modal = new bootstrap.Modal(document.getElementById('bankInfoModal'));
                modal.show();
            });
        }
        
        // Copy IBAN Button
        const copyIbanBtn = document.getElementById('copyIbanBtn');
        if (copyIbanBtn) {
            copyIbanBtn.addEventListener('click', function() {
                const ibanText = document.getElementById('modalIbanNumber').textContent;
                copyToClipboard(ibanText, this, '<?php echo e(s__("IBAN Copied!")); ?>');
                ibanCopied = true;
                checkCopyStatus();
            });
        }
        
        // Copy Description Button
        const copyDescriptionBtn = document.getElementById('copyDescriptionBtn');
        if (copyDescriptionBtn) {
            copyDescriptionBtn.addEventListener('click', function() {
                const descriptionText = document.getElementById('modalDescription').textContent;
                copyToClipboard(descriptionText, this, '<?php echo e(s__("Description Copied!")); ?>');
                descriptionCopied = true;
                checkCopyStatus();
            });
        }
        
        // Enable Upload Button
        const enableUploadBtn = document.getElementById('enableUploadBtn');
        if (enableUploadBtn) {
            enableUploadBtn.addEventListener('click', function() {
                const receiptSection = document.getElementById('receiptUploadSection');
                const receiptInput = receiptSection.querySelector('input[type="file"]');
                
                receiptSection.style.display = 'block';
                receiptInput.disabled = false;
                
                showNotification('success', '<?php echo e(s__("Success")); ?>', '<?php echo e(s__("Receipt upload enabled! Please upload your transfer receipt.")); ?>');
            });
        }
        
        // Form submission
        document.getElementById('balanceForm').addEventListener('submit', function(e) {
            e.preventDefault(); // Prevent default form submission
            
            const amount = parseFloat(amountInput.value);
            
            if (!amount || amount < 10 || amount > 10000) {
                showNotification('error', '<?php echo e(s__("Error")); ?>', '<?php echo e(s__("Please enter an amount between 10 ₺ and 10,000 ₺")); ?>');
                return;
            }
            
            const submitBtn = document.getElementById('submitBtn');
            const originalText = submitBtn.innerHTML;
            const formData = new FormData(this);
            
            submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span><?php echo e(s__("Processing...")); ?>';
            submitBtn.disabled = true;
            
            // AJAX request
            fetch(this.action, {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showNotification('success', '<?php echo e(s__("Success")); ?>', data.message);
                    
                    // Redirect after 2 seconds
                    setTimeout(() => {
                        if (data.redirect) {
                            window.location.href = data.redirect;
                        }
                    }, 2000);
                } else {
                    // Handle validation errors
                    if (data.errors) {
                        let errorMessage = '';
                        Object.keys(data.errors).forEach(key => {
                            errorMessage += data.errors[key].join('\n') + '\n';
                        });
                        
                        showNotification('error', '<?php echo e(s__("Validation Error")); ?>', errorMessage);
                    } else {
                        showNotification('error', '<?php echo e(s__("Error")); ?>', data.message || '<?php echo e(s__("An error occurred")); ?>');
                    }
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showNotification('error', '<?php echo e(s__("Error")); ?>', '<?php echo e(s__("An error occurred. Please try again.")); ?>');
            })
            .finally(() => {
                // Reset button state
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            });
        });
        
        function updateSummary(amount) {
            selectedAmountSpan.textContent = amount.toFixed(2) + ' ₺';
            const newBalance = currentBalance + amount;
            newBalanceSpan.textContent = newBalance.toFixed(2) + ' ₺';
        }
        
        // Copy to clipboard helper
        function copyToClipboard(text, button, successText) {
            const originalContent = button.innerHTML;
            
            navigator.clipboard.writeText(text).then(function() {
                button.innerHTML = '<i class="bi bi-check"></i> ' + successText;
                button.disabled = true;
                
                setTimeout(() => {
                    button.innerHTML = originalContent;
                    button.disabled = false;
                }, 2000);
                
            }).catch(function() {
                // Fallback for older browsers
                const textArea = document.createElement('textarea');
                textArea.value = text;
                textArea.style.position = 'fixed';
                textArea.style.left = '-999999px';
                document.body.appendChild(textArea);
                textArea.focus();
                textArea.select();
                document.execCommand('copy');
                document.body.removeChild(textArea);
                
                button.innerHTML = '<i class="bi bi-check"></i> ' + successText;
                button.disabled = true;
                
                setTimeout(() => {
                    button.innerHTML = originalContent;
                    button.disabled = false;
                }, 2000);
            });
        }
        
        // Check copy status
        function checkCopyStatus() {
            if (ibanCopied && descriptionCopied) {
                const copyStatusAlert = document.getElementById('copyStatusAlert');
                const enableUploadBtn = document.getElementById('enableUploadBtn');
                
                if (copyStatusAlert) copyStatusAlert.style.display = 'block';
                if (enableUploadBtn) enableUploadBtn.disabled = false;
            }
        }
        
        // Reset upload section
        function resetUploadSection() {
            const receiptSection = document.getElementById('receiptUploadSection');
            if (receiptSection) {
                const receiptInput = receiptSection.querySelector('input[type="file"]');
                
                receiptSection.style.display = 'none';
                if (receiptInput) {
                    receiptInput.disabled = true;
                    receiptInput.value = '';
                }
                
                // Reset copy status
                ibanCopied = false;
                descriptionCopied = false;
                
                const copyStatusAlert = document.getElementById('copyStatusAlert');
                const enableUploadBtn = document.getElementById('enableUploadBtn');
                
                if (copyStatusAlert) copyStatusAlert.style.display = 'none';
                if (enableUploadBtn) enableUploadBtn.disabled = true;
            }
        }
        
        // Custom notification function
        function showNotification(type, title, message) {
            // Create notification element
            const notification = document.createElement('div');
            notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'} alert-dismissible fade show position-fixed`;
            notification.style.cssText = `
                top: 20px; 
                right: 20px; 
                z-index: 9999; 
                min-width: 350px; 
                max-width: 500px;
                box-shadow: 0 4px 12px rgba(0,0,0,0.15);
                border: none;
                border-radius: 8px;
            `;
            
            const icon = type === 'success' ? 'bi-check-circle' : 'bi-exclamation-triangle';
            const bgColor = type === 'success' ? '#d1edff' : '#f8d7da';
            const textColor = type === 'success' ? '#0c5460' : '#721c24';
            
            notification.style.backgroundColor = bgColor;
            notification.style.color = textColor;
            notification.style.border = `1px solid ${type === 'success' ? '#bee5eb' : '#f5c6cb'}`;
            
            notification.innerHTML = `
                <div class="d-flex align-items-start">
                    <i class="bi ${icon} me-2 fs-5 mt-1"></i>
                    <div class="flex-grow-1">
                        <strong>${title}</strong><br>
                        <span style="font-size: 0.9em;">${message.replace(/\n/g, '<br>')}</span>
                    </div>
                    <button type="button" class="btn-close ms-2" onclick="this.parentElement.parentElement.remove()"></button>
                </div>
            `;
            
            document.body.appendChild(notification);
            
            // Auto remove after 5 seconds
            setTimeout(() => {
                if (notification.parentNode) {
                    notification.classList.remove('show');
                    setTimeout(() => {
                        if (notification.parentNode) {
                            notification.remove();
                        }
                    }, 150);
                }
            }, 5000);
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('gorevsitesi.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/gorevsitesi/account/balance/create.blade.php ENDPATH**/ ?>