<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(app()->getLocale() == 'ar' ? 'rtl' : 'ltr'); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e($settings['site_name'] ?? config('app.name', 'TaskHub')); ?><?php if($settings['slogan']): ?> - <?php echo e($settings['slogan']); ?><?php else: ?> - Görev Yap, Para Kazan!<?php endif; ?></title>
    <meta name="description" content="<?php echo e($settings['description'] ?? 'Görevleri tamamlayarak para kazanın!'); ?>">
    <meta name="keywords" content="<?php echo e($settings['keywords'] ?? 'görev, para kazanma, online iş'); ?>">
    <meta name="author" content="<?php echo e($settings['site_name'] ?? 'GorevSaati'); ?>">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- AOS Animation -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #6366f1;
            --secondary-color: #8b5cf6;
            --accent-color: #06b6d4;
            --success-color: #10b981;
            --warning-color: #f59e0b;
            --danger-color: #ef4444;
            --dark-color: #1f2937;
            --light-color: #f8fafc;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            line-height: 1.6;
            color: var(--dark-color);
        }

        /* RTL Support */
        [dir="rtl"] {
            text-align: right;
        }
        
        [dir="rtl"] .navbar-nav {
            margin-left: 0;
            margin-right: auto;
        }
        
        [dir="rtl"] .text-md-end {
            text-align: right !important;
        }
        
        [dir="rtl"] .text-md-start {
            text-align: left !important;
        }
        
        [dir="rtl"] .me-2 {
            margin-right: 0 !important;
            margin-left: 0.5rem !important;
        }
        
        [dir="rtl"] .ms-auto {
            margin-left: 0 !important;
            margin-right: auto !important;
        }

        /* Header */
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }

        .navbar-brand {
            font-weight: 800;
            font-size: 1.5rem;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        /* Hero Section */
        .hero {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            position: relative;
            overflow: hidden;
        }

        .hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><polygon fill="%23ffffff08" points="0,1000 1000,0 1000,1000"/></svg>');
            background-size: cover;
        }

        .hero-content {
            position: relative;
            z-index: 2;
        }

        .hero h1 {
          font-weight: 800;
    color: white;
    margin-bottom: 0rem;
    line-height: 1.0;
    margin-top: 100px;
        }

        .hero p {
            font-size: 1.25rem;
            color: rgba(255, 255, 255, 0.9);
            margin-bottom: 2rem;
        }

        .btn-hero {
            padding: 15px 40px;
            font-size: 1.1rem;
            font-weight: 600;
            border-radius: 50px;
            text-decoration: none;
            transition: all 0.3s ease;
            display: inline-block;
            margin: 0 10px 10px 0;
        }

        .btn-hero.primary {
            background: white;
            color: var(--primary-color);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        .btn-hero.primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.3);
            color: var(--primary-color);
        }

        .btn-hero.secondary {
            background: transparent;
            color: white;
            border: 2px solid white;
        }

        .btn-hero.secondary:hover {
            background: white;
            color: var(--primary-color);
        }

        /* Features Section */
        .features {
            padding: 100px 0;
            background: var(--light-color);
        }

        .feature-card {
            background: white;
            padding: 40px 30px;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            height: 100%;
            border: none;
        }

        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
        }

        .feature-icon {
            width: 80px;
            height: 80px;
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: white;
            margin-bottom: 20px;
        }

        /* Stats Section */
        .stats {
            background: linear-gradient(135deg, var(--dark-color) 0%, #374151 100%);
            padding: 80px 0;
            color: white;
        }

        .stat-item {
            text-align: center;
            padding: 20px;
        }

        .stat-number {
            font-size: 3rem;
            font-weight: 800;
            color: var(--accent-color);
            display: block;
        }

        .stat-label {
            font-size: 1.1rem;
            opacity: 0.9;
            margin-top: 10px;
        }

        /* Footer */
        .footer {
            background: var(--dark-color);
            color: white;
            padding: 60px 0 30px;
        }

        .footer h5 {
            color: var(--accent-color);
            margin-bottom: 20px;
        }

        .footer a {
            color: rgba(255, 255, 255, 0.7);
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .footer a:hover {
            color: var(--accent-color);
        }

        /* Responsive */
        @media (max-width: 768px) {
            .hero h1 {
                font-size: 2.5rem;
            }
            
            .hero p {
                font-size: 1.1rem;
            }
            
            .btn-hero {
                padding: 12px 30px;
                font-size: 1rem;
                display: block;
                text-align: center;
                margin: 10px 0;
            }
            
            .stat-number {
                font-size: 2.5rem;
            }
        }

        /* Animations */
        .floating {
            animation: floating 3s ease-in-out infinite;
        }

        @keyframes floating {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
        }

        .gradient-text {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(route('landing')); ?>">
                <i class="fas fa-clock me-2"></i><?php echo e($settings['site_name'] ?? config('app.name', 'TaskHub')); ?>

            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="#features"><?php echo e(__('Features')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#stats"><?php echo e(__('Statistics')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#contact"><?php echo e(__('Contact')); ?></a>
                    </li>
                </ul>
                
                <div class="d-flex align-items-center">
                    <!-- Language Selector -->
                    <div class="dropdown me-3">
                        <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-globe me-1"></i>
                            <?php echo e(strtoupper(app()->getLocale())); ?>

                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="<?php echo e(route('lang.switch', 'tr')); ?>">🇹🇷 Türkçe</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('lang.switch', 'en')); ?>">🇺🇸 English</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('lang.switch', 'ar')); ?>">🇸🇦 العربية</a></li>
                            <li><a class="dropdown-item" href="<?php echo e(route('lang.switch', 'ru')); ?>">🇷🇺 Русский</a></li>
                        </ul>
                    </div>
                    
                    <a href="<?php echo e(route('login')); ?>" class="btn btn-outline-primary me-2">
                        <i class="fas fa-sign-in-alt me-1"></i><?php echo e(__('Login')); ?>

                    </a>
                    <a href="<?php echo e(route('register')); ?>" class="btn btn-primary">
                        <i class="fas fa-user-plus me-1"></i><?php echo e(__('Register')); ?>

                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6" data-aos="fade-right">
                    <div class="hero-content">
                        <h1><?php echo e(__('Complete Tasks, Earn Money!')); ?></h1>
                        <p><?php echo e(__('Join thousands of users earning money by completing simple social media tasks and website visits. Start earning today!')); ?></p>
                        
                        <div class="hero-buttons">
                            <a href="<?php echo e(route('register')); ?>" class="btn-hero primary">
                                <i class="fas fa-rocket me-2"></i><?php echo e(__('Start Earning Now')); ?>

                            </a>
                            <a href="#features" class="btn-hero secondary">
                                <i class="fas fa-play me-2"></i><?php echo e(__('Learn More')); ?>

                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6" data-aos="fade-left">
                    <div class="text-center">
                        <div class="floating">
                            <i class="fas fa-coins" style="font-size: 15rem; color: rgba(255,255,255,0.1);"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="features">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center mb-5" data-aos="fade-up">
                    <h2 class="display-4 fw-bold gradient-text"><?php echo e(__('Our Services')); ?></h2>
                    <p class="lead"><?php echo e(__('Multiple ways to earn money online')); ?></p>
                </div>
            </div>
            
            <div class="row g-4">
                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
                    <div class="feature-card">
                        <div class="feature-icon" style="background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));">
                            <i class="fas fa-globe"></i>
                        </div>
                        <h4><?php echo e(__('Website Visits')); ?></h4>
                        <p><?php echo e(__('Visit websites and earn money for each completed visit. Simple and effective way to earn.')); ?></p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
                    <div class="feature-card">
                        <div class="feature-icon" style="background: linear-gradient(135deg, var(--accent-color), var(--success-color));">
                            <i class="fas fa-thumbs-up"></i>
                        </div>
                        <h4><?php echo e(__('Social Media Tasks')); ?></h4>
                        <p><?php echo e(__('Complete social media tasks like following, liking, and sharing. Grow your social presence while earning.')); ?></p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="300">
                    <div class="feature-card">
                        <div class="feature-icon" style="background: linear-gradient(135deg, var(--warning-color), var(--danger-color));">
                            <i class="fas fa-mobile-alt"></i>
                        </div>
                        <h4><?php echo e(__('Mobile Friendly')); ?></h4>
                        <p><?php echo e(__('Complete tasks on any device. Our platform is fully optimized for mobile and desktop use.')); ?></p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="400">
                    <div class="feature-card">
                        <div class="feature-icon" style="background: linear-gradient(135deg, var(--success-color), var(--accent-color));">
                            <i class="fas fa-shield-alt"></i>
                        </div>
                        <h4><?php echo e(__('Secure Platform')); ?></h4>
                        <p><?php echo e(__('Your data and earnings are protected with advanced security measures. Safe and reliable platform.')); ?></p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="500">
                    <div class="feature-card">
                        <div class="feature-icon" style="background: linear-gradient(135deg, var(--secondary-color), var(--primary-color));">
                            <i class="fas fa-clock"></i>
                        </div>
                        <h4><?php echo e(__('Instant Payments')); ?></h4>
                        <p><?php echo e(__('Get paid instantly after completing tasks. No waiting periods or hidden fees.')); ?></p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="600">
                    <div class="feature-card">
                        <div class="feature-icon" style="background: linear-gradient(135deg, var(--danger-color), var(--warning-color));">
                            <i class="fas fa-headset"></i>
                        </div>
                        <h4><?php echo e(__('24/7 Support')); ?></h4>
                        <p><?php echo e(__('Our support team is always ready to help you. Get assistance whenever you need it.')); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section id="stats" class="stats">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center mb-5" data-aos="fade-up">
                    <h2 class="display-4 fw-bold"><?php echo e(__('Platform Statistics')); ?></h2>
                    <p class="lead"><?php echo e(__('Join our growing community of earners')); ?></p>
                </div>
            </div>
            
            <div class="row">
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="100">
                    <div class="stat-item">
                        <span class="stat-number" data-count="<?php echo e($stats['total_users']); ?>">0</span>
                        <div class="stat-label"><?php echo e(__('Total Users')); ?></div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
                    <div class="stat-item">
                        <span class="stat-number" data-count="<?php echo e($stats['verified_users']); ?>">0</span>
                        <div class="stat-label"><?php echo e(__('Verified Users')); ?></div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="300">
                    <div class="stat-item">
                        <span class="stat-number" data-count="<?php echo e($stats['completed_tasks']); ?>">0</span>
                        <div class="stat-label"><?php echo e(__('Completed Tasks')); ?></div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="400">
                    <div class="stat-item">
                        <span class="stat-number" data-count="<?php echo e($stats['website_visits']); ?>">0</span>
                        <div class="stat-label"><?php echo e(__('Website Visits')); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer id="contact" class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-6 mb-4">
                    <h5><i class="fas fa-clock me-2"></i>GorevSaati</h5>
                    <p><?php echo e(__('The best platform to earn money by completing simple tasks. Join thousands of users who are already earning.')); ?></p>
                    <div class="social-links">
                        <a href="#" class="me-3"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="me-3"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="me-3"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="me-3"><i class="fab fa-linkedin"></i></a>
                    </div>
                </div>
                
                <div class="col-lg-2 col-md-6 mb-4">
                    <h5><?php echo e(__('Quick Links')); ?></h5>
                    <ul class="list-unstyled">
                        <li><a href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a></li>
                        <li><a href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a></li>
                        <li><a href="#features"><?php echo e(__('Features')); ?></a></li>
                        <li><a href="#stats"><?php echo e(__('Statistics')); ?></a></li>
                    </ul>
                </div>
                
                <div class="col-lg-3 col-md-6 mb-4">
                    <h5><?php echo e(__('Services')); ?></h5>
                    <ul class="list-unstyled">
                        <li><a href="#"><?php echo e(__('Website Visits')); ?></a></li>
                        <li><a href="#"><?php echo e(__('Social Media Tasks')); ?></a></li>
                        <li><a href="#"><?php echo e(__('Mobile Tasks')); ?></a></li>
                        <li><a href="#"><?php echo e(__('Premium Tasks')); ?></a></li>
                    </ul>
                </div>
                
                <div class="col-lg-3 col-md-6 mb-4">
                    <h5><?php echo e(__('Support')); ?></h5>
                    <ul class="list-unstyled">
                        <li><a href="#"><?php echo e(__('Help Center')); ?></a></li>
                        <li><a href="#"><?php echo e(__('Contact Us')); ?></a></li>
                        <li><a href="#"><?php echo e(__('Privacy Policy')); ?></a></li>
                        <li><a href="#"><?php echo e(__('Terms of Service')); ?></a></li>
                    </ul>
                </div>
            </div>
            
            <hr class="my-4">
            
            <div class="row align-items-center">
                <div class="col-md-6">
                    <p class="mb-0">&copy; <?php echo e(date('Y')); ?> GörevSaati. <?php echo e(__('All rights reserved.')); ?></p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0"><i class="fas fa-heart text-danger"></i> <?php echo e(__('Made with love in Turkey')); ?></p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    
    <script>
        // Initialize AOS
        AOS.init({
            duration: 1000,
            once: true
        });

        // Counter Animation
        function animateCounters() {
            const counters = document.querySelectorAll('.stat-number');
            
            counters.forEach(counter => {
                const target = parseInt(counter.getAttribute('data-count'));
                const duration = 2000;
                const step = target / (duration / 16);
                let current = 0;
                
                const timer = setInterval(() => {
                    current += step;
                    if (current >= target) {
                        current = target;
                        clearInterval(timer);
                    }
                    counter.textContent = Math.floor(current).toLocaleString();
                }, 16);
            });
        }

        // Trigger counter animation when stats section is visible
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    animateCounters();
                    observer.unobserve(entry.target);
                }
            });
        });

        observer.observe(document.querySelector('.stats'));

        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Navbar background on scroll
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.style.background = 'rgba(255, 255, 255, 0.98)';
            } else {
                navbar.style.background = 'rgba(255, 255, 255, 0.95)';
            }
        });
    </script>
</body>
</html><?php /**PATH /home/saat/public_html/resources/views/landing.blade.php ENDPATH**/ ?>