<?php $__env->startSection('title', __('Tasks') . ' - ' . ($settings['site_name'] ?? 'Site')); ?>
<?php $__env->startSection("style"); ?>
	<link href="<?php echo e(('assets/plugins/notifications/css/lobibox.min.css')); ?>" rel="stylesheet" />
	<?php $__env->stopSection(); ?>
<?php $__env->startSection("wrapper"); ?>
<div class="page-wrapper">
<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3"><?php echo e(__('My Tasks')); ?></div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="/"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page">
                                    <button type="button" class="btn btn-success position-relative me-lg-5"> <i class="fadeIn animated bx bx-task align-middle"></i> <?php echo e(__('My Tasks')); ?> <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-dark"><?php echo e($tasks->count()); ?> <span class="visually-hidden">unread messages</span></span>
                                    </button> 
                                 </li>
							</ol>
						</nav>
					</div>
				<?php echo $__env->make("layouts.transaction-buttons", array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
				</div>
               
				<!--end breadcrumb-->
                <div class="row row-cols-1 row-cols-lg-2 row-cols-xl-4">
<?php if($tasks->isNotEmpty()): ?>
    <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col">
            <div class="card radius-15">
                <div class="card-body text-center">
                    <div class="p-4 border radius-15">
                        <img src="<?php echo e(asset('assets/images/tasks/' . $task->image)); ?>" width="110" height="110" class="rounded-circle shadow" alt="<?php echo e($task->name); ?>">
                        <h5 class="mb-0 mt-5"><?php echo e($task->name); ?></h5>
                       
                        <div class="app-name">
                                <div class="chip">
                                <?php if($task->socialPlatform && $task->socialPlatform->icon): ?>
                                    <img src="<?php echo e(asset('assets/images/app/' . $task->socialPlatform->icon)); ?>" alt="<?php echo e($task->socialPlatform->description ?? ''); ?>"><?php echo e(__('Platform')); ?>: <?php echo e($task->socialPlatform->platform); ?>

                                <?php else: ?>
                                    <?php echo e(__('Platform')); ?>: <?php echo e(__('Unknown')); ?>

                                <?php endif; ?>
                            </div>
                            <div class="chip">
                             <?php echo e(__('Profit')); ?>   <?php echo e(number_format($task->reward, 2, ',', '.')); ?><?php echo e($settings['currency']); ?>

                            </div>
                        
                            <?php if($task->status == 0): ?>
                            <div class="chip chip-lg bg-warning text-white"><?php echo e(__('Task Status')); ?>: <?php echo e(__('Disabled')); ?></div>
                        <?php elseif($task->status == 1): ?>
                        <div class="chip chip-lg bg-success text-white"><?php echo e(__('Task Status')); ?>: <?php echo e(__('Activated')); ?></div>
                            <?php elseif($task->status == 2): ?>
                            <div class="chip chip-lg bg-info text-white"><?php echo e(__('Task Status')); ?>: <?php echo e(__('Awaiting Approval')); ?></div>
                            <?php elseif($task->status == 3): ?>
                            <div class="chip chip-lg bg-danger text-white"><?php echo e(__('Task Status')); ?>: <?php echo e(__('Deleted')); ?></div>
                        <?php endif; ?>
                     

                            <div class="chip">
                                <?php if($task->creator && $task->creator->user_avatar): ?>
                                    <img src="<?php echo e(asset('assets/images/avatars/' . $task->creator->user_avatar)); ?>" alt="<?php echo e(__('Added by')); ?>"><?php echo e(__('Added by')); ?>: <?php echo e($task->creator->account_holder); ?>

                                <?php else: ?>
                                    <?php echo e(__('Added by')); ?>: <?php echo e(__('Unknown')); ?>

                                <?php endif; ?>
                            </div>
                            <div class="chip chip-lg bg-primary text-white"><?php echo e(__('Completed')); ?>: <?php echo e($task->completion_count ?? 0); ?>/<?php echo e($task->limit); ?>

                                <?php if(isset($task->completion_percentage)): ?>
                                    (<?php echo e(number_format($task->completion_percentage, 1)); ?>%)
                                <?php endif; ?>
                            </div>
                            <div class="chip chip-lg bg-secondary text-white"><?php echo e(__('Location')); ?>: 
                                <?php
                                    $locationText = '';
                                    // Debug: Task country_id ve city değerlerini kontrol et
                                    // Country bilgisi
                                    if($task->country && is_object($task->country) && !empty($task->country->name)) {
                                        $locationText .= $task->country->name;
                                    }
                                    // City bilgisi  
                                    if($task->city && is_object($task->city) && !empty($task->city->name)) {
                                        $locationText .= ($locationText ? '/' : '') . $task->city->name;
                                    }
                                    // Debug: Task verilerini kontrol et
                                    // Country ID: {{ $task->country_id }}, City ID: {{ $task->city }}
                                    // Country Object: {{ $task->country ? 'EXISTS' : 'NULL' }}
                                    // City Object: {{ $task->city ? 'EXISTS' : 'NULL' }}
                                    
                                    // Eğer hiçbir konum bilgisi yoksa veya 0 ise "Tümü" göster
                                    if(empty($locationText) || ($task->country_id == 0 && ($task->city == 0 || is_null($task->city)))) {
                                        $locationText = __('All');
                                    }
                                ?>
                                <?php echo e($locationText); ?>

                            
                            </div>
                          
                        </div>
                       



                        <div class="list-inline contacts-social mt-3 mb-3">
                            <!-- Düzenleme butonu - Kendi görevi veya admin ise -->
                            <?php if($task->user_id == $user->id || $user->user_type == 1): ?>
                                <button type="button" data-id="<?php echo e($task->id); ?>" class="btn btn-outline-info edit-task-btn"><?php echo e(__('Edit')); ?></button>
                            <?php endif; ?>
                            
                            <!-- Admin işlemleri - Sadece admin için -->
                            <?php if($user->user_type == 1): ?>
                                <?php if($task->status == 0): ?>
                                    <button type="button" data-id="<?php echo e($task->id); ?>" data-action="activate" class="btn btn-outline-primary task-action-btn">
                                        <span class="btn-text"><?php echo e(__('Make Active')); ?></span>
                                        <span class="btn-loading d-none"><i class="bx bx-loader-alt bx-spin"></i> <?php echo e(__('Processing...')); ?></span>
                                    </button>
                                <?php elseif($task->status == 1): ?>
                                    <button type="button" data-id="<?php echo e($task->id); ?>" data-action="disable" class="btn btn-outline-warning task-action-btn">
                                        <span class="btn-text"><?php echo e(__('Make Passive')); ?></span>
                                        <span class="btn-loading d-none"><i class="bx bx-loader-alt bx-spin"></i> <?php echo e(__('Processing...')); ?></span>
                                    </button>
                                <?php elseif($task->status == 3): ?>
                                    <button type="button" data-id="<?php echo e($task->id); ?>" data-action="activate" class="btn btn-outline-success task-action-btn">
                                        <span class="btn-text"><?php echo e(__('Republish')); ?></span>
                                        <span class="btn-loading d-none"><i class="bx bx-loader-alt bx-spin"></i> <?php echo e(__('Processing...')); ?></span>
                                    </button>
                                <?php else: ?>
                                    <button type="button" data-id="<?php echo e($task->id); ?>" data-action="confirm" class="btn btn-outline-danger task-action-btn">
                                        <span class="btn-text"><?php echo e(__('Approve Task')); ?></span>
                                        <span class="btn-loading d-none"><i class="bx bx-loader-alt bx-spin"></i> <?php echo e(__('Processing...')); ?></span>
                                    </button>
                                <?php endif; ?>
                            
                                <?php if($task->status != 3): ?>
                                    <button type="button" data-id="<?php echo e($task->id); ?>" data-action="delete" class="btn btn-outline-danger task-action-btn">
                                        <span class="btn-text"><?php echo e(__('Delete')); ?></span>
                                        <span class="btn-loading d-none"><i class="bx bx-loader-alt bx-spin"></i> <?php echo e(__('Processing...')); ?></span>
                                    </button>
                                <?php endif; ?>
                            
                                <?php if($task->status == 3 && $task->visibilty == 1): ?>
                                    <button type="button" data-id="<?php echo e($task->id); ?>" data-action="unvisible" class="btn btn-outline-dark task-action-btn"><?php echo e(__('Un Visable')); ?></button>
                                <?php endif; ?>
                            <?php endif; ?>
                
                     </div>

                        

                     <!-- Gereksiz butonlar kaldırıldı -->
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
    <div class="col">
        <p><?php echo e(__('No data found.')); ?></p>
    </div>
<?php endif; ?>

				
				
				</div>
				<!--end row-->
			</div>
</div>

<!-- Offcanvas panel -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasAdd" aria-labelledby="offcanvasAddLabel">
    <div class="offcanvas-header">
        <h5 id="offcanvasAddLabel"><?php echo e(__('Add New Task')); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <!-- Form -->
        <form class="row g-3" id="AddTaskForm" method="POST" enctype="multipart/form-data" onsubmit="return false;">
            <?php echo csrf_field(); ?>
            <!-- Fields -->
            <div class="col-md-6">
                <label for="name" class="form-label"><?php echo e(__('Task Name')); ?></label>
                <input type="text" class="form-control" name="name" required>
            </div>

            <div class="col-md-6">
                <label for="image" class="form-label"><?php echo e(__('Image')); ?></label>
                <input type="file" class="form-control" name="image" required>
            </div>
          
            <div class="col-md-6">
                <label for="link" class="form-label"><?php echo e(__('Task Link')); ?></label>
                <input type="url" class="form-control" name="link" placeholder="<?php echo e(__('Must be start with https://')); ?>" required>
            </div>

            <div class="col-md-6">
                <label for="reward" class="form-label"><?php echo e(__('Award Amount')); ?></label>
                <div class="input-group mb-3">
                    <span class="input-group-text"><?php echo e($settings['currency']); ?></span>
                    <input type="text" class="form-control" aria-label="<?php echo e(__('Award Amount')); ?>" name="reward">
                    <span class="input-group-text">.00</span>
                </div>
            </div>
        
            <div class="col-md-6">
                <label for="country_id" class="form-label"><?php echo e(__('Country')); ?></label>
                <select class="form-select" id="country_id" name="country_id" required onchange="updateCities()">
                    <option value="0"><?php echo e(__('All')); ?></option>
                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($country->code); ?>"><?php echo e($country->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-6">
                <label for="city" class="form-label"><?php echo e(__('City')); ?></label>
                <select class="form-select" id="city" name="city" required>
                    <option value="0"><?php echo e(__('All')); ?></option>
                </select>
            </div>

            <div class="col-md-6">
                <label for="category_id" class="form-label"><?php echo e(__('Platform')); ?></label>
                <select class="form-select" id="category_id" name="category_id" required onchange="updateTaskType()">
                    <?php $__currentLoopData = $platforms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $platform): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($platform->id); ?>" title="<?php echo e($platform->description); ?>"><?php echo e($platform->platform); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            
           
            <div class="col-md-6">
                <label for="proof_number" class="form-label"><?php echo e(__('Proof Number')); ?></label>
                <select class="form-select" name="proof_number" required>
                    <?php for($i = 1; $i <= 10; $i++): ?>
                        <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                    <?php endfor; ?>
                </select>
            </div>
            <div class="col-md-12" id="taskTypeContainer" style="display: none;">
                <label for="task_type" class="form-label"><?php echo e(__('Task Type')); ?></label>
                <select class="form-select" id="task_type" name="task_type" onchange="checkTaskType()">
                    <option value=""><?php echo e(__('Select Task Type')); ?></option>
                    <option value="1"><?php echo e(__('Video Likes')); ?></option>
                    <option value="2"><?php echo e(__('Channel Likes')); ?></option>
                    <option value="3"><?php echo e(__('Video Comments')); ?></option>
                    <option value="4"><?php echo e(__('Video Views')); ?></option>
                </select>
            </div>

            <div class="col-md-12" id="watchTimeContainer" style="display: none;">
                <label for="watch_time" class="form-label"><?php echo e(__('Minimum Watch Time (seconds)')); ?></label>
                <input type="number" class="form-control" id="watch_time" name="watch_time">
            </div>
            <div class="col-md-4">
                <label for="limit" class="form-label"><?php echo e(__('Total Limit')); ?></label>
                <input type="number" class="form-control" name="limit" placeholder="<?php echo e(__('Total Limit')); ?>" required>
            </div>
            
            <div class="col-md-4">
                <label for="daily_limit" class="form-label"><?php echo e(__('Daily Limit')); ?></label>
                <input type="number" class="form-control" name="daily_limit" placeholder="<?php echo e(__('Daily Limit')); ?>" required>
            </div>
            
            <div class="col-md-4">
                <label for="user_limit" class="form-label"><?php echo e(__('User Limit')); ?></label>
                <input type="number" class="form-control" name="user_limit" placeholder="<?php echo e(__('User Limit')); ?>" required>
            </div>
            
            <div class="col-md-6">
                <label for="gender" class="form-label"><?php echo e(__('Gender')); ?></label>
                <select class="form-select" name="gender" required>
                    <option value=""><?php echo e(__('Select a Gender')); ?></option>
                    <option value="1"><?php echo e(__('Male')); ?></option>
                    <option value="2"><?php echo e(__('Female')); ?></option>
                    <option value="3" selected><?php echo e(__('All')); ?></option>
                </select>
            </div>
            
            <div class="col-md-6">
                <label for="button_text" class="form-label"><?php echo e(__('Task Button Text')); ?></label>
                <input type="text" class="form-control" name="button_text" required>
            </div>
            
            <div class="col-md-12">
                <label for="description" class="form-label"><?php echo e(__('Task Description')); ?></label>
                <textarea class="form-control" name="description" placeholder="<?php echo e(__('Task Description')); ?>" rows="3"></textarea>
            </div>
          
            <!-- Submission -->
            <div class="col-md-12">
                <button type="submit" class="btn btn-primary" id="addTaskSubmitBtn">
                    <i class="bx bx-plus"></i><span class="btn-text"><?php echo e(__('Add Task')); ?></span>
                    <span class="btn-loading d-none"><i class="bx bx-loader-alt bx-spin"></i><?php echo e(__('Adding Task...')); ?></span>
                </button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="offcanvas">
                    <i class="bx bx-x"></i><?php echo e(__('Cancel')); ?>

                </button>
            </div>
        </form>
    </div>
</div>

<script>
    function updateTaskType() {
        const categorySelect = document.getElementById('category_id');
        const taskTypeContainer = document.getElementById('taskTypeContainer');
        const watchTimeContainer = document.getElementById('watchTimeContainer');
        if (categorySelect.value == 3) { 
            taskTypeContainer.style.display = 'block';
        } else {
            taskTypeContainer.style.display = 'none';
            watchTimeContainer.style.display = 'none';
        }
    }

    function checkTaskType() {
        const taskTypeSelect = document.getElementById('task_type');
        const watchTimeContainer = document.getElementById('watchTimeContainer');
        if (taskTypeSelect.value == 4) { 
            watchTimeContainer.style.display = 'block';
        } else {
            watchTimeContainer.style.display = 'none';
        }
    }
</script>

 <!-- Edit Task -->
 <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasEdit" aria-labelledby="offcanvasEditLabel">
    <div class="offcanvas-header">
        <h5 id="offcanvasEditLabel"><?php echo e(__('Edit Task')); ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
      
        <form id="editTaskForm" class="row g-3" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <input type="hidden" id="edit_task_id" name="task_id">
            <?php echo method_field('POST'); ?>
             <!-- Fields -->
             <div class="col-md-12">
                <label for="name" class="form-label"><?php echo e(__('Task Name')); ?></label>
                <input type="text" class="form-control" value="" id="name" name="name" required>
            </div>

<div class="col-md-4">
    <img id="currentImage" src="/assets/images/placeholder.png" class="align-self-start rounded-circle p-1 border" width="90" height="90" alt="Current Image">
</div>

            <div class="col-md-8">
                <label for="image" class="form-label"><?php echo e(__('Image')); ?></label>
                <input type="file" class="form-control" id="image" name="image">
            </div>
            
            <div class="col-md-6">
             
                    <label for="name" class="form-label"><?php echo e(__('Task Link')); ?></label>
                 
                    <input type="url" class="form-control" value="" id="link" name="link" placeholder="<?php echo e(__('Must be start with https://')); ?>" required>
                </div>

                <div class="col-md-6">
            <label for="name" class="form-label"><?php echo e(__('Award Amount')); ?></label>
            <div class="input-group mb-3"> <span class="input-group-text"><?php echo e($settings['currency']); ?></span>
                <input type="text" class="form-control" value="" aria-label="<?php echo e(__('Award Amount')); ?>" id="reward" name="reward"> <span class="input-group-text">.00</span>
            </div>
        
        
        </div>
        <div class="col-md-6">
            <label for="country_id" class="form-label"><?php echo e(__('Country')); ?></label>
            <select class="form-select" id="country_ids" name="country_id" required>
                <option value="0"><?php echo e(__('All')); ?></option>
                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($country->code); ?>"><?php echo e($country->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="col-md-6">
            <label for="city" class="form-label"><?php echo e(__('City')); ?></label>
            <select class="form-select" id="citys" name="city" required>
                <option value="0"><?php echo e(__('All')); ?></option>
            </select>
        </div>

            <div class="col-md-6">
                <label for="category_id" class="form-label"><?php echo e(__('Platform')); ?></label>
                <select class="form-select" id="category_ids" name="category_id" required>
                    <?php $__currentLoopData = $platforms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $platform): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($platform->id); ?>" title="<?php echo e($platform->description); ?>"><?php echo e($platform->platform); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-6">
                <label for="proof_number" class="form-label"><?php echo e(__('Proof Number')); ?></label>
                <select class="form-select" id="proof_number" name="proof_number" required>
                    <?php for($i = 1; $i <= 10; $i++): ?>
                        <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                    <?php endfor; ?>
                </select>
            </div>
             <div class="col-md-4">
                <label for="limit" class="form-label"><?php echo e(__('Total Limit')); ?></label>
                <input type="number" class="form-control" id="limit" name="limit" value="" placeholder="<?php echo e(__('Total Limit')); ?>" required>
            </div>
            <div class="col-md-4">
                <label for="daily_limit" class="form-label"><?php echo e(__('Daily Limit')); ?></label>
                <input type="number" class="form-control" id="daily_limit" value="" name="daily_limit" placeholder="<?php echo e(__('Daily Limit')); ?>" required>
            </div>
            <div class="col-md-4">
                <label for="user_limit" class="form-label"><?php echo e(__('User Limit')); ?></label>
                <input type="number" class="form-control" value="" id="user_limit" name="user_limit" placeholder="<?php echo e(__('User Limit')); ?>" required>
            </div>
            <div class="col-md-6">
                <label for="gender" class="form-label"><?php echo e(__('Gender')); ?></label>
                <select class="form-select" id="gender" name="gender" required>
                    <option value=""><?php echo e(__('Select a Gender')); ?></option>
                    <option value="1"><?php echo e(__('Male')); ?></option>
                    <option value="2"><?php echo e(__('Female')); ?></option>
                    <option value="3" selected><?php echo e(__('All')); ?></option>
                </select>
             </div>
             <div class="col-md-6">
                <label for="button_text" class="form-label"><?php echo e(__('Task Button Text')); ?></label>
                <input type="text" class="form-control" value="" id="button_text" name="button_text" required>
            </div>
            <div class="col-md-12">
                <label for="name" class="form-label"><?php echo e(__('Task Description')); ?></label>
                <textarea class="form-control" id="description" name="description" placeholder="<?php echo e(__('Task Description')); ?>" rows="3"></textarea>
            </div>
          
              <!-- Submission -->
              <div class="col-md-12">
                <button type="submit" class="btn btn-primary">
                    <i class="bx bx-check"></i> <?php echo e(__('Update Task')); ?>

                </button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="offcanvas">
                    <i class="bx bx-x"></i> <?php echo e(__('Cancel')); ?>

                </button>
              </div>
        </form>
    </div>
</div>


<!-- Universal Task Action Modal -->
<div class="modal fade" id="taskActionModal" tabindex="-1" aria-labelledby="taskActionModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="taskActionModalLabel">Task Action</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="taskActionModalBody">
                Are you sure you want to perform this action?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" id="cancelActionButton">Cancel</button>
                <button type="button" class="btn btn-primary" id="confirmActionButton">Confirm</button>
            </div>
        </div>
    </div>
</div>



            <?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
	<!--notification js -->
    <script src="<?php echo e(asset('assets/plugins/notifications/js/lobibox.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/plugins/notifications/js/notifications.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/plugins/notifications/js/notification-custom-script.js')); ?>"></script>
    <?php if(session('success')): ?>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        Lobibox.notify('success', {
            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-check-circle',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            msg: '<?php echo e(session('success')); ?>'
        });
    });
    </script>
    <?php endif; ?>
    
    <?php if($errors->any()): ?>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        Lobibox.notify('error', {
            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-error',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            msg: '<?php echo e($error); ?>'
        });
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    });
    </script>
    <?php endif; ?>
    
    <script>
        // Task info form submit with location check
        $(document).ready(function() {
            $('.task-info-form').on('submit', function(e) {
                e.preventDefault();
                
                var form = $(this);
                var formData = form.serialize();
                var submitBtn = form.find('button[type="submit"]');
                var originalText = submitBtn.text();
                
                // Loading state
                submitBtn.prop('disabled', true).text('<?php echo e(__("Loading...")); ?>');
                
                // Önce AJAX ile konum kontrolü yap
                $.ajax({
                    url: form.attr('action'),
                    type: 'POST',
                    data: formData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    },
                    success: function(response) {
                        // Konum kontrolü başarılı, normal form submit yap
                        submitBtn.prop('disabled', false).text(originalText);
                        form.off('submit').submit();
                    },
                    error: function(xhr) {
                        submitBtn.prop('disabled', false).text(originalText);
                        
                        if (xhr.status === 403) {
                            // Konum hatası - Lobibox ile göster
                            var response = xhr.responseJSON;
                            if (response && response.error === 'Location not allowed') {
                                var userLocation = response.user_location;
                                var requiredLocation = response.required_location;
                                
                                var message = response.message;
                                if (userLocation && requiredLocation) {
                                    message += '<br><br>';
                                    message += '<strong><?php echo e(__("Your Location")); ?>:</strong> ' + userLocation.city + ', ' + userLocation.country + '<br>';
                                    message += '<strong><?php echo e(__("Required Location")); ?>:</strong> ' + requiredLocation.city + ', ' + requiredLocation.country;
                                }
                                
                                Lobibox.notify('error', {
                                    pauseDelayOnHover: true,
                                    continueDelayOnInactiveTab: false,
                                    position: 'top right',
                                    icon: 'bx bx-map',
                                    title: '<?php echo e(__("Location Restriction")); ?>',
                                    msg: message,
                                    delay: 8000
                                });
                            }
                        } else {
                            // Diğer hatalar için normal form submit yap
                            form.off('submit').submit();
                        }
                    }
                });
            });
        });
    </script>
    
    <script>
		function updateCities() {
			var countryId = document.getElementById('country_id').value;
			var citySelect = document.getElementById('city');
		
			citySelect.innerHTML = '<option value=""><?php echo e(__("Select City")); ?></option>'; 
		
			if (countryId) {
				fetch(`/cities/${countryId}`)
					.then(response => response.json())
					.then(data => {
						data.forEach(city => {
							var option = new Option(city.name, city.id);
							citySelect.add(option);
						});
					})
					.catch(error => console.log('Error fetching cities:', error));
			}
		}


        function updateCitiy() {
			var countryId = document.getElementById('country_ids').value;
			var citySelect = document.getElementById('citys');
		
			citySelect.innerHTML = '<option value=""><?php echo e(__("Select City")); ?></option>'; 
		
			if (countryId) {
				fetch(`/cities/${countryId}`)
					.then(response => response.json())
					.then(data => {
						data.forEach(city => {
							var option = new Option(city.name, city.id);
							citySelect.add(option);
						});
					})
					.catch(error => console.log('Error fetching cities:', error));
			}
		}

		
    document.addEventListener("DOMContentLoaded", function () {
    const editButtons = document.querySelectorAll('.edit-task-btn');
    editButtons.forEach(button => {
        button.addEventListener('click', function() {
            const taskId = this.dataset.id;
            const form = document.getElementById('editTaskForm');  
            fetch(`/tasks/${taskId}/edit`, {
                    method: 'GET',
                    headers: {
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    return response.json();
                })
                .then(task => {
                    // Form verilerini doldur
                    document.getElementById('edit_task_id').value = task.id;
                    document.getElementById('name').value = task.name;
                    document.getElementById('link').value = task.link;
                    document.getElementById('description').value = task.description;
                    document.getElementById('reward').value = task.reward;
                    document.getElementById('limit').value = task.limit;
                    document.getElementById('daily_limit').value = task.daily_limit;
                    document.getElementById('user_limit').value = task.user_limit;
                    document.getElementById('country_ids').value = task.country_id;
                    
                    // Ülke seçildiğinde şehirleri yükle
                    if (task.country_id) {
                        updateCitiesForEdit(task.country_id, task.city);
                    } else {
                        document.getElementById('citys').value = task.city;
                    }
                    document.getElementById('category_ids').value = task.category_id;
                    document.getElementById('gender').value = task.gender;
                    document.getElementById('button_text').value = task.button_text;
                    document.getElementById('proof_number').value = task.proof_number;
                    document.getElementById('currentImage').src = "assets/images/tasks/" + task.image;
                    
                    const offcanvasEdit = document.getElementById('offcanvasEdit');
                    const bsOffcanvas2 = new bootstrap.Offcanvas(offcanvasEdit);
                    bsOffcanvas2.show();
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert("<?php echo e(__('An error occurred while loading task data:')); ?>" + error.message);
                });
        });
    });
});

// Offcanvas için şehir güncelleme fonksiyonu
function updateCitiesForEdit(countryCode, selectedCityId = null) {

    
    fetch(`/cities/${countryCode}`)
        .then(response => {
          
            return response.json();
        })
        .then(data => {
           
            const citySelect = document.getElementById('citys');
            citySelect.innerHTML = '<option value="0"><?php echo e(__("All Cities")); ?></option>';
            
            data.forEach(city => {
                const option = document.createElement('option');
                option.value = city.id;
                option.textContent = city.name;
                if (selectedCityId && city.id == selectedCityId) {
                    option.selected = true;
                }
                citySelect.appendChild(option);
            });
            
           
        })
        .catch(error => {
            console.error('Error loading cities:', error);
            alert('Şehirler yüklenirken hata oluştu: ' + error.message);
        });
}

// Country dropdown change event for offcanvas
document.addEventListener('DOMContentLoaded', function() {
    const countrySelect = document.getElementById('country_ids');
    if (countrySelect) {
        countrySelect.addEventListener('change', function() {
            const countryCode = this.value;
          
            
            if (countryCode && countryCode !== '0') {
                updateCitiesForEdit(countryCode);
            } else {
                const citySelect = document.getElementById('citys');
                citySelect.innerHTML = '<option value="0"><?php echo e(__("All Cities")); ?></option>';
               
            }
        });
    }
});

// AJAX Form Submit for Edit Task
document.getElementById('editTaskForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const taskId = document.getElementById('edit_task_id').value;
    
    // Submit button'ı disable et
    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="bx bx-loader-alt bx-spin"></i> <?php echo e(__("Updating...")); ?>';
    
    fetch(`/tasks/${taskId}`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Success notification
            Lobibox.notify('success', {
                pauseDelayOnHover: true,
                size: 'mini',
                rounded: true,
                icon: 'bx bx-check-circle',
                delayIndicator: false,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                msg: data.message || '<?php echo e(__("Task updated successfully!")); ?>'
            });
            
            // Offcanvas'ı kapat
            const offcanvasEdit = document.getElementById('offcanvasEdit');
            const bsOffcanvas = bootstrap.Offcanvas.getInstance(offcanvasEdit);
            bsOffcanvas.hide();
            
            // Sayfayı yenile (güncel verileri göstermek için)
            setTimeout(function() {
                location.reload();
            }, 1000);
            
        } else {
            // Loading state'ini kaldır
            btnText.classList.remove('d-none');
            btnLoading.classList.add('d-none');
            button.disabled = false;
            
            // Validation errors varsa göster
            if (data.errors) {
                let errorMsg = '';
                Object.values(data.errors).forEach(function(errors) {
                    errors.forEach(function(error) {
                        errorMsg += error + '<br>';
                    });
                });
                
                Lobibox.notify('error', {
                    pauseDelayOnHover: true,
                    size: 'large',
                    rounded: true,
                    icon: 'bx bx-error',
                    delayIndicator: false,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    msg: errorMsg
                });
            } else {
                // Error notification
                Lobibox.notify('error', {
                    pauseDelayOnHover: true,
                    size: 'mini',
                    rounded: true,
                    icon: 'bx bx-error',
                    delayIndicator: false,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    msg: data.message || '<?php echo e(__("An error occurred while updating the task")); ?>'
                });
            }
        }
    })
    .catch(error => {
        console.error('Error:', error);
        Lobibox.notify('error', {
            pauseDelayOnHover: true,
            size: 'mini',
            rounded: true,
            icon: 'bx bx-error',
            delayIndicator: false,
            continueDelayOnInactiveTab: false,
            position: 'top right',
            msg: '<?php echo e(__("Network error occurred")); ?>'
        });
    })
    .finally(() => {
        // Submit button'ı tekrar aktif et
        submitBtn.disabled = false;
        submitBtn.innerHTML = originalText;
    });
});

// Task action buttons - Sadece bir kez tanımla
let taskActionHandlerAdded = false;

if (!taskActionHandlerAdded) {
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('task-action-btn') || e.target.closest('.task-action-btn')) {
            e.preventDefault();
            e.stopPropagation();
            
            const button = e.target.classList.contains('task-action-btn') ? e.target : e.target.closest('.task-action-btn');
            const taskId = button.getAttribute('data-id');
            const action = button.getAttribute('data-action');
            
          
            
            // Modal açma işlemi - gerçek işlem modal'dan onaylandığında yapılacak
            if (action === 'disable' || action === 'delete' || action === 'confirm') {
                openConfirmModal(taskId, action, button);
                return;
            }
            
            // Activate işlemi direkt yapılabilir (onay gerektirmez)
            if (action === 'activate') {
                performTaskAction(taskId, action, button);
                return;
            }
        }
    });
    taskActionHandlerAdded = true;
}

// Modal açma fonksiyonu
function openConfirmModal(taskId, action, button) {
    // Modal'da kullanılmak üzere bilgileri sakla
    window.currentTaskAction = {
        taskId: taskId,
        action: action,
        button: button
    };
    
    // Modal metnini güncelle
    const modal = document.getElementById('taskActionModal');
    const modalTitle = modal.querySelector('#taskActionModalLabel');
    const modalBody = modal.querySelector('#taskActionModalBody');
    const confirmBtn = modal.querySelector('#confirmActionButton');
    
    if (action === 'disable') {
        modalTitle.textContent = '<?php echo e(__("Disable Task")); ?>';
        modalBody.textContent = '<?php echo e(__("Are you sure you want to disable this task?")); ?>';
        confirmBtn.textContent = '<?php echo e(__("Disable")); ?>';
        confirmBtn.className = 'btn btn-warning';
    } else if (action === 'delete') {
        modalTitle.textContent = '<?php echo e(__("Delete Task")); ?>';
        modalBody.textContent = '<?php echo e(__("Are you sure you want to delete this task? This action cannot be undone.")); ?>';
        confirmBtn.textContent = '<?php echo e(__("Delete")); ?>';
        confirmBtn.className = 'btn btn-danger';
    } else if (action === 'confirm') {
        modalTitle.textContent = '<?php echo e(__("Confirm Task")); ?>';
        modalBody.textContent = '<?php echo e(__("Are you sure you want to approve this task?")); ?>';
        confirmBtn.textContent = '<?php echo e(__("Approve")); ?>';
        confirmBtn.className = 'btn btn-success';
    }
    
    // Modal'ı aç
    const bsModal = new bootstrap.Modal(modal);
    bsModal.show();
}

// Modal onay butonu için event listener - Sadece bir kez
let modalHandlerAdded = false;

if (!modalHandlerAdded) {
    document.addEventListener('DOMContentLoaded', function() {
        // Modal'daki onay butonunu bul ve event listener ekle
        setTimeout(function() {
            const modal = document.getElementById('taskActionModal');
            if (modal) {
                // Modal içindeki tüm butonları kontrol et
                const confirmBtns = modal.querySelectorAll('.btn-primary, .btn-warning, .btn-danger, .btn-success');
                
                confirmBtns.forEach(function(btn) {
                    btn.addEventListener('click', function(e) {
                       
                        
                        if (window.currentTaskAction) {
                            const { taskId, action, button } = window.currentTaskAction;
                            
                    
                            
                            // Modal'ı kapat
                            const bsModal = bootstrap.Modal.getInstance(modal);
                            if (bsModal) {
                                bsModal.hide();
                            }
                            
                            // Gerçek işlemi yap
                            performTaskAction(taskId, action, button);
                            
                            // Geçici verileri temizle
                            window.currentTaskAction = null;
                        }
                    });
                });
            }
        }, 100);
    });
    modalHandlerAdded = true;
}

// Gerçek task işlemini yapan fonksiyon
function performTaskAction(taskId, action, button) {
        
        // Buton state'ini değiştir
        const btnText = button.querySelector('.btn-text');
        const btnLoading = button.querySelector('.btn-loading');
        
        // Loading state
        btnText.classList.add('d-none');
        btnLoading.classList.remove('d-none');
        button.disabled = true;
        
        // Action'a göre endpoint belirle
        let endpoint = '';
        let method = 'POST';
        
        switch(action) {
            case 'disable':
                endpoint = `/task/disable/${taskId}`;
                break;
            case 'activate':
                endpoint = `/task/activate/${taskId}`;
                break;
            case 'delete':
                endpoint = `/task/delete/${taskId}`;
                break;
            case 'confirm':
                endpoint = `/task/confirm/${taskId}`;
                break;
            default:
                console.error('Unknown action:', action);
                return;
        }
        
        // AJAX request
        fetch(endpoint, {
            method: method,
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Success notification
                Lobibox.notify('success', {
                    pauseDelayOnHover: true,
                    size: 'mini',
                    rounded: true,
                    icon: 'bx bx-check-circle',
                    delayIndicator: false,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    msg: data.message
                });
                
                // Loading state'ini kaldır
                btnText.classList.remove('d-none');
                btnLoading.classList.add('d-none');
                button.disabled = false;
                
                // Buton state'ini güncelle
                if (action === 'delete') {
                  
                    
                    // Task kartını bul - HTML yapısına göre doğru selector
                    let taskCard = button.closest('.col');
                  
                    
                    if (!taskCard) {
                        taskCard = button.closest('.card').parentElement;
                      
                    }
                   
                    
                    if (taskCard) {
                       
                        
                        // Fade out animasyonu
                        taskCard.style.transition = 'all 0.5s ease-out';
                        taskCard.style.opacity = '0';
                        taskCard.style.transform = 'translateX(-100%)';
                        
                        setTimeout(() => {
                       
                            taskCard.remove();
                            
                            // Task sayısını güncelle
                            updateTaskCount();
                            
                            // Eğer hiç görev kalmadıysa boş mesajı göster
                            const remainingTaskCards = document.querySelectorAll('.col');
                           
                            
                            if (remainingTaskCards.length === 0) {
                                const container = document.querySelector('.row');
                                if (container) {
                                    container.innerHTML = `
                                        <div class="col-12 text-center">
                                            <div class="card">
                                                <div class="card-body">
                                                    <i class="bx bx-task" style="font-size: 48px; color: #ccc;"></i>
                                                    <h5 class="mt-3"><?php echo e(__('No tasks found')); ?></h5>
                                                    <p class="text-muted"><?php echo e(__('You have not created any tasks yet.')); ?></p>
                                                    <button type="button" class="btn btn-primary" data-bs-toggle="offcanvas" data-bs-target="#offcanvasAdd">
                                                        <i class="bx bx-plus"></i> <?php echo e(__('Add New Task')); ?>

                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    `;
                                }
                            }
                        }, 500);
                    } else {
                        console.error('Task card not found! Button:', button);
                    }
                } else if (action === 'disable') {
                    // Pasif yapıldı - Aktif Et butonuna dönüştür
                    btnText.textContent = '<?php echo e(__("Make Active")); ?>';
                    button.setAttribute('data-action', 'activate');
                    button.className = button.className.replace('btn-outline-warning', 'btn-outline-primary');
                    
                    // Loading span'ını da güncelle
                    btnLoading.innerHTML = '<i class="bx bx-loader-alt bx-spin"></i> <?php echo e(__("Processing...")); ?>';
                    
                    // Task Status badge'ini güncelle
                    updateTaskStatusBadge(taskId, 0); // Pasif
                    
                } else if (action === 'activate') {
                    // Aktif yapıldı - Pasif Et butonuna dönüştür
                    btnText.textContent = '<?php echo e(__("Make Passive")); ?>';
                    button.setAttribute('data-action', 'disable');
                    button.className = button.className.replace('btn-outline-primary', 'btn-outline-warning');
                    
                    // Loading span'ını da güncelle
                    btnLoading.innerHTML = '<i class="bx bx-loader-alt bx-spin"></i> <?php echo e(__("Processing...")); ?>';
                    
                    // Task Status badge'ini güncelle
                    updateTaskStatusBadge(taskId, 1); // Aktif
                    
                } else if (action === 'confirm') {
                    // Onaylandı - Aktif Et butonuna dönüştür
                    btnText.textContent = '<?php echo e(__("Make Passive")); ?>';
                    button.setAttribute('data-action', 'disable');
                    button.className = button.className.replace('btn-outline-danger', 'btn-outline-warning');
                    
                    // Loading span'ını da güncelle
                    btnLoading.innerHTML = '<i class="bx bx-loader-alt bx-spin"></i> <?php echo e(__("Processing...")); ?>';
                    
                    // Task Status badge'ini güncelle
                    updateTaskStatusBadge(taskId, 1); // Aktif
                }
                
            } else {
                // Error notification
                Lobibox.notify('error', {
                    pauseDelayOnHover: true,
                    size: 'mini',
                    rounded: true,
                    icon: 'bx bx-error',
                    delayIndicator: false,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    msg: data.message || '<?php echo e(__("An error occurred")); ?>'
                });
                
                // Buton state'ini geri al
                btnText.classList.remove('d-none');
                btnLoading.classList.add('d-none');
                button.disabled = false;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            
            // Error notification
            Lobibox.notify('error', {
                pauseDelayOnHover: true,
                size: 'mini',
                rounded: true,
                icon: 'bx bx-error',
                delayIndicator: false,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                msg: '<?php echo e(__("Network error occurred")); ?>'
            });
            
            // Buton state'ini geri al
            btnText.classList.remove('d-none');
            btnLoading.classList.add('d-none');
            button.disabled = false;
        });
}

// Task Status badge güncelleme fonksiyonu
function updateTaskStatusBadge(taskId, newStatus) {
    // Task kartını bul
    const taskCard = document.querySelector(`[data-id="${taskId}"]`).closest('.col-12');
    if (!taskCard) return;
    
    // Status badge'ini bul
    const statusBadge = taskCard.querySelector('.badge');
    if (!statusBadge) return;
    
    // Status'a göre badge'i güncelle
    switch(newStatus) {
        case 0: // Pasif
            statusBadge.textContent = '<?php echo e(__("Passive")); ?>';
            statusBadge.className = 'badge bg-warning text-dark';
            break;
        case 1: // Aktif
            statusBadge.textContent = '<?php echo e(__("Active")); ?>';
            statusBadge.className = 'badge bg-success';
            break;
        case 2: // Beklemede
            statusBadge.textContent = '<?php echo e(__("Pending")); ?>';
            statusBadge.className = 'badge bg-info';
            break;
        case 3: // Silindi
            statusBadge.textContent = '<?php echo e(__("Deleted")); ?>';
            statusBadge.className = 'badge bg-danger';
            break;
        default:
            statusBadge.textContent = '<?php echo e(__("Unknown")); ?>';
            statusBadge.className = 'badge bg-secondary';
            break;
    }
}

// AJAX Form Submit for Add Task - Kesin tek seferlik
if (typeof window.addTaskFormInitialized === 'undefined') {
    window.addTaskFormInitialized = true;
    
   document.addEventListener('DOMContentLoaded', function () {
    if (!window.addTaskHandlerAdded) {
        const addTaskForm = document.getElementById('AddTaskForm');
        if (addTaskForm) {
            console.log('Adding submit event listener to AddTaskForm');
            addTaskForm.addEventListener('submit', function (e) {
                e.preventDefault();

                const formData = new FormData(this);
                const submitBtn = document.getElementById('addTaskSubmitBtn');
                const btnText = submitBtn.querySelector('.btn-text');
                const btnLoading = submitBtn.querySelector('.btn-loading');

                // Loading state
                btnText.classList.add('d-none');
                btnLoading.classList.remove('d-none');
                submitBtn.disabled = true;

                fetch('/tasks', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: formData
                })
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(`HTTP error! status: ${response.status}`);
                        }
                        return response.json();
                    })
                    .then(data => {
                        if (data.success) {
                            Lobibox.notify('success', {
                                pauseDelayOnHover: true,
                                size: 'mini',
                                rounded: true,
                                icon: 'bx bx-check-circle',
                                delayIndicator: false,
                                continueDelayOnInactiveTab: false,
                                position: 'top right',
                                msg: data.message || "<?php echo e(__('Task added successfully!')); ?>"
                            });

                            btnText.textContent = "<?php echo e(__('Added')); ?>";
                            btnText.classList.remove('d-none');
                            btnLoading.classList.add('d-none');

                            setTimeout(function () {
                                document.getElementById('AddTaskForm').reset();
                                btnText.textContent = "<?php echo e(__('Add Task')); ?>";
                                submitBtn.disabled = false;

                                const offcanvasAdd = document.getElementById('offcanvasAdd');
                                const bsOffcanvas = bootstrap.Offcanvas.getInstance(offcanvasAdd);
                                if (bsOffcanvas) {
                                    bsOffcanvas.hide();
                                }

                                location.reload();
                            }, 2000);

                        } else {
                            btnText.classList.remove('d-none');
                            btnLoading.classList.add('d-none');
                            submitBtn.disabled = false;

                            if (data.errors) {
                                let errorMsg = '';
                                Object.values(data.errors).forEach(function (errors) {
                                    errors.forEach(function (error) {
                                        errorMsg += error + '<br>';
                                    });
                                });

                                Lobibox.notify('error', {
                                    pauseDelayOnHover: true,
                                    size: 'large',
                                    rounded: true,
                                    icon: 'bx bx-error',
                                    delayIndicator: false,
                                    continueDelayOnInactiveTab: false,
                                    position: 'top right',
                                    msg: errorMsg
                                });
                            } else {
                                Lobibox.notify('error', {
                                    pauseDelayOnHover: true,
                                    size: 'mini',
                                    rounded: true,
                                    icon: 'bx bx-error',
                                    delayIndicator: false,
                                    continueDelayOnInactiveTab: false,
                                    position: 'top right',
                                    msg: data.message || "<?php echo e(__('An error occurred while adding the task')); ?>"
                                });
                            }
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);

                        btnText.classList.remove('d-none');
                        btnLoading.classList.add('d-none');
                        submitBtn.disabled = false;

                        Lobibox.notify('error', {
                            pauseDelayOnHover: true,
                            size: 'mini',
                            rounded: true,
                            icon: 'bx bx-error',
                            delayIndicator: false,
                            continueDelayOnInactiveTab: false,
                            position: 'top right',
                            msg: "<?php echo e(__('Network error occurred')); ?>"
                        });
                    });
            });

            window.addTaskHandlerAdded = true;
            console.log('AddTaskForm event listener added successfully');
        } else {
            console.log('AddTaskForm not found');
        }
    } else {
        console.log('AddTaskForm event listener already exists');
    }
});

}

// Task sayısını güncelleme fonksiyonu
function updateTaskCount() {
    const taskCountBadge = document.querySelector('.badge.rounded-pill.bg-dark');
    if (taskCountBadge) {
        const remainingTasks = document.querySelectorAll('.col').length;
     
        taskCountBadge.textContent = remainingTasks;
    }
}

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.app", array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/tasks/index.blade.php ENDPATH**/ ?>