<?php $__env->startSection('style'); ?>
<style>
    .video-container {
        position: relative;
        background: #000;
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(0,0,0,0.3);
    }
    
    .video-player {
        width: 100%;
        height: 400px;
        border: none;
    }
    
    .progress-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 15px;
        padding: 20px;
        margin-top: 20px;
    }
    
    .progress-bar-custom {
        height: 8px;
        border-radius: 10px;
        background: rgba(255,255,255,0.3);
        overflow: hidden;
    }
    
    .progress-fill {
        height: 100%;
        background: linear-gradient(90deg, #28a745, #20c997);
        border-radius: 10px;
        transition: width 0.3s ease;
        position: relative;
    }
    
    .progress-fill::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
        animation: shimmer 2s infinite;
    }
    
    @keyframes shimmer {
        0% { transform: translateX(-100%); }
        100% { transform: translateX(100%); }
    }
    
    .reward-card {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        color: white;
        border-radius: 15px;
        padding: 20px;
        text-align: center;
        margin-top: 20px;
        display: none;
    }
    
    .reward-card.show {
        display: block;
        animation: slideInUp 0.5s ease;
    }
    
    @keyframes slideInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 15px;
        margin-top: 15px;
    }
    
    .stat-item {
        background: rgba(255,255,255,0.1);
        padding: 15px;
        border-radius: 10px;
        text-align: center;
    }
    
    .stat-value {
        font-size: 1.5rem;
        font-weight: bold;
        margin-bottom: 5px;
    }
    
    .stat-label {
        font-size: 0.9rem;
        opacity: 0.8;
    }
    
    @media (max-width: 768px) {
        .video-player {
            height: 250px;
        }
        
        .progress-container {
            padding: 15px;
        }
        
        .stats-grid {
            grid-template-columns: 1fr 1fr;
        }
    }
    
    .pulse {
        animation: pulse 2s infinite;
    }
    
    @keyframes pulse {
        0% { transform: scale(1); }
        50% { transform: scale(1.05); }
        100% { transform: scale(1); }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Watch Video')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/home')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('tasks.watch')); ?>"><?php echo e(__('Watch & Earn')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Watch Video')); ?></li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="row">
            <!-- Video Player -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-body p-0">
                        <div class="video-container">
                            <iframe id="youtube-player" 
                                    class="video-player"
                                    src="<?php echo e($watchTask->embed_url); ?>"
                                    frameborder="0" 
                                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                                    allowfullscreen>
                            </iframe>
                        </div>
                    </div>
                </div>
                
                <!-- Video Info -->
                <div class="card">
                    <div class="card-body">
                        <h4 class="mb-3"><?php echo e($watchTask->title); ?></h4>
                        <?php if($watchTask->description): ?>
                        <p class="text-muted"><?php echo e($watchTask->description); ?></p>
                        <?php endif; ?>
                        
                        <div class="row mt-3">
                            <div class="col-md-4">
                                <div class="d-flex align-items-center">
                                    <i class="bx bx-time text-primary me-2"></i>
                                    <span><?php echo e(__('Required Time')); ?>: <?php echo e($watchTask->formatted_duration); ?></span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center">
                                    <i class="bx bx-money text-success me-2"></i>
                                    <span><?php echo e(__('Reward')); ?>: <?php echo e($watchTask->reward_amount); ?>₺</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center">
                                    <i class="bx bx-user text-info me-2"></i>
                                    <span><?php echo e(__('Creator')); ?>: <?php echo e($watchTask->creator->account_holder); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Progress & Reward -->
            <div class="col-lg-4">
                <!-- Progress Card -->
                <div class="progress-container">
                    <h5 class="mb-3 text-white">
                        <i class="bx bx-play-circle me-2"></i>
                        <?php echo e(__('Watch Progress')); ?>

                    </h5>
                    
                    <div class="progress-bar-custom mb-3">
                        <div class="progress-fill" id="progress-fill" style="width: 0%"></div>
                    </div>
                    
                    <div class="stats-grid">
                        <div class="stat-item">
                            <div class="stat-value" id="watched-time">0:00</div>
                            <div class="stat-label"><?php echo e(__('Watched')); ?></div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value"><?php echo e($watchTask->formatted_duration); ?></div>
                            <div class="stat-label"><?php echo e(__('Required')); ?></div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value" id="progress-percentage">0%</div>
                            <div class="stat-label"><?php echo e(__('Progress')); ?></div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value"><?php echo e($watchTask->reward_amount); ?>₺</div>
                            <div class="stat-label"><?php echo e(__('Reward')); ?></div>
                        </div>
                    </div>
                    
                    <div class="mt-3 text-center">
                        <small class="opacity-75">
                            <i class="bx bx-info-circle me-1"></i>
                            <?php echo e(__('Keep watching to earn your reward!')); ?>

                        </small>
                    </div>
                </div>
                
                <!-- Reward Card -->
                <div class="reward-card" id="reward-card">
                    <div class="pulse">
                        <i class="bx bx-trophy" style="font-size: 3rem; margin-bottom: 15px;"></i>
                    </div>
                    <h4 class="mb-3">🎉 <?php echo e(__('Congratulations!')); ?></h4>
                    <p class="mb-3"><?php echo e(__('You have successfully watched the required duration!')); ?></p>
                    <button class="btn btn-light btn-lg" id="claim-reward-btn">
                        <i class="bx bx-gift me-2"></i>
                        <?php echo e(__('Claim')); ?> <?php echo e($watchTask->reward_amount); ?>₺
                    </button>
                </div>
                
                <!-- Instructions -->
                <div class="card mt-3">
                    <div class="card-body">
                        <h6 class="mb-3">
                            <i class="bx bx-help-circle text-primary me-2"></i>
                            <?php echo e(__('Instructions')); ?>

                        </h6>
                        <ul class="list-unstyled mb-0">
                            <li class="mb-2">
                                <i class="bx bx-check text-success me-2"></i>
                                <?php echo e(__('Watch the video for at least')); ?> <?php echo e($watchTask->formatted_duration); ?>

                            </li>
                            <li class="mb-2">
                                <i class="bx bx-check text-success me-2"></i>
                                <?php echo e(__('Keep this tab active and focused')); ?>

                            </li>
                            <li class="mb-2">
                                <i class="bx bx-check text-success me-2"></i>
                                <?php echo e(__('Do not skip or fast-forward')); ?>

                            </li>
                            <li class="mb-0">
                                <i class="bx bx-check text-success me-2"></i>
                                <?php echo e(__('Claim your reward when completed')); ?>

                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="https://www.youtube.com/iframe_api"></script>
<script>
let player;
let watchStartTime = Date.now();
let totalWatchedTime = <?php echo e($completion->watched_duration ?? 0); ?>;
let requiredDuration = <?php echo e($watchTask->watch_duration); ?>;
let taskId = <?php echo e($watchTask->id); ?>;
let isCompleted = false;
let progressUpdateInterval;

// YouTube API Ready
function onYouTubeIframeAPIReady() {
    player = new YT.Player('youtube-player', {
        events: {
            'onReady': onPlayerReady,
            'onStateChange': onPlayerStateChange
        }
    });
}

function onPlayerReady(event) {
    console.log('Player ready');
    updateProgressDisplay();
}

function onPlayerStateChange(event) {
    if (event.data == YT.PlayerState.PLAYING) {
        startProgressTracking();
    } else {
        stopProgressTracking();
    }
}

function startProgressTracking() {
    if (progressUpdateInterval) {
        clearInterval(progressUpdateInterval);
    }
    
    watchStartTime = Date.now();
    
    progressUpdateInterval = setInterval(function() {
        if (player && player.getPlayerState() == YT.PlayerState.PLAYING) {
            let currentTime = Date.now();
            let sessionWatchTime = Math.floor((currentTime - watchStartTime) / 1000);
            totalWatchedTime = Math.max(totalWatchedTime, totalWatchedTime + 1);
            
            updateProgressDisplay();
            updateServerProgress();
            
            // Check if completed
            if (totalWatchedTime >= requiredDuration && !isCompleted) {
                showRewardCard();
            }
        }
    }, 1000);
}

function stopProgressTracking() {
    if (progressUpdateInterval) {
        clearInterval(progressUpdateInterval);
    }
}

function updateProgressDisplay() {
    let percentage = Math.min(100, (totalWatchedTime / requiredDuration) * 100);
    let minutes = Math.floor(totalWatchedTime / 60);
    let seconds = totalWatchedTime % 60;
    
    $('#progress-fill').css('width', percentage + '%');
    $('#watched-time').text(minutes + ':' + (seconds < 10 ? '0' : '') + seconds);
    $('#progress-percentage').text(Math.floor(percentage) + '%');
}

function updateServerProgress() {
    $.ajax({
        url: "<?php echo e(route('watch.progress')); ?>",
        method: 'POST',
        data: {
            task_id: taskId,
            watched_duration: totalWatchedTime,
            _token: $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {
            if (response.success && response.can_claim_reward && !isCompleted) {
                showRewardCard();
            }
        }
    });
}

function showRewardCard() {
    isCompleted = true;
    stopProgressTracking();
    $('#reward-card').addClass('show');
    
    // Show notification
    if (typeof Lobibox !== 'undefined') {
        Lobibox.notify('success', {
            title: "<?php echo e(__('Congratulations!')); ?>",
            msg: "<?php echo e(__('You can now claim your reward!')); ?>",
            position: 'top right',
            icon: 'bx bx-trophy'
        });
    }
}

// Claim reward
$('#claim-reward-btn').on('click', function() {
    let btn = $(this);
    btn.prop('disabled', true).html('<i class="bx bx-loader-alt bx-spin me-2"></i><?php echo e(__("Processing...")); ?>');
    
    $.ajax({
        url: "<?php echo e(route('watch.claim')); ?>",
        method: 'POST',
        data: {
            task_id: taskId,
            _token: $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: "<?php echo e(__('Reward Claimed!')); ?>",
                    html: `
                        <div class="text-center">
                            <div style="font-size: 3rem; margin: 20px 0;">🎉</div>
                            <h4>${response.message}</h4>
                            <p class="mt-3"><?php echo e(__('New Balance')); ?>: <strong>${response.new_balance}₺</strong></p>
                        </div>
                    `,
                    showConfirmButton: true,
                    confirmButtonText: "<?php echo e(__('Continue Watching')); ?>",
                    allowOutsideClick: false
                }).then(() => {
                    window.location.href = "<?php echo e(route('watch.video', $task->id)); ?>";
                });
            } else {
                Swal.fire('<?php echo e(__("Error")); ?>', response.message, 'error');
                btn.prop('disabled', false).html('<i class="bx bx-gift me-2"></i><?php echo e(__("Claim")); ?> <?php echo e($watchTask->reward_amount); ?>₺');
            }
        },
        error: function() {
            Swal.fire('<?php echo e(__("Error")); ?>', '<?php echo e(__("An error occurred. Please try again.")); ?>', 'error');
            btn.prop('disabled', false).html('<i class="bx bx-gift me-2"></i><?php echo e(__("Claim")); ?> <?php echo e($watchTask->reward_amount); ?>₺');
        }
    });
});

// Page visibility change
document.addEventListener('visibilitychange', function() {
    if (document.hidden) {
        stopProgressTracking();
    } else if (player && player.getPlayerState() == YT.PlayerState.PLAYING) {
        startProgressTracking();
    }
});

// Prevent page unload if watching
window.addEventListener('beforeunload', function(e) {
    if (player && player.getPlayerState() == YT.PlayerState.PLAYING && !isCompleted) {
        e.preventDefault();
        e.returnValue = "<?php echo e(__('Are you sure you want to leave? Your progress will be saved.')); ?>";
    }
});

// Initial progress update
$(document).ready(function() {
    updateProgressDisplay();
    
    // Update progress every 30 seconds
    setInterval(updateServerProgress, 30000);
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/watch/player.blade.php ENDPATH**/ ?>