<?php $__env->startSection('title', __('Backup Management')); ?>

<?php $__env->startSection('style'); ?>
<link href="<?php echo e(asset('assets/plugins/notifications/css/lobibox.min.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
    .backup-card {
        border: 1px solid #e9ecef;
        border-radius: 16px;
        transition: all 0.3s ease;
        background: white;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        margin-bottom: 20px;
    }
    
    .backup-card:hover {
        box-shadow: 0 8px 30px rgba(0,0,0,0.15);
        transform: translateY(-3px);
    }
    
    .backup-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 20px;
        border-radius: 16px 16px 0 0;
        position: relative;
    }
    
    .backup-header::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, #28a745, #20c997, #17a2b8);
    }
    
    .stats-card {
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        border: none;
        transition: transform 0.3s ease;
    }
    
    .stats-card:hover {
        transform: translateY(-5px);
    }
    
    .stats-icon {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
        margin-bottom: 15px;
    }
    
    .progress-custom {
        height: 8px;
        border-radius: 10px;
        background-color: #f8f9fa;
    }
    
    .progress-custom .progress-bar {
        border-radius: 10px;
    }
    
    .disk-usage {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        color: white;
        border-radius: 12px;
        padding: 20px;
    }
    
    .action-buttons .btn {
        margin: 2px;
        border-radius: 8px;
        font-size: 0.85rem;
    }
    
    .backup-type-badge {
        font-size: 0.75rem;
        padding: 4px 8px;
        border-radius: 12px;
        font-weight: 600;
    }
    
    .file-size {
        font-family: 'Courier New', monospace;
        font-weight: bold;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Admin')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/home')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Backup Management')); ?></li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <button class="btn btn-primary" onclick="showCreateBackupModal()">
                    <i class="bx bx-plus"></i> <?php echo e(__('Create Backup')); ?>

                </button>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-lg-3 col-md-6">
                <div class="stats-card">
                    <div class="stats-icon bg-primary mx-auto">
                        <i class="bx bx-data"></i>
                    </div>
                    <div class="text-center">
                        <h4 class="mb-1"><?php echo e($stats['total_backups']); ?></h4>
                        <p class="text-muted mb-0"><?php echo e(__('Total Backups')); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stats-card">
                    <div class="stats-icon bg-success mx-auto">
                        <i class="bx bx-check-circle"></i>
                    </div>
                    <div class="text-center">
                        <h4 class="mb-1"><?php echo e($stats['completed_backups']); ?></h4>
                        <p class="text-muted mb-0"><?php echo e(__('Completed')); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stats-card">
                    <div class="stats-icon bg-danger mx-auto">
                        <i class="bx bx-x-circle"></i>
                    </div>
                    <div class="text-center">
                        <h4 class="mb-1"><?php echo e($stats['failed_backups']); ?></h4>
                        <p class="text-muted mb-0"><?php echo e(__('Failed')); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stats-card">
                    <div class="stats-icon bg-info mx-auto">
                        <i class="bx bx-hdd"></i>
                    </div>
                    <div class="text-center">
                        <h4 class="mb-1 file-size"><?php echo e(\App\Helpers\BackupHelper::formatBytes($stats['total_size'])); ?></h4>
                        <p class="text-muted mb-0"><?php echo e(__('Total Size')); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Disk Usage -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="disk-usage">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h5 class="mb-2"><?php echo e(__('Disk Usage')); ?></h5>
                            <div class="progress progress-custom mb-2">
                                <?php
                                    $usedPercentage = $diskSpace['total'] > 0 ? ($diskSpace['used'] / $diskSpace['total']) * 100 : 0;
                                ?>
                                <div class="progress-bar bg-white" style="width: <?php echo e($usedPercentage); ?>%"></div>
                            </div>
                            <small>
                                <?php echo e(__('Used')); ?>: <?php echo e(\App\Helpers\BackupHelper::formatBytes($diskSpace['used'])); ?> / 
                                <?php echo e(__('Total')); ?>: <?php echo e(\App\Helpers\BackupHelper::formatBytes($diskSpace['total'])); ?> 
                                (<?php echo e(number_format($usedPercentage, 1)); ?>%)
                            </small>
                        </div>
                        <div class="col-md-4 text-end">
                            <button class="btn btn-outline-light" onclick="showCleanupModal()">
                                <i class="bx bx-trash"></i> <?php echo e(__('Cleanup Old Backups')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Backups List -->
        <div class="backup-card">
            <div class="backup-header">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1"><?php echo e(__('Backup History')); ?></h4>
                        <p class="mb-0 opacity-75"><?php echo e(__('Manage your system backups')); ?></p>
                    </div>
                    <div>
                        <button class="btn btn-outline-light btn-sm" onclick="refreshBackups()">
                            <i class="bx bx-refresh"></i> <?php echo e(__('Refresh')); ?>

                        </button>
                    </div>
                </div>
            </div>
            
            <div class="card-body">
                <div class="table-responsive">
                    <table id="backupsTable" class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo e(__('Name')); ?></th>
                                <th><?php echo e(__('Type')); ?></th>
                                <th><?php echo e(__('Size')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th><?php echo e(__('Progress')); ?></th>
                                <th><?php echo e(__('Created')); ?></th>
                                <th><?php echo e(__('Created By')); ?></th>
                                <th><?php echo e(__('Actions')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $backups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $backup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr id="backup-<?php echo e($backup->id); ?>">
                                <td>
                                    <div>
                                        <strong><?php echo e($backup->original_name); ?></strong>
                                        <?php if($backup->description): ?>
                                            <br><small class="text-muted"><?php echo e($backup->description); ?></small>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($backup->type_badge); ?> backup-type-badge">
                                        <?php echo e($backup->type_text); ?>

                                    </span>
                                </td>
                                <td>
                                    <span class="file-size">
                                        <?php echo e($backup->file_size ? \App\Helpers\BackupHelper::formatBytes($backup->file_size) : '-'); ?>

                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($backup->status_badge); ?>">
                                        <?php echo e($backup->status_text); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php if($backup->status === 'processing'): ?>
                                        <div class="progress progress-custom" style="height: 6px;">
                                            <div class="progress-bar bg-info" style="width: <?php echo e($backup->progress); ?>%"></div>
                                        </div>
                                        <small><?php echo e($backup->progress); ?>%</small>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div>
                                        <?php echo e($backup->created_at->format('d.m.Y H:i')); ?>

                                        <br><small class="text-muted"><?php echo e($backup->age); ?></small>
                                    </div>
                                </td>
                                <td>
                                    <?php echo e($backup->creator->account_holder ?? __('System')); ?>

                                </td>
                                <td>
                                    <div class="action-buttons">
                                        <?php if($backup->canBeDownloaded()): ?>
                                            <a href="<?php echo e(route('admin.backups.download', $backup->id)); ?>" 
                                               class="btn btn-sm btn-outline-primary" 
                                               title="<?php echo e(__('Download')); ?>">
                                                <i class="bx bx-download"></i>
                                            </a>
                                        <?php endif; ?>
                                        
                                        <?php if($backup->canBeRestored()): ?>
                                            <button class="btn btn-sm btn-outline-warning" 
                                                    onclick="showRestoreModal(<?php echo e($backup->id); ?>)"
                                                    title="<?php echo e(__('Restore')); ?>">
                                                <i class="bx bx-reset"></i>
                                            </button>
                                        <?php endif; ?>
                                        
                                        <button class="btn btn-sm btn-outline-danger" 
                                                onclick="deleteBackup(<?php echo e($backup->id); ?>)"
                                                title="<?php echo e(__('Delete')); ?>">
                                            <i class="bx bx-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-3">
                    <?php echo e($backups->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Create Backup Modal -->
<div class="modal fade" id="createBackupModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Create New Backup')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="createBackupForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Backup Type')); ?> <span class="text-danger">*</span></label>
                        <select class="form-select" name="type" required>
                            <option value=""><?php echo e(__('Select backup type')); ?></option>
                            <option value="database"><?php echo e(__('Database Only')); ?></option>
                            <option value="files"><?php echo e(__('Files Only')); ?></option>
                            <option value="full"><?php echo e(__('Full Backup (Database + Files)')); ?></option>
                        </select>
                        <div class="form-text">
                            <small>
                                <strong><?php echo e(__('Database Only')); ?>:</strong> <?php echo e(__('Exports all database tables and data')); ?><br>
                                <strong><?php echo e(__('Files Only')); ?>:</strong> <?php echo e(__('Backs up application files and uploads')); ?><br>
                                <strong><?php echo e(__('Full Backup')); ?>:</strong> <?php echo e(__('Complete backup including database and files')); ?>

                            </small>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Description')); ?> <span class="text-muted">(<?php echo e(__('Optional')); ?>)</span></label>
                        <textarea class="form-control" name="description" rows="3" 
                                  placeholder="<?php echo e(__('Add a description for this backup...')); ?>"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bx bx-plus"></i> <?php echo e(__('Create Backup')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Restore Modal -->
<div class="modal fade" id="restoreModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Restore Database')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="restoreForm">
                <div class="modal-body">
                    <div class="alert alert-warning">
                        <i class="bx bx-warning"></i>
                        <strong><?php echo e(__('Warning!')); ?></strong> 
                        <?php echo e(__('This will replace all current database data with the backup data. This action cannot be undone.')); ?>

                    </div>
                    
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="confirm" id="confirmRestore" required>
                        <label class="form-check-label" for="confirmRestore">
                            <?php echo e(__('I understand that this will overwrite all current data')); ?>

                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                    <button type="submit" class="btn btn-danger">
                        <i class="bx bx-reset"></i> <?php echo e(__('Restore Database')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Cleanup Modal -->
<div class="modal fade" id="cleanupModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(__('Cleanup Old Backups')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="cleanupForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Delete backups older than')); ?> <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="number" class="form-control" name="days" min="1" max="365" value="30" required>
                            <span class="input-group-text"><?php echo e(__('days')); ?></span>
                        </div>
                        <div class="form-text"><?php echo e(__('Backups older than this many days will be permanently deleted')); ?></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                    <button type="submit" class="btn btn-warning">
                        <i class="bx bx-trash"></i> <?php echo e(__('Cleanup Backups')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('assets/plugins/notifications/js/lobibox.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>

<script>
let currentRestoreId = null;

$(document).ready(function() {
    // Initialize DataTable
    $('#backupsTable').DataTable({
        pageLength: 25,
        responsive: true,
        order: [[5, 'desc']], // Order by created date desc
        language: {
            processing: "<?php echo e(__('Processing...')); ?>",
            search: "<?php echo e(__('Search:')); ?>",
            lengthMenu: "<?php echo e(__('Show _MENU_ entries')); ?>",
            info: "<?php echo e(__('Showing _START_ to _END_ of _TOTAL_ entries')); ?>",
            infoEmpty: "<?php echo e(__('Showing 0 to 0 of 0 entries')); ?>",
            infoFiltered: "<?php echo e(__('(filtered from _MAX_ total entries)')); ?>",
            paginate: {
                first: "<?php echo e(__('First')); ?>",
                last: "<?php echo e(__('Last')); ?>",
                next: "<?php echo e(__('Next')); ?>",
                previous: "<?php echo e(__('Previous')); ?>"
            }
        }
    });

    // Auto-refresh processing backups every 5 seconds
    setInterval(function() {
        refreshProcessingBackups();
    }, 5000);
});

// Show create backup modal
function showCreateBackupModal() {
    $('#createBackupModal').modal('show');
}

// Show restore modal
function showRestoreModal(backupId) {
    currentRestoreId = backupId;
    $('#restoreModal').modal('show');
}

// Show cleanup modal
function showCleanupModal() {
    $('#cleanupModal').modal('show');
}

// Create backup form submission
$('#createBackupForm').on('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    $.ajax({
        url: '<?php echo e(route("admin.backups.create")); ?>',
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {
            if (response.success) {
                showNotification('success', response.message);
                $('#createBackupModal').modal('hide');
                setTimeout(() => location.reload(), 1500);
            } else {
                showNotification('error', response.message);
            }
        },
        error: function(xhr) {
            const message = xhr.responseJSON?.message || '<?php echo e(__("Error creating backup")); ?>';
            showNotification('error', message);
        }
    });
});

// Restore form submission
$('#restoreForm').on('submit', function(e) {
    e.preventDefault();
    
    if (!currentRestoreId) return;
    
    const formData = new FormData(this);
    
    $.ajax({
        url: `/admin/backups/${currentRestoreId}/restore`,
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {
            if (response.success) {
                showNotification('success', response.message);
                $('#restoreModal').modal('hide');
            } else {
                showNotification('error', response.message);
            }
        },
        error: function(xhr) {
            const message = xhr.responseJSON?.message || '<?php echo e(__("Error restoring backup")); ?>';
            showNotification('error', message);
        }
    });
});

// Cleanup form submission
$('#cleanupForm').on('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    $.ajax({
        url: '<?php echo e(route("admin.backups.cleanup")); ?>',
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {
            if (response.success) {
                showNotification('success', response.message);
                $('#cleanupModal').modal('hide');
                setTimeout(() => location.reload(), 1500);
            } else {
                showNotification('error', response.message);
            }
        },
        error: function(xhr) {
            const message = xhr.responseJSON?.message || '<?php echo e(__("Error during cleanup")); ?>';
            showNotification('error', message);
        }
    });
});

// Delete backup
function deleteBackup(backupId) {
    Swal.fire({
        title: '<?php echo e(__("Are you sure?")); ?>',
        text: '<?php echo e(__("This backup will be permanently deleted!")); ?>',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: '<?php echo e(__("Yes, delete it!")); ?>',
        cancelButtonText: '<?php echo e(__("Cancel")); ?>',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/admin/backups/${backupId}`,
                method: 'POST',
                data: { _method: 'DELETE' },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        showNotification('success', response.message);
                        $(`#backup-${backupId}`).fadeOut();
                    } else {
                        showNotification('error', response.message);
                    }
                },
                error: function(xhr) {
                    const message = xhr.responseJSON?.message || '<?php echo e(__("Error deleting backup")); ?>';
                    showNotification('error', message);
                }
            });
        }
    });
}

// Refresh backups
function refreshBackups() {
    location.reload();
}

// Refresh processing backups
function refreshProcessingBackups() {
    $('tr[id^="backup-"]').each(function() {
        const row = $(this);
        const backupId = row.attr('id').replace('backup-', '');
        const statusBadge = row.find('.badge');
        
        if (statusBadge.text().trim() === '<?php echo e(__("Processing")); ?>') {
            $.ajax({
                url: `/admin/backups/${backupId}/progress`,
                method: 'GET',
                success: function(response) {
                    if (response.status === 'completed') {
                        location.reload();
                    } else if (response.status === 'failed') {
                        location.reload();
                    } else {
                        // Update progress
                        const progressBar = row.find('.progress-bar');
                        const progressText = row.find('small');
                        
                        if (progressBar.length) {
                            progressBar.css('width', response.progress + '%');
                            progressText.text(response.progress + '%');
                        }
                    }
                }
            });
        }
    });
}

// Show notification
function showNotification(type, message) {
    Lobibox.notify(type, {
        pauseDelayOnHover: true,
        continueDelayOnInactiveTab: false,
        position: 'top right',
        icon: type === 'success' ? 'bx bx-check-circle' : 'bx bx-x-circle',
        msg: message,
        delay: 4000
    });
}

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/admin/backups/index.blade.php ENDPATH**/ ?>