<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!-- Header -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Earnings Management')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/home')); ?>"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Earnings')); ?></li>
                    </ol>
                </nav>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="row">
            <div class="col-12 col-lg-8 col-xl-8 d-flex">
                <div class="card radius-10 w-100">
                    <div class="card-body">
                        <div class="row">
                            <!-- Total Platform Earnings -->
                            <div class="col-6 col-md-3">
                                <div class="text-center">
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-cosmic text-white mx-auto">
                                        <i class='bx bx-trending-up'></i>
                                    </div>
                                    <h4 class="my-2"><?php echo e(number_format($stats['total_earnings'], 2)); ?> <?php echo e(app('settings')['currency'] ?? '₺'); ?></h4>
                                    <p class="mb-0 text-secondary"><?php echo e(__('Total Platform Earnings')); ?></p>
                                </div>
                            </div>
                            
                            <!-- Active Users -->
                            <div class="col-6 col-md-3">
                                <div class="text-center">
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-ibiza text-white mx-auto">
                                        <i class='bx bx-user-check'></i>
                                    </div>
                                    <h4 class="my-2"><?php echo e(number_format($stats['active_users'])); ?></h4>
                                    <p class="mb-0 text-secondary"><?php echo e(__('Active Users')); ?></p>
                                </div>
                            </div>
                            
                            <!-- Today's Earnings -->
                            <div class="col-6 col-md-3">
                                <div class="text-center">
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white mx-auto">
                                        <i class='bx bx-calendar-check'></i>
                                    </div>
                                    <h4 class="my-2"><?php echo e(number_format($stats['today_earnings'], 2)); ?> <?php echo e(app('settings')['currency'] ?? '₺'); ?></h4>
                                    <p class="mb-0 text-secondary"><?php echo e(__('Today Earnings')); ?></p>
                                </div>
                            </div>
                            
                            <!-- Monthly Average -->
                            <div class="col-6 col-md-3">
                                <div class="text-center">
                                    <div class="widgets-icons-2 rounded-circle bg-gradient-moonlit text-white mx-auto">
                                        <i class='bx bx-bar-chart-alt-2'></i>
                                    </div>
                                    <h4 class="my-2"><?php echo e(number_format($stats['monthly_average'], 2)); ?> <?php echo e(app('settings')['currency'] ?? '₺'); ?></h4>
                                    <p class="mb-0 text-secondary"><?php echo e(__('Monthly Average')); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Top Earners -->
            <div class="col-12 col-lg-4 col-xl-4">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0"><?php echo e(__('Top Earners')); ?></h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $__currentLoopData = $topEarners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $earner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex align-items-center mb-3">
                            <div class="me-3">
                                <span class="badge bg-primary rounded-pill"><?php echo e($index + 1); ?></span>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0"><?php echo e($earner->account_holder); ?></h6>
                                <small class="text-muted"><?php echo e(number_format($earner->total_earnings, 2)); ?> <?php echo e(app('settings')['currency'] ?? '₺'); ?></small>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts Row -->
        <div class="row">
            <!-- Weekly Earnings Chart -->
            <div class="col-12 col-lg-6">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0"><?php echo e(__('Weekly Earnings')); ?></h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="weeklyChart" height="300"></canvas>
                    </div>
                </div>
            </div>
            
            <!-- Monthly Earnings Chart -->
            <div class="col-12 col-lg-6">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0"><?php echo e(__('Monthly Earnings')); ?></h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="monthlyChart" height="300"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Earnings by Type Chart -->
        <div class="row">
            <div class="col-12 col-lg-8">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0"><?php echo e(__('Earnings by Task Type')); ?></h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="earningsTypeChart" height="200"></canvas>
                    </div>
                </div>
            </div>
            
            <!-- Earnings Distribution -->
            <div class="col-12 col-lg-4">
                <div class="card radius-10">
                    <div class="card-header">
                        <div class="d-flex align-items-center">
                            <div>
                                <h6 class="mb-0"><?php echo e(__('Task Distribution')); ?></h6>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="distributionChart" height="300"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Weekly Chart
    const weeklyCtx = document.getElementById('weeklyChart').getContext('2d');
    new Chart(weeklyCtx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode($weeklyData['labels']); ?>,
            datasets: [{
                label: '<?php echo e(__("Daily Earnings")); ?>',
                data: <?php echo json_encode($weeklyData['data']); ?>,
                borderColor: 'rgb(75, 192, 192)',
                backgroundColor: 'rgba(75, 192, 192, 0.1)',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return value + ' <?php echo e(app("settings")["currency"] ?? "₺"); ?>';
                        }
                    }
                }
            }
        }
    });

    // Monthly Chart
    const monthlyCtx = document.getElementById('monthlyChart').getContext('2d');
    new Chart(monthlyCtx, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($monthlyData['labels']); ?>,
            datasets: [{
                label: '<?php echo e(__("Monthly Earnings")); ?>',
                data: <?php echo json_encode($monthlyData['data']); ?>,
                backgroundColor: 'rgba(54, 162, 235, 0.8)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return value + ' <?php echo e(app("settings")["currency"] ?? "₺"); ?>';
                        }
                    }
                }
            }
        }
    });

    // Earnings by Type Chart
    const typeCtx = document.getElementById('earningsTypeChart').getContext('2d');
    new Chart(typeCtx, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($earningsByType['labels']); ?>,
            datasets: [{
                label: '<?php echo e(__("Earnings")); ?>',
                data: <?php echo json_encode($earningsByType['data']); ?>,
                backgroundColor: [
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 205, 86, 0.8)',
                    'rgba(75, 192, 192, 0.8)'
                ],
                borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 205, 86, 1)',
                    'rgba(75, 192, 192, 1)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return value + ' <?php echo e(app("settings")["currency"] ?? "₺"); ?>';
                        }
                    }
                }
            }
        }
    });

    // Distribution Chart (Pie)
    const distributionCtx = document.getElementById('distributionChart').getContext('2d');
    new Chart(distributionCtx, {
        type: 'doughnut',
        data: {
            labels: <?php echo json_encode($earningsByType['labels']); ?>,
            datasets: [{
                data: <?php echo json_encode($earningsByType['data']); ?>,
                backgroundColor: [
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 205, 86, 0.8)',
                    'rgba(75, 192, 192, 0.8)'
                ],
                borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 205, 86, 1)',
                    'rgba(75, 192, 192, 1)'
                ],
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/profits/admin.blade.php ENDPATH**/ ?>