<!-- Mobile Cards Layout -->
<div class="d-block d-lg-none">
    <?php $__empty_1 = true; $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="mobile-request-card request-item" data-id="<?php echo e($request->id); ?>">
            <div class="d-flex justify-content-between align-items-start mb-3">
                <div class="d-flex align-items-center">
                    <div class="stat-icon primary me-3" style="width: 45px; height: 45px; font-size: 1.2rem;">
                        <i class="bx bx-user"></i>
                    </div>
                    <div>
                        <h6 class="mb-0 fw-bold"><?php echo e($request->user->username ?? 'N/A'); ?></h6>
                        <small class="text-muted"><?php echo e($request->user->email ?? 'N/A'); ?></small>
                    </div>
                </div>
                <div class="text-end">
                    <?php if($request->status == 'pending'): ?>
                        <span class="status-badge bg-warning text-dark"><?php echo e(__('Pending')); ?></span>
                    <?php elseif($request->status == 'completed'): ?>
                        <span class="status-badge bg-success text-white"><?php echo e(__('Approved')); ?></span>
                    <?php elseif($request->status == 'rejected'): ?>
                        <span class="status-badge bg-danger text-white"><?php echo e(__('Rejected')); ?></span>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="row g-3 mb-3">
                <div class="col-6">
                    <div class="d-flex align-items-center">
                        <i class="bx bx-money text-success me-2"></i>
                        <div>
                            <small class="text-muted d-block"><?php echo e(__('Amount')); ?></small>
                            <span class="fw-bold text-success"><?php echo e(number_format($request->amount, 2)); ?> ₺</span>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="d-flex align-items-center">
                        <i class="bx bx-calendar text-primary me-2"></i>
                        <div>
                            <small class="text-muted d-block"><?php echo e(__('Date')); ?></small>
                            <span class="fw-medium"><?php echo e($request->created_at->format('d.m.Y H:i')); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <?php if($request->receipt_path): ?>
                <div class="mb-3">
                    <a href="<?php echo e(route('admin.balance-requests.download-receipt', ['id' => $request->id])); ?>" 
                       class="btn btn-sm btn-outline-primary btn-modern">
                        <i class="bx bx-download me-1"></i> <?php echo e(__('Download Receipt')); ?>

                    </a>
                </div>
            <?php endif; ?>

            <div class="d-flex gap-2 flex-wrap">
                <button class="btn btn-sm btn-outline-info btn-modern" onclick="viewRequest(<?php echo e($request->id); ?>)">
                    <i class="bx bx-show me-1"></i> <?php echo e(__('View')); ?>

                </button>
                <?php if($request->status == 'pending'): ?>
                    <button class="btn btn-sm btn-success btn-modern" onclick="approveRequest(<?php echo e($request->id); ?>)">
                        <i class="bx bx-check me-1"></i> <?php echo e(__('Approve')); ?>

                    </button>
                    <button class="btn btn-sm btn-danger btn-modern" onclick="rejectRequest(<?php echo e($request->id); ?>)">
                        <i class="bx bx-x me-1"></i> <?php echo e(__('Reject')); ?>

                    </button>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="text-center py-5">
            <div class="stat-icon info d-inline-flex mb-3" style="width: 80px; height: 80px; font-size: 2rem;">
                <i class="bx bx-inbox"></i>
            </div>
            <h5 class="text-muted mb-2"><?php echo e(__('No balance requests found')); ?></h5>
            <p class="text-muted"><?php echo e(__('There are no balance requests to display at the moment.')); ?></p>
        </div>
    <?php endif; ?>
</div>

<!-- Desktop Table Layout -->
<div class="d-none d-lg-block">
    <div class="table-responsive">
        <table class="table table-hover align-middle">
            <thead>
                <tr style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
                    <th class="border-0 fw-bold text-dark">ID</th>
                    <th class="border-0 fw-bold text-dark"><?php echo e(__('User')); ?></th>
                    <th class="border-0 fw-bold text-dark"><?php echo e(__('Amount')); ?></th>
                    <th class="border-0 fw-bold text-dark"><?php echo e(__('Date')); ?></th>
                    <th class="border-0 fw-bold text-dark"><?php echo e(__('Status')); ?></th>
                    <th class="border-0 fw-bold text-dark"><?php echo e(__('Receipt')); ?></th>
                    <th class="border-0 text-center fw-bold text-dark"><?php echo e(__('Actions')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="request-item" data-id="<?php echo e($request->id); ?>" style="border-bottom: 1px solid #f1f3f4;">
                        <td class="py-3">
                            <span class="badge" style="background: linear-gradient(135deg, #6f42c1 0%, #007bff 100%); color: white; padding: 6px 10px; border-radius: 12px;">#<?php echo e($request->id); ?></span>
                        </td>
                        <td class="py-3">
                            <div class="d-flex align-items-center">
                                <div class="stat-icon primary me-3" style="width: 40px; height: 40px; font-size: 1rem;">
                                    <i class="bx bx-user"></i>
                                </div>
                                <div>
                                    <div class="fw-bold text-dark"><?php echo e($request->user->username ?? 'N/A'); ?></div>
                                    <small class="text-muted"><?php echo e($request->user->email ?? 'N/A'); ?></small>
                                </div>
                            </div>
                        </td>
                        <td class="py-3">
                            <div class="d-flex align-items-center">
                                <i class="bx bx-money text-success me-2 fs-5"></i>
                                <span class="fw-bold text-success fs-5"><?php echo e(number_format($request->amount, 2)); ?> ₺</span>
                            </div>
                        </td>
                        <td class="py-3">
                            <div class="d-flex align-items-center">
                                <i class="bx bx-calendar text-primary me-2"></i>
                                <div>
                                    <div class="fw-medium"><?php echo e($request->created_at->format('d.m.Y')); ?></div>
                                    <small class="text-muted"><?php echo e($request->created_at->format('H:i')); ?></small>
                                </div>
                            </div>
                        </td>
                        <td class="py-3">
                            <?php if($request->status == 'pending'): ?>
                                <span class="status-badge bg-warning text-dark"><?php echo e(__('Pending')); ?></span>
                            <?php elseif($request->status == 'completed'): ?>
                                <span class="status-badge bg-success text-white"><?php echo e(__('Approved')); ?></span>
                            <?php elseif($request->status == 'rejected'): ?>
                                <span class="status-badge bg-danger text-white"><?php echo e(__('Rejected')); ?></span>
                            <?php endif; ?>
                        </td>
                        <td class="py-3">
                            <?php if($request->receipt_path): ?>
                                <a href="<?php echo e(route('admin.balance-requests.download-receipt', ['id' => $request->id])); ?>" 
                                   class="btn btn-sm btn-outline-primary btn-modern">
                                    <i class="bx bx-download me-1"></i>
                                    <span class="d-none d-xl-inline"><?php echo e(__('Download')); ?></span>
                                </a>
                            <?php else: ?>
                                <span class="text-muted fst-italic"><?php echo e(__('No receipt')); ?></span>
                            <?php endif; ?>
                        </td>
                        <td class="text-center py-3">
                            <div class="btn-group" role="group">
                                <button class="btn btn-sm btn-outline-info btn-modern" onclick="viewRequest(<?php echo e($request->id); ?>)" title="<?php echo e(__('View Details')); ?>">
                                    <i class="bx bx-show"></i>
                                </button>
                                <?php if($request->status == 'pending'): ?>
                                    <button class="btn btn-sm btn-outline-success btn-modern" onclick="approveRequest(<?php echo e($request->id); ?>)" title="<?php echo e(__('Approve')); ?>">
                                        <i class="bx bx-check"></i>
                                    </button>
                                    <button class="btn btn-sm btn-outline-danger btn-modern" onclick="rejectRequest(<?php echo e($request->id); ?>)" title="<?php echo e(__('Reject')); ?>">
                                        <i class="bx bx-x"></i>
                                    </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center py-5">
                            <div class="stat-icon info d-inline-flex mb-3" style="width: 80px; height: 80px; font-size: 2rem;">
                                <i class="bx bx-inbox"></i>
                            </div>
                            <h5 class="text-muted mb-2"><?php echo e(__('No balance requests found')); ?></h5>
                            <p class="text-muted"><?php echo e(__('There are no balance requests to display at the moment.')); ?></p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Pagination -->
<?php if($requests->hasPages()): ?>
    <div class="d-flex justify-content-center mt-4 px-3">
        <?php echo e($requests->links()); ?>

    </div>
<?php endif; ?><?php /**PATH /home/saat/public_html/resources/views/admin/balance-requests/partials/requests-list.blade.php ENDPATH**/ ?>