<?php $__env->startSection('title', __('Balance Requests')); ?>

<?php $__env->startSection('style'); ?>
    <link href="<?php echo e(asset('assets/plugins/notifications/css/lobibox.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet">
    <style>
        .balance-header {
            background: linear-gradient(135deg, #6f42c1 0%, #007bff 100%);
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 30px;
            color: white;
            position: relative;
            overflow: hidden;
        }
        .balance-header::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 200px;
            height: 200px;
            background: rgba(255,255,255,0.1);
            border-radius: 50%;
            transform: translate(50px, -50px);
        }
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: white;
            border-radius: 16px;
            padding: 25px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            border: 1px solid #f1f3f4;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 30px rgba(0,0,0,0.15);
        }
        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: linear-gradient(135deg, #6f42c1 0%, #007bff 100%);
        }
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.8rem;
            margin-bottom: 15px;
        }
        .stat-number {
            font-size: 2.2rem;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 5px;
        }
        .stat-label {
            color: #6c757d;
            font-size: 0.9rem;
            font-weight: 500;
        }
        .stat-change {
            font-size: 0.8rem;
            font-weight: 600;
            margin-top: 8px;
        }
        .stat-change.positive {
            color: #28a745;
        }
        .stat-change.negative {
            color: #dc3545;
        }
        .stat-change.neutral {
            color: #6c757d;
        }
        
        /* Icon Colors */
        .stat-icon.primary { background: linear-gradient(135deg, #6f42c1 0%, #007bff 100%); color: white; }
        .stat-icon.success { background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white; }
        .stat-icon.warning { background: linear-gradient(135deg, #ffc107 0%, #fd7e14 100%); color: white; }
        .stat-icon.danger { background: linear-gradient(135deg, #dc3545 0%, #e83e8c 100%); color: white; }
        .stat-icon.info { background: linear-gradient(135deg, #17a2b8 0%, #6f42c1 100%); color: white; }
        
        .table-container {
            background: white;
            border-radius: 16px;
            padding: 25px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            margin-bottom: 30px;
        }
        .table-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f8f9fa;
        }
        .table-title {
            font-size: 1.2rem;
            font-weight: 600;
            color: #2c3e50;
        }
        
        .status-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .mobile-balance-requests {
            background: white;
            border-radius: 16px;
            padding: 20px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        }
        
        .mobile-request-card {
            background: #f8f9fa;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 15px;
            border-left: 4px solid #6f42c1;
            transition: all 0.3s ease;
        }
        
        .mobile-request-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        
        .btn-modern {
            border-radius: 10px;
            padding: 8px 16px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .btn-modern:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Balance Management')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Balance Requests')); ?></li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <button class="btn btn-primary" onclick="refreshRequests()">
                    <i class="bx bx-refresh me-2"></i><?php echo e(__('Refresh')); ?>

                </button>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Balance Header -->
        <div class="balance-header">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h2 class="mb-2 text-white"><?php echo e(__('Balance Request Management')); ?></h2>
                    <p class="mb-0 opacity-75"><?php echo e(__('Manage and process user balance top-up requests')); ?></p>
                </div>
                <div class="col-md-4 text-md-end">
                    <div class="d-flex align-items-center justify-content-md-end">
                        <i class="bx bx-wallet" style="font-size: 3rem; opacity: 0.3;"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Grid -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="d-flex align-items-center">
                    <div class="stat-icon warning me-3">
                        <i class="bx bx-time"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="stat-number" id="pendingCount"><?php echo e($stats['pending'] ?? 0); ?></div>
                        <div class="stat-label"><?php echo e(__('Pending Requests')); ?></div>
                        <div class="stat-change neutral">
                            <i class="bx bx-loader-alt"></i> <?php echo e(__('Awaiting review')); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="d-flex align-items-center">
                    <div class="stat-icon success me-3">
                        <i class="bx bx-check"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="stat-number" id="approvedCount"><?php echo e($stats['completed'] ?? 0); ?></div>
                        <div class="stat-label"><?php echo e(__('Approved Requests')); ?></div>
                        <div class="stat-change positive">
                            <i class="bx bx-trending-up"></i> <?php echo e(__('Balance added')); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="d-flex align-items-center">
                    <div class="stat-icon danger me-3">
                        <i class="bx bx-x"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="stat-number" id="rejectedCount"><?php echo e($stats['rejected'] ?? 0); ?></div>
                        <div class="stat-label"><?php echo e(__('Rejected Requests')); ?></div>
                        <div class="stat-change negative">
                            <i class="bx bx-trending-down"></i> <?php echo e(__('Declined')); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="d-flex align-items-center">
                    <div class="stat-icon primary me-3">
                        <i class="bx bx-money"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="stat-number" id="totalAmount"><?php echo e(number_format($stats['total_amount'] ?? 0, 0)); ?>₺</div>
                        <div class="stat-label"><?php echo e(__('Total Amount')); ?></div>
                        <div class="stat-change neutral">
                            <i class="bx bx-calculator"></i> <?php echo e(__('All requests')); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="d-flex align-items-center">
                    <div class="stat-icon info me-3">
                        <i class="bx bx-transfer"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="stat-number" id="approvedAmount"><?php echo e(number_format($stats['approved_amount'] ?? 0, 0)); ?>₺</div>
                        <div class="stat-label"><?php echo e(__('Approved Amount')); ?></div>
                        <div class="stat-change positive">
                            <i class="bx bx-check-circle"></i> <?php echo e(__('Successfully processed')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Balance Requests Table -->
        <!-- Desktop Table -->
        <div class="table-container d-none d-lg-block">
            <div class="table-header">
                <h5 class="table-title"><?php echo e(__('Balance Requests')); ?></h5>
                <div class="d-flex gap-2">
                    <select class="form-select form-select-sm" id="statusFilter" style="width: auto;">
                        <option value=""><?php echo e(__('All Status')); ?></option>
                        <option value="pending"><?php echo e(__('Pending')); ?></option>
                        <option value="completed"><?php echo e(__('Approved')); ?></option>
                        <option value="rejected"><?php echo e(__('Rejected')); ?></option>
                    </select>
                </div>
            </div>
            
            <!-- Loading Indicator -->
            <div id="loadingIndicator" class="text-center py-5 d-none">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden"><?php echo e(__('Loading...')); ?></span>
                </div>
                <p class="mt-2 text-muted"><?php echo e(__('Loading requests...')); ?></p>
            </div>

            <!-- Requests Container -->
            <div id="requestsContainer">
                <?php echo $__env->make('admin.balance-requests.partials.requests-list', ['requests' => $requests], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>

        <!-- Mobile Cards -->
        <div class="mobile-balance-requests d-lg-none">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0"><?php echo e(__('Balance Requests')); ?></h5>
                <div class="d-flex gap-2">
                    <select class="form-select form-select-sm" id="statusFilterMobile" style="width: auto;">
                        <option value=""><?php echo e(__('All Status')); ?></option>
                        <option value="pending"><?php echo e(__('Pending')); ?></option>
                        <option value="completed"><?php echo e(__('Approved')); ?></option>
                        <option value="rejected"><?php echo e(__('Rejected')); ?></option>
                    </select>
                    <button class="btn btn-sm btn-primary" onclick="refreshRequests()">
                        <i class="bx bx-refresh"></i>
                    </button>
                </div>
            </div>
            
            <div id="mobileRequestsContainer">
                <?php echo $__env->make('admin.balance-requests.partials.requests-list', ['requests' => $requests], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>
    </div>
</div>

<!-- Approve Modal -->
<div class="modal fade" id="approveModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg" style="border-radius: 16px;">
            <div class="modal-header text-white" style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); border-radius: 16px 16px 0 0;">
                <h5 class="modal-title fw-bold">
                    <i class="bx bx-check-circle me-2"></i><?php echo e(__('Approve Request')); ?>

                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-4">
                <div class="text-center mb-3">
                    <div class="stat-icon success d-inline-flex mb-3" style="width: 80px; height: 80px; font-size: 2.5rem;">
                        <i class="bx bx-check-circle"></i>
                    </div>
                </div>
                <p class="text-center fs-5 mb-3"><?php echo e(__('Are you sure you want to approve this balance request?')); ?></p>
                <div class="alert alert-success border-0" style="background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%); border-radius: 12px;">
                    <i class="bx bx-info-circle me-2"></i>
                    <strong><?php echo e(__('User balance will be updated immediately')); ?></strong>
                </div>
            </div>
            <div class="modal-footer border-0 p-4">
                <button type="button" class="btn btn-light btn-modern" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <button type="button" class="btn btn-success btn-modern" id="confirmApprove">
                    <i class="bx bx-check me-2"></i><?php echo e(__('Approve')); ?>

                </button>
            </div>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg" style="border-radius: 16px;">
            <div class="modal-header text-white" style="background: linear-gradient(135deg, #dc3545 0%, #e83e8c 100%); border-radius: 16px 16px 0 0;">
                <h5 class="modal-title fw-bold">
                    <i class="bx bx-x-circle me-2"></i><?php echo e(__('Reject Request')); ?>

                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-4">
                <div class="text-center mb-3">
                    <div class="stat-icon danger d-inline-flex mb-3" style="width: 80px; height: 80px; font-size: 2.5rem;">
                        <i class="bx bx-x-circle"></i>
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold"><?php echo e(__('Rejection Reason')); ?> <span class="text-danger">*</span></label>
                    <textarea class="form-control" id="rejectionReason" rows="4" required 
                              placeholder="<?php echo e(__('Please explain the reason for rejection...')); ?>" style="border-radius: 10px;"></textarea>
                    <div class="invalid-feedback">
                        <?php echo e(__('Please provide a reason for rejection')); ?>

                    </div>
                </div>
            </div>
            <div class="modal-footer border-0 p-4">
                <button type="button" class="btn btn-light btn-modern" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <button type="button" class="btn btn-danger btn-modern" id="confirmReject">
                    <i class="bx bx-x me-2"></i><?php echo e(__('Reject')); ?>

                </button>
            </div>
        </div>
    </div>
</div>

<!-- View Request Modal -->
<div class="modal fade" id="viewModal" tabindex="-1">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg" style="border-radius: 16px;">
            <div class="modal-header text-white" style="background: linear-gradient(135deg, #17a2b8 0%, #6f42c1 100%); border-radius: 16px 16px 0 0;">
                <h5 class="modal-title fw-bold">
                    <i class="bx bx-show me-2"></i><?php echo e(__('Request Details')); ?>

                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-4" id="viewModalBody">
                <!-- Content will be loaded here -->
            </div>
            <div class="modal-footer border-0 p-4">
                <button type="button" class="btn btn-light btn-modern" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
// Global variables
let currentRequestId = null;

// View request details
function viewRequest(id) {
    $('#viewModalBody').html(`
        <div class="text-center py-4">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden"><?php echo e(__("Loading...")); ?></span>
            </div>
        </div>
    `);
    
    const modal = new bootstrap.Modal(document.getElementById('viewModal'));
    modal.show();
    
    $.ajax({
        url: `/admin/balance-requests/${id}`,
        type: 'GET',
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        },
        success: function(response) {
            $('#viewModalBody').html(response.html || response);
        },
        error: function(xhr) {
            let message = '<?php echo e(__("Failed to load request details")); ?>';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                message = xhr.responseJSON.message;
            }
            
            $('#viewModalBody').html(`
                <div class="alert alert-danger">
                    <i class="bx bx-error-circle me-2"></i>${message}
                </div>
            `);
        }
    });
}

// Approve request
function approveRequest(id) {
    currentRequestId = id;
    const modal = new bootstrap.Modal(document.getElementById('approveModal'));
    modal.show();
}

// Reject request
function rejectRequest(id) {
    currentRequestId = id;
    $('#rejectionReason').val('').removeClass('is-invalid');
    const modal = new bootstrap.Modal(document.getElementById('rejectModal'));
    modal.show();
}

// Refresh requests
function refreshRequests() {
    loadRequests(window.location.href);
}

// Filter requests with Ajax
function filterRequests() {
    const status = $('#statusFilter').val();
    const url = new URL(window.location.href);
    
    if (status) {
        url.searchParams.set('status', status);
    } else {
        url.searchParams.delete('status');
    }
    
    loadRequests(url.toString());
}

// Load requests via Ajax
function loadRequests(url) {
    $('#loadingIndicator').removeClass('d-none');
    $('#requestsContainer').addClass('opacity-50');
    
    $.ajax({
        url: url,
        type: 'GET',
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        },
        success: function(response) {
            if (response.html) {
                $('#requestsContainer').html(response.html);
                
                // Update stats
                if (response.stats) {
                    $('#pendingCount').text(response.stats.pending || 0);
                    $('#approvedCount').text(response.stats.completed || 0);
                    $('#rejectedCount').text(response.stats.rejected || 0);
                }
                
                // Update URL without reload
                window.history.pushState({}, '', url);
                
                Lobibox.notify('success', {
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    icon: 'bx bx-check-circle',
                    msg: '<?php echo e(__("Requests updated successfully")); ?>'
                });
            }
        },
        error: function(xhr) {
            let message = '<?php echo e(__("Failed to load requests")); ?>';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                message = xhr.responseJSON.message;
            }
            
            Lobibox.notify('error', {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                icon: 'bx bx-x-circle',
                msg: message
            });
        },
        complete: function() {
            $('#loadingIndicator').addClass('d-none');
            $('#requestsContainer').removeClass('opacity-50');
        }
    });
}

// Confirm approve
$('#confirmApprove').on('click', function() {
    if (!currentRequestId) return;
    
    const button = $(this);
    const originalText = button.html();
    
    button.prop('disabled', true).html('<i class="bx bx-loader-alt bx-spin me-2"></i><?php echo e(__("Processing...")); ?>');
    
    $.ajax({
        url: `/admin/balance-requests/${currentRequestId}/approve`,
        type: 'POST',
        data: {
            '_token': $('meta[name="csrf-token"]').attr('content'),
            '_method': 'PATCH'
        },
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        },
        success: function(response, textStatus, xhr) {
            // Check if it's a redirect (302)
            if (xhr.status === 200 || xhr.status === 302) {
                // Hide modal
                bootstrap.Modal.getInstance(document.getElementById('approveModal')).hide();
                
                // Update the specific request item
                updateRequestItem(currentRequestId, 'completed');
                
                Lobibox.notify('success', {
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    icon: 'bx bx-check-circle',
                    msg: '<?php echo e(__("Request approved successfully")); ?>'
                });
            } else if (response && response.success) {
                // Hide modal
                bootstrap.Modal.getInstance(document.getElementById('approveModal')).hide();
                
                // Update the specific request item
                updateRequestItem(currentRequestId, 'completed');
                
                Lobibox.notify('success', {
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    icon: 'bx bx-check-circle',
                    msg: response.message || '<?php echo e(__("Request approved successfully")); ?>'
                });
            } else {
                throw new Error(response.message || '<?php echo e(__("Failed to approve request")); ?>');
            }
        },
        error: function(xhr) {
            let message = '<?php echo e(__("Failed to approve request")); ?>';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                message = xhr.responseJSON.message;
            }
            
            Lobibox.notify('error', {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                icon: 'bx bx-x-circle',
                msg: message
            });
        },
        complete: function() {
            button.prop('disabled', false).html(originalText);
            currentRequestId = null;
        }
    });
});

// Confirm reject
$('#confirmReject').on('click', function() {
    if (!currentRequestId) return;
    
    const reason = $('#rejectionReason').val().trim();
    if (!reason) {
        $('#rejectionReason').addClass('is-invalid');
        return;
    }
    
    $('#rejectionReason').removeClass('is-invalid');
    
    const button = $(this);
    const originalText = button.html();
    
    button.prop('disabled', true).html('<i class="bx bx-loader-alt bx-spin me-2"></i><?php echo e(__("Processing...")); ?>');
    
    $.ajax({
        url: `/admin/balance-requests/${currentRequestId}/reject`,
        type: 'POST',
        data: {
            '_token': $('meta[name="csrf-token"]').attr('content'),
            '_method': 'PATCH',
            'rejection_reason': reason
        },
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        },
        success: function(response, textStatus, xhr) {
            // Check if it's a redirect (302)
            if (xhr.status === 200 || xhr.status === 302) {
                // Hide modal
                bootstrap.Modal.getInstance(document.getElementById('rejectModal')).hide();
                
                // Update the specific request item
                updateRequestItem(currentRequestId, 'rejected');
                
                Lobibox.notify('success', {
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    icon: 'bx bx-check-circle',
                    msg: '<?php echo e(__("Request rejected successfully")); ?>'
                });
            } else if (response && response.success) {
                // Hide modal
                bootstrap.Modal.getInstance(document.getElementById('rejectModal')).hide();
                
                // Update the specific request item
                updateRequestItem(currentRequestId, 'rejected');
                
                Lobibox.notify('success', {
                    pauseDelayOnHover: true,
                    continueDelayOnInactiveTab: false,
                    position: 'top right',
                    icon: 'bx bx-check-circle',
                    msg: response.message || '<?php echo e(__("Request rejected successfully")); ?>'
                });
            } else {
                throw new Error(response.message || '<?php echo e(__("Failed to reject request")); ?>');
            }
        },
        error: function(xhr) {
            let message = '<?php echo e(__("Failed to reject request")); ?>';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                message = xhr.responseJSON.message;
            }
            
            Lobibox.notify('error', {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                icon: 'bx bx-x-circle',
                msg: message
            });
        },
        complete: function() {
            button.prop('disabled', false).html(originalText);
            currentRequestId = null;
        }
    });
});

// Update specific request item status
function updateRequestItem(requestId, newStatus) {
    const requestItem = $(`.request-item[data-id="${requestId}"]`);
    if (requestItem.length) {
        // Get current status for stats update
        const badge = requestItem.find('.badge');
        const currentStatus = badge.text().trim();
        
        // Update badge
        badge.removeClass('bg-warning bg-success bg-danger');
        
        if (newStatus === 'completed') {
            badge.addClass('bg-success').text('<?php echo e(__("Approved")); ?>');
            updateStatsCounters(currentStatus, '<?php echo e(__("Approved")); ?>');
        } else if (newStatus === 'rejected') {
            badge.addClass('bg-danger').text('<?php echo e(__("Rejected")); ?>');
            updateStatsCounters(currentStatus, '<?php echo e(__("Rejected")); ?>');
        }
        
        // Remove action buttons
        requestItem.find('.btn-success, .btn-danger').remove();
        
        // Add fade effect
        requestItem.addClass('table-success').delay(2000).queue(function() {
            $(this).removeClass('table-success').dequeue();
        });
    }
}

// Update stats counters based on status change
function updateStatsCounters(oldStatus, newStatus) {
    let pendingCount = parseInt($('#pendingCount').text()) || 0;
    let approvedCount = parseInt($('#approvedCount').text()) || 0;
    let rejectedCount = parseInt($('#rejectedCount').text()) || 0;
    
    // Decrease from old status
    if (oldStatus === '<?php echo e(__("Pending")); ?>') {
        pendingCount = Math.max(0, pendingCount - 1);
    } else if (oldStatus === '<?php echo e(__("Approved")); ?>') {
        approvedCount = Math.max(0, approvedCount - 1);
    } else if (oldStatus === '<?php echo e(__("Rejected")); ?>') {
        rejectedCount = Math.max(0, rejectedCount - 1);
    }
    
    // Increase to new status
    if (newStatus === '<?php echo e(__("Pending")); ?>') {
        pendingCount++;
    } else if (newStatus === '<?php echo e(__("Approved")); ?>') {
        approvedCount++;
    } else if (newStatus === '<?php echo e(__("Rejected")); ?>') {
        rejectedCount++;
    }
    
    // Update display
    $('#pendingCount').text(pendingCount);
    $('#approvedCount').text(approvedCount);
    $('#rejectedCount').text(rejectedCount);
}

// Update stats counters manually
function updateStats() {
    // Get current counts
    let pendingCount = parseInt($('#pendingCount').text()) || 0;
    let approvedCount = parseInt($('#approvedCount').text()) || 0;
    let rejectedCount = parseInt($('#rejectedCount').text()) || 0;
    
    // Update based on the action performed
    if (currentRequestId) {
        const requestItem = $(`.request-item[data-id="${currentRequestId}"]`);
        const currentStatus = requestItem.find('.badge').text().trim();
        
        // Decrease from current status
        if (currentStatus === '<?php echo e(__("Pending")); ?>') {
            pendingCount = Math.max(0, pendingCount - 1);
        } else if (currentStatus === '<?php echo e(__("Approved")); ?>') {
            approvedCount = Math.max(0, approvedCount - 1);
        } else if (currentStatus === '<?php echo e(__("Rejected")); ?>') {
            rejectedCount = Math.max(0, rejectedCount - 1);
        }
    }
    
    // Update display
    $('#pendingCount').text(pendingCount);
    $('#approvedCount').text(approvedCount);
    $('#rejectedCount').text(rejectedCount);
}

// Add custom styles
const customStyles = `
<style>
.bg-gradient-primary {
    background: linear-gradient(45deg, #007bff, #0056b3) !important;
}
.request-item:hover {
    background-color: rgba(0, 123, 255, 0.05);
}
.table-success {
    background-color: rgba(25, 135, 84, 0.1) !important;
    transition: background-color 0.3s ease;
}
.opacity-50 {
    opacity: 0.5;
    transition: opacity 0.3s ease;
}
@media (max-width: 768px) {
    .btn-group .btn {
        margin-bottom: 5px;
    }
}
</style>
`;
$('head').append(customStyles);

// Initialize page when DOM is ready
$(document).ready(function() {
    // Initialize status filters
    $('#statusFilter').val('<?php echo e(request("status")); ?>');
    $('#statusFilterMobile').val('<?php echo e(request("status")); ?>');
    
    // Status filter change handler for desktop
    $('#statusFilter').on('change', function() {
        $('#statusFilterMobile').val($(this).val());
        refreshRequests();
    });
    
    // Status filter change handler for mobile
    $('#statusFilterMobile').on('change', function() {
        $('#statusFilter').val($(this).val());
        refreshRequests();
    });
    
    // Add smooth animations to stat cards
    $('.stat-card').each(function(index) {
        $(this).css({
            'animation-delay': (index * 0.1) + 's',
            'opacity': '0',
            'transform': 'translateY(20px)'
        });
        
        setTimeout(() => {
            $(this).css({
                'opacity': '1',
                'transform': 'translateY(0)',
                'transition': 'all 0.6s ease'
            });
        }, index * 100);
    });
    
    // Enhanced button hover effects
    $('.btn-modern').hover(
        function() {
            $(this).css('transform', 'translateY(-2px) scale(1.02)');
        },
        function() {
            $(this).css('transform', 'translateY(0) scale(1)');
        }
    );
    
    // Add loading animation to refresh button
    $('[onclick="refreshRequests()"]').on('click', function() {
        const $btn = $(this);
        const $icon = $btn.find('i');
        $icon.addClass('bx-spin');
        setTimeout(() => $icon.removeClass('bx-spin'), 1000);
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/admin/balance-requests/index.blade.php ENDPATH**/ ?>