<?php $__env->startSection('title', $product->product_name . ' - GorevSitesi'); ?>
<?php $__env->startSection('description', 'GorevSitesi\'nde ' . $product->product_name . ' ürününü inceleyin. ' . Str::limit($product->description, 150)); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav aria-label="breadcrumb" class="mb-4">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="<?php echo e(route('site2.landing')); ?>" class="text-decoration-none">Ana Sayfa</a></li>
        <li class="breadcrumb-item"><a href="<?php echo e(route('site2.products.index')); ?>" class="text-decoration-none">Ürünler</a></li>
        <?php if($product->category): ?>
            <li class="breadcrumb-item"><?php echo e($product->category->name); ?></li>
        <?php endif; ?>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e($product->product_name); ?></li>
    </ol>
</nav>

<div class="row">
    <!-- Product Images -->
    <div class="col-lg-6 mb-4">
        <div class="product-gallery">
            <!-- Main Image -->
            <div class="main-image mb-3">
                <img src="<?php echo e($product->image_url ?? '/assets/images/placeholder.png'); ?>" 
                     class="img-fluid rounded shadow-sm" 
                     alt="<?php echo e($product->product_name); ?>"
                     id="mainProductImage"
                     style="width: 100%; height: 400px; object-fit: cover;">
                
                <?php if($product->is_digital): ?>
                    <span class="badge bg-info position-absolute top-0 start-0 m-3 fs-6">
                        <i class="bi bi-download me-1"></i>Dijital Ürün
                    </span>
                <?php endif; ?>
            </div>
            
            <!-- Thumbnail Images (if multiple images available) -->
            <div class="thumbnail-images d-flex gap-2">
                <img src="<?php echo e($product->image_url ?? '/assets/images/placeholder.png'); ?>" 
                     class="img-thumbnail thumbnail-img active" 
                     style="width: 80px; height: 80px; object-fit: cover; cursor: pointer;"
                     onclick="changeMainImage(this.src)">
                <!-- Add more thumbnails here if product has multiple images -->
            </div>
        </div>
    </div>

    <!-- Product Details -->
    <div class="col-lg-6">
        <div class="product-details">
            <!-- Product Title -->
            <h1 class="fw-bold mb-3"><?php echo e($product->product_name); ?></h1>
            
            <!-- Category -->
            <?php if($product->category): ?>
                <div class="mb-3">
                    <span class="badge bg-light text-dark border">
                        <i class="bi bi-tag me-1"></i><?php echo e($product->category->name); ?>

                    </span>
                </div>
            <?php endif; ?>

            <!-- Price -->
            <div class="price-section mb-4">
                <div class="d-flex align-items-center gap-3">
                    <span class="h2 fw-bold text-primary mb-0"><?php echo e(number_format($product->price, 2)); ?> ₺</span>
                    <span class="badge bg-<?php echo e($product->stock_badge); ?> fs-6">
                        <?php echo e($product->stock_status); ?>

                    </span>
                </div>
            </div>

            <!-- Product Info -->
            <div class="product-info mb-4">
                <div class="row g-3">
                    <div class="col-6">
                        <div class="info-item">
                            <small class="text-muted d-block">Minimum Miktar</small>
                            <span class="fw-medium"><?php echo e($product->min_quantity); ?> adet</span>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="info-item">
                            <small class="text-muted d-block">Maksimum Miktar</small>
                            <span class="fw-medium"><?php echo e($product->max_quantity); ?> adet</span>
                        </div>
                    </div>
                    <?php if($product->completing_time): ?>
                        <div class="col-6">
                            <div class="info-item">
                                <small class="text-muted d-block">Teslim Süresi</small>
                                <span class="fw-medium"><?php echo e($product->completing_time); ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($product->provider): ?>
                        <div class="col-6">
                            <div class="info-item">
                                <small class="text-muted d-block">Sağlayıcı</small>
                                <span class="fw-medium"><?php echo e($product->provider); ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Quantity Selector & Add to Cart -->
            <?php
                $isAvailable = $product->status && ($product->is_digital || ($product->stock_quantity ?? 0) > 0);
            ?>
            <?php if($isAvailable): ?>
                <div class="purchase-section mb-4">
                    <div class="row g-3 align-items-end">
                        <div class="col-md-4">
                            <label for="quantity" class="form-label fw-medium">Miktar</label>
                            <div class="input-group">
                                <button class="btn btn-outline-secondary" type="button" id="decreaseQty">
                                    <i class="bi bi-dash"></i>
                                </button>
                                <input type="number" 
                                       class="form-control text-center" 
                                       id="quantity" 
                                       value="<?php echo e($product->min_quantity ?? 1); ?>" 
                                       min="<?php echo e($product->min_quantity ?? 1); ?>" 
                                       max="<?php echo e($product->max_quantity ?? 100); ?>">
                                <button class="btn btn-outline-secondary" type="button" id="increaseQty">
                                    <i class="bi bi-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="d-grid gap-2">
                                <button class="btn btn-primary btn-lg" id="addToCartBtn">
                                    <i class="bi bi-bag-plus me-2"></i>Sepete Ekle
                                </button>
                                <?php if(auth()->guard()->check()): ?>
                                    <button class="btn btn-success btn-lg" id="buyNowBtn">
                                        <i class="bi bi-lightning me-2"></i>Hemen Al
                                    </button>
                                <?php else: ?>
                                    <a href="<?php echo e(route('site2.login')); ?>" class="btn btn-success btn-lg">
                                        <i class="bi bi-box-arrow-in-right me-2"></i>Hemen Almak İçin Giriş Yap
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Total Price Display -->
                    <div class="mt-3 p-3 bg-light rounded">
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="fw-medium">Toplam Fiyat:</span>
                            <span class="h5 fw-bold text-primary mb-0" id="totalPrice">
                                <?php echo e(number_format($product->price * ($product->min_quantity ?? 1), 2)); ?> ₺
                            </span>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    Bu ürün şu anda stokta bulunmamaktadır.
                </div>
            <?php endif; ?>

            <!-- Features -->
            <div class="features-section mb-4">
                <div class="row g-3">
                    <div class="col-6">
                        <div class="feature-item text-center p-3 bg-light rounded">
                            <i class="bi bi-shield-check text-success fs-4 mb-2"></i>
                            <div class="small fw-medium">Güvenli Ödeme</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="feature-item text-center p-3 bg-light rounded">
                            <i class="bi bi-truck text-primary fs-4 mb-2"></i>
                            <div class="small fw-medium">Hızlı Teslimat</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="feature-item text-center p-3 bg-light rounded">
                            <i class="bi bi-arrow-clockwise text-warning fs-4 mb-2"></i>
                            <div class="small fw-medium">Kolay İade</div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="feature-item text-center p-3 bg-light rounded">
                            <i class="bi bi-headset text-info fs-4 mb-2"></i>
                            <div class="small fw-medium">7/24 Destek</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Product Description -->
<div class="row mt-5">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white border-0">
                <h3 class="fw-bold mb-0">
                    <i class="bi bi-info-circle me-2"></i>Ürün Açıklaması
                </h3>
            </div>
            <div class="card-body">
                <div class="product-description">
                    <?php echo nl2br(e($product->description)); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Related Products -->
<?php if($relatedProducts && $relatedProducts->count() > 0): ?>
    <div class="row mt-5">
        <div class="col-12">
            <h3 class="fw-bold mb-4">
                <i class="bi bi-grid me-2"></i>Benzer Ürünler
            </h3>
            <div class="row g-4">
                <?php $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-3 col-md-6">
                        <div class="card product-card h-100 border-0 shadow-sm">
                            <div class="position-relative">
                                <img src="<?php echo e($relatedProduct->image_url ?? '/assets/images/placeholder.png'); ?>" 
                                     class="card-img-top product-image" 
                                     alt="<?php echo e($relatedProduct->product_name); ?>"
                                     loading="lazy">
                                
                                <?php if($relatedProduct->is_digital): ?>
                                    <span class="badge bg-info position-absolute top-0 start-0 m-2">
                                        <i class="bi bi-download me-1"></i>Dijital
                                    </span>
                                <?php endif; ?>
                            </div>
                            
                            <div class="card-body d-flex flex-column">
                                <h6 class="card-title text-truncate-2 mb-2"><?php echo e($relatedProduct->product_name); ?></h6>
                                <p class="card-text text-muted small text-truncate-2 flex-grow-1">
                                    <?php echo e($relatedProduct->description); ?>

                                </p>
                                
                                <div class="mt-auto">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="fw-bold text-primary"><?php echo e(number_format($relatedProduct->price, 2)); ?> ₺</span>
                                        <?php if($relatedProduct->is_digital): ?>
                                            <span class="badge bg-info">Dijital</span>
                                        <?php elseif(isset($relatedProduct->stock_quantity)): ?>
                                            <?php if($relatedProduct->stock_quantity > 10): ?>
                                                <span class="badge bg-success">Stokta</span>
                                            <?php elseif($relatedProduct->stock_quantity > 0): ?>
                                                <span class="badge bg-warning">Az Stok</span>
                                            <?php else: ?>
                                                <span class="badge bg-danger">Stokta Yok</span>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="badge bg-success">Mevcut</span>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div class="d-grid">
                                        <a href="<?php echo e(route('site2.products.show', $relatedProduct->id)); ?>" 
                                           class="btn btn-outline-primary btn-sm">
                                            <i class="bi bi-eye me-1"></i>İncele
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const quantityInput = document.getElementById('quantity');
        const decreaseBtn = document.getElementById('decreaseQty');
        const increaseBtn = document.getElementById('increaseQty');
        const addToCartBtn = document.getElementById('addToCartBtn');
        const buyNowBtn = document.getElementById('buyNowBtn');
        const totalPriceElement = document.getElementById('totalPrice');
        
        const productData = {
            id: <?php echo e($product->id); ?>,
            name: '<?php echo e(addslashes($product->product_name)); ?>',
            price: <?php echo e($product->price); ?>,
            image: '<?php echo e($product->image_url ?? '/assets/images/placeholder.png'); ?>',
            minQuantity: <?php echo e($product->min_quantity ?? 1); ?>,
            maxQuantity: <?php echo e($product->max_quantity ?? 100); ?>

        };

        // Quantity controls
        decreaseBtn.addEventListener('click', function() {
            const currentValue = parseInt(quantityInput.value);
            if (currentValue > productData.minQuantity) {
                quantityInput.value = currentValue - 1;
                updateTotalPrice();
            }
        });

        increaseBtn.addEventListener('click', function() {
            const currentValue = parseInt(quantityInput.value);
            if (currentValue < productData.maxQuantity) {
                quantityInput.value = currentValue + 1;
                updateTotalPrice();
            }
        });

        quantityInput.addEventListener('input', function() {
            let value = parseInt(this.value);
            if (isNaN(value) || value < productData.minQuantity) {
                value = productData.minQuantity;
            } else if (value > productData.maxQuantity) {
                value = productData.maxQuantity;
            }
            this.value = value;
            updateTotalPrice();
        });

        // Update total price
        function updateTotalPrice() {
            const quantity = parseInt(quantityInput.value);
            const total = productData.price * quantity;
            totalPriceElement.textContent = new Intl.NumberFormat('tr-TR', {
                style: 'currency',
                currency: 'TRY'
            }).format(total);
        }

        // Add to cart functionality
        if (addToCartBtn) {
            addToCartBtn.addEventListener('click', function() {
                const quantity = parseInt(quantityInput.value);
                addToCart(productData, quantity);
            });
        }

        // Buy now functionality
        if (buyNowBtn) {
            buyNowBtn.addEventListener('click', function() {
                const quantity = parseInt(quantityInput.value);
                buyNow(productData, quantity);
            });
        }

        function addToCart(product, quantity) {
            // Get existing cart
            let cart = JSON.parse(localStorage.getItem('cart') || '[]');
            
            // Check if product already in cart
            const existingIndex = cart.findIndex(item => item.id === product.id);
            
            if (existingIndex > -1) {
                cart[existingIndex].quantity += quantity;
                if (cart[existingIndex].quantity > product.maxQuantity) {
                    cart[existingIndex].quantity = product.maxQuantity;
                    alert(`Maksimum ${product.maxQuantity} adet ekleyebilirsiniz.`);
                }
            } else {
                cart.push({
                    id: product.id,
                    name: product.name,
                    price: product.price,
                    image: product.image,
                    quantity: quantity,
                    maxQuantity: product.maxQuantity,
                    minQuantity: product.minQuantity
                });
            }

            // Save cart
            localStorage.setItem('cart', JSON.stringify(cart));
            
            // Update cart count
            updateCartCount(cart.length);
            
            // Show success message
            const originalText = addToCartBtn.innerHTML;
            addToCartBtn.innerHTML = '<i class="bi bi-check me-2"></i>Sepete Eklendi!';
            addToCartBtn.classList.remove('btn-primary');
            addToCartBtn.classList.add('btn-success');
            
            setTimeout(() => {
                addToCartBtn.innerHTML = originalText;
                addToCartBtn.classList.remove('btn-success');
                addToCartBtn.classList.add('btn-primary');
            }, 2000);
        }

        function buyNow(product, quantity) {
            // Add to cart first
            addToCart(product, quantity);
            
            // Redirect to checkout
            setTimeout(() => {
                window.location.href = '<?php echo e(route("site2.cart.checkout")); ?>';
            }, 500);
        }

        // Image gallery functionality
        window.changeMainImage = function(src) {
            document.getElementById('mainProductImage').src = src;
            
            // Update active thumbnail
            document.querySelectorAll('.thumbnail-img').forEach(img => {
                img.classList.remove('active');
            });
            event.target.classList.add('active');
        };
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .thumbnail-img {
        border: 2px solid transparent;
        transition: all 0.2s ease;
    }
    
    .thumbnail-img:hover,
    .thumbnail-img.active {
        border-color: var(--primary-color);
    }
    
    .product-description {
        line-height: 1.8;
        font-size: 1.1rem;
    }
    
    .feature-item {
        transition: all 0.2s ease;
    }
    
    .feature-item:hover {
        transform: translateY(-2px);
        box-shadow: var(--shadow-sm);
    }
    
    .info-item {
        padding: 0.5rem 0;
    }
    
    @media (max-width: 768px) {
        .main-image img {
            height: 300px !important;
        }
        
        .product-info .row {
            text-align: center;
        }
    }
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('gorevsitesi.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/gorevsitesi/products/show.blade.php ENDPATH**/ ?>