<?php $__env->startSection('style'); ?>
    <link href="<?php echo e(asset('assets/plugins/notifications/css/lobibox.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet">
    <style>
        .analytics-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 30px;
            color: white;
            position: relative;
            overflow: hidden;
        }
        .analytics-header::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 200px;
            height: 200px;
            background: rgba(255,255,255,0.1);
            border-radius: 50%;
            transform: translate(50px, -50px);
        }
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: white;
            border-radius: 16px;
            padding: 25px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            border: 1px solid #f1f3f4;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 30px rgba(0,0,0,0.15);
        }
        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.8rem;
            margin-bottom: 15px;
        }
        .stat-number {
            font-size: 2.2rem;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 5px;
        }
        .stat-label {
            color: #6c757d;
            font-size: 0.9rem;
            font-weight: 500;
        }
        .stat-change {
            font-size: 0.8rem;
            font-weight: 600;
            margin-top: 8px;
        }
        .stat-change.positive {
            color: #28a745;
        }
        .stat-change.negative {
            color: #dc3545;
        }
        
        /* Icon Colors */
        .stat-icon.primary { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; }
        .stat-icon.success { background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white; }
        .stat-icon.warning { background: linear-gradient(135deg, #ffc107 0%, #fd7e14 100%); color: white; }
        .stat-icon.danger { background: linear-gradient(135deg, #dc3545 0%, #e83e8c 100%); color: white; }
        .stat-icon.info { background: linear-gradient(135deg, #17a2b8 0%, #6f42c1 100%); color: white; }
        
        .chart-container {
            background: white;
            border-radius: 16px;
            padding: 25px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            margin-bottom: 30px;
        }
        .chart-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f8f9fa;
        }
        .chart-title {
            font-size: 1.2rem;
            font-weight: 600;
            color: #2c3e50;
        }
        
        .activity-item {
            display: flex;
            align-items: center;
            padding: 15px;
            border-radius: 12px;
            margin-bottom: 10px;
            background: #f8f9fa;
            transition: all 0.3s ease;
        }
        .activity-item:hover {
            background: #e9ecef;
            transform: translateX(5px);
        }
        .activity-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            margin-right: 15px;
        }
        .activity-content {
            flex: 1;
        }
        .activity-title {
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 2px;
        }
        .activity-meta {
            font-size: 0.85rem;
            color: #6c757d;
        }
        .activity-amount {
            font-weight: 700;
            color: #28a745;
        }
        
        .top-creators {
            background: white;
            border-radius: 16px;
            padding: 25px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        }
        .creator-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #f1f3f4;
        }
        .creator-item:last-child {
            border-bottom: none;
        }
        .creator-rank {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 0.9rem;
            margin-right: 15px;
        }
        
        /* Mobile Responsive */
        @media (max-width: 768px) {
            .analytics-header {
                padding: 20px;
                text-align: center;
            }
            .stats-grid {
                grid-template-columns: 1fr;
                gap: 15px;
            }
            .stat-card {
                padding: 20px;
            }
            .stat-number {
                font-size: 1.8rem;
            }
            .chart-container {
                padding: 20px;
            }
            .activity-item {
                flex-direction: column;
                text-align: center;
            }
            .activity-avatar {
                margin-right: 0;
                margin-bottom: 10px;
            }
        }
        
        @media (max-width: 576px) {
            .analytics-header {
                padding: 15px;
            }
            .stat-card {
                padding: 15px;
            }
            .stat-number {
                font-size: 1.5rem;
            }
            .chart-container {
                padding: 15px;
            }
        }
        
        /* DataTable Responsive */
        .table-responsive {
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        }
        .table {
            margin-bottom: 0;
        }
        .table thead th {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            font-weight: 600;
            padding: 15px;
        }
        .table tbody td {
            padding: 15px;
            border-color: #f1f3f4;
            vertical-align: middle;
        }
        .table tbody tr:hover {
            background: #f8f9fa;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('wrapper'); ?>
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo e(__('Watch Tasks Analytics')); ?></div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Watch Tasks Analytics')); ?></li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <a href="<?php echo e(route('tasks.watch')); ?>" class="btn btn-primary">
                    <i class="bx bx-play-circle me-2"></i><?php echo e(__('Watch Tasks')); ?>

                </a>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Analytics Header -->
        <div class="analytics-header">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h2 class="mb-2 text-white"><?php echo e(__('YouTube Watch Tasks Analytics')); ?></h2>
                    <p class="mb-0 opacity-75"><?php echo e(__('Comprehensive overview of all watch tasks performance and statistics')); ?></p>
                </div>
                <div class="col-md-4 text-md-end">
                    <div class="d-flex align-items-center justify-content-md-end">
                        <i class="bx bx-play-circle" style="font-size: 3rem; opacity: 0.3;"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Grid -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="d-flex align-items-center">
                    <div class="stat-icon primary me-3">
                        <i class="bx bx-task"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="stat-number"><?php echo e(number_format($stats['total_tasks'])); ?></div>
                        <div class="stat-label"><?php echo e(__('Total Tasks')); ?></div>
                        <div class="stat-change positive">
                            <i class="bx bx-trending-up"></i> <?php echo e(__('All time')); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="d-flex align-items-center">
                    <div class="stat-icon success me-3">
                        <i class="bx bx-play"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="stat-number"><?php echo e(number_format($stats['active_tasks'])); ?></div>
                        <div class="stat-label"><?php echo e(__('Active Tasks')); ?></div>
                        <div class="stat-change positive">
                            <i class="bx bx-check-circle"></i> <?php echo e(__('Currently running')); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="d-flex align-items-center">
                    <div class="stat-icon warning me-3">
                        <i class="bx bx-pause"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="stat-number"><?php echo e(number_format($stats['inactive_tasks'])); ?></div>
                        <div class="stat-label"><?php echo e(__('Inactive Tasks')); ?></div>
                        <div class="stat-change negative">
                            <i class="bx bx-pause-circle"></i> <?php echo e(__('Paused or ended')); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="d-flex align-items-center">
                    <div class="stat-icon info me-3">
                        <i class="bx bx-check-double"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="stat-number"><?php echo e(number_format($stats['total_completions'])); ?></div>
                        <div class="stat-label"><?php echo e(__('Total Completions')); ?></div>
                        <div class="stat-change positive">
                            <i class="bx bx-trending-up"></i> <?php echo e(__('Videos watched')); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="d-flex align-items-center">
                    <div class="stat-icon success me-3">
                        <i class="bx bx-money"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="stat-number"><?php echo e(number_format($stats['total_rewards_paid'], 2)); ?><?php echo e($settings['currency'] ?? 'TL'); ?></div>
                        <div class="stat-label"><?php echo e(__('Total Rewards Paid')); ?></div>
                        <div class="stat-change positive">
                            <i class="bx bx-wallet"></i> <?php echo e(__('Earnings distributed')); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="d-flex align-items-center">
                    <div class="stat-icon warning me-3">
                        <i class="bx bx-time"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="stat-number"><?php echo e(number_format($stats['pending_completions'])); ?></div>
                        <div class="stat-label"><?php echo e(__('Pending Completions')); ?></div>
                        <div class="stat-change">
                            <i class="bx bx-loader-alt"></i> <?php echo e(__('In progress')); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="d-flex align-items-center">
                    <div class="stat-icon primary me-3">
                        <i class="bx bx-user"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="stat-number"><?php echo e(number_format($stats['total_users'])); ?></div>
                        <div class="stat-label"><?php echo e(__('Active Users')); ?></div>
                        <div class="stat-change positive">
                            <i class="bx bx-group"></i> <?php echo e(__('Participants')); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="stat-card">
                <div class="d-flex align-items-center">
                    <div class="stat-icon info me-3">
                        <i class="bx bx-trending-up"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="stat-number"><?php echo e($stats['avg_completion_rate']); ?>%</div>
                        <div class="stat-label"><?php echo e(__('Avg Completion Rate')); ?></div>
                        <div class="stat-change positive">
                            <i class="bx bx-bar-chart-alt-2"></i> <?php echo e(__('Success rate')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts and Tables Row -->
        <div class="row">
            <!-- Recent Activities -->
            <div class="col-lg-8">
                <div class="chart-container">
                    <div class="chart-header">
                        <h5 class="chart-title"><?php echo e(__('All Watch Tasks')); ?></h5>
                        <div class="d-flex gap-2">
                            <span class="badge bg-primary"><?php echo e(__('Today')); ?>: <?php echo e($stats['today_completions']); ?></span>
                            <span class="badge bg-success"><?php echo e(__('This Week')); ?>: <?php echo e($stats['this_week_completions']); ?></span>
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table id="watchTasksTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Title')); ?></th>
                                    <th><?php echo e(__('Creator')); ?></th>
                                    <th><?php echo e(__('Reward')); ?></th>
                                    <th><?php echo e(__('Duration')); ?></th>
                                    <th><?php echo e(__('Completions')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Created')); ?></th>
                                    <th><?php echo e(__('Actions')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- DataTable will populate this -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Top Creators & Recent Activities -->
            <div class="col-lg-4">
                <!-- Top Creators -->
                <div class="top-creators mb-4">
                    <div class="chart-header">
                        <h5 class="chart-title"><?php echo e(__('Top Creators')); ?></h5>
                    </div>
                    <?php if($stats['top_creators']->count() > 0): ?>
                        <?php $__currentLoopData = $stats['top_creators']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $creator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="creator-item">
                                <div class="d-flex align-items-center">
                                    <div class="creator-rank"><?php echo e($index + 1); ?></div>
                                    <div>
                                        <div class="fw-bold"><?php echo e($creator->creator->account_holder ?? __('Unknown')); ?></div>
                                        <small class="text-muted"><?php echo e($creator->completions_count); ?> <?php echo e(__('completions')); ?></small>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="text-center py-3">
                            <i class="bx bx-user-x text-muted" style="font-size: 2rem;"></i>
                            <p class="text-muted mt-2"><?php echo e(__('No creators yet')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Recent Activities -->
                <div class="chart-container">
                    <div class="chart-header">
                        <h5 class="chart-title"><?php echo e(__('Recent Activities')); ?></h5>
                    </div>
                    <?php if($stats['recent_activities']->count() > 0): ?>
                        <?php $__currentLoopData = $stats['recent_activities']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="activity-item">
                                <div class="activity-avatar">
                                    <?php echo e(substr($activity->user->account_holder ?? 'U', 0, 1)); ?>

                                </div>
                                <div class="activity-content">
                                    <div class="activity-title"><?php echo e(Str::limit($activity->watchTask->title, 30)); ?></div>
                                    <div class="activity-meta">
                                        <?php echo e(__('Completed by')); ?> <?php echo e($activity->user->account_holder ?? __('Unknown')); ?>

                                        <br>
                                        <small><?php echo e($activity->completed_at->diffForHumans()); ?></small>
                                    </div>
                                </div>
                                <div class="activity-amount">
                                    +<?php echo e(number_format($activity->earned_amount, 2)); ?><?php echo e($settings['currency'] ?? 'TL'); ?>

                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="text-center py-3">
                            <i class="bx bx-time text-muted" style="font-size: 2rem;"></i>
                            <p class="text-muted mt-2"><?php echo e(__('No recent activities')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('assets/plugins/notifications/js/lobibox.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>

    <script>
        $(document).ready(function() {
            // Initialize DataTable
            $('#watchTasksTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo e(route('api.admin.watch.datatable')); ?>',
                columns: [
                    { data: 'title', name: 'title' },
                    { data: 'creator', name: 'creator' },
                    { 
                        data: 'reward_amount', 
                        name: 'reward_amount',
                        render: function(data) {
                            return data + '<?php echo e($settings['currency'] ?? 'TL'); ?>';
                        }
                    },
                    { data: 'watch_duration', name: 'watch_duration' },
                    { 
                        data: 'current_completions', 
                        name: 'current_completions',
                        render: function(data, type, row) {
                            return data + '/' + row.max_completions;
                        }
                    },
                    { 
                        data: 'is_active', 
                        name: 'is_active',
                        render: function(data) {
                            return data ? 
                                '<span class="badge bg-success"><?php echo e(__('Active')); ?></span>' : 
                                '<span class="badge bg-secondary"><?php echo e(__('Inactive')); ?></span>';
                        }
                    },
                    { data: 'created_at', name: 'created_at' },
                    { data: 'actions', name: 'actions', orderable: false, searchable: false }
                ],
                order: [[6, 'desc']],
                pageLength: 25,
                responsive: true,
                language: {
                    search: "<?php echo e(__('Search')); ?>:",
                    lengthMenu: "<?php echo e(__('Show')); ?> _MENU_ <?php echo e(__('entries')); ?>",
                    info: "<?php echo e(__('Showing')); ?> _START_ <?php echo e(__('to')); ?> _END_ <?php echo e(__('of')); ?> _TOTAL_ <?php echo e(__('entries')); ?>",
                    paginate: {
                        first: "<?php echo e(__('First')); ?>",
                        last: "<?php echo e(__('Last')); ?>",
                        next: "<?php echo e(__('Next')); ?>",
                        previous: "<?php echo e(__('Previous')); ?>"
                    }
                }
            });

            // Task actions
            $(document).on('click', '.view-task', function() {
                const taskId = $(this).data('id');
                viewTaskDetails(taskId);
            });

            $(document).on('click', '.activate-task', function() {
                const taskId = $(this).data('id');
                toggleTaskStatus(taskId, true);
            });

            $(document).on('click', '.deactivate-task', function() {
                const taskId = $(this).data('id');
                toggleTaskStatus(taskId, false);
            });
        });

        function viewTaskDetails(taskId) {
            // Implement task details modal or redirect
            console.log('View task:', taskId);
        }

        function toggleTaskStatus(taskId, activate) {
            const action = activate ? 'activate' : 'deactivate';
            const message = activate ? '<?php echo e(__('activate')); ?>' : '<?php echo e(__('deactivate')); ?>';
            
            if (confirm(`<?php echo e(__('Are you sure you want to')); ?> ${message} <?php echo e(__('this task?')); ?>`)) {
                $.ajax({
                    url: `/api/watch-tasks/${taskId}/toggle`,
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: { is_active: activate },
                    success: function(response) {
                        if (response.success) {
                            showNotification('success', response.message);
                            $('#watchTasksTable').DataTable().ajax.reload();
                        } else {
                            showNotification('error', response.message);
                        }
                    },
                    error: function() {
                        showNotification('error', '<?php echo e(__('An error occurred')); ?>');
                    }
                });
            }
        }

        function showNotification(type, message) {
            Lobibox.notify(type, {
                pauseDelayOnHover: true,
                continueDelayOnInactiveTab: false,
                position: 'top right',
                icon: type === 'success' ? 'bx bx-check-circle' : 'bx bx-x-circle',
                msg: message
            });
        }

        // Auto refresh every 30 seconds
        setInterval(function() {
            if (document.hidden === false) {
                $('#watchTasksTable').DataTable().ajax.reload(null, false);
            }
        }, 30000);
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/admin/watch/analytics.blade.php ENDPATH**/ ?>