<?php $__env->startSection('title', 'Sepetim - GorevSitesi'); ?>
<?php $__env->startSection('description', 'Sepetinizdeki ürünleri görüntüleyin ve siparişinizi tamamlayın.'); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<div class="row mb-4">
    <div class="col-12">
        <h1 class="fw-bold mb-2">
            <i class="bi bi-bag me-2"></i>Sepetim
        </h1>
        <p class="text-muted mb-0">Sepetinizdeki ürünleri kontrol edin ve siparişinizi tamamlayın</p>
    </div>
</div>

<!-- Cart Content -->
<div class="row">
    <div class="col-lg-8">
        <!-- Cart Items -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-header bg-white border-0">
                <h5 class="mb-0 fw-bold">Sepetinizdeki Ürünler</h5>
            </div>
            <div class="card-body p-0">
                <div id="cartItems">
                    <!-- Cart items will be loaded here by JavaScript -->
                </div>
                
                <!-- Empty Cart Message -->
                <div id="emptyCart" class="text-center py-5 d-none">
                    <i class="bi bi-bag-x text-muted" style="font-size: 4rem;"></i>
                    <h4 class="mt-3 mb-3">Sepetiniz Boş</h4>
                    <p class="text-muted mb-4">Henüz sepetinize ürün eklemediniz. Alışverişe başlamak için ürünlerimizi inceleyin.</p>
                    <a href="<?php echo e(route('site2.products.index')); ?>" class="btn btn-primary">
                        <i class="bi bi-grid me-2"></i>Ürünleri İncele
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <!-- Order Summary -->
        <div class="card border-0 shadow-sm sticky-top" style="top: 100px;">
            <div class="card-header bg-white border-0">
                <h5 class="mb-0 fw-bold">Sipariş Özeti</h5>
            </div>
            <div class="card-body">
                <div class="order-summary">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Ara Toplam:</span>
                        <span id="subtotal">0,00 ₺</span>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Kargo:</span>
                        <span class="text-success">Ücretsiz</span>
                    </div>
                    <hr>
                    <div class="d-flex justify-content-between mb-3">
                        <span class="fw-bold">Toplam:</span>
                        <span class="fw-bold text-primary h5 mb-0" id="total">0,00 ₺</span>
                    </div>
                    
                    <div class="d-grid gap-2" id="checkoutButtons" style="display: none;">
                        <?php if(auth()->guard()->check()): ?>
                            <button class="btn btn-primary btn-lg" id="checkoutBtn">
                                <i class="bi bi-credit-card me-2"></i>Siparişi Tamamla
                            </button>
                        <?php else: ?>
                            <a href="<?php echo e(route('site2.login')); ?>" class="btn btn-primary btn-lg">
                                <i class="bi bi-box-arrow-in-right me-2"></i>Giriş Yap ve Devam Et
                            </a>
                        <?php endif; ?>
                        <a href="<?php echo e(route('site2.products.index')); ?>" class="btn btn-outline-primary">
                            <i class="bi bi-arrow-left me-2"></i>Alışverişe Devam Et
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Security Features -->
        <div class="card border-0 shadow-sm mt-4">
            <div class="card-body">
                <h6 class="fw-bold mb-3">
                    <i class="bi bi-shield-check text-success me-2"></i>Güvenli Alışveriş
                </h6>
                <div class="row g-3 text-center">
                    <div class="col-6">
                        <i class="bi bi-lock text-primary fs-4"></i>
                        <div class="small mt-1">SSL Güvenlik</div>
                    </div>
                    <div class="col-6">
                        <i class="bi bi-credit-card text-success fs-4"></i>
                        <div class="small mt-1">Güvenli Ödeme</div>
                    </div>
                    <div class="col-6">
                        <i class="bi bi-truck text-warning fs-4"></i>
                        <div class="small mt-1">Hızlı Kargo</div>
                    </div>
                    <div class="col-6">
                        <i class="bi bi-arrow-clockwise text-info fs-4"></i>
                        <div class="small mt-1">Kolay İade</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        loadCart();
        
        // Event listeners for cart actions
        document.addEventListener('click', function(e) {
            if (e.target.classList.contains('remove-item')) {
                const productId = parseInt(e.target.dataset.productId);
                if (confirm('Bu ürünü sepetten kaldırmak istediğinizden emin misiniz?')) {
                    removeFromCart(productId);
                }
            }
            
            if (e.target.classList.contains('quantity-decrease')) {
                updateQuantity(parseInt(e.target.dataset.productId), -1);
            }
            
            if (e.target.classList.contains('quantity-increase')) {
                updateQuantity(parseInt(e.target.dataset.productId), 1);
            }
        });
        
        // Quantity input change
        document.addEventListener('change', function(e) {
            if (e.target.classList.contains('quantity-input')) {
                const newQuantity = parseInt(e.target.value);
                const productId = parseInt(e.target.dataset.productId);
                setQuantity(productId, newQuantity);
            }
        });
        
        // Checkout button
        const checkoutBtn = document.getElementById('checkoutBtn');
        if (checkoutBtn) {
            checkoutBtn.addEventListener('click', function() {
                window.location.href = '<?php echo e(route("site2.cart.checkout")); ?>';
            });
        }
    });

    function loadCart() {
        const cart = JSON.parse(localStorage.getItem('cart') || '[]');
        const cartItemsContainer = document.getElementById('cartItems');
        const emptyCartMessage = document.getElementById('emptyCart');
        const checkoutButtons = document.getElementById('checkoutButtons');
        
        if (cart.length === 0) {
            cartItemsContainer.innerHTML = '';
            emptyCartMessage.classList.remove('d-none');
            checkoutButtons.style.display = 'none';
            updateCartSummary(0);
            return;
        }
        
        emptyCartMessage.classList.add('d-none');
        checkoutButtons.style.display = 'block';
        
        let cartHTML = '';
        let total = 0;
        
        cart.forEach(item => {
            const itemTotal = item.price * item.quantity;
            total += itemTotal;
            
            cartHTML += `
                <div class="cart-item border-bottom p-3" data-product-id="${item.id}">
                    <div class="row align-items-center">
                        <div class="col-md-2">
                            <img src="${item.image}" class="img-fluid rounded" alt="${item.name}" style="height: 80px; object-fit: cover;">
                        </div>
                        <div class="col-md-4">
                            <h6 class="mb-1">${item.name}</h6>
                            <small class="text-muted">${item.price.toFixed(2)} ₺ / adet</small>
                        </div>
                        <div class="col-md-3">
                            <div class="input-group input-group-sm">
                                <button class="btn btn-outline-secondary quantity-decrease" type="button" data-product-id="${item.id}">
                                    <i class="bi bi-dash"></i>
                                </button>
                                <input type="number" class="form-control text-center quantity-input" 
                                       value="${item.quantity}" 
                                       min="${item.minQuantity}" 
                                       max="${item.maxQuantity}"
                                       data-product-id="${item.id}">
                                <button class="btn btn-outline-secondary quantity-increase" type="button" data-product-id="${item.id}">
                                    <i class="bi bi-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-2 text-end">
                            <div class="fw-bold">${itemTotal.toFixed(2)} ₺</div>
                        </div>
                        <div class="col-md-1 text-end">
                            <button class="btn btn-sm btn-outline-danger remove-item" data-product-id="${item.id}">
                                <i class="bi bi-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            `;
        });
        
        cartItemsContainer.innerHTML = cartHTML;
        updateCartSummary(total);
        updateCartCount(cart.length);
    }

    function updateCartSummary(total) {
        document.getElementById('subtotal').textContent = total.toFixed(2) + ' ₺';
        document.getElementById('total').textContent = total.toFixed(2) + ' ₺';
    }

    function removeFromCart(productId) {
        productId = parseInt(productId);
        let cart = JSON.parse(localStorage.getItem('cart') || '[]');
        cart = cart.filter(item => parseInt(item.id) !== productId);
        localStorage.setItem('cart', JSON.stringify(cart));
        loadCart();
        
        // Show success message
        showToast('Ürün sepetten kaldırıldı', 'success');
    }

    function updateQuantity(productId, change) {
        productId = parseInt(productId);
        let cart = JSON.parse(localStorage.getItem('cart') || '[]');
        const itemIndex = cart.findIndex(item => parseInt(item.id) === productId);
        
        if (itemIndex > -1) {
            const newQuantity = cart[itemIndex].quantity + change;
            
            if (newQuantity >= cart[itemIndex].minQuantity && newQuantity <= cart[itemIndex].maxQuantity) {
                cart[itemIndex].quantity = newQuantity;
                localStorage.setItem('cart', JSON.stringify(cart));
                loadCart();
            } else {
                showToast('Miktar limitleri aşıldı', 'warning');
            }
        }
    }

    function setQuantity(productId, quantity) {
        productId = parseInt(productId);
        quantity = parseInt(quantity);
        let cart = JSON.parse(localStorage.getItem('cart') || '[]');
        const itemIndex = cart.findIndex(item => parseInt(item.id) === productId);
        
        if (itemIndex > -1) {
            if (quantity >= cart[itemIndex].minQuantity && quantity <= cart[itemIndex].maxQuantity) {
                cart[itemIndex].quantity = quantity;
                localStorage.setItem('cart', JSON.stringify(cart));
                loadCart();
            } else {
                // Reset to valid value
                showToast('Geçersiz miktar girdiniz', 'warning');
                loadCart();
            }
        }
    }
    
    // Toast notification function
    function showToast(message, type = 'info') {
        // Create toast element
        const toast = document.createElement('div');
        toast.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
        toast.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
        toast.innerHTML = `
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        
        document.body.appendChild(toast);
        
        // Auto remove after 3 seconds
        setTimeout(() => {
            if (toast.parentNode) {
                toast.remove();
            }
        }, 3000);
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('gorevsitesi.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/saat/public_html/resources/views/gorevsitesi/cart/index.blade.php ENDPATH**/ ?>